package software.amazon.awscdk.services.appmesh;

/**
 * Used to generate Subject Alternative Names Matchers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Mesh mesh;
 * VirtualNode node1 = VirtualNode.Builder.create(this, "node1")
 *         .mesh(mesh)
 *         .serviceDiscovery(ServiceDiscovery.dns("node"))
 *         .listeners(List.of(VirtualNodeListener.grpc(GrpcVirtualNodeListenerOptions.builder()
 *                 .port(80)
 *                 .tls(ListenerTlsOptions.builder()
 *                         .mode(TlsMode.STRICT)
 *                         .certificate(TlsCertificate.file("path/to/certChain", "path/to/privateKey"))
 *                         // Validate a file client certificates to enable mutual TLS authentication when a client provides a certificate.
 *                         .mutualTlsValidation(MutualTlsValidation.builder()
 *                                 .trust(TlsValidationTrust.file("path-to-certificate"))
 *                                 .build())
 *                         .build())
 *                 .build())))
 *         .build();
 * String certificateAuthorityArn = "arn:aws:acm-pca:us-east-1:123456789012:certificate-authority/12345678-1234-1234-1234-123456789012";
 * VirtualNode node2 = VirtualNode.Builder.create(this, "node2")
 *         .mesh(mesh)
 *         .serviceDiscovery(ServiceDiscovery.dns("node2"))
 *         .backendDefaults(BackendDefaults.builder()
 *                 .tlsClientPolicy(TlsClientPolicy.builder()
 *                         .ports(List.of(8080, 8081))
 *                         .validation(TlsValidation.builder()
 *                                 .subjectAlternativeNames(SubjectAlternativeNames.matchingExactly("mesh-endpoint.apps.local"))
 *                                 .trust(TlsValidationTrust.acm(List.of(CertificateAuthority.fromCertificateAuthorityArn(this, "certificate", certificateAuthorityArn))))
 *                                 .build())
 *                         // Provide a SDS client certificate when a server requests it and enable mutual TLS authentication.
 *                         .mutualTlsCertificate(TlsCertificate.sds("secret_certificate"))
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:08.989Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.SubjectAlternativeNames")
public abstract class SubjectAlternativeNames extends software.amazon.jsii.JsiiObject {

    protected SubjectAlternativeNames(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SubjectAlternativeNames(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected SubjectAlternativeNames() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * The values of the SAN must match the specified values exactly.
     * <p>
     * @param names The exact values to test against. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.SubjectAlternativeNames matchingExactly(final @org.jetbrains.annotations.NotNull java.lang.String... names) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.SubjectAlternativeNames.class, "matchingExactly", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.SubjectAlternativeNames.class), java.util.Arrays.<Object>stream(names).toArray(Object[]::new));
    }

    /**
     * Returns Subject Alternative Names Matcher based on method type.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.SubjectAlternativeNamesMatcherConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appmesh.SubjectAlternativeNames {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Returns Subject Alternative Names Matcher based on method type.
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.SubjectAlternativeNamesMatcherConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.SubjectAlternativeNamesMatcherConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
