package software.amazon.awscdk.services.appmesh;

/**
 * Interface with properties ncecessary to import a reusable Route.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * VirtualRouter virtualRouter;
 * RouteAttributes routeAttributes = RouteAttributes.builder()
 *         .routeName("routeName")
 *         .virtualRouter(virtualRouter)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:08.985Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.RouteAttributes")
@software.amazon.jsii.Jsii.Proxy(RouteAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RouteAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRouteName();

    /**
     * The VirtualRouter the Route belongs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualRouter getVirtualRouter();

    /**
     * @return a {@link Builder} of {@link RouteAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RouteAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RouteAttributes> {
        java.lang.String routeName;
        software.amazon.awscdk.services.appmesh.IVirtualRouter virtualRouter;

        /**
         * Sets the value of {@link RouteAttributes#getRouteName}
         * @param routeName The name of the Route. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeName(java.lang.String routeName) {
            this.routeName = routeName;
            return this;
        }

        /**
         * Sets the value of {@link RouteAttributes#getVirtualRouter}
         * @param virtualRouter The VirtualRouter the Route belongs to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualRouter(software.amazon.awscdk.services.appmesh.IVirtualRouter virtualRouter) {
            this.virtualRouter = virtualRouter;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RouteAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RouteAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RouteAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RouteAttributes {
        private final java.lang.String routeName;
        private final software.amazon.awscdk.services.appmesh.IVirtualRouter virtualRouter;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.routeName = software.amazon.jsii.Kernel.get(this, "routeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.virtualRouter = software.amazon.jsii.Kernel.get(this, "virtualRouter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IVirtualRouter.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.routeName = java.util.Objects.requireNonNull(builder.routeName, "routeName is required");
            this.virtualRouter = java.util.Objects.requireNonNull(builder.virtualRouter, "virtualRouter is required");
        }

        @Override
        public final java.lang.String getRouteName() {
            return this.routeName;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.IVirtualRouter getVirtualRouter() {
            return this.virtualRouter;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("routeName", om.valueToTree(this.getRouteName()));
            data.set("virtualRouter", om.valueToTree(this.getVirtualRouter()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.RouteAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RouteAttributes.Jsii$Proxy that = (RouteAttributes.Jsii$Proxy) o;

            if (!routeName.equals(that.routeName)) return false;
            return this.virtualRouter.equals(that.virtualRouter);
        }

        @Override
        public final int hashCode() {
            int result = this.routeName.hashCode();
            result = 31 * result + (this.virtualRouter.hashCode());
            return result;
        }
    }
}
