package software.amazon.awscdk.services.appintegrations;

/**
 * A CloudFormation `AWS::AppIntegrations::EventIntegration`.
 * <p>
 * Creates an event integration. You provide a name, description, and a reference to an Amazon EventBridge bus in your account and a partner event source that will push events to that bus. No objects are created in your account, only metadata that is persisted on the EventIntegration control plane.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appintegrations.*;
 * CfnEventIntegration cfnEventIntegration = CfnEventIntegration.Builder.create(this, "MyCfnEventIntegration")
 *         .eventBridgeBus("eventBridgeBus")
 *         .eventFilter(EventFilterProperty.builder()
 *                 .source("source")
 *                 .build())
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-11-18T21:59:08.774Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appintegrations.CfnEventIntegration")
public class CfnEventIntegration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnEventIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEventIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appintegrations.CfnEventIntegration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::AppIntegrations::EventIntegration`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEventIntegration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appintegrations.CfnEventIntegrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The association status of the event integration, returned as an array of EventIntegrationAssociation objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrAssociations() {
        return software.amazon.jsii.Kernel.get(this, "attrAssociations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the event integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEventIntegrationArn() {
        return software.amazon.jsii.Kernel.get(this, "attrEventIntegrationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The Amazon EventBridge bus for the event integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEventBridgeBus() {
        return software.amazon.jsii.Kernel.get(this, "eventBridgeBus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon EventBridge bus for the event integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventBridgeBus(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "eventBridgeBus", java.util.Objects.requireNonNull(value, "eventBridgeBus is required"));
    }

    /**
     * The event integration filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getEventFilter() {
        return software.amazon.jsii.Kernel.get(this, "eventFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The event integration filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventFilter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appintegrations.CfnEventIntegration.EventFilterProperty value) {
        software.amazon.jsii.Kernel.set(this, "eventFilter", java.util.Objects.requireNonNull(value, "eventFilter is required"));
    }

    /**
     * The event integration filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventFilter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "eventFilter", java.util.Objects.requireNonNull(value, "eventFilter is required"));
    }

    /**
     * The name of the event integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the event integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The event integration description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The event integration description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }
    /**
     * The event integration filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appintegrations.*;
     * EventFilterProperty eventFilterProperty = EventFilterProperty.builder()
     *         .source("source")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appintegrations.CfnEventIntegration.EventFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(EventFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source of the events.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSource();

        /**
         * @return a {@link Builder} of {@link EventFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventFilterProperty> {
            java.lang.String source;

            /**
             * Sets the value of {@link EventFilterProperty#getSource}
             * @param source The source of the events. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventFilterProperty {
            private final java.lang.String source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("source", om.valueToTree(this.getSource()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appintegrations.CfnEventIntegration.EventFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventFilterProperty.Jsii$Proxy that = (EventFilterProperty.Jsii$Proxy) o;

                return this.source.equals(that.source);
            }

            @Override
            public final int hashCode() {
                int result = this.source.hashCode();
                return result;
            }
        }
    }
    /**
     * The event integration association.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appintegrations.*;
     * EventIntegrationAssociationProperty eventIntegrationAssociationProperty = EventIntegrationAssociationProperty.builder()
     *         .clientAssociationMetadata(List.of(MetadataProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .clientId("clientId")
     *         .eventBridgeRuleName("eventBridgeRuleName")
     *         .eventIntegrationAssociationArn("eventIntegrationAssociationArn")
     *         .eventIntegrationAssociationId("eventIntegrationAssociationId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appintegrations.CfnEventIntegration.EventIntegrationAssociationProperty")
    @software.amazon.jsii.Jsii.Proxy(EventIntegrationAssociationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventIntegrationAssociationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The metadata associated with the client.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getClientAssociationMetadata() {
            return null;
        }

        /**
         * The identifier for the client that is associated with the event integration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientId() {
            return null;
        }

        /**
         * The name of the EventBridge rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEventBridgeRuleName() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) for the event integration association.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEventIntegrationAssociationArn() {
            return null;
        }

        /**
         * The identifier for the event integration association.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEventIntegrationAssociationId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventIntegrationAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventIntegrationAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventIntegrationAssociationProperty> {
            java.lang.Object clientAssociationMetadata;
            java.lang.String clientId;
            java.lang.String eventBridgeRuleName;
            java.lang.String eventIntegrationAssociationArn;
            java.lang.String eventIntegrationAssociationId;

            /**
             * Sets the value of {@link EventIntegrationAssociationProperty#getClientAssociationMetadata}
             * @param clientAssociationMetadata The metadata associated with the client.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientAssociationMetadata(software.amazon.awscdk.IResolvable clientAssociationMetadata) {
                this.clientAssociationMetadata = clientAssociationMetadata;
                return this;
            }

            /**
             * Sets the value of {@link EventIntegrationAssociationProperty#getClientAssociationMetadata}
             * @param clientAssociationMetadata The metadata associated with the client.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientAssociationMetadata(java.util.List<? extends java.lang.Object> clientAssociationMetadata) {
                this.clientAssociationMetadata = clientAssociationMetadata;
                return this;
            }

            /**
             * Sets the value of {@link EventIntegrationAssociationProperty#getClientId}
             * @param clientId The identifier for the client that is associated with the event integration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link EventIntegrationAssociationProperty#getEventBridgeRuleName}
             * @param eventBridgeRuleName The name of the EventBridge rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBridgeRuleName(java.lang.String eventBridgeRuleName) {
                this.eventBridgeRuleName = eventBridgeRuleName;
                return this;
            }

            /**
             * Sets the value of {@link EventIntegrationAssociationProperty#getEventIntegrationAssociationArn}
             * @param eventIntegrationAssociationArn The Amazon Resource Name (ARN) for the event integration association.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventIntegrationAssociationArn(java.lang.String eventIntegrationAssociationArn) {
                this.eventIntegrationAssociationArn = eventIntegrationAssociationArn;
                return this;
            }

            /**
             * Sets the value of {@link EventIntegrationAssociationProperty#getEventIntegrationAssociationId}
             * @param eventIntegrationAssociationId The identifier for the event integration association.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventIntegrationAssociationId(java.lang.String eventIntegrationAssociationId) {
                this.eventIntegrationAssociationId = eventIntegrationAssociationId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventIntegrationAssociationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventIntegrationAssociationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventIntegrationAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventIntegrationAssociationProperty {
            private final java.lang.Object clientAssociationMetadata;
            private final java.lang.String clientId;
            private final java.lang.String eventBridgeRuleName;
            private final java.lang.String eventIntegrationAssociationArn;
            private final java.lang.String eventIntegrationAssociationId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientAssociationMetadata = software.amazon.jsii.Kernel.get(this, "clientAssociationMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.eventBridgeRuleName = software.amazon.jsii.Kernel.get(this, "eventBridgeRuleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.eventIntegrationAssociationArn = software.amazon.jsii.Kernel.get(this, "eventIntegrationAssociationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.eventIntegrationAssociationId = software.amazon.jsii.Kernel.get(this, "eventIntegrationAssociationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientAssociationMetadata = builder.clientAssociationMetadata;
                this.clientId = builder.clientId;
                this.eventBridgeRuleName = builder.eventBridgeRuleName;
                this.eventIntegrationAssociationArn = builder.eventIntegrationAssociationArn;
                this.eventIntegrationAssociationId = builder.eventIntegrationAssociationId;
            }

            @Override
            public final java.lang.Object getClientAssociationMetadata() {
                return this.clientAssociationMetadata;
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.String getEventBridgeRuleName() {
                return this.eventBridgeRuleName;
            }

            @Override
            public final java.lang.String getEventIntegrationAssociationArn() {
                return this.eventIntegrationAssociationArn;
            }

            @Override
            public final java.lang.String getEventIntegrationAssociationId() {
                return this.eventIntegrationAssociationId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClientAssociationMetadata() != null) {
                    data.set("clientAssociationMetadata", om.valueToTree(this.getClientAssociationMetadata()));
                }
                if (this.getClientId() != null) {
                    data.set("clientId", om.valueToTree(this.getClientId()));
                }
                if (this.getEventBridgeRuleName() != null) {
                    data.set("eventBridgeRuleName", om.valueToTree(this.getEventBridgeRuleName()));
                }
                if (this.getEventIntegrationAssociationArn() != null) {
                    data.set("eventIntegrationAssociationArn", om.valueToTree(this.getEventIntegrationAssociationArn()));
                }
                if (this.getEventIntegrationAssociationId() != null) {
                    data.set("eventIntegrationAssociationId", om.valueToTree(this.getEventIntegrationAssociationId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appintegrations.CfnEventIntegration.EventIntegrationAssociationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventIntegrationAssociationProperty.Jsii$Proxy that = (EventIntegrationAssociationProperty.Jsii$Proxy) o;

                if (this.clientAssociationMetadata != null ? !this.clientAssociationMetadata.equals(that.clientAssociationMetadata) : that.clientAssociationMetadata != null) return false;
                if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) return false;
                if (this.eventBridgeRuleName != null ? !this.eventBridgeRuleName.equals(that.eventBridgeRuleName) : that.eventBridgeRuleName != null) return false;
                if (this.eventIntegrationAssociationArn != null ? !this.eventIntegrationAssociationArn.equals(that.eventIntegrationAssociationArn) : that.eventIntegrationAssociationArn != null) return false;
                return this.eventIntegrationAssociationId != null ? this.eventIntegrationAssociationId.equals(that.eventIntegrationAssociationId) : that.eventIntegrationAssociationId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientAssociationMetadata != null ? this.clientAssociationMetadata.hashCode() : 0;
                result = 31 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
                result = 31 * result + (this.eventBridgeRuleName != null ? this.eventBridgeRuleName.hashCode() : 0);
                result = 31 * result + (this.eventIntegrationAssociationArn != null ? this.eventIntegrationAssociationArn.hashCode() : 0);
                result = 31 * result + (this.eventIntegrationAssociationId != null ? this.eventIntegrationAssociationId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The metadata associated with the client.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appintegrations.*;
     * MetadataProperty metadataProperty = MetadataProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appintegrations.CfnEventIntegration.MetadataProperty")
    @software.amazon.jsii.Jsii.Proxy(MetadataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetadataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link MetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetadataProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link MetadataProperty#getKey}
             * @param key The key name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link MetadataProperty#getValue}
             * @param value The value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetadataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetadataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetadataProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appintegrations.CfnEventIntegration.MetadataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetadataProperty.Jsii$Proxy that = (MetadataProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appintegrations.CfnEventIntegration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appintegrations.CfnEventIntegration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appintegrations.CfnEventIntegrationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appintegrations.CfnEventIntegrationProps.Builder();
        }

        /**
         * The Amazon EventBridge bus for the event integration.
         * <p>
         * @return {@code this}
         * @param eventBridgeBus The Amazon EventBridge bus for the event integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBridgeBus(final java.lang.String eventBridgeBus) {
            this.props.eventBridgeBus(eventBridgeBus);
            return this;
        }

        /**
         * The event integration filter.
         * <p>
         * @return {@code this}
         * @param eventFilter The event integration filter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventFilter(final software.amazon.awscdk.services.appintegrations.CfnEventIntegration.EventFilterProperty eventFilter) {
            this.props.eventFilter(eventFilter);
            return this;
        }
        /**
         * The event integration filter.
         * <p>
         * @return {@code this}
         * @param eventFilter The event integration filter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventFilter(final software.amazon.awscdk.IResolvable eventFilter) {
            this.props.eventFilter(eventFilter);
            return this;
        }

        /**
         * The name of the event integration.
         * <p>
         * @return {@code this}
         * @param name The name of the event integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The event integration description.
         * <p>
         * @return {@code this}
         * @param description The event integration description. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.appintegrations.CfnEventIntegration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appintegrations.CfnEventIntegration build() {
            return new software.amazon.awscdk.services.appintegrations.CfnEventIntegration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
