package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for calling a EKS endpoint with EksCall.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.eks.*;
 * Cluster myEksCluster = Cluster.Builder.create(this, "my sample cluster")
 *         .version(KubernetesVersion.V1_18)
 *         .clusterName("myEksCluster")
 *         .build();
 * EksCall.Builder.create(this, "Call a EKS Endpoint")
 *         .cluster(myEksCluster)
 *         .httpMethod(HttpMethods.GET)
 *         .httpPath("/api/v1/namespaces/default/pods")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:54.735Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.EksCallProps")
@software.amazon.jsii.Jsii.Proxy(EksCallProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EksCallProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.TaskStateBaseProps {

    /**
     * The EKS cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ICluster getCluster();

    /**
     * HTTP method ("GET", "POST", "PUT", ...) part of HTTP request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.HttpMethods getHttpMethod();

    /**
     * HTTP path of the Kubernetes REST API operation For example: /api/v1/namespaces/default/pods.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHttpPath();

    /**
     * Query Parameters part of HTTP request.
     * <p>
     * Default: - no query parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.util.List<java.lang.String>> getQueryParameters() {
        return null;
    }

    /**
     * Request body part of HTTP request.
     * <p>
     * Default: - No request body
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskInput getRequestBody() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EksCallProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EksCallProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EksCallProps> {
        software.amazon.awscdk.services.eks.ICluster cluster;
        software.amazon.awscdk.services.stepfunctions.tasks.HttpMethods httpMethod;
        java.lang.String httpPath;
        java.util.Map<java.lang.String, java.util.List<java.lang.String>> queryParameters;
        software.amazon.awscdk.services.stepfunctions.TaskInput requestBody;
        java.lang.String comment;
        software.amazon.awscdk.Duration heartbeat;
        java.lang.String inputPath;
        software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        java.lang.String outputPath;
        java.lang.String resultPath;
        java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        software.amazon.awscdk.Duration timeout;

        /**
         * Sets the value of {@link EksCallProps#getCluster}
         * @param cluster The EKS cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.eks.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link EksCallProps#getHttpMethod}
         * @param httpMethod HTTP method ("GET", "POST", "PUT", ...) part of HTTP request. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpMethod(software.amazon.awscdk.services.stepfunctions.tasks.HttpMethods httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        /**
         * Sets the value of {@link EksCallProps#getHttpPath}
         * @param httpPath HTTP path of the Kubernetes REST API operation For example: /api/v1/namespaces/default/pods. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpPath(java.lang.String httpPath) {
            this.httpPath = httpPath;
            return this;
        }

        /**
         * Sets the value of {@link EksCallProps#getQueryParameters}
         * @param queryParameters Query Parameters part of HTTP request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder queryParameters(java.util.Map<java.lang.String, ? extends java.util.List<java.lang.String>> queryParameters) {
            this.queryParameters = (java.util.Map<java.lang.String, java.util.List<java.lang.String>>)queryParameters;
            return this;
        }

        /**
         * Sets the value of {@link EksCallProps#getRequestBody}
         * @param requestBody Request body part of HTTP request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestBody(software.amazon.awscdk.services.stepfunctions.TaskInput requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        /**
         * Sets the value of {@link EksCallProps#getComment}
         * @param comment An optional description for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link EksCallProps#getHeartbeat}
         * @param heartbeat Timeout for the heartbeat.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeat(software.amazon.awscdk.Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        /**
         * Sets the value of {@link EksCallProps#getInputPath}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state.
         *                  May also be the special value JsonPath.DISCARD, which will cause the effective
         *                  input to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link EksCallProps#getIntegrationPattern}
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language.
         *                           You can control these AWS services using service integration patterns
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link EksCallProps#getOutputPath}
         * @param outputPath JSONPath expression to select select a portion of the state output to pass to the next state.
         *                   May also be the special value JsonPath.DISCARD, which will cause the effective
         *                   output to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Sets the value of {@link EksCallProps#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the state's output.
         *                   May also be the special value JsonPath.DISCARD, which will cause the state's
         *                   input to become its output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Sets the value of {@link EksCallProps#getResultSelector}
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         *                       You can use ResultSelector to create a payload with values that are static
         *                       or selected from the state's raw result.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder resultSelector(java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)resultSelector;
            return this;
        }

        /**
         * Sets the value of {@link EksCallProps#getTimeout}
         * @param timeout Timeout for the state machine.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EksCallProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EksCallProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EksCallProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EksCallProps {
        private final software.amazon.awscdk.services.eks.ICluster cluster;
        private final software.amazon.awscdk.services.stepfunctions.tasks.HttpMethods httpMethod;
        private final java.lang.String httpPath;
        private final java.util.Map<java.lang.String, java.util.List<java.lang.String>> queryParameters;
        private final software.amazon.awscdk.services.stepfunctions.TaskInput requestBody;
        private final java.lang.String comment;
        private final software.amazon.awscdk.Duration heartbeat;
        private final java.lang.String inputPath;
        private final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private final java.lang.String outputPath;
        private final java.lang.String resultPath;
        private final java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        private final software.amazon.awscdk.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.ICluster.class));
            this.httpMethod = software.amazon.jsii.Kernel.get(this, "httpMethod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.HttpMethods.class));
            this.httpPath = software.amazon.jsii.Kernel.get(this, "httpPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryParameters = software.amazon.jsii.Kernel.get(this, "queryParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
            this.requestBody = software.amazon.jsii.Kernel.get(this, "requestBody", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.heartbeat = software.amazon.jsii.Kernel.get(this, "heartbeat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integrationPattern = software.amazon.jsii.Kernel.get(this, "integrationPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IntegrationPattern.class));
            this.outputPath = software.amazon.jsii.Kernel.get(this, "outputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultPath = software.amazon.jsii.Kernel.get(this, "resultPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultSelector = software.amazon.jsii.Kernel.get(this, "resultSelector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.httpMethod = java.util.Objects.requireNonNull(builder.httpMethod, "httpMethod is required");
            this.httpPath = java.util.Objects.requireNonNull(builder.httpPath, "httpPath is required");
            this.queryParameters = (java.util.Map<java.lang.String, java.util.List<java.lang.String>>)builder.queryParameters;
            this.requestBody = builder.requestBody;
            this.comment = builder.comment;
            this.heartbeat = builder.heartbeat;
            this.inputPath = builder.inputPath;
            this.integrationPattern = builder.integrationPattern;
            this.outputPath = builder.outputPath;
            this.resultPath = builder.resultPath;
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)builder.resultSelector;
            this.timeout = builder.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.eks.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.HttpMethods getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public final java.lang.String getHttpPath() {
            return this.httpPath;
        }

        @Override
        public final java.util.Map<java.lang.String, java.util.List<java.lang.String>> getQueryParameters() {
            return this.queryParameters;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.TaskInput getRequestBody() {
            return this.requestBody;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.Duration getHeartbeat() {
            return this.heartbeat;
        }

        @Override
        public final java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public final java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        public final java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getResultSelector() {
            return this.resultSelector;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cluster", om.valueToTree(this.getCluster()));
            data.set("httpMethod", om.valueToTree(this.getHttpMethod()));
            data.set("httpPath", om.valueToTree(this.getHttpPath()));
            if (this.getQueryParameters() != null) {
                data.set("queryParameters", om.valueToTree(this.getQueryParameters()));
            }
            if (this.getRequestBody() != null) {
                data.set("requestBody", om.valueToTree(this.getRequestBody()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getHeartbeat() != null) {
                data.set("heartbeat", om.valueToTree(this.getHeartbeat()));
            }
            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }
            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }
            if (this.getResultSelector() != null) {
                data.set("resultSelector", om.valueToTree(this.getResultSelector()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.EksCallProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EksCallProps.Jsii$Proxy that = (EksCallProps.Jsii$Proxy) o;

            if (!cluster.equals(that.cluster)) return false;
            if (!httpMethod.equals(that.httpMethod)) return false;
            if (!httpPath.equals(that.httpPath)) return false;
            if (this.queryParameters != null ? !this.queryParameters.equals(that.queryParameters) : that.queryParameters != null) return false;
            if (this.requestBody != null ? !this.requestBody.equals(that.requestBody) : that.requestBody != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) return false;
            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.outputPath != null ? !this.outputPath.equals(that.outputPath) : that.outputPath != null) return false;
            if (this.resultPath != null ? !this.resultPath.equals(that.resultPath) : that.resultPath != null) return false;
            if (this.resultSelector != null ? !this.resultSelector.equals(that.resultSelector) : that.resultSelector != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cluster.hashCode();
            result = 31 * result + (this.httpMethod.hashCode());
            result = 31 * result + (this.httpPath.hashCode());
            result = 31 * result + (this.queryParameters != null ? this.queryParameters.hashCode() : 0);
            result = 31 * result + (this.requestBody != null ? this.requestBody.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
            result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            result = 31 * result + (this.resultPath != null ? this.resultPath.hashCode() : 0);
            result = 31 * result + (this.resultSelector != null ? this.resultSelector.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
