package software.amazon.awscdk.services.stepfunctions;

/**
 * Extract a field from the State Machine data or context that gets passed around between states.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Activity submitJobActivity = new Activity(this, "SubmitJob");
 * StepFunctionsInvokeActivity.Builder.create(this, "Submit Job")
 *         .activity(submitJobActivity)
 *         .parameters(Map.of(
 *                 "comment", "Selecting what I care about.",
 *                 "MyDetails", Map.of(
 *                         "size", JsonPath.stringAt("$.product.details.size"),
 *                         "exists", JsonPath.stringAt("$.product.availability"),
 *                         "StaticValue", "foo")))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-paths.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-paths.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:54.655Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.JsonPath")
public class JsonPath extends software.amazon.jsii.JsiiObject {

    protected JsonPath(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected JsonPath(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        DISCARD = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "DISCARD", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Make an intrinsic States.Array expression.
     * <p>
     * Combine any number of string literals or JsonPath expressions into an array.
     * <p>
     * Use this function if the value of an array element directly has to come
     * from a JSON Path expression (either the State object or the Context object).
     * <p>
     * If the array contains object literals whose values come from a JSON path
     * expression, you do not need to use this function.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     * @param values This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String array(final @org.jetbrains.annotations.NotNull java.lang.String... values) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "array", software.amazon.jsii.NativeType.forClass(java.lang.String.class), java.util.Arrays.<Object>stream(values).toArray(Object[]::new));
    }

    /**
     * Make an intrinsic States.Format expression.
     * <p>
     * This can be used to embed JSON Path variables inside a format string.
     * <p>
     * For example:
     * <p>
     * <blockquote><pre>
     * JsonPath.format("Hello, my name is {}.", JsonPath.stringAt("$.name"));
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     * @param formatString This parameter is required.
     * @param values This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String format(final @org.jetbrains.annotations.NotNull java.lang.String formatString, final @org.jetbrains.annotations.NotNull java.lang.String... values) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(formatString, "formatString is required") }), java.util.Arrays.<Object>stream(values)).toArray(Object[]::new));
    }

    /**
     * Determines if the indicated string is an encoded JSON path.
     * <p>
     * @param value string to be evaluated. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isEncodedJsonPath(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "isEncodedJsonPath", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Make an intrinsic States.JsonToString expression.
     * <p>
     * During the execution of the Step Functions state machine, encode the
     * given object into a JSON string.
     * <p>
     * For example:
     * <p>
     * <blockquote><pre>
     * JsonPath.jsonToString(JsonPath.objectAt("$.someObject"));
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String jsonToString(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "jsonToString", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { value });
    }

    /**
     * Instead of using a literal string list, get the value from a JSON path.
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> listAt(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "listAt", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(path, "path is required") }));
    }

    /**
     * Instead of using a literal number, get the value from a JSON path.
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Number numberAt(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "numberAt", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Reference a complete (complex) object in a JSON path location.
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable objectAt(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "objectAt", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Instead of using a literal string, get the value from a JSON path.
     * <p>
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String stringAt(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "stringAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Make an intrinsic States.StringToJson expression.
     * <p>
     * During the execution of the Step Functions state machine, parse the given
     * argument as JSON into its object form.
     * <p>
     * For example:
     * <p>
     * <blockquote><pre>
     * JsonPath.stringToJson(JsonPath.stringAt("$.someJsonBody"));
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html">https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-intrinsic-functions.html</a>
     * @param jsonString This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable stringToJson(final @org.jetbrains.annotations.NotNull java.lang.String jsonString) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "stringToJson", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class), new Object[] { java.util.Objects.requireNonNull(jsonString, "jsonString is required") });
    }

    /**
     * Special string value to discard state input, output or result.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String DISCARD;

    /**
     * Use the entire context data structure.
     * <p>
     * Will be an object at invocation time, but is represented in the CDK
     * application as a string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getEntireContext() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "entireContext", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Use the entire data structure.
     * <p>
     * Will be an object at invocation time, but is represented in the CDK
     * application as a string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getEntirePayload() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "entirePayload", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Return the Task Token field.
     * <p>
     * External actions will need this token to report step completion
     * back to StepFunctions using the <code>SendTaskSuccess</code> or <code>SendTaskFailure</code>
     * calls.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getTaskToken() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.JsonPath.class, "taskToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
