package software.amazon.awscdk.services.ssmcontacts;

/**
 * A CloudFormation `AWS::SSMContacts::Contact`.
 * <p>
 * The <code>AWS::SSMContacts::Contact</code> resource specifies a contact or escalation plan. Incident Manager contacts are a subset of actions and data types that you can use for managing responder engagement and interaction.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssmcontacts.*;
 * CfnContact cfnContact = CfnContact.Builder.create(this, "MyCfnContact")
 *         .alias("alias")
 *         .displayName("displayName")
 *         .plan(List.of(StageProperty.builder()
 *                 .durationInMinutes(123)
 *                 // the properties below are optional
 *                 .targets(List.of(TargetsProperty.builder()
 *                         .channelTargetInfo(ChannelTargetInfoProperty.builder()
 *                                 .channelId("channelId")
 *                                 .retryIntervalInMinutes(123)
 *                                 .build())
 *                         .contactTargetInfo(ContactTargetInfoProperty.builder()
 *                                 .contactId("contactId")
 *                                 .isEssential(false)
 *                                 .build())
 *                         .build()))
 *                 .build()))
 *         .type("type")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:54.596Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmcontacts.CfnContact")
public class CfnContact extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnContact(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnContact(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ssmcontacts.CfnContact.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::SSMContacts::Contact`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnContact(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssmcontacts.CfnContactProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the `Contact` resource, such as `arn:aws:ssm-contacts:us-west-2:123456789012:contact/contactalias` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The unique and identifiable alias of the contact or escalation plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAlias() {
        return software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique and identifiable alias of the contact or escalation plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlias(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "alias", java.util.Objects.requireNonNull(value, "alias is required"));
    }

    /**
     * The full name of the contact or escalation plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The full name of the contact or escalation plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisplayName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "displayName", java.util.Objects.requireNonNull(value, "displayName is required"));
    }

    /**
     * A list of stages.
     * <p>
     * A contact has an engagement plan with stages that contact specified contact channels. An escalation plan uses stages that contact specified contacts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getPlan() {
        return software.amazon.jsii.Kernel.get(this, "plan", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of stages.
     * <p>
     * A contact has an engagement plan with stages that contact specified contact channels. An escalation plan uses stages that contact specified contacts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlan(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "plan", java.util.Objects.requireNonNull(value, "plan is required"));
    }

    /**
     * A list of stages.
     * <p>
     * A contact has an engagement plan with stages that contact specified contact channels. An escalation plan uses stages that contact specified contacts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlan(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.ssmcontacts.CfnContact.StageProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.ssmcontacts.CfnContact.StageProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "plan", java.util.Objects.requireNonNull(value, "plan is required"));
    }

    /**
     * Refers to the type of contact.
     * <p>
     * A single contact is type <code>PERSONAL</code> and an escalation plan is type <code>ESCALATION</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Refers to the type of contact.
     * <p>
     * A single contact is type <code>PERSONAL</code> and an escalation plan is type <code>ESCALATION</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }
    /**
     * Information about the contact channel that Incident Manager uses to engage the contact.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmcontacts.*;
     * ChannelTargetInfoProperty channelTargetInfoProperty = ChannelTargetInfoProperty.builder()
     *         .channelId("channelId")
     *         .retryIntervalInMinutes(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmcontacts.CfnContact.ChannelTargetInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(ChannelTargetInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ChannelTargetInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the contact channel.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getChannelId();

        /**
         * The number of minutes to wait to retry sending engagement in the case the engagement initially fails.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getRetryIntervalInMinutes();

        /**
         * @return a {@link Builder} of {@link ChannelTargetInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ChannelTargetInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ChannelTargetInfoProperty> {
            java.lang.String channelId;
            java.lang.Number retryIntervalInMinutes;

            /**
             * Sets the value of {@link ChannelTargetInfoProperty#getChannelId}
             * @param channelId The Amazon Resource Name (ARN) of the contact channel. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder channelId(java.lang.String channelId) {
                this.channelId = channelId;
                return this;
            }

            /**
             * Sets the value of {@link ChannelTargetInfoProperty#getRetryIntervalInMinutes}
             * @param retryIntervalInMinutes The number of minutes to wait to retry sending engagement in the case the engagement initially fails. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryIntervalInMinutes(java.lang.Number retryIntervalInMinutes) {
                this.retryIntervalInMinutes = retryIntervalInMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ChannelTargetInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ChannelTargetInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ChannelTargetInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChannelTargetInfoProperty {
            private final java.lang.String channelId;
            private final java.lang.Number retryIntervalInMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.channelId = software.amazon.jsii.Kernel.get(this, "channelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.retryIntervalInMinutes = software.amazon.jsii.Kernel.get(this, "retryIntervalInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.channelId = java.util.Objects.requireNonNull(builder.channelId, "channelId is required");
                this.retryIntervalInMinutes = java.util.Objects.requireNonNull(builder.retryIntervalInMinutes, "retryIntervalInMinutes is required");
            }

            @Override
            public final java.lang.String getChannelId() {
                return this.channelId;
            }

            @Override
            public final java.lang.Number getRetryIntervalInMinutes() {
                return this.retryIntervalInMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("channelId", om.valueToTree(this.getChannelId()));
                data.set("retryIntervalInMinutes", om.valueToTree(this.getRetryIntervalInMinutes()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmcontacts.CfnContact.ChannelTargetInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ChannelTargetInfoProperty.Jsii$Proxy that = (ChannelTargetInfoProperty.Jsii$Proxy) o;

                if (!channelId.equals(that.channelId)) return false;
                return this.retryIntervalInMinutes.equals(that.retryIntervalInMinutes);
            }

            @Override
            public final int hashCode() {
                int result = this.channelId.hashCode();
                result = 31 * result + (this.retryIntervalInMinutes.hashCode());
                return result;
            }
        }
    }
    /**
     * The contact that Incident Manager is engaging during an incident.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmcontacts.*;
     * ContactTargetInfoProperty contactTargetInfoProperty = ContactTargetInfoProperty.builder()
     *         .contactId("contactId")
     *         .isEssential(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmcontacts.CfnContact.ContactTargetInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(ContactTargetInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContactTargetInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the contact.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContactId();

        /**
         * A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIsEssential();

        /**
         * @return a {@link Builder} of {@link ContactTargetInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContactTargetInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContactTargetInfoProperty> {
            java.lang.String contactId;
            java.lang.Object isEssential;

            /**
             * Sets the value of {@link ContactTargetInfoProperty#getContactId}
             * @param contactId The Amazon Resource Name (ARN) of the contact. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contactId(java.lang.String contactId) {
                this.contactId = contactId;
                return this;
            }

            /**
             * Sets the value of {@link ContactTargetInfoProperty#getIsEssential}
             * @param isEssential A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isEssential(java.lang.Boolean isEssential) {
                this.isEssential = isEssential;
                return this;
            }

            /**
             * Sets the value of {@link ContactTargetInfoProperty#getIsEssential}
             * @param isEssential A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isEssential(software.amazon.awscdk.IResolvable isEssential) {
                this.isEssential = isEssential;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContactTargetInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContactTargetInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContactTargetInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContactTargetInfoProperty {
            private final java.lang.String contactId;
            private final java.lang.Object isEssential;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.contactId = software.amazon.jsii.Kernel.get(this, "contactId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.isEssential = software.amazon.jsii.Kernel.get(this, "isEssential", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.contactId = java.util.Objects.requireNonNull(builder.contactId, "contactId is required");
                this.isEssential = java.util.Objects.requireNonNull(builder.isEssential, "isEssential is required");
            }

            @Override
            public final java.lang.String getContactId() {
                return this.contactId;
            }

            @Override
            public final java.lang.Object getIsEssential() {
                return this.isEssential;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("contactId", om.valueToTree(this.getContactId()));
                data.set("isEssential", om.valueToTree(this.getIsEssential()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmcontacts.CfnContact.ContactTargetInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContactTargetInfoProperty.Jsii$Proxy that = (ContactTargetInfoProperty.Jsii$Proxy) o;

                if (!contactId.equals(that.contactId)) return false;
                return this.isEssential.equals(that.isEssential);
            }

            @Override
            public final int hashCode() {
                int result = this.contactId.hashCode();
                result = 31 * result + (this.isEssential.hashCode());
                return result;
            }
        }
    }
    /**
     * The `Stage` property type specifies a set amount of time that an escalation plan or engagement plan engages the specified contacts or contact methods.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmcontacts.*;
     * StageProperty stageProperty = StageProperty.builder()
     *         .durationInMinutes(123)
     *         // the properties below are optional
     *         .targets(List.of(TargetsProperty.builder()
     *                 .channelTargetInfo(ChannelTargetInfoProperty.builder()
     *                         .channelId("channelId")
     *                         .retryIntervalInMinutes(123)
     *                         .build())
     *                 .contactTargetInfo(ContactTargetInfoProperty.builder()
     *                         .contactId("contactId")
     *                         .isEssential(false)
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmcontacts.CfnContact.StageProperty")
    @software.amazon.jsii.Jsii.Proxy(StageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The time to wait until beginning the next stage.
         * <p>
         * The duration can only be set to 0 if a target is specified.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getDurationInMinutes();

        /**
         * The contacts or contact methods that the escalation plan or engagement plan is engaging.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargets() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StageProperty> {
            java.lang.Number durationInMinutes;
            java.lang.Object targets;

            /**
             * Sets the value of {@link StageProperty#getDurationInMinutes}
             * @param durationInMinutes The time to wait until beginning the next stage. This parameter is required.
             *                          The duration can only be set to 0 if a target is specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationInMinutes(java.lang.Number durationInMinutes) {
                this.durationInMinutes = durationInMinutes;
                return this;
            }

            /**
             * Sets the value of {@link StageProperty#getTargets}
             * @param targets The contacts or contact methods that the escalation plan or engagement plan is engaging.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targets(software.amazon.awscdk.IResolvable targets) {
                this.targets = targets;
                return this;
            }

            /**
             * Sets the value of {@link StageProperty#getTargets}
             * @param targets The contacts or contact methods that the escalation plan or engagement plan is engaging.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targets(java.util.List<? extends java.lang.Object> targets) {
                this.targets = targets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StageProperty {
            private final java.lang.Number durationInMinutes;
            private final java.lang.Object targets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.durationInMinutes = software.amazon.jsii.Kernel.get(this, "durationInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.targets = software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.durationInMinutes = java.util.Objects.requireNonNull(builder.durationInMinutes, "durationInMinutes is required");
                this.targets = builder.targets;
            }

            @Override
            public final java.lang.Number getDurationInMinutes() {
                return this.durationInMinutes;
            }

            @Override
            public final java.lang.Object getTargets() {
                return this.targets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("durationInMinutes", om.valueToTree(this.getDurationInMinutes()));
                if (this.getTargets() != null) {
                    data.set("targets", om.valueToTree(this.getTargets()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmcontacts.CfnContact.StageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StageProperty.Jsii$Proxy that = (StageProperty.Jsii$Proxy) o;

                if (!durationInMinutes.equals(that.durationInMinutes)) return false;
                return this.targets != null ? this.targets.equals(that.targets) : that.targets == null;
            }

            @Override
            public final int hashCode() {
                int result = this.durationInMinutes.hashCode();
                result = 31 * result + (this.targets != null ? this.targets.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The contact or contact channel that's being engaged.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ssmcontacts.*;
     * TargetsProperty targetsProperty = TargetsProperty.builder()
     *         .channelTargetInfo(ChannelTargetInfoProperty.builder()
     *                 .channelId("channelId")
     *                 .retryIntervalInMinutes(123)
     *                 .build())
     *         .contactTargetInfo(ContactTargetInfoProperty.builder()
     *                 .contactId("contactId")
     *                 .isEssential(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmcontacts.CfnContact.TargetsProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about the contact channel Incident Manager is engaging.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getChannelTargetInfo() {
            return null;
        }

        /**
         * The contact that Incident Manager is engaging during an incident.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContactTargetInfo() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetsProperty> {
            java.lang.Object channelTargetInfo;
            java.lang.Object contactTargetInfo;

            /**
             * Sets the value of {@link TargetsProperty#getChannelTargetInfo}
             * @param channelTargetInfo Information about the contact channel Incident Manager is engaging.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder channelTargetInfo(software.amazon.awscdk.services.ssmcontacts.CfnContact.ChannelTargetInfoProperty channelTargetInfo) {
                this.channelTargetInfo = channelTargetInfo;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getChannelTargetInfo}
             * @param channelTargetInfo Information about the contact channel Incident Manager is engaging.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder channelTargetInfo(software.amazon.awscdk.IResolvable channelTargetInfo) {
                this.channelTargetInfo = channelTargetInfo;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getContactTargetInfo}
             * @param contactTargetInfo The contact that Incident Manager is engaging during an incident.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contactTargetInfo(software.amazon.awscdk.services.ssmcontacts.CfnContact.ContactTargetInfoProperty contactTargetInfo) {
                this.contactTargetInfo = contactTargetInfo;
                return this;
            }

            /**
             * Sets the value of {@link TargetsProperty#getContactTargetInfo}
             * @param contactTargetInfo The contact that Incident Manager is engaging during an incident.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contactTargetInfo(software.amazon.awscdk.IResolvable contactTargetInfo) {
                this.contactTargetInfo = contactTargetInfo;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetsProperty {
            private final java.lang.Object channelTargetInfo;
            private final java.lang.Object contactTargetInfo;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.channelTargetInfo = software.amazon.jsii.Kernel.get(this, "channelTargetInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.contactTargetInfo = software.amazon.jsii.Kernel.get(this, "contactTargetInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.channelTargetInfo = builder.channelTargetInfo;
                this.contactTargetInfo = builder.contactTargetInfo;
            }

            @Override
            public final java.lang.Object getChannelTargetInfo() {
                return this.channelTargetInfo;
            }

            @Override
            public final java.lang.Object getContactTargetInfo() {
                return this.contactTargetInfo;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getChannelTargetInfo() != null) {
                    data.set("channelTargetInfo", om.valueToTree(this.getChannelTargetInfo()));
                }
                if (this.getContactTargetInfo() != null) {
                    data.set("contactTargetInfo", om.valueToTree(this.getContactTargetInfo()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmcontacts.CfnContact.TargetsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetsProperty.Jsii$Proxy that = (TargetsProperty.Jsii$Proxy) o;

                if (this.channelTargetInfo != null ? !this.channelTargetInfo.equals(that.channelTargetInfo) : that.channelTargetInfo != null) return false;
                return this.contactTargetInfo != null ? this.contactTargetInfo.equals(that.contactTargetInfo) : that.contactTargetInfo == null;
            }

            @Override
            public final int hashCode() {
                int result = this.channelTargetInfo != null ? this.channelTargetInfo.hashCode() : 0;
                result = 31 * result + (this.contactTargetInfo != null ? this.contactTargetInfo.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ssmcontacts.CfnContact}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ssmcontacts.CfnContact> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ssmcontacts.CfnContactProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ssmcontacts.CfnContactProps.Builder();
        }

        /**
         * The unique and identifiable alias of the contact or escalation plan.
         * <p>
         * @return {@code this}
         * @param alias The unique and identifiable alias of the contact or escalation plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alias(final java.lang.String alias) {
            this.props.alias(alias);
            return this;
        }

        /**
         * The full name of the contact or escalation plan.
         * <p>
         * @return {@code this}
         * @param displayName The full name of the contact or escalation plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(final java.lang.String displayName) {
            this.props.displayName(displayName);
            return this;
        }

        /**
         * A list of stages.
         * <p>
         * A contact has an engagement plan with stages that contact specified contact channels. An escalation plan uses stages that contact specified contacts.
         * <p>
         * @return {@code this}
         * @param plan A list of stages. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder plan(final software.amazon.awscdk.IResolvable plan) {
            this.props.plan(plan);
            return this;
        }
        /**
         * A list of stages.
         * <p>
         * A contact has an engagement plan with stages that contact specified contact channels. An escalation plan uses stages that contact specified contacts.
         * <p>
         * @return {@code this}
         * @param plan A list of stages. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder plan(final java.util.List<? extends java.lang.Object> plan) {
            this.props.plan(plan);
            return this;
        }

        /**
         * Refers to the type of contact.
         * <p>
         * A single contact is type <code>PERSONAL</code> and an escalation plan is type <code>ESCALATION</code> .
         * <p>
         * @return {@code this}
         * @param type Refers to the type of contact. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ssmcontacts.CfnContact}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ssmcontacts.CfnContact build() {
            return new software.amazon.awscdk.services.ssmcontacts.CfnContact(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
