package software.amazon.awscdk.services.ses;

/**
 * A CloudFormation `AWS::SES::EmailIdentity`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * CfnEmailIdentity cfnEmailIdentity = CfnEmailIdentity.Builder.create(this, "MyCfnEmailIdentity")
 *         .emailIdentity("emailIdentity")
 *         // the properties below are optional
 *         .configurationSetAttributes(ConfigurationSetAttributesProperty.builder()
 *                 .configurationSetName("configurationSetName")
 *                 .build())
 *         .dkimAttributes(DkimAttributesProperty.builder()
 *                 .signingEnabled(false)
 *                 .build())
 *         .dkimSigningAttributes(DkimSigningAttributesProperty.builder()
 *                 .domainSigningPrivateKey("domainSigningPrivateKey")
 *                 .domainSigningSelector("domainSigningSelector")
 *                 .nextSigningKeyLength("nextSigningKeyLength")
 *                 .build())
 *         .feedbackAttributes(FeedbackAttributesProperty.builder()
 *                 .emailForwardingEnabled(false)
 *                 .build())
 *         .mailFromAttributes(MailFromAttributesProperty.builder()
 *                 .behaviorOnMxFailure("behaviorOnMxFailure")
 *                 .mailFromDomain("mailFromDomain")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:54.444Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnEmailIdentity")
public class CfnEmailIdentity extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnEmailIdentity(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEmailIdentity(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ses.CfnEmailIdentity.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::SES::EmailIdentity`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEmailIdentity(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.CfnEmailIdentityProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDkimDnsTokenName1() {
        return software.amazon.jsii.Kernel.get(this, "attrDkimDnsTokenName1", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDkimDnsTokenName2() {
        return software.amazon.jsii.Kernel.get(this, "attrDkimDnsTokenName2", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDkimDnsTokenName3() {
        return software.amazon.jsii.Kernel.get(this, "attrDkimDnsTokenName3", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDkimDnsTokenValue1() {
        return software.amazon.jsii.Kernel.get(this, "attrDkimDnsTokenValue1", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDkimDnsTokenValue2() {
        return software.amazon.jsii.Kernel.get(this, "attrDkimDnsTokenValue2", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDkimDnsTokenValue3() {
        return software.amazon.jsii.Kernel.get(this, "attrDkimDnsTokenValue3", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::SES::EmailIdentity.EmailIdentity`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEmailIdentity() {
        return software.amazon.jsii.Kernel.get(this, "emailIdentity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::SES::EmailIdentity.EmailIdentity`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEmailIdentity(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "emailIdentity", java.util.Objects.requireNonNull(value, "emailIdentity is required"));
    }

    /**
     * `AWS::SES::EmailIdentity.ConfigurationSetAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfigurationSetAttributes() {
        return software.amazon.jsii.Kernel.get(this, "configurationSetAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SES::EmailIdentity.ConfigurationSetAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationSetAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnEmailIdentity.ConfigurationSetAttributesProperty value) {
        software.amazon.jsii.Kernel.set(this, "configurationSetAttributes", value);
    }

    /**
     * `AWS::SES::EmailIdentity.ConfigurationSetAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationSetAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configurationSetAttributes", value);
    }

    /**
     * `AWS::SES::EmailIdentity.DkimAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDkimAttributes() {
        return software.amazon.jsii.Kernel.get(this, "dkimAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SES::EmailIdentity.DkimAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDkimAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnEmailIdentity.DkimAttributesProperty value) {
        software.amazon.jsii.Kernel.set(this, "dkimAttributes", value);
    }

    /**
     * `AWS::SES::EmailIdentity.DkimAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDkimAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dkimAttributes", value);
    }

    /**
     * `AWS::SES::EmailIdentity.DkimSigningAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDkimSigningAttributes() {
        return software.amazon.jsii.Kernel.get(this, "dkimSigningAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SES::EmailIdentity.DkimSigningAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDkimSigningAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnEmailIdentity.DkimSigningAttributesProperty value) {
        software.amazon.jsii.Kernel.set(this, "dkimSigningAttributes", value);
    }

    /**
     * `AWS::SES::EmailIdentity.DkimSigningAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDkimSigningAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dkimSigningAttributes", value);
    }

    /**
     * `AWS::SES::EmailIdentity.FeedbackAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFeedbackAttributes() {
        return software.amazon.jsii.Kernel.get(this, "feedbackAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SES::EmailIdentity.FeedbackAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFeedbackAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnEmailIdentity.FeedbackAttributesProperty value) {
        software.amazon.jsii.Kernel.set(this, "feedbackAttributes", value);
    }

    /**
     * `AWS::SES::EmailIdentity.FeedbackAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFeedbackAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "feedbackAttributes", value);
    }

    /**
     * `AWS::SES::EmailIdentity.MailFromAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMailFromAttributes() {
        return software.amazon.jsii.Kernel.get(this, "mailFromAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::SES::EmailIdentity.MailFromAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMailFromAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.CfnEmailIdentity.MailFromAttributesProperty value) {
        software.amazon.jsii.Kernel.set(this, "mailFromAttributes", value);
    }

    /**
     * `AWS::SES::EmailIdentity.MailFromAttributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMailFromAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mailFromAttributes", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * ConfigurationSetAttributesProperty configurationSetAttributesProperty = ConfigurationSetAttributesProperty.builder()
     *         .configurationSetName("configurationSetName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnEmailIdentity.ConfigurationSetAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigurationSetAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfigurationSetAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEmailIdentity.ConfigurationSetAttributesProperty.ConfigurationSetName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConfigurationSetName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfigurationSetAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigurationSetAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigurationSetAttributesProperty> {
            java.lang.String configurationSetName;

            /**
             * Sets the value of {@link ConfigurationSetAttributesProperty#getConfigurationSetName}
             * @param configurationSetName `CfnEmailIdentity.ConfigurationSetAttributesProperty.ConfigurationSetName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurationSetName(java.lang.String configurationSetName) {
                this.configurationSetName = configurationSetName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationSetAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfigurationSetAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfigurationSetAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationSetAttributesProperty {
            private final java.lang.String configurationSetName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configurationSetName = software.amazon.jsii.Kernel.get(this, "configurationSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configurationSetName = builder.configurationSetName;
            }

            @Override
            public final java.lang.String getConfigurationSetName() {
                return this.configurationSetName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConfigurationSetName() != null) {
                    data.set("configurationSetName", om.valueToTree(this.getConfigurationSetName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnEmailIdentity.ConfigurationSetAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigurationSetAttributesProperty.Jsii$Proxy that = (ConfigurationSetAttributesProperty.Jsii$Proxy) o;

                return this.configurationSetName != null ? this.configurationSetName.equals(that.configurationSetName) : that.configurationSetName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.configurationSetName != null ? this.configurationSetName.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * DkimAttributesProperty dkimAttributesProperty = DkimAttributesProperty.builder()
     *         .signingEnabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnEmailIdentity.DkimAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(DkimAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DkimAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEmailIdentity.DkimAttributesProperty.SigningEnabled`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSigningEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DkimAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DkimAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DkimAttributesProperty> {
            java.lang.Object signingEnabled;

            /**
             * Sets the value of {@link DkimAttributesProperty#getSigningEnabled}
             * @param signingEnabled `CfnEmailIdentity.DkimAttributesProperty.SigningEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder signingEnabled(java.lang.Boolean signingEnabled) {
                this.signingEnabled = signingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link DkimAttributesProperty#getSigningEnabled}
             * @param signingEnabled `CfnEmailIdentity.DkimAttributesProperty.SigningEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder signingEnabled(software.amazon.awscdk.IResolvable signingEnabled) {
                this.signingEnabled = signingEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DkimAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DkimAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DkimAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DkimAttributesProperty {
            private final java.lang.Object signingEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.signingEnabled = software.amazon.jsii.Kernel.get(this, "signingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.signingEnabled = builder.signingEnabled;
            }

            @Override
            public final java.lang.Object getSigningEnabled() {
                return this.signingEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSigningEnabled() != null) {
                    data.set("signingEnabled", om.valueToTree(this.getSigningEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnEmailIdentity.DkimAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DkimAttributesProperty.Jsii$Proxy that = (DkimAttributesProperty.Jsii$Proxy) o;

                return this.signingEnabled != null ? this.signingEnabled.equals(that.signingEnabled) : that.signingEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.signingEnabled != null ? this.signingEnabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * DkimSigningAttributesProperty dkimSigningAttributesProperty = DkimSigningAttributesProperty.builder()
     *         .domainSigningPrivateKey("domainSigningPrivateKey")
     *         .domainSigningSelector("domainSigningSelector")
     *         .nextSigningKeyLength("nextSigningKeyLength")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnEmailIdentity.DkimSigningAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(DkimSigningAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DkimSigningAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEmailIdentity.DkimSigningAttributesProperty.DomainSigningPrivateKey`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDomainSigningPrivateKey() {
            return null;
        }

        /**
         * `CfnEmailIdentity.DkimSigningAttributesProperty.DomainSigningSelector`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDomainSigningSelector() {
            return null;
        }

        /**
         * `CfnEmailIdentity.DkimSigningAttributesProperty.NextSigningKeyLength`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNextSigningKeyLength() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DkimSigningAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DkimSigningAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DkimSigningAttributesProperty> {
            java.lang.String domainSigningPrivateKey;
            java.lang.String domainSigningSelector;
            java.lang.String nextSigningKeyLength;

            /**
             * Sets the value of {@link DkimSigningAttributesProperty#getDomainSigningPrivateKey}
             * @param domainSigningPrivateKey `CfnEmailIdentity.DkimSigningAttributesProperty.DomainSigningPrivateKey`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainSigningPrivateKey(java.lang.String domainSigningPrivateKey) {
                this.domainSigningPrivateKey = domainSigningPrivateKey;
                return this;
            }

            /**
             * Sets the value of {@link DkimSigningAttributesProperty#getDomainSigningSelector}
             * @param domainSigningSelector `CfnEmailIdentity.DkimSigningAttributesProperty.DomainSigningSelector`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainSigningSelector(java.lang.String domainSigningSelector) {
                this.domainSigningSelector = domainSigningSelector;
                return this;
            }

            /**
             * Sets the value of {@link DkimSigningAttributesProperty#getNextSigningKeyLength}
             * @param nextSigningKeyLength `CfnEmailIdentity.DkimSigningAttributesProperty.NextSigningKeyLength`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nextSigningKeyLength(java.lang.String nextSigningKeyLength) {
                this.nextSigningKeyLength = nextSigningKeyLength;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DkimSigningAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DkimSigningAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DkimSigningAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DkimSigningAttributesProperty {
            private final java.lang.String domainSigningPrivateKey;
            private final java.lang.String domainSigningSelector;
            private final java.lang.String nextSigningKeyLength;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainSigningPrivateKey = software.amazon.jsii.Kernel.get(this, "domainSigningPrivateKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.domainSigningSelector = software.amazon.jsii.Kernel.get(this, "domainSigningSelector", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nextSigningKeyLength = software.amazon.jsii.Kernel.get(this, "nextSigningKeyLength", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainSigningPrivateKey = builder.domainSigningPrivateKey;
                this.domainSigningSelector = builder.domainSigningSelector;
                this.nextSigningKeyLength = builder.nextSigningKeyLength;
            }

            @Override
            public final java.lang.String getDomainSigningPrivateKey() {
                return this.domainSigningPrivateKey;
            }

            @Override
            public final java.lang.String getDomainSigningSelector() {
                return this.domainSigningSelector;
            }

            @Override
            public final java.lang.String getNextSigningKeyLength() {
                return this.nextSigningKeyLength;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDomainSigningPrivateKey() != null) {
                    data.set("domainSigningPrivateKey", om.valueToTree(this.getDomainSigningPrivateKey()));
                }
                if (this.getDomainSigningSelector() != null) {
                    data.set("domainSigningSelector", om.valueToTree(this.getDomainSigningSelector()));
                }
                if (this.getNextSigningKeyLength() != null) {
                    data.set("nextSigningKeyLength", om.valueToTree(this.getNextSigningKeyLength()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnEmailIdentity.DkimSigningAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DkimSigningAttributesProperty.Jsii$Proxy that = (DkimSigningAttributesProperty.Jsii$Proxy) o;

                if (this.domainSigningPrivateKey != null ? !this.domainSigningPrivateKey.equals(that.domainSigningPrivateKey) : that.domainSigningPrivateKey != null) return false;
                if (this.domainSigningSelector != null ? !this.domainSigningSelector.equals(that.domainSigningSelector) : that.domainSigningSelector != null) return false;
                return this.nextSigningKeyLength != null ? this.nextSigningKeyLength.equals(that.nextSigningKeyLength) : that.nextSigningKeyLength == null;
            }

            @Override
            public final int hashCode() {
                int result = this.domainSigningPrivateKey != null ? this.domainSigningPrivateKey.hashCode() : 0;
                result = 31 * result + (this.domainSigningSelector != null ? this.domainSigningSelector.hashCode() : 0);
                result = 31 * result + (this.nextSigningKeyLength != null ? this.nextSigningKeyLength.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * FeedbackAttributesProperty feedbackAttributesProperty = FeedbackAttributesProperty.builder()
     *         .emailForwardingEnabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnEmailIdentity.FeedbackAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(FeedbackAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FeedbackAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEmailIdentity.FeedbackAttributesProperty.EmailForwardingEnabled`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmailForwardingEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FeedbackAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FeedbackAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FeedbackAttributesProperty> {
            java.lang.Object emailForwardingEnabled;

            /**
             * Sets the value of {@link FeedbackAttributesProperty#getEmailForwardingEnabled}
             * @param emailForwardingEnabled `CfnEmailIdentity.FeedbackAttributesProperty.EmailForwardingEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailForwardingEnabled(java.lang.Boolean emailForwardingEnabled) {
                this.emailForwardingEnabled = emailForwardingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link FeedbackAttributesProperty#getEmailForwardingEnabled}
             * @param emailForwardingEnabled `CfnEmailIdentity.FeedbackAttributesProperty.EmailForwardingEnabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailForwardingEnabled(software.amazon.awscdk.IResolvable emailForwardingEnabled) {
                this.emailForwardingEnabled = emailForwardingEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FeedbackAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FeedbackAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FeedbackAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FeedbackAttributesProperty {
            private final java.lang.Object emailForwardingEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.emailForwardingEnabled = software.amazon.jsii.Kernel.get(this, "emailForwardingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.emailForwardingEnabled = builder.emailForwardingEnabled;
            }

            @Override
            public final java.lang.Object getEmailForwardingEnabled() {
                return this.emailForwardingEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEmailForwardingEnabled() != null) {
                    data.set("emailForwardingEnabled", om.valueToTree(this.getEmailForwardingEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnEmailIdentity.FeedbackAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FeedbackAttributesProperty.Jsii$Proxy that = (FeedbackAttributesProperty.Jsii$Proxy) o;

                return this.emailForwardingEnabled != null ? this.emailForwardingEnabled.equals(that.emailForwardingEnabled) : that.emailForwardingEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.emailForwardingEnabled != null ? this.emailForwardingEnabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ses.*;
     * MailFromAttributesProperty mailFromAttributesProperty = MailFromAttributesProperty.builder()
     *         .behaviorOnMxFailure("behaviorOnMxFailure")
     *         .mailFromDomain("mailFromDomain")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnEmailIdentity.MailFromAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(MailFromAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MailFromAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEmailIdentity.MailFromAttributesProperty.BehaviorOnMxFailure`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBehaviorOnMxFailure() {
            return null;
        }

        /**
         * `CfnEmailIdentity.MailFromAttributesProperty.MailFromDomain`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMailFromDomain() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MailFromAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MailFromAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MailFromAttributesProperty> {
            java.lang.String behaviorOnMxFailure;
            java.lang.String mailFromDomain;

            /**
             * Sets the value of {@link MailFromAttributesProperty#getBehaviorOnMxFailure}
             * @param behaviorOnMxFailure `CfnEmailIdentity.MailFromAttributesProperty.BehaviorOnMxFailure`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder behaviorOnMxFailure(java.lang.String behaviorOnMxFailure) {
                this.behaviorOnMxFailure = behaviorOnMxFailure;
                return this;
            }

            /**
             * Sets the value of {@link MailFromAttributesProperty#getMailFromDomain}
             * @param mailFromDomain `CfnEmailIdentity.MailFromAttributesProperty.MailFromDomain`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mailFromDomain(java.lang.String mailFromDomain) {
                this.mailFromDomain = mailFromDomain;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MailFromAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MailFromAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MailFromAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MailFromAttributesProperty {
            private final java.lang.String behaviorOnMxFailure;
            private final java.lang.String mailFromDomain;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.behaviorOnMxFailure = software.amazon.jsii.Kernel.get(this, "behaviorOnMxFailure", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mailFromDomain = software.amazon.jsii.Kernel.get(this, "mailFromDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.behaviorOnMxFailure = builder.behaviorOnMxFailure;
                this.mailFromDomain = builder.mailFromDomain;
            }

            @Override
            public final java.lang.String getBehaviorOnMxFailure() {
                return this.behaviorOnMxFailure;
            }

            @Override
            public final java.lang.String getMailFromDomain() {
                return this.mailFromDomain;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBehaviorOnMxFailure() != null) {
                    data.set("behaviorOnMxFailure", om.valueToTree(this.getBehaviorOnMxFailure()));
                }
                if (this.getMailFromDomain() != null) {
                    data.set("mailFromDomain", om.valueToTree(this.getMailFromDomain()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnEmailIdentity.MailFromAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MailFromAttributesProperty.Jsii$Proxy that = (MailFromAttributesProperty.Jsii$Proxy) o;

                if (this.behaviorOnMxFailure != null ? !this.behaviorOnMxFailure.equals(that.behaviorOnMxFailure) : that.behaviorOnMxFailure != null) return false;
                return this.mailFromDomain != null ? this.mailFromDomain.equals(that.mailFromDomain) : that.mailFromDomain == null;
            }

            @Override
            public final int hashCode() {
                int result = this.behaviorOnMxFailure != null ? this.behaviorOnMxFailure.hashCode() : 0;
                result = 31 * result + (this.mailFromDomain != null ? this.mailFromDomain.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.CfnEmailIdentity}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.CfnEmailIdentity> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ses.CfnEmailIdentityProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ses.CfnEmailIdentityProps.Builder();
        }

        /**
         * `AWS::SES::EmailIdentity.EmailIdentity`.
         * <p>
         * @return {@code this}
         * @param emailIdentity `AWS::SES::EmailIdentity.EmailIdentity`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailIdentity(final java.lang.String emailIdentity) {
            this.props.emailIdentity(emailIdentity);
            return this;
        }

        /**
         * `AWS::SES::EmailIdentity.ConfigurationSetAttributes`.
         * <p>
         * @return {@code this}
         * @param configurationSetAttributes `AWS::SES::EmailIdentity.ConfigurationSetAttributes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationSetAttributes(final software.amazon.awscdk.services.ses.CfnEmailIdentity.ConfigurationSetAttributesProperty configurationSetAttributes) {
            this.props.configurationSetAttributes(configurationSetAttributes);
            return this;
        }
        /**
         * `AWS::SES::EmailIdentity.ConfigurationSetAttributes`.
         * <p>
         * @return {@code this}
         * @param configurationSetAttributes `AWS::SES::EmailIdentity.ConfigurationSetAttributes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationSetAttributes(final software.amazon.awscdk.IResolvable configurationSetAttributes) {
            this.props.configurationSetAttributes(configurationSetAttributes);
            return this;
        }

        /**
         * `AWS::SES::EmailIdentity.DkimAttributes`.
         * <p>
         * @return {@code this}
         * @param dkimAttributes `AWS::SES::EmailIdentity.DkimAttributes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dkimAttributes(final software.amazon.awscdk.services.ses.CfnEmailIdentity.DkimAttributesProperty dkimAttributes) {
            this.props.dkimAttributes(dkimAttributes);
            return this;
        }
        /**
         * `AWS::SES::EmailIdentity.DkimAttributes`.
         * <p>
         * @return {@code this}
         * @param dkimAttributes `AWS::SES::EmailIdentity.DkimAttributes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dkimAttributes(final software.amazon.awscdk.IResolvable dkimAttributes) {
            this.props.dkimAttributes(dkimAttributes);
            return this;
        }

        /**
         * `AWS::SES::EmailIdentity.DkimSigningAttributes`.
         * <p>
         * @return {@code this}
         * @param dkimSigningAttributes `AWS::SES::EmailIdentity.DkimSigningAttributes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dkimSigningAttributes(final software.amazon.awscdk.services.ses.CfnEmailIdentity.DkimSigningAttributesProperty dkimSigningAttributes) {
            this.props.dkimSigningAttributes(dkimSigningAttributes);
            return this;
        }
        /**
         * `AWS::SES::EmailIdentity.DkimSigningAttributes`.
         * <p>
         * @return {@code this}
         * @param dkimSigningAttributes `AWS::SES::EmailIdentity.DkimSigningAttributes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dkimSigningAttributes(final software.amazon.awscdk.IResolvable dkimSigningAttributes) {
            this.props.dkimSigningAttributes(dkimSigningAttributes);
            return this;
        }

        /**
         * `AWS::SES::EmailIdentity.FeedbackAttributes`.
         * <p>
         * @return {@code this}
         * @param feedbackAttributes `AWS::SES::EmailIdentity.FeedbackAttributes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder feedbackAttributes(final software.amazon.awscdk.services.ses.CfnEmailIdentity.FeedbackAttributesProperty feedbackAttributes) {
            this.props.feedbackAttributes(feedbackAttributes);
            return this;
        }
        /**
         * `AWS::SES::EmailIdentity.FeedbackAttributes`.
         * <p>
         * @return {@code this}
         * @param feedbackAttributes `AWS::SES::EmailIdentity.FeedbackAttributes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder feedbackAttributes(final software.amazon.awscdk.IResolvable feedbackAttributes) {
            this.props.feedbackAttributes(feedbackAttributes);
            return this;
        }

        /**
         * `AWS::SES::EmailIdentity.MailFromAttributes`.
         * <p>
         * @return {@code this}
         * @param mailFromAttributes `AWS::SES::EmailIdentity.MailFromAttributes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mailFromAttributes(final software.amazon.awscdk.services.ses.CfnEmailIdentity.MailFromAttributesProperty mailFromAttributes) {
            this.props.mailFromAttributes(mailFromAttributes);
            return this;
        }
        /**
         * `AWS::SES::EmailIdentity.MailFromAttributes`.
         * <p>
         * @return {@code this}
         * @param mailFromAttributes `AWS::SES::EmailIdentity.MailFromAttributes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mailFromAttributes(final software.amazon.awscdk.IResolvable mailFromAttributes) {
            this.props.mailFromAttributes(mailFromAttributes);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ses.CfnEmailIdentity}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.CfnEmailIdentity build() {
            return new software.amazon.awscdk.services.ses.CfnEmailIdentity(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
