package software.amazon.awscdk.services.secretsmanager;

/**
 * The properties required to create a new secret in AWS Secrets Manager.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Stack stack;
 * User user = new User(stack, "User");
 * AccessKey accessKey = AccessKey.Builder.create(stack, "AccessKey").user(user).build();
 * Secret.Builder.create(stack, "Secret")
 *         .secretObjectValue(Map.of(
 *                 "username", SecretValue.unsafePlainText(user.getUserName()),
 *                 "database", SecretValue.unsafePlainText("foo"),
 *                 "password", accessKey.getSecretAccessKey()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:54.322Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.SecretProps")
@software.amazon.jsii.Jsii.Proxy(SecretProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SecretProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An optional, human-friendly description of the secret.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The customer-managed encryption key to use for encrypting the secret value.
     * <p>
     * Default: - A default KMS key for the account and region is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * Configuration for how to generate a secret value.
     * <p>
     * Only one of <code>secretString</code> and <code>generateSecretString</code> can be provided.
     * <p>
     * Default: - 32 characters with upper-case letters, lower-case letters, punctuation and numbers (at least one from each
     * category), per the default values of ``SecretStringGenerator``.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.SecretStringGenerator getGenerateSecretString() {
        return null;
    }

    /**
     * Policy to apply when the secret is removed from this stack.
     * <p>
     * Default: - Not set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * A list of regions where to replicate this secret.
     * <p>
     * Default: - Secret is not replicated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion> getReplicaRegions() {
        return null;
    }

    /**
     * A name for the secret.
     * <p>
     * Note that deleting secrets from SecretsManager does not happen immediately, but after a 7 to
     * 30 days blackout period. During that period, it is not possible to create another secret that shares the same name.
     * <p>
     * Default: - A name is generated by CloudFormation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecretName() {
        return null;
    }

    /**
     * Initial value for a JSON secret.
     * <p>
     * <strong>NOTE:</strong> *It is <strong>highly</strong> encouraged to leave this field undefined and allow SecretsManager to create the secret value.
     * The secret object -- if provided -- will be included in the output of the cdk as part of synthesis,
     * and will appear in the CloudFormation template in the console. This can be secure(-ish) if that value is merely reference to
     * another resource (or one of its attributes), but if the value is a plaintext string, it will be visible to anyone with access
     * to the CloudFormation template (via the AWS Console, SDKs, or CLI).
     * <p>
     * Specifies a JSON object that you want to encrypt and store in this new version of the secret.
     * To specify a simple string value instead, use {&#64;link SecretProps.secretStringValue}
     * <p>
     * Only one of <code>secretStringBeta1</code>, <code>secretStringValue</code>, 'secretObjectValue', and <code>generateSecretString</code> can be provided.
     * <p>
     * Default: - SecretsManager generates a new secret value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * User user;
     * AccessKey accessKey;
     * Stack stack;
     * Secret.Builder.create(stack, "JSONSecret")
     *         .secretObjectValue(Map.of(
     *                 "username", SecretValue.unsafePlainText(user.getUserName()),  // intrinsic reference, not exposed as plaintext
     *                 "database", SecretValue.unsafePlainText("foo"),  // rendered as plain text, but not a secret
     *                 "password", accessKey.getSecretAccessKey()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.SecretValue> getSecretObjectValue() {
        return null;
    }

    /**
     * (deprecated) Initial value for the secret.
     * <p>
     * <strong>NOTE:</strong> *It is <strong>highly</strong> encouraged to leave this field undefined and allow SecretsManager to create the secret value.
     * The secret string -- if provided -- will be included in the output of the cdk as part of synthesis,
     * and will appear in the CloudFormation template in the console. This can be secure(-ish) if that value is merely reference to
     * another resource (or one of its attributes), but if the value is a plaintext string, it will be visible to anyone with access
     * to the CloudFormation template (via the AWS Console, SDKs, or CLI).
     * <p>
     * Specifies text data that you want to encrypt and store in this new version of the secret.
     * May be a simple string value, or a string representation of a JSON structure.
     * <p>
     * Only one of <code>secretStringBeta1</code>, <code>secretStringValue</code>, and <code>generateSecretString</code> can be provided.
     * <p>
     * Default: - SecretsManager generates a new secret value.
     * <p>
     * @deprecated Use `secretStringValue` instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.SecretStringValueBeta1 getSecretStringBeta1() {
        return null;
    }

    /**
     * Initial value for the secret.
     * <p>
     * <strong>NOTE:</strong> *It is <strong>highly</strong> encouraged to leave this field undefined and allow SecretsManager to create the secret value.
     * The secret string -- if provided -- will be included in the output of the cdk as part of synthesis,
     * and will appear in the CloudFormation template in the console. This can be secure(-ish) if that value is merely reference to
     * another resource (or one of its attributes), but if the value is a plaintext string, it will be visible to anyone with access
     * to the CloudFormation template (via the AWS Console, SDKs, or CLI).
     * <p>
     * Specifies text data that you want to encrypt and store in this new version of the secret.
     * May be a simple string value. To provide a string representation of JSON structure, use {&#64;link SecretProps.secretObjectValue} instead.
     * <p>
     * Only one of <code>secretStringBeta1</code>, <code>secretStringValue</code>, 'secretObjectValue', and <code>generateSecretString</code> can be provided.
     * <p>
     * Default: - SecretsManager generates a new secret value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.SecretValue getSecretStringValue() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SecretProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SecretProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SecretProps> {
        java.lang.String description;
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        software.amazon.awscdk.services.secretsmanager.SecretStringGenerator generateSecretString;
        software.amazon.awscdk.RemovalPolicy removalPolicy;
        java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion> replicaRegions;
        java.lang.String secretName;
        java.util.Map<java.lang.String, software.amazon.awscdk.SecretValue> secretObjectValue;
        software.amazon.awscdk.services.secretsmanager.SecretStringValueBeta1 secretStringBeta1;
        software.amazon.awscdk.SecretValue secretStringValue;

        /**
         * Sets the value of {@link SecretProps#getDescription}
         * @param description An optional, human-friendly description of the secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link SecretProps#getEncryptionKey}
         * @param encryptionKey The customer-managed encryption key to use for encrypting the secret value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link SecretProps#getGenerateSecretString}
         * @param generateSecretString Configuration for how to generate a secret value.
         *                             Only one of <code>secretString</code> and <code>generateSecretString</code> can be provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateSecretString(software.amazon.awscdk.services.secretsmanager.SecretStringGenerator generateSecretString) {
            this.generateSecretString = generateSecretString;
            return this;
        }

        /**
         * Sets the value of {@link SecretProps#getRemovalPolicy}
         * @param removalPolicy Policy to apply when the secret is removed from this stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link SecretProps#getReplicaRegions}
         * @param replicaRegions A list of regions where to replicate this secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder replicaRegions(java.util.List<? extends software.amazon.awscdk.services.secretsmanager.ReplicaRegion> replicaRegions) {
            this.replicaRegions = (java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion>)replicaRegions;
            return this;
        }

        /**
         * Sets the value of {@link SecretProps#getSecretName}
         * @param secretName A name for the secret.
         *                   Note that deleting secrets from SecretsManager does not happen immediately, but after a 7 to
         *                   30 days blackout period. During that period, it is not possible to create another secret that shares the same name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretName(java.lang.String secretName) {
            this.secretName = secretName;
            return this;
        }

        /**
         * Sets the value of {@link SecretProps#getSecretObjectValue}
         * @param secretObjectValue Initial value for a JSON secret.
         *                          <strong>NOTE:</strong> *It is <strong>highly</strong> encouraged to leave this field undefined and allow SecretsManager to create the secret value.
         *                          The secret object -- if provided -- will be included in the output of the cdk as part of synthesis,
         *                          and will appear in the CloudFormation template in the console. This can be secure(-ish) if that value is merely reference to
         *                          another resource (or one of its attributes), but if the value is a plaintext string, it will be visible to anyone with access
         *                          to the CloudFormation template (via the AWS Console, SDKs, or CLI).
         *                          <p>
         *                          Specifies a JSON object that you want to encrypt and store in this new version of the secret.
         *                          To specify a simple string value instead, use {&#64;link SecretProps.secretStringValue}
         *                          <p>
         *                          Only one of <code>secretStringBeta1</code>, <code>secretStringValue</code>, 'secretObjectValue', and <code>generateSecretString</code> can be provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder secretObjectValue(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.SecretValue> secretObjectValue) {
            this.secretObjectValue = (java.util.Map<java.lang.String, software.amazon.awscdk.SecretValue>)secretObjectValue;
            return this;
        }

        /**
         * Sets the value of {@link SecretProps#getSecretStringBeta1}
         * @param secretStringBeta1 Initial value for the secret.
         *                          <strong>NOTE:</strong> *It is <strong>highly</strong> encouraged to leave this field undefined and allow SecretsManager to create the secret value.
         *                          The secret string -- if provided -- will be included in the output of the cdk as part of synthesis,
         *                          and will appear in the CloudFormation template in the console. This can be secure(-ish) if that value is merely reference to
         *                          another resource (or one of its attributes), but if the value is a plaintext string, it will be visible to anyone with access
         *                          to the CloudFormation template (via the AWS Console, SDKs, or CLI).
         *                          <p>
         *                          Specifies text data that you want to encrypt and store in this new version of the secret.
         *                          May be a simple string value, or a string representation of a JSON structure.
         *                          <p>
         *                          Only one of <code>secretStringBeta1</code>, <code>secretStringValue</code>, and <code>generateSecretString</code> can be provided.
         * @return {@code this}
         * @deprecated Use `secretStringValue` instead.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder secretStringBeta1(software.amazon.awscdk.services.secretsmanager.SecretStringValueBeta1 secretStringBeta1) {
            this.secretStringBeta1 = secretStringBeta1;
            return this;
        }

        /**
         * Sets the value of {@link SecretProps#getSecretStringValue}
         * @param secretStringValue Initial value for the secret.
         *                          <strong>NOTE:</strong> *It is <strong>highly</strong> encouraged to leave this field undefined and allow SecretsManager to create the secret value.
         *                          The secret string -- if provided -- will be included in the output of the cdk as part of synthesis,
         *                          and will appear in the CloudFormation template in the console. This can be secure(-ish) if that value is merely reference to
         *                          another resource (or one of its attributes), but if the value is a plaintext string, it will be visible to anyone with access
         *                          to the CloudFormation template (via the AWS Console, SDKs, or CLI).
         *                          <p>
         *                          Specifies text data that you want to encrypt and store in this new version of the secret.
         *                          May be a simple string value. To provide a string representation of JSON structure, use {&#64;link SecretProps.secretObjectValue} instead.
         *                          <p>
         *                          Only one of <code>secretStringBeta1</code>, <code>secretStringValue</code>, 'secretObjectValue', and <code>generateSecretString</code> can be provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretStringValue(software.amazon.awscdk.SecretValue secretStringValue) {
            this.secretStringValue = secretStringValue;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SecretProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SecretProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SecretProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecretProps {
        private final java.lang.String description;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final software.amazon.awscdk.services.secretsmanager.SecretStringGenerator generateSecretString;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion> replicaRegions;
        private final java.lang.String secretName;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.SecretValue> secretObjectValue;
        private final software.amazon.awscdk.services.secretsmanager.SecretStringValueBeta1 secretStringBeta1;
        private final software.amazon.awscdk.SecretValue secretStringValue;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.generateSecretString = software.amazon.jsii.Kernel.get(this, "generateSecretString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretStringGenerator.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.replicaRegions = software.amazon.jsii.Kernel.get(this, "replicaRegions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ReplicaRegion.class)));
            this.secretName = software.amazon.jsii.Kernel.get(this, "secretName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.secretObjectValue = software.amazon.jsii.Kernel.get(this, "secretObjectValue", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class)));
            this.secretStringBeta1 = software.amazon.jsii.Kernel.get(this, "secretStringBeta1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretStringValueBeta1.class));
            this.secretStringValue = software.amazon.jsii.Kernel.get(this, "secretStringValue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = builder.description;
            this.encryptionKey = builder.encryptionKey;
            this.generateSecretString = builder.generateSecretString;
            this.removalPolicy = builder.removalPolicy;
            this.replicaRegions = (java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion>)builder.replicaRegions;
            this.secretName = builder.secretName;
            this.secretObjectValue = (java.util.Map<java.lang.String, software.amazon.awscdk.SecretValue>)builder.secretObjectValue;
            this.secretStringBeta1 = builder.secretStringBeta1;
            this.secretStringValue = builder.secretStringValue;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.SecretStringGenerator getGenerateSecretString() {
            return this.generateSecretString;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion> getReplicaRegions() {
            return this.replicaRegions;
        }

        @Override
        public final java.lang.String getSecretName() {
            return this.secretName;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.SecretValue> getSecretObjectValue() {
            return this.secretObjectValue;
        }

        @Override
        public final software.amazon.awscdk.services.secretsmanager.SecretStringValueBeta1 getSecretStringBeta1() {
            return this.secretStringBeta1;
        }

        @Override
        public final software.amazon.awscdk.SecretValue getSecretStringValue() {
            return this.secretStringValue;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getGenerateSecretString() != null) {
                data.set("generateSecretString", om.valueToTree(this.getGenerateSecretString()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getReplicaRegions() != null) {
                data.set("replicaRegions", om.valueToTree(this.getReplicaRegions()));
            }
            if (this.getSecretName() != null) {
                data.set("secretName", om.valueToTree(this.getSecretName()));
            }
            if (this.getSecretObjectValue() != null) {
                data.set("secretObjectValue", om.valueToTree(this.getSecretObjectValue()));
            }
            if (this.getSecretStringBeta1() != null) {
                data.set("secretStringBeta1", om.valueToTree(this.getSecretStringBeta1()));
            }
            if (this.getSecretStringValue() != null) {
                data.set("secretStringValue", om.valueToTree(this.getSecretStringValue()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_secretsmanager.SecretProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SecretProps.Jsii$Proxy that = (SecretProps.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.generateSecretString != null ? !this.generateSecretString.equals(that.generateSecretString) : that.generateSecretString != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.replicaRegions != null ? !this.replicaRegions.equals(that.replicaRegions) : that.replicaRegions != null) return false;
            if (this.secretName != null ? !this.secretName.equals(that.secretName) : that.secretName != null) return false;
            if (this.secretObjectValue != null ? !this.secretObjectValue.equals(that.secretObjectValue) : that.secretObjectValue != null) return false;
            if (this.secretStringBeta1 != null ? !this.secretStringBeta1.equals(that.secretStringBeta1) : that.secretStringBeta1 != null) return false;
            return this.secretStringValue != null ? this.secretStringValue.equals(that.secretStringValue) : that.secretStringValue == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.generateSecretString != null ? this.generateSecretString.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.replicaRegions != null ? this.replicaRegions.hashCode() : 0);
            result = 31 * result + (this.secretName != null ? this.secretName.hashCode() : 0);
            result = 31 * result + (this.secretObjectValue != null ? this.secretObjectValue.hashCode() : 0);
            result = 31 * result + (this.secretStringBeta1 != null ? this.secretStringBeta1.hashCode() : 0);
            result = 31 * result + (this.secretStringValue != null ? this.secretStringValue.hashCode() : 0);
            return result;
        }
    }
}
