package software.amazon.awscdk.services.route53;

/**
 * A record to delegate further lookups to a different set of name servers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.route53.*;
 * HostedZone hostedZone;
 * ZoneDelegationRecord zoneDelegationRecord = ZoneDelegationRecord.Builder.create(this, "MyZoneDelegationRecord")
 *         .nameServers(List.of("nameServers"))
 *         .zone(hostedZone)
 *         // the properties below are optional
 *         .comment("comment")
 *         .deleteExisting(false)
 *         .recordName("recordName")
 *         .ttl(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:53.964Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.ZoneDelegationRecord")
public class ZoneDelegationRecord extends software.amazon.awscdk.services.route53.RecordSet {

    protected ZoneDelegationRecord(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ZoneDelegationRecord(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ZoneDelegationRecord(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.ZoneDelegationRecordProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.route53.ZoneDelegationRecord}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.route53.ZoneDelegationRecord> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.route53.ZoneDelegationRecordProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.route53.ZoneDelegationRecordProps.Builder();
        }

        /**
         * The hosted zone in which to define the new record.
         * <p>
         * @return {@code this}
         * @param zone The hosted zone in which to define the new record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zone(final software.amazon.awscdk.services.route53.IHostedZone zone) {
            this.props.zone(zone);
            return this;
        }

        /**
         * A comment to add on the record.
         * <p>
         * Default: no comment
         * <p>
         * @return {@code this}
         * @param comment A comment to add on the record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * Whether to delete the same record set in the hosted zone if it already exists.
         * <p>
         * This allows to deploy a new record set while minimizing the downtime because the
         * new record set will be created immediately after the existing one is deleted. It
         * also avoids "manual" actions to delete existing record sets.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param deleteExisting Whether to delete the same record set in the hosted zone if it already exists. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteExisting(final java.lang.Boolean deleteExisting) {
            this.props.deleteExisting(deleteExisting);
            return this;
        }

        /**
         * The domain name for this record.
         * <p>
         * Default: zone root
         * <p>
         * @return {@code this}
         * @param recordName The domain name for this record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordName(final java.lang.String recordName) {
            this.props.recordName(recordName);
            return this;
        }

        /**
         * The resource record cache time to live (TTL).
         * <p>
         * Default: Duration.minutes(30)
         * <p>
         * @return {@code this}
         * @param ttl The resource record cache time to live (TTL). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ttl(final software.amazon.awscdk.Duration ttl) {
            this.props.ttl(ttl);
            return this;
        }

        /**
         * The name servers to report in the delegation records.
         * <p>
         * @return {@code this}
         * @param nameServers The name servers to report in the delegation records. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nameServers(final java.util.List<java.lang.String> nameServers) {
            this.props.nameServers(nameServers);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.route53.ZoneDelegationRecord}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.route53.ZoneDelegationRecord build() {
            return new software.amazon.awscdk.services.route53.ZoneDelegationRecord(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
