package software.amazon.awscdk.services.pinpoint;

/**
 * A CloudFormation `AWS::Pinpoint::ApplicationSettings`.
 * <p>
 * Specifies the settings for an Amazon Pinpoint application. In Amazon Pinpoint, an <em>application</em> (also referred to as an <em>app</em> or <em>project</em> ) is a collection of related settings, customer information, segments, and campaigns, and other types of Amazon Pinpoint resources.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pinpoint.*;
 * CfnApplicationSettings cfnApplicationSettings = CfnApplicationSettings.Builder.create(this, "MyCfnApplicationSettings")
 *         .applicationId("applicationId")
 *         // the properties below are optional
 *         .campaignHook(CampaignHookProperty.builder()
 *                 .lambdaFunctionName("lambdaFunctionName")
 *                 .mode("mode")
 *                 .webUrl("webUrl")
 *                 .build())
 *         .cloudWatchMetricsEnabled(false)
 *         .limits(LimitsProperty.builder()
 *                 .daily(123)
 *                 .maximumDuration(123)
 *                 .messagesPerSecond(123)
 *                 .total(123)
 *                 .build())
 *         .quietTime(QuietTimeProperty.builder()
 *                 .end("end")
 *                 .start("start")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:53.489Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnApplicationSettings")
public class CfnApplicationSettings extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnApplicationSettings(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplicationSettings(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.pinpoint.CfnApplicationSettings.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Pinpoint::ApplicationSettings`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApplicationSettings(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.pinpoint.CfnApplicationSettingsProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The unique identifier for the Amazon Pinpoint application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApplicationId() {
        return software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for the Amazon Pinpoint application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applicationId", java.util.Objects.requireNonNull(value, "applicationId is required"));
    }

    /**
     * The settings for the Lambda function to use by default as a code hook for campaigns in the application.
     * <p>
     * To override these settings for a specific campaign, use the Campaign resource to define custom Lambda function settings for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCampaignHook() {
        return software.amazon.jsii.Kernel.get(this, "campaignHook", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The settings for the Lambda function to use by default as a code hook for campaigns in the application.
     * <p>
     * To override these settings for a specific campaign, use the Campaign resource to define custom Lambda function settings for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCampaignHook(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pinpoint.CfnApplicationSettings.CampaignHookProperty value) {
        software.amazon.jsii.Kernel.set(this, "campaignHook", value);
    }

    /**
     * The settings for the Lambda function to use by default as a code hook for campaigns in the application.
     * <p>
     * To override these settings for a specific campaign, use the Campaign resource to define custom Lambda function settings for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCampaignHook(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "campaignHook", value);
    }

    /**
     * Specifies whether to enable application-related alarms in Amazon CloudWatch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchMetricsEnabled() {
        return software.amazon.jsii.Kernel.get(this, "cloudWatchMetricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether to enable application-related alarms in Amazon CloudWatch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCloudWatchMetricsEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "cloudWatchMetricsEnabled", value);
    }

    /**
     * Specifies whether to enable application-related alarms in Amazon CloudWatch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCloudWatchMetricsEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cloudWatchMetricsEnabled", value);
    }

    /**
     * The default sending limits for campaigns in the application.
     * <p>
     * To override these limits for a specific campaign, use the Campaign resource to define custom limits for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLimits() {
        return software.amazon.jsii.Kernel.get(this, "limits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The default sending limits for campaigns in the application.
     * <p>
     * To override these limits for a specific campaign, use the Campaign resource to define custom limits for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLimits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pinpoint.CfnApplicationSettings.LimitsProperty value) {
        software.amazon.jsii.Kernel.set(this, "limits", value);
    }

    /**
     * The default sending limits for campaigns in the application.
     * <p>
     * To override these limits for a specific campaign, use the Campaign resource to define custom limits for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLimits(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "limits", value);
    }

    /**
     * The default quiet time for campaigns in the application.
     * <p>
     * Quiet time is a specific time range when campaigns don't send messages to endpoints, if all the following conditions are met:
     * <p>
     * <ul>
     * <li>The <code>EndpointDemographic.Timezone</code> property of the endpoint is set to a valid value.</li>
     * <li>The current time in the endpoint's time zone is later than or equal to the time specified by the <code>QuietTime.Start</code> property for the application (or a campaign that has custom quiet time settings).</li>
     * <li>The current time in the endpoint's time zone is earlier than or equal to the time specified by the <code>QuietTime.End</code> property for the application (or a campaign that has custom quiet time settings).</li>
     * </ul>
     * <p>
     * If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign, even if quiet time is enabled.
     * <p>
     * To override the default quiet time settings for a specific campaign, use the Campaign resource to define a custom quiet time for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getQuietTime() {
        return software.amazon.jsii.Kernel.get(this, "quietTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The default quiet time for campaigns in the application.
     * <p>
     * Quiet time is a specific time range when campaigns don't send messages to endpoints, if all the following conditions are met:
     * <p>
     * <ul>
     * <li>The <code>EndpointDemographic.Timezone</code> property of the endpoint is set to a valid value.</li>
     * <li>The current time in the endpoint's time zone is later than or equal to the time specified by the <code>QuietTime.Start</code> property for the application (or a campaign that has custom quiet time settings).</li>
     * <li>The current time in the endpoint's time zone is earlier than or equal to the time specified by the <code>QuietTime.End</code> property for the application (or a campaign that has custom quiet time settings).</li>
     * </ul>
     * <p>
     * If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign, even if quiet time is enabled.
     * <p>
     * To override the default quiet time settings for a specific campaign, use the Campaign resource to define a custom quiet time for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQuietTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.pinpoint.CfnApplicationSettings.QuietTimeProperty value) {
        software.amazon.jsii.Kernel.set(this, "quietTime", value);
    }

    /**
     * The default quiet time for campaigns in the application.
     * <p>
     * Quiet time is a specific time range when campaigns don't send messages to endpoints, if all the following conditions are met:
     * <p>
     * <ul>
     * <li>The <code>EndpointDemographic.Timezone</code> property of the endpoint is set to a valid value.</li>
     * <li>The current time in the endpoint's time zone is later than or equal to the time specified by the <code>QuietTime.Start</code> property for the application (or a campaign that has custom quiet time settings).</li>
     * <li>The current time in the endpoint's time zone is earlier than or equal to the time specified by the <code>QuietTime.End</code> property for the application (or a campaign that has custom quiet time settings).</li>
     * </ul>
     * <p>
     * If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign, even if quiet time is enabled.
     * <p>
     * To override the default quiet time settings for a specific campaign, use the Campaign resource to define a custom quiet time for the campaign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQuietTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "quietTime", value);
    }
    /**
     * Specifies the Lambda function to use by default as a code hook for campaigns in the application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * CampaignHookProperty campaignHookProperty = CampaignHookProperty.builder()
     *         .lambdaFunctionName("lambdaFunctionName")
     *         .mode("mode")
     *         .webUrl("webUrl")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnApplicationSettings.CampaignHookProperty")
    @software.amazon.jsii.Jsii.Proxy(CampaignHookProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CampaignHookProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name or Amazon Resource Name (ARN) of the Lambda function that Amazon Pinpoint invokes to send messages for campaigns in the application.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLambdaFunctionName() {
            return null;
        }

        /**
         * The mode that Amazon Pinpoint uses to invoke the Lambda function. Possible values are:.
         * <p>
         * <ul>
         * <li><code>FILTER</code> - Invoke the function to customize the segment that's used by a campaign.</li>
         * <li><code>DELIVERY</code> - (Deprecated) Previously, invoked the function to send a campaign through a custom channel. This functionality is not supported anymore. To send a campaign through a custom channel, use the <code>CustomDeliveryConfiguration</code> and <code>CampaignCustomMessage</code> objects of the campaign.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMode() {
            return null;
        }

        /**
         * The web URL that Amazon Pinpoint calls to invoke the Lambda function over HTTPS.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWebUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CampaignHookProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CampaignHookProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CampaignHookProperty> {
            java.lang.String lambdaFunctionName;
            java.lang.String mode;
            java.lang.String webUrl;

            /**
             * Sets the value of {@link CampaignHookProperty#getLambdaFunctionName}
             * @param lambdaFunctionName The name or Amazon Resource Name (ARN) of the Lambda function that Amazon Pinpoint invokes to send messages for campaigns in the application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionName(java.lang.String lambdaFunctionName) {
                this.lambdaFunctionName = lambdaFunctionName;
                return this;
            }

            /**
             * Sets the value of {@link CampaignHookProperty#getMode}
             * @param mode The mode that Amazon Pinpoint uses to invoke the Lambda function. Possible values are:.
             *             <ul>
             *             <li><code>FILTER</code> - Invoke the function to customize the segment that's used by a campaign.</li>
             *             <li><code>DELIVERY</code> - (Deprecated) Previously, invoked the function to send a campaign through a custom channel. This functionality is not supported anymore. To send a campaign through a custom channel, use the <code>CustomDeliveryConfiguration</code> and <code>CampaignCustomMessage</code> objects of the campaign.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Sets the value of {@link CampaignHookProperty#getWebUrl}
             * @param webUrl The web URL that Amazon Pinpoint calls to invoke the Lambda function over HTTPS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webUrl(java.lang.String webUrl) {
                this.webUrl = webUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CampaignHookProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CampaignHookProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CampaignHookProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CampaignHookProperty {
            private final java.lang.String lambdaFunctionName;
            private final java.lang.String mode;
            private final java.lang.String webUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lambdaFunctionName = software.amazon.jsii.Kernel.get(this, "lambdaFunctionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.webUrl = software.amazon.jsii.Kernel.get(this, "webUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lambdaFunctionName = builder.lambdaFunctionName;
                this.mode = builder.mode;
                this.webUrl = builder.webUrl;
            }

            @Override
            public final java.lang.String getLambdaFunctionName() {
                return this.lambdaFunctionName;
            }

            @Override
            public final java.lang.String getMode() {
                return this.mode;
            }

            @Override
            public final java.lang.String getWebUrl() {
                return this.webUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLambdaFunctionName() != null) {
                    data.set("lambdaFunctionName", om.valueToTree(this.getLambdaFunctionName()));
                }
                if (this.getMode() != null) {
                    data.set("mode", om.valueToTree(this.getMode()));
                }
                if (this.getWebUrl() != null) {
                    data.set("webUrl", om.valueToTree(this.getWebUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnApplicationSettings.CampaignHookProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CampaignHookProperty.Jsii$Proxy that = (CampaignHookProperty.Jsii$Proxy) o;

                if (this.lambdaFunctionName != null ? !this.lambdaFunctionName.equals(that.lambdaFunctionName) : that.lambdaFunctionName != null) return false;
                if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) return false;
                return this.webUrl != null ? this.webUrl.equals(that.webUrl) : that.webUrl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.lambdaFunctionName != null ? this.lambdaFunctionName.hashCode() : 0;
                result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
                result = 31 * result + (this.webUrl != null ? this.webUrl.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the default sending limits for campaigns in the application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * LimitsProperty limitsProperty = LimitsProperty.builder()
     *         .daily(123)
     *         .maximumDuration(123)
     *         .messagesPerSecond(123)
     *         .total(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnApplicationSettings.LimitsProperty")
    @software.amazon.jsii.Jsii.Proxy(LimitsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LimitsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of messages that a campaign can send to a single endpoint during a 24-hour period.
         * <p>
         * The maximum value is 100.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDaily() {
            return null;
        }

        /**
         * The maximum amount of time, in seconds, that a campaign can attempt to deliver a message after the scheduled start time for the campaign.
         * <p>
         * The minimum value is 60 seconds.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumDuration() {
            return null;
        }

        /**
         * The maximum number of messages that a campaign can send each second.
         * <p>
         * The minimum value is 50. The maximum value is 20,000.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMessagesPerSecond() {
            return null;
        }

        /**
         * The maximum number of messages that a campaign can send to a single endpoint during the course of the campaign.
         * <p>
         * The maximum value is 100.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTotal() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LimitsProperty> {
            java.lang.Number daily;
            java.lang.Number maximumDuration;
            java.lang.Number messagesPerSecond;
            java.lang.Number total;

            /**
             * Sets the value of {@link LimitsProperty#getDaily}
             * @param daily The maximum number of messages that a campaign can send to a single endpoint during a 24-hour period.
             *              The maximum value is 100.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder daily(java.lang.Number daily) {
                this.daily = daily;
                return this;
            }

            /**
             * Sets the value of {@link LimitsProperty#getMaximumDuration}
             * @param maximumDuration The maximum amount of time, in seconds, that a campaign can attempt to deliver a message after the scheduled start time for the campaign.
             *                        The minimum value is 60 seconds.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumDuration(java.lang.Number maximumDuration) {
                this.maximumDuration = maximumDuration;
                return this;
            }

            /**
             * Sets the value of {@link LimitsProperty#getMessagesPerSecond}
             * @param messagesPerSecond The maximum number of messages that a campaign can send each second.
             *                          The minimum value is 50. The maximum value is 20,000.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messagesPerSecond(java.lang.Number messagesPerSecond) {
                this.messagesPerSecond = messagesPerSecond;
                return this;
            }

            /**
             * Sets the value of {@link LimitsProperty#getTotal}
             * @param total The maximum number of messages that a campaign can send to a single endpoint during the course of the campaign.
             *              The maximum value is 100.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder total(java.lang.Number total) {
                this.total = total;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LimitsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LimitsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LimitsProperty {
            private final java.lang.Number daily;
            private final java.lang.Number maximumDuration;
            private final java.lang.Number messagesPerSecond;
            private final java.lang.Number total;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.daily = software.amazon.jsii.Kernel.get(this, "daily", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumDuration = software.amazon.jsii.Kernel.get(this, "maximumDuration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.messagesPerSecond = software.amazon.jsii.Kernel.get(this, "messagesPerSecond", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.total = software.amazon.jsii.Kernel.get(this, "total", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.daily = builder.daily;
                this.maximumDuration = builder.maximumDuration;
                this.messagesPerSecond = builder.messagesPerSecond;
                this.total = builder.total;
            }

            @Override
            public final java.lang.Number getDaily() {
                return this.daily;
            }

            @Override
            public final java.lang.Number getMaximumDuration() {
                return this.maximumDuration;
            }

            @Override
            public final java.lang.Number getMessagesPerSecond() {
                return this.messagesPerSecond;
            }

            @Override
            public final java.lang.Number getTotal() {
                return this.total;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDaily() != null) {
                    data.set("daily", om.valueToTree(this.getDaily()));
                }
                if (this.getMaximumDuration() != null) {
                    data.set("maximumDuration", om.valueToTree(this.getMaximumDuration()));
                }
                if (this.getMessagesPerSecond() != null) {
                    data.set("messagesPerSecond", om.valueToTree(this.getMessagesPerSecond()));
                }
                if (this.getTotal() != null) {
                    data.set("total", om.valueToTree(this.getTotal()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnApplicationSettings.LimitsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LimitsProperty.Jsii$Proxy that = (LimitsProperty.Jsii$Proxy) o;

                if (this.daily != null ? !this.daily.equals(that.daily) : that.daily != null) return false;
                if (this.maximumDuration != null ? !this.maximumDuration.equals(that.maximumDuration) : that.maximumDuration != null) return false;
                if (this.messagesPerSecond != null ? !this.messagesPerSecond.equals(that.messagesPerSecond) : that.messagesPerSecond != null) return false;
                return this.total != null ? this.total.equals(that.total) : that.total == null;
            }

            @Override
            public final int hashCode() {
                int result = this.daily != null ? this.daily.hashCode() : 0;
                result = 31 * result + (this.maximumDuration != null ? this.maximumDuration.hashCode() : 0);
                result = 31 * result + (this.messagesPerSecond != null ? this.messagesPerSecond.hashCode() : 0);
                result = 31 * result + (this.total != null ? this.total.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the start and end times that define a time range when messages aren't sent to endpoints.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.pinpoint.*;
     * QuietTimeProperty quietTimeProperty = QuietTimeProperty.builder()
     *         .end("end")
     *         .start("start")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnApplicationSettings.QuietTimeProperty")
    @software.amazon.jsii.Jsii.Proxy(QuietTimeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QuietTimeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The specific time when quiet time ends.
         * <p>
         * This value has to use 24-hour notation and be in HH:MM format, where HH is the hour (with a leading zero, if applicable) and MM is the minutes. For example, use <code>02:30</code> to represent 2:30 AM, or <code>14:30</code> to represent 2:30 PM.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEnd();

        /**
         * The specific time when quiet time begins.
         * <p>
         * This value has to use 24-hour notation and be in HH:MM format, where HH is the hour (with a leading zero, if applicable) and MM is the minutes. For example, use <code>02:30</code> to represent 2:30 AM, or <code>14:30</code> to represent 2:30 PM.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStart();

        /**
         * @return a {@link Builder} of {@link QuietTimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QuietTimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QuietTimeProperty> {
            java.lang.String end;
            java.lang.String start;

            /**
             * Sets the value of {@link QuietTimeProperty#getEnd}
             * @param end The specific time when quiet time ends. This parameter is required.
             *            This value has to use 24-hour notation and be in HH:MM format, where HH is the hour (with a leading zero, if applicable) and MM is the minutes. For example, use <code>02:30</code> to represent 2:30 AM, or <code>14:30</code> to represent 2:30 PM.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder end(java.lang.String end) {
                this.end = end;
                return this;
            }

            /**
             * Sets the value of {@link QuietTimeProperty#getStart}
             * @param start The specific time when quiet time begins. This parameter is required.
             *              This value has to use 24-hour notation and be in HH:MM format, where HH is the hour (with a leading zero, if applicable) and MM is the minutes. For example, use <code>02:30</code> to represent 2:30 AM, or <code>14:30</code> to represent 2:30 PM.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder start(java.lang.String start) {
                this.start = start;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QuietTimeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QuietTimeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QuietTimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QuietTimeProperty {
            private final java.lang.String end;
            private final java.lang.String start;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.end = software.amazon.jsii.Kernel.get(this, "end", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.start = software.amazon.jsii.Kernel.get(this, "start", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.end = java.util.Objects.requireNonNull(builder.end, "end is required");
                this.start = java.util.Objects.requireNonNull(builder.start, "start is required");
            }

            @Override
            public final java.lang.String getEnd() {
                return this.end;
            }

            @Override
            public final java.lang.String getStart() {
                return this.start;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("end", om.valueToTree(this.getEnd()));
                data.set("start", om.valueToTree(this.getStart()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnApplicationSettings.QuietTimeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QuietTimeProperty.Jsii$Proxy that = (QuietTimeProperty.Jsii$Proxy) o;

                if (!end.equals(that.end)) return false;
                return this.start.equals(that.start);
            }

            @Override
            public final int hashCode() {
                int result = this.end.hashCode();
                result = 31 * result + (this.start.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.pinpoint.CfnApplicationSettings}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.pinpoint.CfnApplicationSettings> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.pinpoint.CfnApplicationSettingsProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.pinpoint.CfnApplicationSettingsProps.Builder();
        }

        /**
         * The unique identifier for the Amazon Pinpoint application.
         * <p>
         * @return {@code this}
         * @param applicationId The unique identifier for the Amazon Pinpoint application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(final java.lang.String applicationId) {
            this.props.applicationId(applicationId);
            return this;
        }

        /**
         * The settings for the Lambda function to use by default as a code hook for campaigns in the application.
         * <p>
         * To override these settings for a specific campaign, use the Campaign resource to define custom Lambda function settings for the campaign.
         * <p>
         * @return {@code this}
         * @param campaignHook The settings for the Lambda function to use by default as a code hook for campaigns in the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder campaignHook(final software.amazon.awscdk.services.pinpoint.CfnApplicationSettings.CampaignHookProperty campaignHook) {
            this.props.campaignHook(campaignHook);
            return this;
        }
        /**
         * The settings for the Lambda function to use by default as a code hook for campaigns in the application.
         * <p>
         * To override these settings for a specific campaign, use the Campaign resource to define custom Lambda function settings for the campaign.
         * <p>
         * @return {@code this}
         * @param campaignHook The settings for the Lambda function to use by default as a code hook for campaigns in the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder campaignHook(final software.amazon.awscdk.IResolvable campaignHook) {
            this.props.campaignHook(campaignHook);
            return this;
        }

        /**
         * Specifies whether to enable application-related alarms in Amazon CloudWatch.
         * <p>
         * @return {@code this}
         * @param cloudWatchMetricsEnabled Specifies whether to enable application-related alarms in Amazon CloudWatch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchMetricsEnabled(final java.lang.Boolean cloudWatchMetricsEnabled) {
            this.props.cloudWatchMetricsEnabled(cloudWatchMetricsEnabled);
            return this;
        }
        /**
         * Specifies whether to enable application-related alarms in Amazon CloudWatch.
         * <p>
         * @return {@code this}
         * @param cloudWatchMetricsEnabled Specifies whether to enable application-related alarms in Amazon CloudWatch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchMetricsEnabled(final software.amazon.awscdk.IResolvable cloudWatchMetricsEnabled) {
            this.props.cloudWatchMetricsEnabled(cloudWatchMetricsEnabled);
            return this;
        }

        /**
         * The default sending limits for campaigns in the application.
         * <p>
         * To override these limits for a specific campaign, use the Campaign resource to define custom limits for the campaign.
         * <p>
         * @return {@code this}
         * @param limits The default sending limits for campaigns in the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder limits(final software.amazon.awscdk.services.pinpoint.CfnApplicationSettings.LimitsProperty limits) {
            this.props.limits(limits);
            return this;
        }
        /**
         * The default sending limits for campaigns in the application.
         * <p>
         * To override these limits for a specific campaign, use the Campaign resource to define custom limits for the campaign.
         * <p>
         * @return {@code this}
         * @param limits The default sending limits for campaigns in the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder limits(final software.amazon.awscdk.IResolvable limits) {
            this.props.limits(limits);
            return this;
        }

        /**
         * The default quiet time for campaigns in the application.
         * <p>
         * Quiet time is a specific time range when campaigns don't send messages to endpoints, if all the following conditions are met:
         * <p>
         * <ul>
         * <li>The <code>EndpointDemographic.Timezone</code> property of the endpoint is set to a valid value.</li>
         * <li>The current time in the endpoint's time zone is later than or equal to the time specified by the <code>QuietTime.Start</code> property for the application (or a campaign that has custom quiet time settings).</li>
         * <li>The current time in the endpoint's time zone is earlier than or equal to the time specified by the <code>QuietTime.End</code> property for the application (or a campaign that has custom quiet time settings).</li>
         * </ul>
         * <p>
         * If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign, even if quiet time is enabled.
         * <p>
         * To override the default quiet time settings for a specific campaign, use the Campaign resource to define a custom quiet time for the campaign.
         * <p>
         * @return {@code this}
         * @param quietTime The default quiet time for campaigns in the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quietTime(final software.amazon.awscdk.services.pinpoint.CfnApplicationSettings.QuietTimeProperty quietTime) {
            this.props.quietTime(quietTime);
            return this;
        }
        /**
         * The default quiet time for campaigns in the application.
         * <p>
         * Quiet time is a specific time range when campaigns don't send messages to endpoints, if all the following conditions are met:
         * <p>
         * <ul>
         * <li>The <code>EndpointDemographic.Timezone</code> property of the endpoint is set to a valid value.</li>
         * <li>The current time in the endpoint's time zone is later than or equal to the time specified by the <code>QuietTime.Start</code> property for the application (or a campaign that has custom quiet time settings).</li>
         * <li>The current time in the endpoint's time zone is earlier than or equal to the time specified by the <code>QuietTime.End</code> property for the application (or a campaign that has custom quiet time settings).</li>
         * </ul>
         * <p>
         * If any of the preceding conditions isn't met, the endpoint will receive messages from a campaign, even if quiet time is enabled.
         * <p>
         * To override the default quiet time settings for a specific campaign, use the Campaign resource to define a custom quiet time for the campaign.
         * <p>
         * @return {@code this}
         * @param quietTime The default quiet time for campaigns in the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quietTime(final software.amazon.awscdk.IResolvable quietTime) {
            this.props.quietTime(quietTime);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.pinpoint.CfnApplicationSettings}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.pinpoint.CfnApplicationSettings build() {
            return new software.amazon.awscdk.services.pinpoint.CfnApplicationSettings(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
