package software.amazon.awscdk.services.networkmanager;

/**
 * Properties for defining a `CfnConnectPeer`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkmanager.*;
 * CfnConnectPeerProps cfnConnectPeerProps = CfnConnectPeerProps.builder()
 *         .bgpOptions(BgpOptionsProperty.builder()
 *                 .peerAsn(123)
 *                 .build())
 *         .connectAttachmentId("connectAttachmentId")
 *         .coreNetworkAddress("coreNetworkAddress")
 *         .insideCidrBlocks(List.of("insideCidrBlocks"))
 *         .peerAddress("peerAddress")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:53.355Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkmanager.CfnConnectPeerProps")
@software.amazon.jsii.Jsii.Proxy(CfnConnectPeerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConnectPeerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The BGP peer options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBgpOptions() {
        return null;
    }

    /**
     * The ID of Connect peer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConnectAttachmentId() {
        return null;
    }

    /**
     * The IP address of a core network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCoreNetworkAddress() {
        return null;
    }

    /**
     * The inside IP addresses used for a Connect peer configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInsideCidrBlocks() {
        return null;
    }

    /**
     * The IP address of the Connect peer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPeerAddress() {
        return null;
    }

    /**
     * The tags associated with the Connect peer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConnectPeerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConnectPeerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConnectPeerProps> {
        java.lang.Object bgpOptions;
        java.lang.String connectAttachmentId;
        java.lang.String coreNetworkAddress;
        java.util.List<java.lang.String> insideCidrBlocks;
        java.lang.String peerAddress;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnConnectPeerProps#getBgpOptions}
         * @param bgpOptions The BGP peer options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bgpOptions(software.amazon.awscdk.services.networkmanager.CfnConnectPeer.BgpOptionsProperty bgpOptions) {
            this.bgpOptions = bgpOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectPeerProps#getBgpOptions}
         * @param bgpOptions The BGP peer options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bgpOptions(software.amazon.awscdk.IResolvable bgpOptions) {
            this.bgpOptions = bgpOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectPeerProps#getConnectAttachmentId}
         * @param connectAttachmentId The ID of Connect peer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectAttachmentId(java.lang.String connectAttachmentId) {
            this.connectAttachmentId = connectAttachmentId;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectPeerProps#getCoreNetworkAddress}
         * @param coreNetworkAddress The IP address of a core network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreNetworkAddress(java.lang.String coreNetworkAddress) {
            this.coreNetworkAddress = coreNetworkAddress;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectPeerProps#getInsideCidrBlocks}
         * @param insideCidrBlocks The inside IP addresses used for a Connect peer configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insideCidrBlocks(java.util.List<java.lang.String> insideCidrBlocks) {
            this.insideCidrBlocks = insideCidrBlocks;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectPeerProps#getPeerAddress}
         * @param peerAddress The IP address of the Connect peer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder peerAddress(java.lang.String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectPeerProps#getTags}
         * @param tags The tags associated with the Connect peer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConnectPeerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConnectPeerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConnectPeerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConnectPeerProps {
        private final java.lang.Object bgpOptions;
        private final java.lang.String connectAttachmentId;
        private final java.lang.String coreNetworkAddress;
        private final java.util.List<java.lang.String> insideCidrBlocks;
        private final java.lang.String peerAddress;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bgpOptions = software.amazon.jsii.Kernel.get(this, "bgpOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.connectAttachmentId = software.amazon.jsii.Kernel.get(this, "connectAttachmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.coreNetworkAddress = software.amazon.jsii.Kernel.get(this, "coreNetworkAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.insideCidrBlocks = software.amazon.jsii.Kernel.get(this, "insideCidrBlocks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.peerAddress = software.amazon.jsii.Kernel.get(this, "peerAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bgpOptions = builder.bgpOptions;
            this.connectAttachmentId = builder.connectAttachmentId;
            this.coreNetworkAddress = builder.coreNetworkAddress;
            this.insideCidrBlocks = builder.insideCidrBlocks;
            this.peerAddress = builder.peerAddress;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getBgpOptions() {
            return this.bgpOptions;
        }

        @Override
        public final java.lang.String getConnectAttachmentId() {
            return this.connectAttachmentId;
        }

        @Override
        public final java.lang.String getCoreNetworkAddress() {
            return this.coreNetworkAddress;
        }

        @Override
        public final java.util.List<java.lang.String> getInsideCidrBlocks() {
            return this.insideCidrBlocks;
        }

        @Override
        public final java.lang.String getPeerAddress() {
            return this.peerAddress;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBgpOptions() != null) {
                data.set("bgpOptions", om.valueToTree(this.getBgpOptions()));
            }
            if (this.getConnectAttachmentId() != null) {
                data.set("connectAttachmentId", om.valueToTree(this.getConnectAttachmentId()));
            }
            if (this.getCoreNetworkAddress() != null) {
                data.set("coreNetworkAddress", om.valueToTree(this.getCoreNetworkAddress()));
            }
            if (this.getInsideCidrBlocks() != null) {
                data.set("insideCidrBlocks", om.valueToTree(this.getInsideCidrBlocks()));
            }
            if (this.getPeerAddress() != null) {
                data.set("peerAddress", om.valueToTree(this.getPeerAddress()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkmanager.CfnConnectPeerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConnectPeerProps.Jsii$Proxy that = (CfnConnectPeerProps.Jsii$Proxy) o;

            if (this.bgpOptions != null ? !this.bgpOptions.equals(that.bgpOptions) : that.bgpOptions != null) return false;
            if (this.connectAttachmentId != null ? !this.connectAttachmentId.equals(that.connectAttachmentId) : that.connectAttachmentId != null) return false;
            if (this.coreNetworkAddress != null ? !this.coreNetworkAddress.equals(that.coreNetworkAddress) : that.coreNetworkAddress != null) return false;
            if (this.insideCidrBlocks != null ? !this.insideCidrBlocks.equals(that.insideCidrBlocks) : that.insideCidrBlocks != null) return false;
            if (this.peerAddress != null ? !this.peerAddress.equals(that.peerAddress) : that.peerAddress != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bgpOptions != null ? this.bgpOptions.hashCode() : 0;
            result = 31 * result + (this.connectAttachmentId != null ? this.connectAttachmentId.hashCode() : 0);
            result = 31 * result + (this.coreNetworkAddress != null ? this.coreNetworkAddress.hashCode() : 0);
            result = 31 * result + (this.insideCidrBlocks != null ? this.insideCidrBlocks.hashCode() : 0);
            result = 31 * result + (this.peerAddress != null ? this.peerAddress.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
