package software.amazon.awscdk.services.logs;

/**
 * A new CloudWatch Logs Destination for use in cross-account scenarios.
 * <p>
 * CrossAccountDestinations are used to subscribe a Kinesis stream in a
 * different account to a CloudWatch Subscription.
 * <p>
 * Consumers will hardly ever need to use this class. Instead, directly
 * subscribe a Kinesis stream using the integration class in the
 * <code>&#64;aws-cdk/aws-logs-destinations</code> package; if necessary, a
 * <code>CrossAccountDestination</code> will be created automatically.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.logs.*;
 * Role role;
 * CrossAccountDestination crossAccountDestination = CrossAccountDestination.Builder.create(this, "MyCrossAccountDestination")
 *         .role(role)
 *         .targetArn("targetArn")
 *         // the properties below are optional
 *         .destinationName("destinationName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:53.004Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CrossAccountDestination")
public class CrossAccountDestination extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.logs.ILogSubscriptionDestination {

    protected CrossAccountDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CrossAccountDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CrossAccountDestination(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.CrossAccountDestinationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addToPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        software.amazon.jsii.Kernel.call(this, "addToPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Return the properties required to send subscription events to this destination.
     * <p>
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     * <p>
     * The destination may reconfigure its own permissions in response to this
     * function call.
     * <p>
     * @param _scope This parameter is required.
     * @param _sourceLogGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.LogSubscriptionDestinationConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogGroup _sourceLogGroup) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.LogSubscriptionDestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_sourceLogGroup, "_sourceLogGroup is required") });
    }

    /**
     * The ARN of this CrossAccountDestination object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDestinationArn() {
        return software.amazon.jsii.Kernel.get(this, "destinationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of this CrossAccountDestination object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDestinationName() {
        return software.amazon.jsii.Kernel.get(this, "destinationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Policy object of this CrossAccountDestination object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyDocument getPolicyDocument() {
        return software.amazon.jsii.Kernel.get(this, "policyDocument", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.logs.CrossAccountDestination}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.CrossAccountDestination> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.logs.CrossAccountDestinationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.logs.CrossAccountDestinationProps.Builder();
        }

        /**
         * The role to assume that grants permissions to write to 'target'.
         * <p>
         * The role must be assumable by 'logs.{REGION}.amazonaws.com'.
         * <p>
         * @return {@code this}
         * @param role The role to assume that grants permissions to write to 'target'. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * The log destination target's ARN.
         * <p>
         * @return {@code this}
         * @param targetArn The log destination target's ARN. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetArn(final java.lang.String targetArn) {
            this.props.targetArn(targetArn);
            return this;
        }

        /**
         * The name of the log destination.
         * <p>
         * Default: Automatically generated
         * <p>
         * @return {@code this}
         * @param destinationName The name of the log destination. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationName(final java.lang.String destinationName) {
            this.props.destinationName(destinationName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.logs.CrossAccountDestination}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.logs.CrossAccountDestination build() {
            return new software.amazon.awscdk.services.logs.CrossAccountDestination(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
