package software.amazon.awscdk.services.logs;

/**
 * Properties for defining a `CfnDestination`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * CfnDestinationProps cfnDestinationProps = CfnDestinationProps.builder()
 *         .destinationName("destinationName")
 *         .roleArn("roleArn")
 *         .targetArn("targetArn")
 *         // the properties below are optional
 *         .destinationPolicy("destinationPolicy")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:52.996Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnDestinationProps")
@software.amazon.jsii.Jsii.Proxy(CfnDestinationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDestinationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDestinationName();

    /**
     * The ARN of an IAM role that permits CloudWatch Logs to send data to the specified AWS resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The Amazon Resource Name (ARN) of the physical target where the log events are delivered (for example, a Kinesis stream).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetArn();

    /**
     * An IAM policy document that governs which AWS accounts can create subscription filters against this destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestinationPolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDestinationProps> {
        java.lang.String destinationName;
        java.lang.String roleArn;
        java.lang.String targetArn;
        java.lang.String destinationPolicy;

        /**
         * Sets the value of {@link CfnDestinationProps#getDestinationName}
         * @param destinationName The name of the destination. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationName(java.lang.String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDestinationProps#getRoleArn}
         * @param roleArn The ARN of an IAM role that permits CloudWatch Logs to send data to the specified AWS resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDestinationProps#getTargetArn}
         * @param targetArn The Amazon Resource Name (ARN) of the physical target where the log events are delivered (for example, a Kinesis stream). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetArn(java.lang.String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDestinationProps#getDestinationPolicy}
         * @param destinationPolicy An IAM policy document that governs which AWS accounts can create subscription filters against this destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationPolicy(java.lang.String destinationPolicy) {
            this.destinationPolicy = destinationPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDestinationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDestinationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDestinationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDestinationProps {
        private final java.lang.String destinationName;
        private final java.lang.String roleArn;
        private final java.lang.String targetArn;
        private final java.lang.String destinationPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinationName = software.amazon.jsii.Kernel.get(this, "destinationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetArn = software.amazon.jsii.Kernel.get(this, "targetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationPolicy = software.amazon.jsii.Kernel.get(this, "destinationPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinationName = java.util.Objects.requireNonNull(builder.destinationName, "destinationName is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.targetArn = java.util.Objects.requireNonNull(builder.targetArn, "targetArn is required");
            this.destinationPolicy = builder.destinationPolicy;
        }

        @Override
        public final java.lang.String getDestinationName() {
            return this.destinationName;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getTargetArn() {
            return this.targetArn;
        }

        @Override
        public final java.lang.String getDestinationPolicy() {
            return this.destinationPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinationName", om.valueToTree(this.getDestinationName()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            data.set("targetArn", om.valueToTree(this.getTargetArn()));
            if (this.getDestinationPolicy() != null) {
                data.set("destinationPolicy", om.valueToTree(this.getDestinationPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnDestinationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDestinationProps.Jsii$Proxy that = (CfnDestinationProps.Jsii$Proxy) o;

            if (!destinationName.equals(that.destinationName)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (!targetArn.equals(that.targetArn)) return false;
            return this.destinationPolicy != null ? this.destinationPolicy.equals(that.destinationPolicy) : that.destinationPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destinationName.hashCode();
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.targetArn.hashCode());
            result = 31 * result + (this.destinationPolicy != null ? this.destinationPolicy.hashCode() : 0);
            return result;
        }
    }
}
