package software.amazon.awscdk.services.lightsail;

/**
 * A CloudFormation `AWS::Lightsail::Alarm`.
 * <p>
 * The <code>AWS::Lightsail::Alarm</code> resource specifies an alarm that can be used to monitor a single metric for one of your Lightsail resources.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lightsail.*;
 * CfnAlarm cfnAlarm = CfnAlarm.Builder.create(this, "MyCfnAlarm")
 *         .alarmName("alarmName")
 *         .comparisonOperator("comparisonOperator")
 *         .evaluationPeriods(123)
 *         .metricName("metricName")
 *         .monitoredResourceName("monitoredResourceName")
 *         .threshold(123)
 *         // the properties below are optional
 *         .contactProtocols(List.of("contactProtocols"))
 *         .datapointsToAlarm(123)
 *         .notificationEnabled(false)
 *         .notificationTriggers(List.of("notificationTriggers"))
 *         .treatMissingData("treatMissingData")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:52.927Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnAlarm")
public class CfnAlarm extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnAlarm(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAlarm(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lightsail.CfnAlarm.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Lightsail::Alarm`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAlarm(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lightsail.CfnAlarmProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAlarmArn() {
        return software.amazon.jsii.Kernel.get(this, "attrAlarmArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The current state of the alarm.
     * <p>
     * An alarm has the following possible states:
     * <p>
     * <ul>
     * <li><code>ALARM</code> - The metric is outside of the defined threshold.</li>
     * <li><code>INSUFFICIENT_DATA</code> - The alarm has recently started, the metric is not available, or not enough data is available for the metric to determine the alarm state.</li>
     * <li><code>OK</code> - The metric is within the defined threshold.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrState() {
        return software.amazon.jsii.Kernel.get(this, "attrState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAlarmName() {
        return software.amazon.jsii.Kernel.get(this, "alarmName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlarmName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "alarmName", java.util.Objects.requireNonNull(value, "alarmName is required"));
    }

    /**
     * The arithmetic operation to use when comparing the specified statistic and threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getComparisonOperator() {
        return software.amazon.jsii.Kernel.get(this, "comparisonOperator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The arithmetic operation to use when comparing the specified statistic and threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComparisonOperator(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "comparisonOperator", java.util.Objects.requireNonNull(value, "comparisonOperator is required"));
    }

    /**
     * The number of periods over which data is compared to the specified threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getEvaluationPeriods() {
        return software.amazon.jsii.Kernel.get(this, "evaluationPeriods", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of periods over which data is compared to the specified threshold.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEvaluationPeriods(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "evaluationPeriods", java.util.Objects.requireNonNull(value, "evaluationPeriods is required"));
    }

    /**
     * The name of the metric associated with the alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMetricName() {
        return software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the metric associated with the alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "metricName", java.util.Objects.requireNonNull(value, "metricName is required"));
    }

    /**
     * The name of the Lightsail resource that the alarm monitors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMonitoredResourceName() {
        return software.amazon.jsii.Kernel.get(this, "monitoredResourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Lightsail resource that the alarm monitors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoredResourceName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "monitoredResourceName", java.util.Objects.requireNonNull(value, "monitoredResourceName is required"));
    }

    /**
     * The value against which the specified statistic is compared.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getThreshold() {
        return software.amazon.jsii.Kernel.get(this, "threshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The value against which the specified statistic is compared.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setThreshold(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "threshold", java.util.Objects.requireNonNull(value, "threshold is required"));
    }

    /**
     * The contact protocols for the alarm, such as `Email` , `SMS` (text messaging), or both.
     * <p>
     * <em>Allowed Values</em> : <code>Email</code> | <code>SMS</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getContactProtocols() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "contactProtocols", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The contact protocols for the alarm, such as `Email` , `SMS` (text messaging), or both.
     * <p>
     * <em>Allowed Values</em> : <code>Email</code> | <code>SMS</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContactProtocols(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "contactProtocols", value);
    }

    /**
     * The number of data points within the evaluation periods that must be breaching to cause the alarm to go to the `ALARM` state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getDatapointsToAlarm() {
        return software.amazon.jsii.Kernel.get(this, "datapointsToAlarm", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of data points within the evaluation periods that must be breaching to cause the alarm to go to the `ALARM` state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatapointsToAlarm(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "datapointsToAlarm", value);
    }

    /**
     * A Boolean value indicating whether the alarm is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNotificationEnabled() {
        return software.amazon.jsii.Kernel.get(this, "notificationEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A Boolean value indicating whether the alarm is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "notificationEnabled", value);
    }

    /**
     * A Boolean value indicating whether the alarm is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "notificationEnabled", value);
    }

    /**
     * The alarm states that trigger a notification.
     * <p>
     * <blockquote>
     * <p>
     * To specify the <code>OK</code> and <code>INSUFFICIENT_DATA</code> values, you must also specify <code>ContactProtocols</code> values. Otherwise, the <code>OK</code> and <code>INSUFFICIENT_DATA</code> values will not take effect and the stack will drift.
     * <p>
     * </blockquote>
     * <p>
     * <em>Allowed Values</em> : <code>OK</code> | <code>ALARM</code> | <code>INSUFFICIENT_DATA</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotificationTriggers() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "notificationTriggers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The alarm states that trigger a notification.
     * <p>
     * <blockquote>
     * <p>
     * To specify the <code>OK</code> and <code>INSUFFICIENT_DATA</code> values, you must also specify <code>ContactProtocols</code> values. Otherwise, the <code>OK</code> and <code>INSUFFICIENT_DATA</code> values will not take effect and the stack will drift.
     * <p>
     * </blockquote>
     * <p>
     * <em>Allowed Values</em> : <code>OK</code> | <code>ALARM</code> | <code>INSUFFICIENT_DATA</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationTriggers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "notificationTriggers", value);
    }

    /**
     * Specifies how the alarm handles missing data points.
     * <p>
     * An alarm can treat missing data in the following ways:
     * <p>
     * <ul>
     * <li><code>breaching</code> - Assumes the missing data is not within the threshold. Missing data counts towards the number of times that the metric is not within the threshold.</li>
     * <li><code>notBreaching</code> - Assumes the missing data is within the threshold. Missing data does not count towards the number of times that the metric is not within the threshold.</li>
     * <li><code>ignore</code> - Ignores the missing data. Maintains the current alarm state.</li>
     * <li><code>missing</code> - Missing data is treated as missing.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTreatMissingData() {
        return software.amazon.jsii.Kernel.get(this, "treatMissingData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies how the alarm handles missing data points.
     * <p>
     * An alarm can treat missing data in the following ways:
     * <p>
     * <ul>
     * <li><code>breaching</code> - Assumes the missing data is not within the threshold. Missing data counts towards the number of times that the metric is not within the threshold.</li>
     * <li><code>notBreaching</code> - Assumes the missing data is within the threshold. Missing data does not count towards the number of times that the metric is not within the threshold.</li>
     * <li><code>ignore</code> - Ignores the missing data. Maintains the current alarm state.</li>
     * <li><code>missing</code> - Missing data is treated as missing.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTreatMissingData(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "treatMissingData", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lightsail.CfnAlarm}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lightsail.CfnAlarm> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lightsail.CfnAlarmProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lightsail.CfnAlarmProps.Builder();
        }

        /**
         * The name of the alarm.
         * <p>
         * @return {@code this}
         * @param alarmName The name of the alarm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmName(final java.lang.String alarmName) {
            this.props.alarmName(alarmName);
            return this;
        }

        /**
         * The arithmetic operation to use when comparing the specified statistic and threshold.
         * <p>
         * @return {@code this}
         * @param comparisonOperator The arithmetic operation to use when comparing the specified statistic and threshold. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comparisonOperator(final java.lang.String comparisonOperator) {
            this.props.comparisonOperator(comparisonOperator);
            return this;
        }

        /**
         * The number of periods over which data is compared to the specified threshold.
         * <p>
         * @return {@code this}
         * @param evaluationPeriods The number of periods over which data is compared to the specified threshold. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationPeriods(final java.lang.Number evaluationPeriods) {
            this.props.evaluationPeriods(evaluationPeriods);
            return this;
        }

        /**
         * The name of the metric associated with the alarm.
         * <p>
         * @return {@code this}
         * @param metricName The name of the metric associated with the alarm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricName(final java.lang.String metricName) {
            this.props.metricName(metricName);
            return this;
        }

        /**
         * The name of the Lightsail resource that the alarm monitors.
         * <p>
         * @return {@code this}
         * @param monitoredResourceName The name of the Lightsail resource that the alarm monitors. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoredResourceName(final java.lang.String monitoredResourceName) {
            this.props.monitoredResourceName(monitoredResourceName);
            return this;
        }

        /**
         * The value against which the specified statistic is compared.
         * <p>
         * @return {@code this}
         * @param threshold The value against which the specified statistic is compared. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder threshold(final java.lang.Number threshold) {
            this.props.threshold(threshold);
            return this;
        }

        /**
         * The contact protocols for the alarm, such as `Email` , `SMS` (text messaging), or both.
         * <p>
         * <em>Allowed Values</em> : <code>Email</code> | <code>SMS</code>
         * <p>
         * @return {@code this}
         * @param contactProtocols The contact protocols for the alarm, such as `Email` , `SMS` (text messaging), or both. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contactProtocols(final java.util.List<java.lang.String> contactProtocols) {
            this.props.contactProtocols(contactProtocols);
            return this;
        }

        /**
         * The number of data points within the evaluation periods that must be breaching to cause the alarm to go to the `ALARM` state.
         * <p>
         * @return {@code this}
         * @param datapointsToAlarm The number of data points within the evaluation periods that must be breaching to cause the alarm to go to the `ALARM` state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datapointsToAlarm(final java.lang.Number datapointsToAlarm) {
            this.props.datapointsToAlarm(datapointsToAlarm);
            return this;
        }

        /**
         * A Boolean value indicating whether the alarm is enabled.
         * <p>
         * @return {@code this}
         * @param notificationEnabled A Boolean value indicating whether the alarm is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationEnabled(final java.lang.Boolean notificationEnabled) {
            this.props.notificationEnabled(notificationEnabled);
            return this;
        }
        /**
         * A Boolean value indicating whether the alarm is enabled.
         * <p>
         * @return {@code this}
         * @param notificationEnabled A Boolean value indicating whether the alarm is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationEnabled(final software.amazon.awscdk.IResolvable notificationEnabled) {
            this.props.notificationEnabled(notificationEnabled);
            return this;
        }

        /**
         * The alarm states that trigger a notification.
         * <p>
         * <blockquote>
         * <p>
         * To specify the <code>OK</code> and <code>INSUFFICIENT_DATA</code> values, you must also specify <code>ContactProtocols</code> values. Otherwise, the <code>OK</code> and <code>INSUFFICIENT_DATA</code> values will not take effect and the stack will drift.
         * <p>
         * </blockquote>
         * <p>
         * <em>Allowed Values</em> : <code>OK</code> | <code>ALARM</code> | <code>INSUFFICIENT_DATA</code>
         * <p>
         * @return {@code this}
         * @param notificationTriggers The alarm states that trigger a notification. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationTriggers(final java.util.List<java.lang.String> notificationTriggers) {
            this.props.notificationTriggers(notificationTriggers);
            return this;
        }

        /**
         * Specifies how the alarm handles missing data points.
         * <p>
         * An alarm can treat missing data in the following ways:
         * <p>
         * <ul>
         * <li><code>breaching</code> - Assumes the missing data is not within the threshold. Missing data counts towards the number of times that the metric is not within the threshold.</li>
         * <li><code>notBreaching</code> - Assumes the missing data is within the threshold. Missing data does not count towards the number of times that the metric is not within the threshold.</li>
         * <li><code>ignore</code> - Ignores the missing data. Maintains the current alarm state.</li>
         * <li><code>missing</code> - Missing data is treated as missing.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param treatMissingData Specifies how the alarm handles missing data points. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder treatMissingData(final java.lang.String treatMissingData) {
            this.props.treatMissingData(treatMissingData);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lightsail.CfnAlarm}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lightsail.CfnAlarm build() {
            return new software.amazon.awscdk.services.lightsail.CfnAlarm(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
