package software.amazon.awscdk.services.lambda;

/**
 * The auth types for a function url.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Can be a Function or an Alias
 * Function fn;
 * FunctionUrl fnUrl = fn.addFunctionUrl(FunctionUrlOptions.builder()
 *         .authType(FunctionUrlAuthType.NONE)
 *         .build());
 * CfnOutput.Builder.create(this, "TheUrl")
 *         .value(fnUrl.getUrl())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:52.763Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.FunctionUrlAuthType")
public enum FunctionUrlAuthType {
    /**
     * Restrict access to authenticated IAM users only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS_IAM,
    /**
     * Bypass IAM authentication to create a public endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
}
