package software.amazon.awscdk.services.fsx;

/**
 * A CloudFormation `AWS::FSx::Volume`.
 * <p>
 * Creates an FSx for ONTAP or Amazon FSx for OpenZFS storage volume.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.fsx.*;
 * CfnVolume cfnVolume = CfnVolume.Builder.create(this, "MyCfnVolume")
 *         .name("name")
 *         // the properties below are optional
 *         .backupId("backupId")
 *         .ontapConfiguration(OntapConfigurationProperty.builder()
 *                 .junctionPath("junctionPath")
 *                 .sizeInMegabytes("sizeInMegabytes")
 *                 .storageEfficiencyEnabled("storageEfficiencyEnabled")
 *                 .storageVirtualMachineId("storageVirtualMachineId")
 *                 // the properties below are optional
 *                 .securityStyle("securityStyle")
 *                 .tieringPolicy(TieringPolicyProperty.builder()
 *                         .coolingPeriod(123)
 *                         .name("name")
 *                         .build())
 *                 .build())
 *         .openZfsConfiguration(OpenZFSConfigurationProperty.builder()
 *                 .parentVolumeId("parentVolumeId")
 *                 // the properties below are optional
 *                 .copyTagsToSnapshots(false)
 *                 .dataCompressionType("dataCompressionType")
 *                 .nfsExports(List.of(NfsExportsProperty.builder()
 *                         .clientConfigurations(List.of(ClientConfigurationsProperty.builder()
 *                                 .clients("clients")
 *                                 .options(List.of("options"))
 *                                 .build()))
 *                         .build()))
 *                 .options(List.of("options"))
 *                 .originSnapshot(OriginSnapshotProperty.builder()
 *                         .copyStrategy("copyStrategy")
 *                         .snapshotArn("snapshotArn")
 *                         .build())
 *                 .readOnly(false)
 *                 .recordSizeKiB(123)
 *                 .storageCapacityQuotaGiB(123)
 *                 .storageCapacityReservationGiB(123)
 *                 .userAndGroupQuotas(List.of(UserAndGroupQuotasProperty.builder()
 *                         .id(123)
 *                         .storageCapacityQuotaGiB(123)
 *                         .type("type")
 *                         .build()))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .volumeType("volumeType")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:51.754Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolume")
public class CfnVolume extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnVolume(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnVolume(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.fsx.CfnVolume.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::FSx::Volume`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnVolume(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.fsx.CfnVolumeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the volume's Amazon Resource Name (ARN).
     * <p>
     * Example: <code>arn:aws:fsx:us-east-2:111122223333:volume/fs-0123456789abcdef9/fsvol-01234567891112223</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the volume's universally unique identifier (UUID).
     * <p>
     * Example: <code>abcd0123-cd45-ef67-11aa-1111aaaa23bc</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUuid() {
        return software.amazon.jsii.Kernel.get(this, "attrUuid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the volume's ID.
     * <p>
     * Example: <code>fsvol-0123456789abcdefa</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVolumeId() {
        return software.amazon.jsii.Kernel.get(this, "attrVolumeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Specifies the ID of the volume backup to use to create a new volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBackupId() {
        return software.amazon.jsii.Kernel.get(this, "backupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the ID of the volume backup to use to create a new volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "backupId", value);
    }

    /**
     * The configuration of an Amazon FSx for NetApp ONTAP volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOntapConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "ontapConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of an Amazon FSx for NetApp ONTAP volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOntapConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fsx.CfnVolume.OntapConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "ontapConfiguration", value);
    }

    /**
     * The configuration of an Amazon FSx for NetApp ONTAP volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOntapConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ontapConfiguration", value);
    }

    /**
     * The configuration of an Amazon FSx for OpenZFS volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOpenZfsConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "openZfsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of an Amazon FSx for OpenZFS volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpenZfsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fsx.CfnVolume.OpenZFSConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "openZfsConfiguration", value);
    }

    /**
     * The configuration of an Amazon FSx for OpenZFS volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpenZfsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "openZfsConfiguration", value);
    }

    /**
     * The type of the volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVolumeType() {
        return software.amazon.jsii.Kernel.get(this, "volumeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVolumeType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "volumeType", value);
    }
    /**
     * Specifies who can mount an OpenZFS file system and the options available while mounting the file system.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * ClientConfigurationsProperty clientConfigurationsProperty = ClientConfigurationsProperty.builder()
     *         .clients("clients")
     *         .options(List.of("options"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolume.ClientConfigurationsProperty")
    @software.amazon.jsii.Jsii.Proxy(ClientConfigurationsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClientConfigurationsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A value that specifies who can mount the file system.
         * <p>
         * You can provide a wildcard character ( <code>*</code> ), an IP address ( <code>0.0.0.0</code> ), or a CIDR address ( <code>192.0.2.0/24</code> ). By default, Amazon FSx uses the wildcard character when specifying the client.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClients();

        /**
         * The options to use when mounting the file system.
         * <p>
         * For a list of options that you can use with Network File System (NFS), see the <a href="https://docs.aws.amazon.com/https://linux.die.net/man/5/exports">exports(5) - Linux man page</a> . When choosing your options, consider the following:
         * <p>
         * <ul>
         * <li><code>crossmnt</code> is used by default. If you don't specify <code>crossmnt</code> when changing the client configuration, you won't be able to see or access snapshots in your file system's snapshot directory.</li>
         * <li><code>sync</code> is used by default. If you instead specify <code>async</code> , the system acknowledges writes before writing to disk. If the system crashes before the writes are finished, you lose the unwritten data.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getOptions();

        /**
         * @return a {@link Builder} of {@link ClientConfigurationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClientConfigurationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClientConfigurationsProperty> {
            java.lang.String clients;
            java.util.List<java.lang.String> options;

            /**
             * Sets the value of {@link ClientConfigurationsProperty#getClients}
             * @param clients A value that specifies who can mount the file system. This parameter is required.
             *                You can provide a wildcard character ( <code>*</code> ), an IP address ( <code>0.0.0.0</code> ), or a CIDR address ( <code>192.0.2.0/24</code> ). By default, Amazon FSx uses the wildcard character when specifying the client.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clients(java.lang.String clients) {
                this.clients = clients;
                return this;
            }

            /**
             * Sets the value of {@link ClientConfigurationsProperty#getOptions}
             * @param options The options to use when mounting the file system. This parameter is required.
             *                For a list of options that you can use with Network File System (NFS), see the <a href="https://docs.aws.amazon.com/https://linux.die.net/man/5/exports">exports(5) - Linux man page</a> . When choosing your options, consider the following:
             *                <p>
             *                <ul>
             *                <li><code>crossmnt</code> is used by default. If you don't specify <code>crossmnt</code> when changing the client configuration, you won't be able to see or access snapshots in your file system's snapshot directory.</li>
             *                <li><code>sync</code> is used by default. If you instead specify <code>async</code> , the system acknowledges writes before writing to disk. If the system crashes before the writes are finished, you lose the unwritten data.</li>
             *                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(java.util.List<java.lang.String> options) {
                this.options = options;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClientConfigurationsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClientConfigurationsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClientConfigurationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientConfigurationsProperty {
            private final java.lang.String clients;
            private final java.util.List<java.lang.String> options;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clients = software.amazon.jsii.Kernel.get(this, "clients", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clients = java.util.Objects.requireNonNull(builder.clients, "clients is required");
                this.options = java.util.Objects.requireNonNull(builder.options, "options is required");
            }

            @Override
            public final java.lang.String getClients() {
                return this.clients;
            }

            @Override
            public final java.util.List<java.lang.String> getOptions() {
                return this.options;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clients", om.valueToTree(this.getClients()));
                data.set("options", om.valueToTree(this.getOptions()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnVolume.ClientConfigurationsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClientConfigurationsProperty.Jsii$Proxy that = (ClientConfigurationsProperty.Jsii$Proxy) o;

                if (!clients.equals(that.clients)) return false;
                return this.options.equals(that.options);
            }

            @Override
            public final int hashCode() {
                int result = this.clients.hashCode();
                result = 31 * result + (this.options.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration object for mounting a Network File System (NFS) file system.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * NfsExportsProperty nfsExportsProperty = NfsExportsProperty.builder()
     *         .clientConfigurations(List.of(ClientConfigurationsProperty.builder()
     *                 .clients("clients")
     *                 .options(List.of("options"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolume.NfsExportsProperty")
    @software.amazon.jsii.Jsii.Proxy(NfsExportsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NfsExportsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of configuration objects that contain the client and options for mounting the OpenZFS file system.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getClientConfigurations();

        /**
         * @return a {@link Builder} of {@link NfsExportsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NfsExportsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NfsExportsProperty> {
            java.lang.Object clientConfigurations;

            /**
             * Sets the value of {@link NfsExportsProperty#getClientConfigurations}
             * @param clientConfigurations A list of configuration objects that contain the client and options for mounting the OpenZFS file system. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientConfigurations(software.amazon.awscdk.IResolvable clientConfigurations) {
                this.clientConfigurations = clientConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link NfsExportsProperty#getClientConfigurations}
             * @param clientConfigurations A list of configuration objects that contain the client and options for mounting the OpenZFS file system. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientConfigurations(java.util.List<? extends java.lang.Object> clientConfigurations) {
                this.clientConfigurations = clientConfigurations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NfsExportsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NfsExportsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NfsExportsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NfsExportsProperty {
            private final java.lang.Object clientConfigurations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientConfigurations = software.amazon.jsii.Kernel.get(this, "clientConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientConfigurations = java.util.Objects.requireNonNull(builder.clientConfigurations, "clientConfigurations is required");
            }

            @Override
            public final java.lang.Object getClientConfigurations() {
                return this.clientConfigurations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientConfigurations", om.valueToTree(this.getClientConfigurations()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnVolume.NfsExportsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NfsExportsProperty.Jsii$Proxy that = (NfsExportsProperty.Jsii$Proxy) o;

                return this.clientConfigurations.equals(that.clientConfigurations);
            }

            @Override
            public final int hashCode() {
                int result = this.clientConfigurations.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the configuration of the ONTAP volume that you are creating.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * OntapConfigurationProperty ontapConfigurationProperty = OntapConfigurationProperty.builder()
     *         .junctionPath("junctionPath")
     *         .sizeInMegabytes("sizeInMegabytes")
     *         .storageEfficiencyEnabled("storageEfficiencyEnabled")
     *         .storageVirtualMachineId("storageVirtualMachineId")
     *         // the properties below are optional
     *         .securityStyle("securityStyle")
     *         .tieringPolicy(TieringPolicyProperty.builder()
     *                 .coolingPeriod(123)
     *                 .name("name")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolume.OntapConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OntapConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OntapConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the location in the SVM's namespace where the volume is mounted.
         * <p>
         * The <code>JunctionPath</code> must have a leading forward slash, such as <code>/vol3</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getJunctionPath();

        /**
         * Specifies the size of the volume, in megabytes (MB), that you are creating.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSizeInMegabytes();

        /**
         * Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStorageEfficiencyEnabled();

        /**
         * Specifies the ONTAP SVM in which to create the volume.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStorageVirtualMachineId();

        /**
         * The security style for the volume. Specify one of the following values:.
         * <p>
         * <ul>
         * <li><code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS clients, and an application accessing the data uses a UNIX user as the service account. <code>UNIX</code> is the default.</li>
         * <li><code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB clients, and an application accessing the data uses a Windows user as the service account.</li>
         * <li><code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users consist of both NFS and SMB clients.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecurityStyle() {
            return null;
        }

        /**
         * Describes the data tiering policy for an ONTAP volume.
         * <p>
         * When enabled, Amazon FSx for ONTAP's intelligent tiering automatically transitions a volume's data between the file system's primary storage and capacity pool storage based on your access patterns.
         * <p>
         * Valid tiering policies are the following:
         * <p>
         * <ul>
         * <li><code>SNAPSHOT_ONLY</code> - (Default value) moves cold snapshots to the capacity pool storage tier.</li>
         * <li><code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your access patterns.</li>
         * <li><code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the storage pool tier.</li>
         * <li><code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to the capacity pool tier.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTieringPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OntapConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OntapConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OntapConfigurationProperty> {
            java.lang.String junctionPath;
            java.lang.String sizeInMegabytes;
            java.lang.String storageEfficiencyEnabled;
            java.lang.String storageVirtualMachineId;
            java.lang.String securityStyle;
            java.lang.Object tieringPolicy;

            /**
             * Sets the value of {@link OntapConfigurationProperty#getJunctionPath}
             * @param junctionPath Specifies the location in the SVM's namespace where the volume is mounted. This parameter is required.
             *                     The <code>JunctionPath</code> must have a leading forward slash, such as <code>/vol3</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder junctionPath(java.lang.String junctionPath) {
                this.junctionPath = junctionPath;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getSizeInMegabytes}
             * @param sizeInMegabytes Specifies the size of the volume, in megabytes (MB), that you are creating. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeInMegabytes(java.lang.String sizeInMegabytes) {
                this.sizeInMegabytes = sizeInMegabytes;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getStorageEfficiencyEnabled}
             * @param storageEfficiencyEnabled Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageEfficiencyEnabled(java.lang.String storageEfficiencyEnabled) {
                this.storageEfficiencyEnabled = storageEfficiencyEnabled;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getStorageVirtualMachineId}
             * @param storageVirtualMachineId Specifies the ONTAP SVM in which to create the volume. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageVirtualMachineId(java.lang.String storageVirtualMachineId) {
                this.storageVirtualMachineId = storageVirtualMachineId;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getSecurityStyle}
             * @param securityStyle The security style for the volume. Specify one of the following values:.
             *                      <ul>
             *                      <li><code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS clients, and an application accessing the data uses a UNIX user as the service account. <code>UNIX</code> is the default.</li>
             *                      <li><code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB clients, and an application accessing the data uses a Windows user as the service account.</li>
             *                      <li><code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users consist of both NFS and SMB clients.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityStyle(java.lang.String securityStyle) {
                this.securityStyle = securityStyle;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getTieringPolicy}
             * @param tieringPolicy Describes the data tiering policy for an ONTAP volume.
             *                      When enabled, Amazon FSx for ONTAP's intelligent tiering automatically transitions a volume's data between the file system's primary storage and capacity pool storage based on your access patterns.
             *                      <p>
             *                      Valid tiering policies are the following:
             *                      <p>
             *                      <ul>
             *                      <li><code>SNAPSHOT_ONLY</code> - (Default value) moves cold snapshots to the capacity pool storage tier.</li>
             *                      <li><code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your access patterns.</li>
             *                      <li><code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the storage pool tier.</li>
             *                      <li><code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to the capacity pool tier.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tieringPolicy(software.amazon.awscdk.services.fsx.CfnVolume.TieringPolicyProperty tieringPolicy) {
                this.tieringPolicy = tieringPolicy;
                return this;
            }

            /**
             * Sets the value of {@link OntapConfigurationProperty#getTieringPolicy}
             * @param tieringPolicy Describes the data tiering policy for an ONTAP volume.
             *                      When enabled, Amazon FSx for ONTAP's intelligent tiering automatically transitions a volume's data between the file system's primary storage and capacity pool storage based on your access patterns.
             *                      <p>
             *                      Valid tiering policies are the following:
             *                      <p>
             *                      <ul>
             *                      <li><code>SNAPSHOT_ONLY</code> - (Default value) moves cold snapshots to the capacity pool storage tier.</li>
             *                      <li><code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your access patterns.</li>
             *                      <li><code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the storage pool tier.</li>
             *                      <li><code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to the capacity pool tier.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tieringPolicy(software.amazon.awscdk.IResolvable tieringPolicy) {
                this.tieringPolicy = tieringPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OntapConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OntapConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OntapConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OntapConfigurationProperty {
            private final java.lang.String junctionPath;
            private final java.lang.String sizeInMegabytes;
            private final java.lang.String storageEfficiencyEnabled;
            private final java.lang.String storageVirtualMachineId;
            private final java.lang.String securityStyle;
            private final java.lang.Object tieringPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.junctionPath = software.amazon.jsii.Kernel.get(this, "junctionPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sizeInMegabytes = software.amazon.jsii.Kernel.get(this, "sizeInMegabytes", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.storageEfficiencyEnabled = software.amazon.jsii.Kernel.get(this, "storageEfficiencyEnabled", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.storageVirtualMachineId = software.amazon.jsii.Kernel.get(this, "storageVirtualMachineId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityStyle = software.amazon.jsii.Kernel.get(this, "securityStyle", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tieringPolicy = software.amazon.jsii.Kernel.get(this, "tieringPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.junctionPath = java.util.Objects.requireNonNull(builder.junctionPath, "junctionPath is required");
                this.sizeInMegabytes = java.util.Objects.requireNonNull(builder.sizeInMegabytes, "sizeInMegabytes is required");
                this.storageEfficiencyEnabled = java.util.Objects.requireNonNull(builder.storageEfficiencyEnabled, "storageEfficiencyEnabled is required");
                this.storageVirtualMachineId = java.util.Objects.requireNonNull(builder.storageVirtualMachineId, "storageVirtualMachineId is required");
                this.securityStyle = builder.securityStyle;
                this.tieringPolicy = builder.tieringPolicy;
            }

            @Override
            public final java.lang.String getJunctionPath() {
                return this.junctionPath;
            }

            @Override
            public final java.lang.String getSizeInMegabytes() {
                return this.sizeInMegabytes;
            }

            @Override
            public final java.lang.String getStorageEfficiencyEnabled() {
                return this.storageEfficiencyEnabled;
            }

            @Override
            public final java.lang.String getStorageVirtualMachineId() {
                return this.storageVirtualMachineId;
            }

            @Override
            public final java.lang.String getSecurityStyle() {
                return this.securityStyle;
            }

            @Override
            public final java.lang.Object getTieringPolicy() {
                return this.tieringPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("junctionPath", om.valueToTree(this.getJunctionPath()));
                data.set("sizeInMegabytes", om.valueToTree(this.getSizeInMegabytes()));
                data.set("storageEfficiencyEnabled", om.valueToTree(this.getStorageEfficiencyEnabled()));
                data.set("storageVirtualMachineId", om.valueToTree(this.getStorageVirtualMachineId()));
                if (this.getSecurityStyle() != null) {
                    data.set("securityStyle", om.valueToTree(this.getSecurityStyle()));
                }
                if (this.getTieringPolicy() != null) {
                    data.set("tieringPolicy", om.valueToTree(this.getTieringPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnVolume.OntapConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OntapConfigurationProperty.Jsii$Proxy that = (OntapConfigurationProperty.Jsii$Proxy) o;

                if (!junctionPath.equals(that.junctionPath)) return false;
                if (!sizeInMegabytes.equals(that.sizeInMegabytes)) return false;
                if (!storageEfficiencyEnabled.equals(that.storageEfficiencyEnabled)) return false;
                if (!storageVirtualMachineId.equals(that.storageVirtualMachineId)) return false;
                if (this.securityStyle != null ? !this.securityStyle.equals(that.securityStyle) : that.securityStyle != null) return false;
                return this.tieringPolicy != null ? this.tieringPolicy.equals(that.tieringPolicy) : that.tieringPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.junctionPath.hashCode();
                result = 31 * result + (this.sizeInMegabytes.hashCode());
                result = 31 * result + (this.storageEfficiencyEnabled.hashCode());
                result = 31 * result + (this.storageVirtualMachineId.hashCode());
                result = 31 * result + (this.securityStyle != null ? this.securityStyle.hashCode() : 0);
                result = 31 * result + (this.tieringPolicy != null ? this.tieringPolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration of the Amazon FSx for OpenZFS volume that you are creating.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * OpenZFSConfigurationProperty openZFSConfigurationProperty = OpenZFSConfigurationProperty.builder()
     *         .parentVolumeId("parentVolumeId")
     *         // the properties below are optional
     *         .copyTagsToSnapshots(false)
     *         .dataCompressionType("dataCompressionType")
     *         .nfsExports(List.of(NfsExportsProperty.builder()
     *                 .clientConfigurations(List.of(ClientConfigurationsProperty.builder()
     *                         .clients("clients")
     *                         .options(List.of("options"))
     *                         .build()))
     *                 .build()))
     *         .options(List.of("options"))
     *         .originSnapshot(OriginSnapshotProperty.builder()
     *                 .copyStrategy("copyStrategy")
     *                 .snapshotArn("snapshotArn")
     *                 .build())
     *         .readOnly(false)
     *         .recordSizeKiB(123)
     *         .storageCapacityQuotaGiB(123)
     *         .storageCapacityReservationGiB(123)
     *         .userAndGroupQuotas(List.of(UserAndGroupQuotasProperty.builder()
     *                 .id(123)
     *                 .storageCapacityQuotaGiB(123)
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolume.OpenZFSConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenZFSConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenZFSConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the volume to use as the parent volume of the volume that you are creating.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getParentVolumeId();

        /**
         * A Boolean value indicating whether tags for the volume should be copied to snapshots.
         * <p>
         * This value defaults to <code>false</code> . If it's set to <code>true</code> , all tags for the volume are copied to snapshots where the user doesn't specify tags. If this value is <code>true</code> , and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCopyTagsToSnapshots() {
            return null;
        }

        /**
         * Specifies the method used to compress the data on the volume. The compression type is `NONE` by default.
         * <p>
         * <ul>
         * <li><code>NONE</code> - Doesn't compress the data on the volume. <code>NONE</code> is the default.</li>
         * <li><code>ZSTD</code> - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm. Compared to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage utilization.</li>
         * <li><code>LZ4</code> - Compresses the data in the volume using the LZ4 compression algorithm. Compared to Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput speeds.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataCompressionType() {
            return null;
        }

        /**
         * The configuration object for mounting a Network File System (NFS) file system.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNfsExports() {
            return null;
        }

        /**
         * To delete the volume's child volumes, snapshots, and clones, use the string `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOptions() {
            return null;
        }

        /**
         * The configuration object that specifies the snapshot to use as the origin of the data for the volume.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOriginSnapshot() {
            return null;
        }

        /**
         * A Boolean value indicating whether the volume is read-only.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadOnly() {
            return null;
        }

        /**
         * Specifies the suggested block size for a volume in a ZFS dataset, in kibibytes (KiB).
         * <p>
         * Valid values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB. We recommend using the default setting for the majority of use cases. Generally, workloads that write in fixed small or large record sizes may benefit from setting a custom record size, like database workloads (small record size) or media streaming workloads (large record size). For additional guidance on when to set a custom record size, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#record-size-performance">ZFS Record size</a> in the <em>Amazon FSx for OpenZFS User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRecordSizeKiB() {
            return null;
        }

        /**
         * Sets the maximum storage size in gibibytes (GiB) for the volume.
         * <p>
         * You can specify a quota that is larger than the storage on the parent volume. A volume quota limits the amount of storage that the volume can consume to the configured amount, but does not guarantee the space will be available on the parent volume. To guarantee quota space, you must also set <code>StorageCapacityReservationGiB</code> . To <em>not</em> specify a storage capacity quota, set this to <code>-1</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-volumes.html#volume-properties">Volume properties</a> in the <em>Amazon FSx for OpenZFS User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStorageCapacityQuotaGiB() {
            return null;
        }

        /**
         * Specifies the amount of storage in gibibytes (GiB) to reserve from the parent volume.
         * <p>
         * Setting <code>StorageCapacityReservationGiB</code> guarantees that the specified amount of storage space on the parent volume will always be available for the volume. You can't reserve more storage than the parent volume has. To <em>not</em> specify a storage capacity reservation, set this to <code>0</code> or <code>-1</code> . For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-volumes.html#volume-properties">Volume properties</a> in the <em>Amazon FSx for OpenZFS User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStorageCapacityReservationGiB() {
            return null;
        }

        /**
         * An object specifying how much storage users or groups can use on the volume.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUserAndGroupQuotas() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OpenZFSConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenZFSConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenZFSConfigurationProperty> {
            java.lang.String parentVolumeId;
            java.lang.Object copyTagsToSnapshots;
            java.lang.String dataCompressionType;
            java.lang.Object nfsExports;
            java.util.List<java.lang.String> options;
            java.lang.Object originSnapshot;
            java.lang.Object readOnly;
            java.lang.Number recordSizeKiB;
            java.lang.Number storageCapacityQuotaGiB;
            java.lang.Number storageCapacityReservationGiB;
            java.lang.Object userAndGroupQuotas;

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getParentVolumeId}
             * @param parentVolumeId The ID of the volume to use as the parent volume of the volume that you are creating. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parentVolumeId(java.lang.String parentVolumeId) {
                this.parentVolumeId = parentVolumeId;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getCopyTagsToSnapshots}
             * @param copyTagsToSnapshots A Boolean value indicating whether tags for the volume should be copied to snapshots.
             *                            This value defaults to <code>false</code> . If it's set to <code>true</code> , all tags for the volume are copied to snapshots where the user doesn't specify tags. If this value is <code>true</code> , and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTagsToSnapshots(java.lang.Boolean copyTagsToSnapshots) {
                this.copyTagsToSnapshots = copyTagsToSnapshots;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getCopyTagsToSnapshots}
             * @param copyTagsToSnapshots A Boolean value indicating whether tags for the volume should be copied to snapshots.
             *                            This value defaults to <code>false</code> . If it's set to <code>true</code> , all tags for the volume are copied to snapshots where the user doesn't specify tags. If this value is <code>true</code> , and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyTagsToSnapshots(software.amazon.awscdk.IResolvable copyTagsToSnapshots) {
                this.copyTagsToSnapshots = copyTagsToSnapshots;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getDataCompressionType}
             * @param dataCompressionType Specifies the method used to compress the data on the volume. The compression type is `NONE` by default.
             *                            <ul>
             *                            <li><code>NONE</code> - Doesn't compress the data on the volume. <code>NONE</code> is the default.</li>
             *                            <li><code>ZSTD</code> - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm. Compared to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage utilization.</li>
             *                            <li><code>LZ4</code> - Compresses the data in the volume using the LZ4 compression algorithm. Compared to Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput speeds.</li>
             *                            </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataCompressionType(java.lang.String dataCompressionType) {
                this.dataCompressionType = dataCompressionType;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getNfsExports}
             * @param nfsExports The configuration object for mounting a Network File System (NFS) file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nfsExports(software.amazon.awscdk.IResolvable nfsExports) {
                this.nfsExports = nfsExports;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getNfsExports}
             * @param nfsExports The configuration object for mounting a Network File System (NFS) file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nfsExports(java.util.List<? extends java.lang.Object> nfsExports) {
                this.nfsExports = nfsExports;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getOptions}
             * @param options To delete the volume's child volumes, snapshots, and clones, use the string `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS` .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(java.util.List<java.lang.String> options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getOriginSnapshot}
             * @param originSnapshot The configuration object that specifies the snapshot to use as the origin of the data for the volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originSnapshot(software.amazon.awscdk.services.fsx.CfnVolume.OriginSnapshotProperty originSnapshot) {
                this.originSnapshot = originSnapshot;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getOriginSnapshot}
             * @param originSnapshot The configuration object that specifies the snapshot to use as the origin of the data for the volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originSnapshot(software.amazon.awscdk.IResolvable originSnapshot) {
                this.originSnapshot = originSnapshot;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getReadOnly}
             * @param readOnly A Boolean value indicating whether the volume is read-only.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(java.lang.Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getReadOnly}
             * @param readOnly A Boolean value indicating whether the volume is read-only.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(software.amazon.awscdk.IResolvable readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getRecordSizeKiB}
             * @param recordSizeKiB Specifies the suggested block size for a volume in a ZFS dataset, in kibibytes (KiB).
             *                      Valid values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB. We recommend using the default setting for the majority of use cases. Generally, workloads that write in fixed small or large record sizes may benefit from setting a custom record size, like database workloads (small record size) or media streaming workloads (large record size). For additional guidance on when to set a custom record size, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#record-size-performance">ZFS Record size</a> in the <em>Amazon FSx for OpenZFS User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordSizeKiB(java.lang.Number recordSizeKiB) {
                this.recordSizeKiB = recordSizeKiB;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getStorageCapacityQuotaGiB}
             * @param storageCapacityQuotaGiB Sets the maximum storage size in gibibytes (GiB) for the volume.
             *                                You can specify a quota that is larger than the storage on the parent volume. A volume quota limits the amount of storage that the volume can consume to the configured amount, but does not guarantee the space will be available on the parent volume. To guarantee quota space, you must also set <code>StorageCapacityReservationGiB</code> . To <em>not</em> specify a storage capacity quota, set this to <code>-1</code> .
             *                                <p>
             *                                For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-volumes.html#volume-properties">Volume properties</a> in the <em>Amazon FSx for OpenZFS User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageCapacityQuotaGiB(java.lang.Number storageCapacityQuotaGiB) {
                this.storageCapacityQuotaGiB = storageCapacityQuotaGiB;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getStorageCapacityReservationGiB}
             * @param storageCapacityReservationGiB Specifies the amount of storage in gibibytes (GiB) to reserve from the parent volume.
             *                                      Setting <code>StorageCapacityReservationGiB</code> guarantees that the specified amount of storage space on the parent volume will always be available for the volume. You can't reserve more storage than the parent volume has. To <em>not</em> specify a storage capacity reservation, set this to <code>0</code> or <code>-1</code> . For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-volumes.html#volume-properties">Volume properties</a> in the <em>Amazon FSx for OpenZFS User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageCapacityReservationGiB(java.lang.Number storageCapacityReservationGiB) {
                this.storageCapacityReservationGiB = storageCapacityReservationGiB;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getUserAndGroupQuotas}
             * @param userAndGroupQuotas An object specifying how much storage users or groups can use on the volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userAndGroupQuotas(software.amazon.awscdk.IResolvable userAndGroupQuotas) {
                this.userAndGroupQuotas = userAndGroupQuotas;
                return this;
            }

            /**
             * Sets the value of {@link OpenZFSConfigurationProperty#getUserAndGroupQuotas}
             * @param userAndGroupQuotas An object specifying how much storage users or groups can use on the volume.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userAndGroupQuotas(java.util.List<? extends java.lang.Object> userAndGroupQuotas) {
                this.userAndGroupQuotas = userAndGroupQuotas;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenZFSConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenZFSConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenZFSConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenZFSConfigurationProperty {
            private final java.lang.String parentVolumeId;
            private final java.lang.Object copyTagsToSnapshots;
            private final java.lang.String dataCompressionType;
            private final java.lang.Object nfsExports;
            private final java.util.List<java.lang.String> options;
            private final java.lang.Object originSnapshot;
            private final java.lang.Object readOnly;
            private final java.lang.Number recordSizeKiB;
            private final java.lang.Number storageCapacityQuotaGiB;
            private final java.lang.Number storageCapacityReservationGiB;
            private final java.lang.Object userAndGroupQuotas;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.parentVolumeId = software.amazon.jsii.Kernel.get(this, "parentVolumeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.copyTagsToSnapshots = software.amazon.jsii.Kernel.get(this, "copyTagsToSnapshots", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataCompressionType = software.amazon.jsii.Kernel.get(this, "dataCompressionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nfsExports = software.amazon.jsii.Kernel.get(this, "nfsExports", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.originSnapshot = software.amazon.jsii.Kernel.get(this, "originSnapshot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.readOnly = software.amazon.jsii.Kernel.get(this, "readOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.recordSizeKiB = software.amazon.jsii.Kernel.get(this, "recordSizeKiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.storageCapacityQuotaGiB = software.amazon.jsii.Kernel.get(this, "storageCapacityQuotaGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.storageCapacityReservationGiB = software.amazon.jsii.Kernel.get(this, "storageCapacityReservationGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.userAndGroupQuotas = software.amazon.jsii.Kernel.get(this, "userAndGroupQuotas", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.parentVolumeId = java.util.Objects.requireNonNull(builder.parentVolumeId, "parentVolumeId is required");
                this.copyTagsToSnapshots = builder.copyTagsToSnapshots;
                this.dataCompressionType = builder.dataCompressionType;
                this.nfsExports = builder.nfsExports;
                this.options = builder.options;
                this.originSnapshot = builder.originSnapshot;
                this.readOnly = builder.readOnly;
                this.recordSizeKiB = builder.recordSizeKiB;
                this.storageCapacityQuotaGiB = builder.storageCapacityQuotaGiB;
                this.storageCapacityReservationGiB = builder.storageCapacityReservationGiB;
                this.userAndGroupQuotas = builder.userAndGroupQuotas;
            }

            @Override
            public final java.lang.String getParentVolumeId() {
                return this.parentVolumeId;
            }

            @Override
            public final java.lang.Object getCopyTagsToSnapshots() {
                return this.copyTagsToSnapshots;
            }

            @Override
            public final java.lang.String getDataCompressionType() {
                return this.dataCompressionType;
            }

            @Override
            public final java.lang.Object getNfsExports() {
                return this.nfsExports;
            }

            @Override
            public final java.util.List<java.lang.String> getOptions() {
                return this.options;
            }

            @Override
            public final java.lang.Object getOriginSnapshot() {
                return this.originSnapshot;
            }

            @Override
            public final java.lang.Object getReadOnly() {
                return this.readOnly;
            }

            @Override
            public final java.lang.Number getRecordSizeKiB() {
                return this.recordSizeKiB;
            }

            @Override
            public final java.lang.Number getStorageCapacityQuotaGiB() {
                return this.storageCapacityQuotaGiB;
            }

            @Override
            public final java.lang.Number getStorageCapacityReservationGiB() {
                return this.storageCapacityReservationGiB;
            }

            @Override
            public final java.lang.Object getUserAndGroupQuotas() {
                return this.userAndGroupQuotas;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("parentVolumeId", om.valueToTree(this.getParentVolumeId()));
                if (this.getCopyTagsToSnapshots() != null) {
                    data.set("copyTagsToSnapshots", om.valueToTree(this.getCopyTagsToSnapshots()));
                }
                if (this.getDataCompressionType() != null) {
                    data.set("dataCompressionType", om.valueToTree(this.getDataCompressionType()));
                }
                if (this.getNfsExports() != null) {
                    data.set("nfsExports", om.valueToTree(this.getNfsExports()));
                }
                if (this.getOptions() != null) {
                    data.set("options", om.valueToTree(this.getOptions()));
                }
                if (this.getOriginSnapshot() != null) {
                    data.set("originSnapshot", om.valueToTree(this.getOriginSnapshot()));
                }
                if (this.getReadOnly() != null) {
                    data.set("readOnly", om.valueToTree(this.getReadOnly()));
                }
                if (this.getRecordSizeKiB() != null) {
                    data.set("recordSizeKiB", om.valueToTree(this.getRecordSizeKiB()));
                }
                if (this.getStorageCapacityQuotaGiB() != null) {
                    data.set("storageCapacityQuotaGiB", om.valueToTree(this.getStorageCapacityQuotaGiB()));
                }
                if (this.getStorageCapacityReservationGiB() != null) {
                    data.set("storageCapacityReservationGiB", om.valueToTree(this.getStorageCapacityReservationGiB()));
                }
                if (this.getUserAndGroupQuotas() != null) {
                    data.set("userAndGroupQuotas", om.valueToTree(this.getUserAndGroupQuotas()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnVolume.OpenZFSConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenZFSConfigurationProperty.Jsii$Proxy that = (OpenZFSConfigurationProperty.Jsii$Proxy) o;

                if (!parentVolumeId.equals(that.parentVolumeId)) return false;
                if (this.copyTagsToSnapshots != null ? !this.copyTagsToSnapshots.equals(that.copyTagsToSnapshots) : that.copyTagsToSnapshots != null) return false;
                if (this.dataCompressionType != null ? !this.dataCompressionType.equals(that.dataCompressionType) : that.dataCompressionType != null) return false;
                if (this.nfsExports != null ? !this.nfsExports.equals(that.nfsExports) : that.nfsExports != null) return false;
                if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
                if (this.originSnapshot != null ? !this.originSnapshot.equals(that.originSnapshot) : that.originSnapshot != null) return false;
                if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) return false;
                if (this.recordSizeKiB != null ? !this.recordSizeKiB.equals(that.recordSizeKiB) : that.recordSizeKiB != null) return false;
                if (this.storageCapacityQuotaGiB != null ? !this.storageCapacityQuotaGiB.equals(that.storageCapacityQuotaGiB) : that.storageCapacityQuotaGiB != null) return false;
                if (this.storageCapacityReservationGiB != null ? !this.storageCapacityReservationGiB.equals(that.storageCapacityReservationGiB) : that.storageCapacityReservationGiB != null) return false;
                return this.userAndGroupQuotas != null ? this.userAndGroupQuotas.equals(that.userAndGroupQuotas) : that.userAndGroupQuotas == null;
            }

            @Override
            public final int hashCode() {
                int result = this.parentVolumeId.hashCode();
                result = 31 * result + (this.copyTagsToSnapshots != null ? this.copyTagsToSnapshots.hashCode() : 0);
                result = 31 * result + (this.dataCompressionType != null ? this.dataCompressionType.hashCode() : 0);
                result = 31 * result + (this.nfsExports != null ? this.nfsExports.hashCode() : 0);
                result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
                result = 31 * result + (this.originSnapshot != null ? this.originSnapshot.hashCode() : 0);
                result = 31 * result + (this.readOnly != null ? this.readOnly.hashCode() : 0);
                result = 31 * result + (this.recordSizeKiB != null ? this.recordSizeKiB.hashCode() : 0);
                result = 31 * result + (this.storageCapacityQuotaGiB != null ? this.storageCapacityQuotaGiB.hashCode() : 0);
                result = 31 * result + (this.storageCapacityReservationGiB != null ? this.storageCapacityReservationGiB.hashCode() : 0);
                result = 31 * result + (this.userAndGroupQuotas != null ? this.userAndGroupQuotas.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration object that specifies the snapshot to use as the origin of the data for the volume.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * OriginSnapshotProperty originSnapshotProperty = OriginSnapshotProperty.builder()
     *         .copyStrategy("copyStrategy")
     *         .snapshotArn("snapshotArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolume.OriginSnapshotProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginSnapshotProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginSnapshotProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The strategy used when copying data from the snapshot to the new volume.
         * <p>
         * <ul>
         * <li><code>CLONE</code> - The new volume references the data in the origin snapshot. Cloning a snapshot is faster than copying data from the snapshot to a new volume and doesn't consume disk throughput. However, the origin snapshot can't be deleted if there is a volume using its copied data.</li>
         * <li><code>FULL_COPY</code> - Copies all data from the snapshot to the new volume.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCopyStrategy();

        /**
         * Specifies the snapshot to use when creating an OpenZFS volume from a snapshot.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSnapshotArn();

        /**
         * @return a {@link Builder} of {@link OriginSnapshotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginSnapshotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginSnapshotProperty> {
            java.lang.String copyStrategy;
            java.lang.String snapshotArn;

            /**
             * Sets the value of {@link OriginSnapshotProperty#getCopyStrategy}
             * @param copyStrategy The strategy used when copying data from the snapshot to the new volume. This parameter is required.
             *                     <ul>
             *                     <li><code>CLONE</code> - The new volume references the data in the origin snapshot. Cloning a snapshot is faster than copying data from the snapshot to a new volume and doesn't consume disk throughput. However, the origin snapshot can't be deleted if there is a volume using its copied data.</li>
             *                     <li><code>FULL_COPY</code> - Copies all data from the snapshot to the new volume.</li>
             *                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyStrategy(java.lang.String copyStrategy) {
                this.copyStrategy = copyStrategy;
                return this;
            }

            /**
             * Sets the value of {@link OriginSnapshotProperty#getSnapshotArn}
             * @param snapshotArn Specifies the snapshot to use when creating an OpenZFS volume from a snapshot. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotArn(java.lang.String snapshotArn) {
                this.snapshotArn = snapshotArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginSnapshotProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginSnapshotProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OriginSnapshotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginSnapshotProperty {
            private final java.lang.String copyStrategy;
            private final java.lang.String snapshotArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.copyStrategy = software.amazon.jsii.Kernel.get(this, "copyStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.snapshotArn = software.amazon.jsii.Kernel.get(this, "snapshotArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.copyStrategy = java.util.Objects.requireNonNull(builder.copyStrategy, "copyStrategy is required");
                this.snapshotArn = java.util.Objects.requireNonNull(builder.snapshotArn, "snapshotArn is required");
            }

            @Override
            public final java.lang.String getCopyStrategy() {
                return this.copyStrategy;
            }

            @Override
            public final java.lang.String getSnapshotArn() {
                return this.snapshotArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("copyStrategy", om.valueToTree(this.getCopyStrategy()));
                data.set("snapshotArn", om.valueToTree(this.getSnapshotArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnVolume.OriginSnapshotProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginSnapshotProperty.Jsii$Proxy that = (OriginSnapshotProperty.Jsii$Proxy) o;

                if (!copyStrategy.equals(that.copyStrategy)) return false;
                return this.snapshotArn.equals(that.snapshotArn);
            }

            @Override
            public final int hashCode() {
                int result = this.copyStrategy.hashCode();
                result = 31 * result + (this.snapshotArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Describes the data tiering policy for an ONTAP volume.
     * <p>
     * When enabled, Amazon FSx for ONTAP's intelligent tiering automatically transitions a volume's data between the file system's primary storage and capacity pool storage based on your access patterns.
     * <p>
     * Valid tiering policies are the following:
     * <p>
     * <ul>
     * <li><code>SNAPSHOT_ONLY</code> - (Default value) moves cold snapshots to the capacity pool storage tier.</li>
     * <li><code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your access patterns.</li>
     * <li><code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the storage pool tier.</li>
     * <li><code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to the capacity pool tier.</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * TieringPolicyProperty tieringPolicyProperty = TieringPolicyProperty.builder()
     *         .coolingPeriod(123)
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolume.TieringPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(TieringPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TieringPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the number of days that user data in a volume must remain inactive before it is considered "cold" and moved to the capacity pool.
         * <p>
         * Used with the <code>AUTO</code> and <code>SNAPSHOT_ONLY</code> tiering policies. Enter a whole number between 2 and 183. Default values are 31 days for <code>AUTO</code> and 2 days for <code>SNAPSHOT_ONLY</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCoolingPeriod() {
            return null;
        }

        /**
         * Specifies the tiering policy used to transition data. Default value is `SNAPSHOT_ONLY` .
         * <p>
         * <ul>
         * <li><code>SNAPSHOT_ONLY</code> - moves cold snapshots to the capacity pool storage tier.</li>
         * <li><code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your access patterns.</li>
         * <li><code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the storage pool tier.</li>
         * <li><code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to the capacity pool tier.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TieringPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TieringPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TieringPolicyProperty> {
            java.lang.Number coolingPeriod;
            java.lang.String name;

            /**
             * Sets the value of {@link TieringPolicyProperty#getCoolingPeriod}
             * @param coolingPeriod Specifies the number of days that user data in a volume must remain inactive before it is considered "cold" and moved to the capacity pool.
             *                      Used with the <code>AUTO</code> and <code>SNAPSHOT_ONLY</code> tiering policies. Enter a whole number between 2 and 183. Default values are 31 days for <code>AUTO</code> and 2 days for <code>SNAPSHOT_ONLY</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coolingPeriod(java.lang.Number coolingPeriod) {
                this.coolingPeriod = coolingPeriod;
                return this;
            }

            /**
             * Sets the value of {@link TieringPolicyProperty#getName}
             * @param name Specifies the tiering policy used to transition data. Default value is `SNAPSHOT_ONLY` .
             *             <ul>
             *             <li><code>SNAPSHOT_ONLY</code> - moves cold snapshots to the capacity pool storage tier.</li>
             *             <li><code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your access patterns.</li>
             *             <li><code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the storage pool tier.</li>
             *             <li><code>NONE</code> - keeps a volume's data in the primary storage tier, preventing it from being moved to the capacity pool tier.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TieringPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TieringPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TieringPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TieringPolicyProperty {
            private final java.lang.Number coolingPeriod;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.coolingPeriod = software.amazon.jsii.Kernel.get(this, "coolingPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.coolingPeriod = builder.coolingPeriod;
                this.name = builder.name;
            }

            @Override
            public final java.lang.Number getCoolingPeriod() {
                return this.coolingPeriod;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCoolingPeriod() != null) {
                    data.set("coolingPeriod", om.valueToTree(this.getCoolingPeriod()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnVolume.TieringPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TieringPolicyProperty.Jsii$Proxy that = (TieringPolicyProperty.Jsii$Proxy) o;

                if (this.coolingPeriod != null ? !this.coolingPeriod.equals(that.coolingPeriod) : that.coolingPeriod != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.coolingPeriod != null ? this.coolingPeriod.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object specifying how much storage users or groups can use on the volume.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * UserAndGroupQuotasProperty userAndGroupQuotasProperty = UserAndGroupQuotasProperty.builder()
     *         .id(123)
     *         .storageCapacityQuotaGiB(123)
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnVolume.UserAndGroupQuotasProperty")
    @software.amazon.jsii.Jsii.Proxy(UserAndGroupQuotasProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserAndGroupQuotasProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the user or group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getId();

        /**
         * The amount of storage that the user or group can use in gibibytes (GiB).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getStorageCapacityQuotaGiB();

        /**
         * A value that specifies whether the quota applies to a user or group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link UserAndGroupQuotasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserAndGroupQuotasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserAndGroupQuotasProperty> {
            java.lang.Number id;
            java.lang.Number storageCapacityQuotaGiB;
            java.lang.String type;

            /**
             * Sets the value of {@link UserAndGroupQuotasProperty#getId}
             * @param id The ID of the user or group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.Number id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link UserAndGroupQuotasProperty#getStorageCapacityQuotaGiB}
             * @param storageCapacityQuotaGiB The amount of storage that the user or group can use in gibibytes (GiB). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageCapacityQuotaGiB(java.lang.Number storageCapacityQuotaGiB) {
                this.storageCapacityQuotaGiB = storageCapacityQuotaGiB;
                return this;
            }

            /**
             * Sets the value of {@link UserAndGroupQuotasProperty#getType}
             * @param type A value that specifies whether the quota applies to a user or group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserAndGroupQuotasProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserAndGroupQuotasProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UserAndGroupQuotasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserAndGroupQuotasProperty {
            private final java.lang.Number id;
            private final java.lang.Number storageCapacityQuotaGiB;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.storageCapacityQuotaGiB = software.amazon.jsii.Kernel.get(this, "storageCapacityQuotaGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.storageCapacityQuotaGiB = java.util.Objects.requireNonNull(builder.storageCapacityQuotaGiB, "storageCapacityQuotaGiB is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.Number getId() {
                return this.id;
            }

            @Override
            public final java.lang.Number getStorageCapacityQuotaGiB() {
                return this.storageCapacityQuotaGiB;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                data.set("storageCapacityQuotaGiB", om.valueToTree(this.getStorageCapacityQuotaGiB()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnVolume.UserAndGroupQuotasProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserAndGroupQuotasProperty.Jsii$Proxy that = (UserAndGroupQuotasProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                if (!storageCapacityQuotaGiB.equals(that.storageCapacityQuotaGiB)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.storageCapacityQuotaGiB.hashCode());
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.fsx.CfnVolume}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.fsx.CfnVolume> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.fsx.CfnVolumeProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.fsx.CfnVolumeProps.Builder();
        }

        /**
         * The name of the volume.
         * <p>
         * @return {@code this}
         * @param name The name of the volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Specifies the ID of the volume backup to use to create a new volume.
         * <p>
         * @return {@code this}
         * @param backupId Specifies the ID of the volume backup to use to create a new volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupId(final java.lang.String backupId) {
            this.props.backupId(backupId);
            return this;
        }

        /**
         * The configuration of an Amazon FSx for NetApp ONTAP volume.
         * <p>
         * @return {@code this}
         * @param ontapConfiguration The configuration of an Amazon FSx for NetApp ONTAP volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ontapConfiguration(final software.amazon.awscdk.services.fsx.CfnVolume.OntapConfigurationProperty ontapConfiguration) {
            this.props.ontapConfiguration(ontapConfiguration);
            return this;
        }
        /**
         * The configuration of an Amazon FSx for NetApp ONTAP volume.
         * <p>
         * @return {@code this}
         * @param ontapConfiguration The configuration of an Amazon FSx for NetApp ONTAP volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ontapConfiguration(final software.amazon.awscdk.IResolvable ontapConfiguration) {
            this.props.ontapConfiguration(ontapConfiguration);
            return this;
        }

        /**
         * The configuration of an Amazon FSx for OpenZFS volume.
         * <p>
         * @return {@code this}
         * @param openZfsConfiguration The configuration of an Amazon FSx for OpenZFS volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openZfsConfiguration(final software.amazon.awscdk.services.fsx.CfnVolume.OpenZFSConfigurationProperty openZfsConfiguration) {
            this.props.openZfsConfiguration(openZfsConfiguration);
            return this;
        }
        /**
         * The configuration of an Amazon FSx for OpenZFS volume.
         * <p>
         * @return {@code this}
         * @param openZfsConfiguration The configuration of an Amazon FSx for OpenZFS volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openZfsConfiguration(final software.amazon.awscdk.IResolvable openZfsConfiguration) {
            this.props.openZfsConfiguration(openZfsConfiguration);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The type of the volume.
         * <p>
         * @return {@code this}
         * @param volumeType The type of the volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeType(final java.lang.String volumeType) {
            this.props.volumeType(volumeType);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.fsx.CfnVolume}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.fsx.CfnVolume build() {
            return new software.amazon.awscdk.services.fsx.CfnVolume(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
