package software.amazon.awscdk.services.cognito;

/**
 * Options while specifying a cognito prefix domain.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool pool = new UserPool(this, "Pool");
 * pool.addDomain("CognitoDomain", UserPoolDomainOptions.builder()
 *         .cognitoDomain(CognitoDomainOptions.builder()
 *                 .domainPrefix("my-awesome-app")
 *                 .build())
 *         .build());
 * String certificateArn = "arn:aws:acm:us-east-1:123456789012:certificate/11-3336f1-44483d-adc7-9cd375c5169d";
 * ICertificate domainCert = Certificate.fromCertificateArn(this, "domainCert", certificateArn);
 * pool.addDomain("CustomDomain", UserPoolDomainOptions.builder()
 *         .customDomain(CustomDomainOptions.builder()
 *                 .domainName("user.myapp.com")
 *                 .certificate(domainCert)
 *                 .build())
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain-prefix.html">https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain-prefix.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:50.005Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CognitoDomainOptions")
@software.amazon.jsii.Jsii.Proxy(CognitoDomainOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CognitoDomainOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The prefix to the Cognito hosted domain name that will be associated with the user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainPrefix();

    /**
     * @return a {@link Builder} of {@link CognitoDomainOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CognitoDomainOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CognitoDomainOptions> {
        java.lang.String domainPrefix;

        /**
         * Sets the value of {@link CognitoDomainOptions#getDomainPrefix}
         * @param domainPrefix The prefix to the Cognito hosted domain name that will be associated with the user pool. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainPrefix(java.lang.String domainPrefix) {
            this.domainPrefix = domainPrefix;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CognitoDomainOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CognitoDomainOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CognitoDomainOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CognitoDomainOptions {
        private final java.lang.String domainPrefix;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainPrefix = software.amazon.jsii.Kernel.get(this, "domainPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainPrefix = java.util.Objects.requireNonNull(builder.domainPrefix, "domainPrefix is required");
        }

        @Override
        public final java.lang.String getDomainPrefix() {
            return this.domainPrefix;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainPrefix", om.valueToTree(this.getDomainPrefix()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CognitoDomainOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CognitoDomainOptions.Jsii$Proxy that = (CognitoDomainOptions.Jsii$Proxy) o;

            return this.domainPrefix.equals(that.domainPrefix);
        }

        @Override
        public final int hashCode() {
            int result = this.domainPrefix.hashCode();
            return result;
        }
    }
}
