package software.amazon.awscdk.services.codestarnotifications;

/**
 * Properties for defining a `CfnNotificationRule`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codestarnotifications.*;
 * Object tags;
 * CfnNotificationRuleProps cfnNotificationRuleProps = CfnNotificationRuleProps.builder()
 *         .detailType("detailType")
 *         .eventTypeIds(List.of("eventTypeIds"))
 *         .name("name")
 *         .resource("resource")
 *         .targets(List.of(TargetProperty.builder()
 *                 .targetAddress("targetAddress")
 *                 .targetType("targetType")
 *                 .build()))
 *         // the properties below are optional
 *         .createdBy("createdBy")
 *         .eventTypeId("eventTypeId")
 *         .status("status")
 *         .tags(tags)
 *         .targetAddress("targetAddress")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:49.916Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codestarnotifications.CfnNotificationRuleProps")
@software.amazon.jsii.Jsii.Proxy(CfnNotificationRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnNotificationRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The level of detail to include in the notifications for this resource.
     * <p>
     * <code>BASIC</code> will include only the contents of the event as it would appear in Amazon CloudWatch. <code>FULL</code> will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDetailType();

    /**
     * A list of event types associated with this notification rule.
     * <p>
     * For a complete list of event types and IDs, see <a href="https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api">Notification concepts</a> in the <em>Developer Tools Console User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getEventTypeIds();

    /**
     * The name for the notification rule.
     * <p>
     * Notification rule names must be unique in your AWS account .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The Amazon Resource Name (ARN) of the resource to associate with the notification rule.
     * <p>
     * Supported resources include pipelines in AWS CodePipeline , repositories in AWS CodeCommit , and build projects in AWS CodeBuild .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResource();

    /**
     * A list of Amazon Resource Names (ARNs) of AWS Chatbot topics and AWS Chatbot clients to associate with the notification rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTargets();

    /**
     * `AWS::CodeStarNotifications::NotificationRule.CreatedBy`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCreatedBy() {
        return null;
    }

    /**
     * `AWS::CodeStarNotifications::NotificationRule.EventTypeId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEventTypeId() {
        return null;
    }

    /**
     * The status of the notification rule.
     * <p>
     * The default value is <code>ENABLED</code> . If the status is set to <code>DISABLED</code> , notifications aren't sent for the notification rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return null;
    }

    /**
     * A list of tags to apply to this notification rule.
     * <p>
     * Key names cannot start with " <code>aws</code> ".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * `AWS::CodeStarNotifications::NotificationRule.TargetAddress`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTargetAddress() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnNotificationRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnNotificationRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnNotificationRuleProps> {
        java.lang.String detailType;
        java.util.List<java.lang.String> eventTypeIds;
        java.lang.String name;
        java.lang.String resource;
        java.lang.Object targets;
        java.lang.String createdBy;
        java.lang.String eventTypeId;
        java.lang.String status;
        java.lang.Object tags;
        java.lang.String targetAddress;

        /**
         * Sets the value of {@link CfnNotificationRuleProps#getDetailType}
         * @param detailType The level of detail to include in the notifications for this resource. This parameter is required.
         *                   <code>BASIC</code> will include only the contents of the event as it would appear in Amazon CloudWatch. <code>FULL</code> will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detailType(java.lang.String detailType) {
            this.detailType = detailType;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotificationRuleProps#getEventTypeIds}
         * @param eventTypeIds A list of event types associated with this notification rule. This parameter is required.
         *                     For a complete list of event types and IDs, see <a href="https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api">Notification concepts</a> in the <em>Developer Tools Console User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventTypeIds(java.util.List<java.lang.String> eventTypeIds) {
            this.eventTypeIds = eventTypeIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotificationRuleProps#getName}
         * @param name The name for the notification rule. This parameter is required.
         *             Notification rule names must be unique in your AWS account .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotificationRuleProps#getResource}
         * @param resource The Amazon Resource Name (ARN) of the resource to associate with the notification rule. This parameter is required.
         *                 Supported resources include pipelines in AWS CodePipeline , repositories in AWS CodeCommit , and build projects in AWS CodeBuild .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resource(java.lang.String resource) {
            this.resource = resource;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotificationRuleProps#getTargets}
         * @param targets A list of Amazon Resource Names (ARNs) of AWS Chatbot topics and AWS Chatbot clients to associate with the notification rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(software.amazon.awscdk.IResolvable targets) {
            this.targets = targets;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotificationRuleProps#getTargets}
         * @param targets A list of Amazon Resource Names (ARNs) of AWS Chatbot topics and AWS Chatbot clients to associate with the notification rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(java.util.List<? extends java.lang.Object> targets) {
            this.targets = targets;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotificationRuleProps#getCreatedBy}
         * @param createdBy `AWS::CodeStarNotifications::NotificationRule.CreatedBy`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createdBy(java.lang.String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotificationRuleProps#getEventTypeId}
         * @param eventTypeId `AWS::CodeStarNotifications::NotificationRule.EventTypeId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventTypeId(java.lang.String eventTypeId) {
            this.eventTypeId = eventTypeId;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotificationRuleProps#getStatus}
         * @param status The status of the notification rule.
         *               The default value is <code>ENABLED</code> . If the status is set to <code>DISABLED</code> , notifications aren't sent for the notification rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotificationRuleProps#getTags}
         * @param tags A list of tags to apply to this notification rule.
         *             Key names cannot start with " <code>aws</code> ".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnNotificationRuleProps#getTargetAddress}
         * @param targetAddress `AWS::CodeStarNotifications::NotificationRule.TargetAddress`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetAddress(java.lang.String targetAddress) {
            this.targetAddress = targetAddress;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNotificationRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnNotificationRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnNotificationRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnNotificationRuleProps {
        private final java.lang.String detailType;
        private final java.util.List<java.lang.String> eventTypeIds;
        private final java.lang.String name;
        private final java.lang.String resource;
        private final java.lang.Object targets;
        private final java.lang.String createdBy;
        private final java.lang.String eventTypeId;
        private final java.lang.String status;
        private final java.lang.Object tags;
        private final java.lang.String targetAddress;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.detailType = software.amazon.jsii.Kernel.get(this, "detailType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventTypeIds = software.amazon.jsii.Kernel.get(this, "eventTypeIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resource = software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targets = software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.createdBy = software.amazon.jsii.Kernel.get(this, "createdBy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventTypeId = software.amazon.jsii.Kernel.get(this, "eventTypeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.targetAddress = software.amazon.jsii.Kernel.get(this, "targetAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.detailType = java.util.Objects.requireNonNull(builder.detailType, "detailType is required");
            this.eventTypeIds = java.util.Objects.requireNonNull(builder.eventTypeIds, "eventTypeIds is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.resource = java.util.Objects.requireNonNull(builder.resource, "resource is required");
            this.targets = java.util.Objects.requireNonNull(builder.targets, "targets is required");
            this.createdBy = builder.createdBy;
            this.eventTypeId = builder.eventTypeId;
            this.status = builder.status;
            this.tags = builder.tags;
            this.targetAddress = builder.targetAddress;
        }

        @Override
        public final java.lang.String getDetailType() {
            return this.detailType;
        }

        @Override
        public final java.util.List<java.lang.String> getEventTypeIds() {
            return this.eventTypeIds;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getResource() {
            return this.resource;
        }

        @Override
        public final java.lang.Object getTargets() {
            return this.targets;
        }

        @Override
        public final java.lang.String getCreatedBy() {
            return this.createdBy;
        }

        @Override
        public final java.lang.String getEventTypeId() {
            return this.eventTypeId;
        }

        @Override
        public final java.lang.String getStatus() {
            return this.status;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTargetAddress() {
            return this.targetAddress;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("detailType", om.valueToTree(this.getDetailType()));
            data.set("eventTypeIds", om.valueToTree(this.getEventTypeIds()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("resource", om.valueToTree(this.getResource()));
            data.set("targets", om.valueToTree(this.getTargets()));
            if (this.getCreatedBy() != null) {
                data.set("createdBy", om.valueToTree(this.getCreatedBy()));
            }
            if (this.getEventTypeId() != null) {
                data.set("eventTypeId", om.valueToTree(this.getEventTypeId()));
            }
            if (this.getStatus() != null) {
                data.set("status", om.valueToTree(this.getStatus()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTargetAddress() != null) {
                data.set("targetAddress", om.valueToTree(this.getTargetAddress()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codestarnotifications.CfnNotificationRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnNotificationRuleProps.Jsii$Proxy that = (CfnNotificationRuleProps.Jsii$Proxy) o;

            if (!detailType.equals(that.detailType)) return false;
            if (!eventTypeIds.equals(that.eventTypeIds)) return false;
            if (!name.equals(that.name)) return false;
            if (!resource.equals(that.resource)) return false;
            if (!targets.equals(that.targets)) return false;
            if (this.createdBy != null ? !this.createdBy.equals(that.createdBy) : that.createdBy != null) return false;
            if (this.eventTypeId != null ? !this.eventTypeId.equals(that.eventTypeId) : that.eventTypeId != null) return false;
            if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.targetAddress != null ? this.targetAddress.equals(that.targetAddress) : that.targetAddress == null;
        }

        @Override
        public final int hashCode() {
            int result = this.detailType.hashCode();
            result = 31 * result + (this.eventTypeIds.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.resource.hashCode());
            result = 31 * result + (this.targets.hashCode());
            result = 31 * result + (this.createdBy != null ? this.createdBy.hashCode() : 0);
            result = 31 * result + (this.eventTypeId != null ? this.eventTypeId.hashCode() : 0);
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.targetAddress != null ? this.targetAddress.hashCode() : 0);
            return result;
        }
    }
}
