package software.amazon.awscdk.services.codedeploy;

/**
 * The Deployment Configuration of an ECS Deployment Group.
 * <p>
 * The default, pre-defined Configurations are available as constants on the {&#64;link EcsDeploymentConfig} class
 * (for example, <code>EcsDeploymentConfig.AllAtOnce</code>).
 * <p>
 * Note: CloudFormation does not currently support creating custom ECS configs outside
 * of using a custom resource. You can import custom deployment config created outside the
 * CDK or via a custom resource with {&#64;link EcsDeploymentConfig#fromEcsDeploymentConfigName}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:49.762Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codedeploy.IEcsDeploymentConfig")
@software.amazon.jsii.Jsii.Proxy(IEcsDeploymentConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IEcsDeploymentConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigArn();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigName();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codedeploy.IEcsDeploymentConfig.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigArn() {
            return software.amazon.jsii.Kernel.get(this, "deploymentConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigName() {
            return software.amazon.jsii.Kernel.get(this, "deploymentConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }

    /**
     * Internal default implementation for {@link IEcsDeploymentConfig}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IEcsDeploymentConfig {

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigArn() {
            return software.amazon.jsii.Kernel.get(this, "deploymentConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getDeploymentConfigName() {
            return software.amazon.jsii.Kernel.get(this, "deploymentConfigName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
