package software.amazon.awscdk.services.cloudtrail;

/**
 * A CloudFormation `AWS::CloudTrail::EventDataStore`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudtrail.*;
 * CfnEventDataStore cfnEventDataStore = CfnEventDataStore.Builder.create(this, "MyCfnEventDataStore")
 *         .advancedEventSelectors(List.of(AdvancedEventSelectorProperty.builder()
 *                 .fieldSelectors(List.of(AdvancedFieldSelectorProperty.builder()
 *                         .field("field")
 *                         // the properties below are optional
 *                         .endsWith(List.of("endsWith"))
 *                         .equalTo(List.of("equalTo"))
 *                         .notEndsWith(List.of("notEndsWith"))
 *                         .notEquals(List.of("notEquals"))
 *                         .notStartsWith(List.of("notStartsWith"))
 *                         .startsWith(List.of("startsWith"))
 *                         .build()))
 *                 // the properties below are optional
 *                 .name("name")
 *                 .build()))
 *         .multiRegionEnabled(false)
 *         .name("name")
 *         .organizationEnabled(false)
 *         .retentionPeriod(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .terminationProtectionEnabled(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:49.530Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnEventDataStore")
public class CfnEventDataStore extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnEventDataStore(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEventDataStore(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudtrail.CfnEventDataStore.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::CloudTrail::EventDataStore`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEventDataStore(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudtrail.CfnEventDataStoreProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::CloudTrail::EventDataStore`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEventDataStore(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedTimestamp() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedTimestamp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEventDataStoreArn() {
        return software.amazon.jsii.Kernel.get(this, "attrEventDataStoreArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedTimestamp() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedTimestamp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::CloudTrail::EventDataStore.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * `AWS::CloudTrail::EventDataStore.AdvancedEventSelectors`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedEventSelectors() {
        return software.amazon.jsii.Kernel.get(this, "advancedEventSelectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::CloudTrail::EventDataStore.AdvancedEventSelectors`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdvancedEventSelectors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "advancedEventSelectors", value);
    }

    /**
     * `AWS::CloudTrail::EventDataStore.AdvancedEventSelectors`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdvancedEventSelectors(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.cloudtrail.CfnEventDataStore.AdvancedEventSelectorProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.cloudtrail.CfnEventDataStore.AdvancedEventSelectorProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "advancedEventSelectors", value);
    }

    /**
     * `AWS::CloudTrail::EventDataStore.MultiRegionEnabled`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMultiRegionEnabled() {
        return software.amazon.jsii.Kernel.get(this, "multiRegionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::CloudTrail::EventDataStore.MultiRegionEnabled`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiRegionEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "multiRegionEnabled", value);
    }

    /**
     * `AWS::CloudTrail::EventDataStore.MultiRegionEnabled`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiRegionEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "multiRegionEnabled", value);
    }

    /**
     * `AWS::CloudTrail::EventDataStore.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::CloudTrail::EventDataStore.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * `AWS::CloudTrail::EventDataStore.OrganizationEnabled`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOrganizationEnabled() {
        return software.amazon.jsii.Kernel.get(this, "organizationEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::CloudTrail::EventDataStore.OrganizationEnabled`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "organizationEnabled", value);
    }

    /**
     * `AWS::CloudTrail::EventDataStore.OrganizationEnabled`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "organizationEnabled", value);
    }

    /**
     * `AWS::CloudTrail::EventDataStore.RetentionPeriod`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "retentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * `AWS::CloudTrail::EventDataStore.RetentionPeriod`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "retentionPeriod", value);
    }

    /**
     * `AWS::CloudTrail::EventDataStore.TerminationProtectionEnabled`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTerminationProtectionEnabled() {
        return software.amazon.jsii.Kernel.get(this, "terminationProtectionEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::CloudTrail::EventDataStore.TerminationProtectionEnabled`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTerminationProtectionEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "terminationProtectionEnabled", value);
    }

    /**
     * `AWS::CloudTrail::EventDataStore.TerminationProtectionEnabled`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTerminationProtectionEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "terminationProtectionEnabled", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudtrail.*;
     * AdvancedEventSelectorProperty advancedEventSelectorProperty = AdvancedEventSelectorProperty.builder()
     *         .fieldSelectors(List.of(AdvancedFieldSelectorProperty.builder()
     *                 .field("field")
     *                 // the properties below are optional
     *                 .endsWith(List.of("endsWith"))
     *                 .equalTo(List.of("equalTo"))
     *                 .notEndsWith(List.of("notEndsWith"))
     *                 .notEquals(List.of("notEquals"))
     *                 .notStartsWith(List.of("notStartsWith"))
     *                 .startsWith(List.of("startsWith"))
     *                 .build()))
     *         // the properties below are optional
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnEventDataStore.AdvancedEventSelectorProperty")
    @software.amazon.jsii.Jsii.Proxy(AdvancedEventSelectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdvancedEventSelectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEventDataStore.AdvancedEventSelectorProperty.FieldSelectors`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldSelectors();

        /**
         * `CfnEventDataStore.AdvancedEventSelectorProperty.Name`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdvancedEventSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdvancedEventSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdvancedEventSelectorProperty> {
            java.lang.Object fieldSelectors;
            java.lang.String name;

            /**
             * Sets the value of {@link AdvancedEventSelectorProperty#getFieldSelectors}
             * @param fieldSelectors `CfnEventDataStore.AdvancedEventSelectorProperty.FieldSelectors`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldSelectors(software.amazon.awscdk.IResolvable fieldSelectors) {
                this.fieldSelectors = fieldSelectors;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedEventSelectorProperty#getFieldSelectors}
             * @param fieldSelectors `CfnEventDataStore.AdvancedEventSelectorProperty.FieldSelectors`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldSelectors(java.util.List<? extends java.lang.Object> fieldSelectors) {
                this.fieldSelectors = fieldSelectors;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedEventSelectorProperty#getName}
             * @param name `CfnEventDataStore.AdvancedEventSelectorProperty.Name`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdvancedEventSelectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdvancedEventSelectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdvancedEventSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdvancedEventSelectorProperty {
            private final java.lang.Object fieldSelectors;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldSelectors = software.amazon.jsii.Kernel.get(this, "fieldSelectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldSelectors = java.util.Objects.requireNonNull(builder.fieldSelectors, "fieldSelectors is required");
                this.name = builder.name;
            }

            @Override
            public final java.lang.Object getFieldSelectors() {
                return this.fieldSelectors;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fieldSelectors", om.valueToTree(this.getFieldSelectors()));
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.CfnEventDataStore.AdvancedEventSelectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdvancedEventSelectorProperty.Jsii$Proxy that = (AdvancedEventSelectorProperty.Jsii$Proxy) o;

                if (!fieldSelectors.equals(that.fieldSelectors)) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fieldSelectors.hashCode();
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudtrail.*;
     * AdvancedFieldSelectorProperty advancedFieldSelectorProperty = AdvancedFieldSelectorProperty.builder()
     *         .field("field")
     *         // the properties below are optional
     *         .endsWith(List.of("endsWith"))
     *         .equalTo(List.of("equalTo"))
     *         .notEndsWith(List.of("notEndsWith"))
     *         .notEquals(List.of("notEquals"))
     *         .notStartsWith(List.of("notStartsWith"))
     *         .startsWith(List.of("startsWith"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnEventDataStore.AdvancedFieldSelectorProperty")
    @software.amazon.jsii.Jsii.Proxy(AdvancedFieldSelectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdvancedFieldSelectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnEventDataStore.AdvancedFieldSelectorProperty.Field`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getField();

        /**
         * `CfnEventDataStore.AdvancedFieldSelectorProperty.EndsWith`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEndsWith() {
            return null;
        }

        /**
         * `CfnEventDataStore.AdvancedFieldSelectorProperty.Equals`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEqualTo() {
            return null;
        }

        /**
         * `CfnEventDataStore.AdvancedFieldSelectorProperty.NotEndsWith`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotEndsWith() {
            return null;
        }

        /**
         * `CfnEventDataStore.AdvancedFieldSelectorProperty.NotEquals`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotEquals() {
            return null;
        }

        /**
         * `CfnEventDataStore.AdvancedFieldSelectorProperty.NotStartsWith`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotStartsWith() {
            return null;
        }

        /**
         * `CfnEventDataStore.AdvancedFieldSelectorProperty.StartsWith`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStartsWith() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdvancedFieldSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdvancedFieldSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdvancedFieldSelectorProperty> {
            java.lang.String field;
            java.util.List<java.lang.String> endsWith;
            java.util.List<java.lang.String> equalTo;
            java.util.List<java.lang.String> notEndsWith;
            java.util.List<java.lang.String> notEquals;
            java.util.List<java.lang.String> notStartsWith;
            java.util.List<java.lang.String> startsWith;

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getField}
             * @param field `CfnEventDataStore.AdvancedFieldSelectorProperty.Field`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder field(java.lang.String field) {
                this.field = field;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getEndsWith}
             * @param endsWith `CfnEventDataStore.AdvancedFieldSelectorProperty.EndsWith`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endsWith(java.util.List<java.lang.String> endsWith) {
                this.endsWith = endsWith;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getEqualTo}
             * @param equalTo `CfnEventDataStore.AdvancedFieldSelectorProperty.Equals`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder equalTo(java.util.List<java.lang.String> equalTo) {
                this.equalTo = equalTo;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getNotEndsWith}
             * @param notEndsWith `CfnEventDataStore.AdvancedFieldSelectorProperty.NotEndsWith`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notEndsWith(java.util.List<java.lang.String> notEndsWith) {
                this.notEndsWith = notEndsWith;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getNotEquals}
             * @param notEquals `CfnEventDataStore.AdvancedFieldSelectorProperty.NotEquals`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notEquals(java.util.List<java.lang.String> notEquals) {
                this.notEquals = notEquals;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getNotStartsWith}
             * @param notStartsWith `CfnEventDataStore.AdvancedFieldSelectorProperty.NotStartsWith`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notStartsWith(java.util.List<java.lang.String> notStartsWith) {
                this.notStartsWith = notStartsWith;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getStartsWith}
             * @param startsWith `CfnEventDataStore.AdvancedFieldSelectorProperty.StartsWith`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startsWith(java.util.List<java.lang.String> startsWith) {
                this.startsWith = startsWith;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdvancedFieldSelectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdvancedFieldSelectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdvancedFieldSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdvancedFieldSelectorProperty {
            private final java.lang.String field;
            private final java.util.List<java.lang.String> endsWith;
            private final java.util.List<java.lang.String> equalTo;
            private final java.util.List<java.lang.String> notEndsWith;
            private final java.util.List<java.lang.String> notEquals;
            private final java.util.List<java.lang.String> notStartsWith;
            private final java.util.List<java.lang.String> startsWith;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.field = software.amazon.jsii.Kernel.get(this, "field", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endsWith = software.amazon.jsii.Kernel.get(this, "endsWith", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.equalTo = software.amazon.jsii.Kernel.get(this, "equalTo", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.notEndsWith = software.amazon.jsii.Kernel.get(this, "notEndsWith", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.notEquals = software.amazon.jsii.Kernel.get(this, "notEquals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.notStartsWith = software.amazon.jsii.Kernel.get(this, "notStartsWith", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.startsWith = software.amazon.jsii.Kernel.get(this, "startsWith", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.field = java.util.Objects.requireNonNull(builder.field, "field is required");
                this.endsWith = builder.endsWith;
                this.equalTo = builder.equalTo;
                this.notEndsWith = builder.notEndsWith;
                this.notEquals = builder.notEquals;
                this.notStartsWith = builder.notStartsWith;
                this.startsWith = builder.startsWith;
            }

            @Override
            public final java.lang.String getField() {
                return this.field;
            }

            @Override
            public final java.util.List<java.lang.String> getEndsWith() {
                return this.endsWith;
            }

            @Override
            public final java.util.List<java.lang.String> getEqualTo() {
                return this.equalTo;
            }

            @Override
            public final java.util.List<java.lang.String> getNotEndsWith() {
                return this.notEndsWith;
            }

            @Override
            public final java.util.List<java.lang.String> getNotEquals() {
                return this.notEquals;
            }

            @Override
            public final java.util.List<java.lang.String> getNotStartsWith() {
                return this.notStartsWith;
            }

            @Override
            public final java.util.List<java.lang.String> getStartsWith() {
                return this.startsWith;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("field", om.valueToTree(this.getField()));
                if (this.getEndsWith() != null) {
                    data.set("endsWith", om.valueToTree(this.getEndsWith()));
                }
                if (this.getEqualTo() != null) {
                    data.set("equalTo", om.valueToTree(this.getEqualTo()));
                }
                if (this.getNotEndsWith() != null) {
                    data.set("notEndsWith", om.valueToTree(this.getNotEndsWith()));
                }
                if (this.getNotEquals() != null) {
                    data.set("notEquals", om.valueToTree(this.getNotEquals()));
                }
                if (this.getNotStartsWith() != null) {
                    data.set("notStartsWith", om.valueToTree(this.getNotStartsWith()));
                }
                if (this.getStartsWith() != null) {
                    data.set("startsWith", om.valueToTree(this.getStartsWith()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.CfnEventDataStore.AdvancedFieldSelectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdvancedFieldSelectorProperty.Jsii$Proxy that = (AdvancedFieldSelectorProperty.Jsii$Proxy) o;

                if (!field.equals(that.field)) return false;
                if (this.endsWith != null ? !this.endsWith.equals(that.endsWith) : that.endsWith != null) return false;
                if (this.equalTo != null ? !this.equalTo.equals(that.equalTo) : that.equalTo != null) return false;
                if (this.notEndsWith != null ? !this.notEndsWith.equals(that.notEndsWith) : that.notEndsWith != null) return false;
                if (this.notEquals != null ? !this.notEquals.equals(that.notEquals) : that.notEquals != null) return false;
                if (this.notStartsWith != null ? !this.notStartsWith.equals(that.notStartsWith) : that.notStartsWith != null) return false;
                return this.startsWith != null ? this.startsWith.equals(that.startsWith) : that.startsWith == null;
            }

            @Override
            public final int hashCode() {
                int result = this.field.hashCode();
                result = 31 * result + (this.endsWith != null ? this.endsWith.hashCode() : 0);
                result = 31 * result + (this.equalTo != null ? this.equalTo.hashCode() : 0);
                result = 31 * result + (this.notEndsWith != null ? this.notEndsWith.hashCode() : 0);
                result = 31 * result + (this.notEquals != null ? this.notEquals.hashCode() : 0);
                result = 31 * result + (this.notStartsWith != null ? this.notStartsWith.hashCode() : 0);
                result = 31 * result + (this.startsWith != null ? this.startsWith.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudtrail.CfnEventDataStore}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudtrail.CfnEventDataStore> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.cloudtrail.CfnEventDataStoreProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * `AWS::CloudTrail::EventDataStore.AdvancedEventSelectors`.
         * <p>
         * @return {@code this}
         * @param advancedEventSelectors `AWS::CloudTrail::EventDataStore.AdvancedEventSelectors`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedEventSelectors(final software.amazon.awscdk.IResolvable advancedEventSelectors) {
            this.props().advancedEventSelectors(advancedEventSelectors);
            return this;
        }
        /**
         * `AWS::CloudTrail::EventDataStore.AdvancedEventSelectors`.
         * <p>
         * @return {@code this}
         * @param advancedEventSelectors `AWS::CloudTrail::EventDataStore.AdvancedEventSelectors`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedEventSelectors(final java.util.List<? extends java.lang.Object> advancedEventSelectors) {
            this.props().advancedEventSelectors(advancedEventSelectors);
            return this;
        }

        /**
         * `AWS::CloudTrail::EventDataStore.MultiRegionEnabled`.
         * <p>
         * @return {@code this}
         * @param multiRegionEnabled `AWS::CloudTrail::EventDataStore.MultiRegionEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegionEnabled(final java.lang.Boolean multiRegionEnabled) {
            this.props().multiRegionEnabled(multiRegionEnabled);
            return this;
        }
        /**
         * `AWS::CloudTrail::EventDataStore.MultiRegionEnabled`.
         * <p>
         * @return {@code this}
         * @param multiRegionEnabled `AWS::CloudTrail::EventDataStore.MultiRegionEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiRegionEnabled(final software.amazon.awscdk.IResolvable multiRegionEnabled) {
            this.props().multiRegionEnabled(multiRegionEnabled);
            return this;
        }

        /**
         * `AWS::CloudTrail::EventDataStore.Name`.
         * <p>
         * @return {@code this}
         * @param name `AWS::CloudTrail::EventDataStore.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * `AWS::CloudTrail::EventDataStore.OrganizationEnabled`.
         * <p>
         * @return {@code this}
         * @param organizationEnabled `AWS::CloudTrail::EventDataStore.OrganizationEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationEnabled(final java.lang.Boolean organizationEnabled) {
            this.props().organizationEnabled(organizationEnabled);
            return this;
        }
        /**
         * `AWS::CloudTrail::EventDataStore.OrganizationEnabled`.
         * <p>
         * @return {@code this}
         * @param organizationEnabled `AWS::CloudTrail::EventDataStore.OrganizationEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationEnabled(final software.amazon.awscdk.IResolvable organizationEnabled) {
            this.props().organizationEnabled(organizationEnabled);
            return this;
        }

        /**
         * `AWS::CloudTrail::EventDataStore.RetentionPeriod`.
         * <p>
         * @return {@code this}
         * @param retentionPeriod `AWS::CloudTrail::EventDataStore.RetentionPeriod`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(final java.lang.Number retentionPeriod) {
            this.props().retentionPeriod(retentionPeriod);
            return this;
        }

        /**
         * `AWS::CloudTrail::EventDataStore.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::CloudTrail::EventDataStore.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * `AWS::CloudTrail::EventDataStore.TerminationProtectionEnabled`.
         * <p>
         * @return {@code this}
         * @param terminationProtectionEnabled `AWS::CloudTrail::EventDataStore.TerminationProtectionEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtectionEnabled(final java.lang.Boolean terminationProtectionEnabled) {
            this.props().terminationProtectionEnabled(terminationProtectionEnabled);
            return this;
        }
        /**
         * `AWS::CloudTrail::EventDataStore.TerminationProtectionEnabled`.
         * <p>
         * @return {@code this}
         * @param terminationProtectionEnabled `AWS::CloudTrail::EventDataStore.TerminationProtectionEnabled`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtectionEnabled(final software.amazon.awscdk.IResolvable terminationProtectionEnabled) {
            this.props().terminationProtectionEnabled(terminationProtectionEnabled);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudtrail.CfnEventDataStore}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudtrail.CfnEventDataStore build() {
            return new software.amazon.awscdk.services.cloudtrail.CfnEventDataStore(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cloudtrail.CfnEventDataStoreProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cloudtrail.CfnEventDataStoreProps.Builder();
            }
            return this.props;
        }
    }
}
