package software.amazon.awscdk.services.cloudfront;

/**
 * Determines whether CloudFront includes the X-XSS-Protection HTTP response header and the header’s value.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Using an existing managed response headers policy
 * S3Origin bucketOrigin;
 * Distribution.Builder.create(this, "myDistManagedPolicy")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(bucketOrigin)
 *                 .responseHeadersPolicy(ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS)
 *                 .build())
 *         .build();
 * // Creating a custom response headers policy -- all parameters optional
 * ResponseHeadersPolicy myResponseHeadersPolicy = ResponseHeadersPolicy.Builder.create(this, "ResponseHeadersPolicy")
 *         .responseHeadersPolicyName("MyPolicy")
 *         .comment("A default policy")
 *         .corsBehavior(ResponseHeadersCorsBehavior.builder()
 *                 .accessControlAllowCredentials(false)
 *                 .accessControlAllowHeaders(List.of("X-Custom-Header-1", "X-Custom-Header-2"))
 *                 .accessControlAllowMethods(List.of("GET", "POST"))
 *                 .accessControlAllowOrigins(List.of("*"))
 *                 .accessControlExposeHeaders(List.of("X-Custom-Header-1", "X-Custom-Header-2"))
 *                 .accessControlMaxAge(Duration.seconds(600))
 *                 .originOverride(true)
 *                 .build())
 *         .customHeadersBehavior(ResponseCustomHeadersBehavior.builder()
 *                 .customHeaders(List.of(ResponseCustomHeader.builder().header("X-Amz-Date").value("some-value").override(true).build(), ResponseCustomHeader.builder().header("X-Amz-Security-Token").value("some-value").override(false).build()))
 *                 .build())
 *         .securityHeadersBehavior(ResponseSecurityHeadersBehavior.builder()
 *                 .contentSecurityPolicy(ResponseHeadersContentSecurityPolicy.builder().contentSecurityPolicy("default-src https:;").override(true).build())
 *                 .contentTypeOptions(ResponseHeadersContentTypeOptions.builder().override(true).build())
 *                 .frameOptions(ResponseHeadersFrameOptions.builder().frameOption(HeadersFrameOption.DENY).override(true).build())
 *                 .referrerPolicy(ResponseHeadersReferrerPolicy.builder().referrerPolicy(HeadersReferrerPolicy.NO_REFERRER).override(true).build())
 *                 .strictTransportSecurity(ResponseHeadersStrictTransportSecurity.builder().accessControlMaxAge(Duration.seconds(600)).includeSubdomains(true).override(true).build())
 *                 .xssProtection(ResponseHeadersXSSProtection.builder().protection(true).modeBlock(true).reportUri("https://example.com/csp-report").override(true).build())
 *                 .build())
 *         .build();
 * Distribution.Builder.create(this, "myDistCustomPolicy")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(bucketOrigin)
 *                 .responseHeadersPolicy(myResponseHeadersPolicy)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:49.501Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.ResponseHeadersXSSProtection")
@software.amazon.jsii.Jsii.Proxy(ResponseHeadersXSSProtection.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResponseHeadersXSSProtection extends software.amazon.jsii.JsiiSerializable {

    /**
     * A Boolean that determines whether CloudFront overrides the X-XSS-Protection HTTP response header received from the origin with the one specified in this response headers policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getOverride();

    /**
     * A Boolean that determines the value of the X-XSS-Protection HTTP response header.
     * <p>
     * When this setting is true, the value of the X-XSS-Protection header is 1.
     * When this setting is false, the value of the X-XSS-Protection header is 0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getProtection();

    /**
     * A Boolean that determines whether CloudFront includes the mode=block directive in the X-XSS-Protection header.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getModeBlock() {
        return null;
    }

    /**
     * A reporting URI, which CloudFront uses as the value of the report directive in the X-XSS-Protection header.
     * <p>
     * You cannot specify a ReportUri when ModeBlock is true.
     * <p>
     * Default: - no report uri
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReportUri() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ResponseHeadersXSSProtection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResponseHeadersXSSProtection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ResponseHeadersXSSProtection> {
        java.lang.Boolean override;
        java.lang.Boolean protection;
        java.lang.Boolean modeBlock;
        java.lang.String reportUri;

        /**
         * Sets the value of {@link ResponseHeadersXSSProtection#getOverride}
         * @param override A Boolean that determines whether CloudFront overrides the X-XSS-Protection HTTP response header received from the origin with the one specified in this response headers policy. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder override(java.lang.Boolean override) {
            this.override = override;
            return this;
        }

        /**
         * Sets the value of {@link ResponseHeadersXSSProtection#getProtection}
         * @param protection A Boolean that determines the value of the X-XSS-Protection HTTP response header. This parameter is required.
         *                   When this setting is true, the value of the X-XSS-Protection header is 1.
         *                   When this setting is false, the value of the X-XSS-Protection header is 0.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protection(java.lang.Boolean protection) {
            this.protection = protection;
            return this;
        }

        /**
         * Sets the value of {@link ResponseHeadersXSSProtection#getModeBlock}
         * @param modeBlock A Boolean that determines whether CloudFront includes the mode=block directive in the X-XSS-Protection header.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modeBlock(java.lang.Boolean modeBlock) {
            this.modeBlock = modeBlock;
            return this;
        }

        /**
         * Sets the value of {@link ResponseHeadersXSSProtection#getReportUri}
         * @param reportUri A reporting URI, which CloudFront uses as the value of the report directive in the X-XSS-Protection header.
         *                  You cannot specify a ReportUri when ModeBlock is true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportUri(java.lang.String reportUri) {
            this.reportUri = reportUri;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResponseHeadersXSSProtection}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ResponseHeadersXSSProtection build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ResponseHeadersXSSProtection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResponseHeadersXSSProtection {
        private final java.lang.Boolean override;
        private final java.lang.Boolean protection;
        private final java.lang.Boolean modeBlock;
        private final java.lang.String reportUri;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.override = software.amazon.jsii.Kernel.get(this, "override", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.protection = software.amazon.jsii.Kernel.get(this, "protection", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.modeBlock = software.amazon.jsii.Kernel.get(this, "modeBlock", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.reportUri = software.amazon.jsii.Kernel.get(this, "reportUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.override = java.util.Objects.requireNonNull(builder.override, "override is required");
            this.protection = java.util.Objects.requireNonNull(builder.protection, "protection is required");
            this.modeBlock = builder.modeBlock;
            this.reportUri = builder.reportUri;
        }

        @Override
        public final java.lang.Boolean getOverride() {
            return this.override;
        }

        @Override
        public final java.lang.Boolean getProtection() {
            return this.protection;
        }

        @Override
        public final java.lang.Boolean getModeBlock() {
            return this.modeBlock;
        }

        @Override
        public final java.lang.String getReportUri() {
            return this.reportUri;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("override", om.valueToTree(this.getOverride()));
            data.set("protection", om.valueToTree(this.getProtection()));
            if (this.getModeBlock() != null) {
                data.set("modeBlock", om.valueToTree(this.getModeBlock()));
            }
            if (this.getReportUri() != null) {
                data.set("reportUri", om.valueToTree(this.getReportUri()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.ResponseHeadersXSSProtection"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResponseHeadersXSSProtection.Jsii$Proxy that = (ResponseHeadersXSSProtection.Jsii$Proxy) o;

            if (!override.equals(that.override)) return false;
            if (!protection.equals(that.protection)) return false;
            if (this.modeBlock != null ? !this.modeBlock.equals(that.modeBlock) : that.modeBlock != null) return false;
            return this.reportUri != null ? this.reportUri.equals(that.reportUri) : that.reportUri == null;
        }

        @Override
        public final int hashCode() {
            int result = this.override.hashCode();
            result = 31 * result + (this.protection.hashCode());
            result = 31 * result + (this.modeBlock != null ? this.modeBlock.hashCode() : 0);
            result = 31 * result + (this.reportUri != null ? this.reportUri.hashCode() : 0);
            return result;
        }
    }
}
