package software.amazon.awscdk.services.ce;

/**
 * Properties for defining a `CfnAnomalySubscription`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ce.*;
 * CfnAnomalySubscriptionProps cfnAnomalySubscriptionProps = CfnAnomalySubscriptionProps.builder()
 *         .frequency("frequency")
 *         .monitorArnList(List.of("monitorArnList"))
 *         .subscribers(List.of(SubscriberProperty.builder()
 *                 .address("address")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .status("status")
 *                 .build()))
 *         .subscriptionName("subscriptionName")
 *         .threshold(123)
 *         // the properties below are optional
 *         .resourceTags(List.of(ResourceTagProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:49.316Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ce.CfnAnomalySubscriptionProps")
@software.amazon.jsii.Jsii.Proxy(CfnAnomalySubscriptionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAnomalySubscriptionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The frequency that anomaly reports are sent over email.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFrequency();

    /**
     * A list of cost anomaly monitors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getMonitorArnList();

    /**
     * A list of subscribers to notify.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSubscribers();

    /**
     * The name for the subscription.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSubscriptionName();

    /**
     * The dollar value that triggers a notification if the threshold is exceeded.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getThreshold();

    /**
     * `AWS::CE::AnomalySubscription.ResourceTags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getResourceTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAnomalySubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAnomalySubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAnomalySubscriptionProps> {
        java.lang.String frequency;
        java.util.List<java.lang.String> monitorArnList;
        java.lang.Object subscribers;
        java.lang.String subscriptionName;
        java.lang.Number threshold;
        java.lang.Object resourceTags;

        /**
         * Sets the value of {@link CfnAnomalySubscriptionProps#getFrequency}
         * @param frequency The frequency that anomaly reports are sent over email. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder frequency(java.lang.String frequency) {
            this.frequency = frequency;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalySubscriptionProps#getMonitorArnList}
         * @param monitorArnList A list of cost anomaly monitors. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitorArnList(java.util.List<java.lang.String> monitorArnList) {
            this.monitorArnList = monitorArnList;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalySubscriptionProps#getSubscribers}
         * @param subscribers A list of subscribers to notify. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscribers(software.amazon.awscdk.IResolvable subscribers) {
            this.subscribers = subscribers;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalySubscriptionProps#getSubscribers}
         * @param subscribers A list of subscribers to notify. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscribers(java.util.List<? extends java.lang.Object> subscribers) {
            this.subscribers = subscribers;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalySubscriptionProps#getSubscriptionName}
         * @param subscriptionName The name for the subscription. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriptionName(java.lang.String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalySubscriptionProps#getThreshold}
         * @param threshold The dollar value that triggers a notification if the threshold is exceeded. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder threshold(java.lang.Number threshold) {
            this.threshold = threshold;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalySubscriptionProps#getResourceTags}
         * @param resourceTags `AWS::CE::AnomalySubscription.ResourceTags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceTags(software.amazon.awscdk.IResolvable resourceTags) {
            this.resourceTags = resourceTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnomalySubscriptionProps#getResourceTags}
         * @param resourceTags `AWS::CE::AnomalySubscription.ResourceTags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceTags(java.util.List<? extends java.lang.Object> resourceTags) {
            this.resourceTags = resourceTags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAnomalySubscriptionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAnomalySubscriptionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAnomalySubscriptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAnomalySubscriptionProps {
        private final java.lang.String frequency;
        private final java.util.List<java.lang.String> monitorArnList;
        private final java.lang.Object subscribers;
        private final java.lang.String subscriptionName;
        private final java.lang.Number threshold;
        private final java.lang.Object resourceTags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.frequency = software.amazon.jsii.Kernel.get(this, "frequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.monitorArnList = software.amazon.jsii.Kernel.get(this, "monitorArnList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.subscribers = software.amazon.jsii.Kernel.get(this, "subscribers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.subscriptionName = software.amazon.jsii.Kernel.get(this, "subscriptionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.threshold = software.amazon.jsii.Kernel.get(this, "threshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.resourceTags = software.amazon.jsii.Kernel.get(this, "resourceTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.frequency = java.util.Objects.requireNonNull(builder.frequency, "frequency is required");
            this.monitorArnList = java.util.Objects.requireNonNull(builder.monitorArnList, "monitorArnList is required");
            this.subscribers = java.util.Objects.requireNonNull(builder.subscribers, "subscribers is required");
            this.subscriptionName = java.util.Objects.requireNonNull(builder.subscriptionName, "subscriptionName is required");
            this.threshold = java.util.Objects.requireNonNull(builder.threshold, "threshold is required");
            this.resourceTags = builder.resourceTags;
        }

        @Override
        public final java.lang.String getFrequency() {
            return this.frequency;
        }

        @Override
        public final java.util.List<java.lang.String> getMonitorArnList() {
            return this.monitorArnList;
        }

        @Override
        public final java.lang.Object getSubscribers() {
            return this.subscribers;
        }

        @Override
        public final java.lang.String getSubscriptionName() {
            return this.subscriptionName;
        }

        @Override
        public final java.lang.Number getThreshold() {
            return this.threshold;
        }

        @Override
        public final java.lang.Object getResourceTags() {
            return this.resourceTags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("frequency", om.valueToTree(this.getFrequency()));
            data.set("monitorArnList", om.valueToTree(this.getMonitorArnList()));
            data.set("subscribers", om.valueToTree(this.getSubscribers()));
            data.set("subscriptionName", om.valueToTree(this.getSubscriptionName()));
            data.set("threshold", om.valueToTree(this.getThreshold()));
            if (this.getResourceTags() != null) {
                data.set("resourceTags", om.valueToTree(this.getResourceTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ce.CfnAnomalySubscriptionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAnomalySubscriptionProps.Jsii$Proxy that = (CfnAnomalySubscriptionProps.Jsii$Proxy) o;

            if (!frequency.equals(that.frequency)) return false;
            if (!monitorArnList.equals(that.monitorArnList)) return false;
            if (!subscribers.equals(that.subscribers)) return false;
            if (!subscriptionName.equals(that.subscriptionName)) return false;
            if (!threshold.equals(that.threshold)) return false;
            return this.resourceTags != null ? this.resourceTags.equals(that.resourceTags) : that.resourceTags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.frequency.hashCode();
            result = 31 * result + (this.monitorArnList.hashCode());
            result = 31 * result + (this.subscribers.hashCode());
            result = 31 * result + (this.subscriptionName.hashCode());
            result = 31 * result + (this.threshold.hashCode());
            result = 31 * result + (this.resourceTags != null ? this.resourceTags.hashCode() : 0);
            return result;
        }
    }
}
