package software.amazon.awscdk.services.cassandra;

/**
 * A CloudFormation `AWS::Cassandra::Table`.
 * <p>
 * The <code>AWS::Cassandra::Table</code> resource allows you to create a new table in Amazon Keyspaces (for Apache Cassandra). For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/getting-started.ddl.html">Create a keyspace and a table</a> in the <em>Amazon Keyspaces Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cassandra.*;
 * CfnTable cfnTable = CfnTable.Builder.create(this, "MyCfnTable")
 *         .keyspaceName("keyspaceName")
 *         .partitionKeyColumns(List.of(ColumnProperty.builder()
 *                 .columnName("columnName")
 *                 .columnType("columnType")
 *                 .build()))
 *         // the properties below are optional
 *         .billingMode(BillingModeProperty.builder()
 *                 .mode("mode")
 *                 // the properties below are optional
 *                 .provisionedThroughput(ProvisionedThroughputProperty.builder()
 *                         .readCapacityUnits(123)
 *                         .writeCapacityUnits(123)
 *                         .build())
 *                 .build())
 *         .clusteringKeyColumns(List.of(ClusteringKeyColumnProperty.builder()
 *                 .column(ColumnProperty.builder()
 *                         .columnName("columnName")
 *                         .columnType("columnType")
 *                         .build())
 *                 // the properties below are optional
 *                 .orderBy("orderBy")
 *                 .build()))
 *         .defaultTimeToLive(123)
 *         .encryptionSpecification(EncryptionSpecificationProperty.builder()
 *                 .encryptionType("encryptionType")
 *                 // the properties below are optional
 *                 .kmsKeyIdentifier("kmsKeyIdentifier")
 *                 .build())
 *         .pointInTimeRecoveryEnabled(false)
 *         .regularColumns(List.of(ColumnProperty.builder()
 *                 .columnName("columnName")
 *                 .columnType("columnType")
 *                 .build()))
 *         .tableName("tableName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:49.306Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnTable")
public class CfnTable extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnTable(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTable(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cassandra.CfnTable.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Cassandra::Table`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTable(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cassandra.CfnTableProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of key-value pair tags to be attached to the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the keyspace in which to create the table.
     * <p>
     * The keyspace must already exist.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKeyspaceName() {
        return software.amazon.jsii.Kernel.get(this, "keyspaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the keyspace in which to create the table.
     * <p>
     * The keyspace must already exist.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeyspaceName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "keyspaceName", java.util.Objects.requireNonNull(value, "keyspaceName is required"));
    }

    /**
     * One or more columns that uniquely identify every row in the table.
     * <p>
     * Every table must have a partition key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getPartitionKeyColumns() {
        return software.amazon.jsii.Kernel.get(this, "partitionKeyColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * One or more columns that uniquely identify every row in the table.
     * <p>
     * Every table must have a partition key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPartitionKeyColumns(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "partitionKeyColumns", java.util.Objects.requireNonNull(value, "partitionKeyColumns is required"));
    }

    /**
     * One or more columns that uniquely identify every row in the table.
     * <p>
     * Every table must have a partition key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPartitionKeyColumns(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.cassandra.CfnTable.ColumnProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.cassandra.CfnTable.ColumnProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "partitionKeyColumns", java.util.Objects.requireNonNull(value, "partitionKeyColumns is required"));
    }

    /**
     * The billing mode for the table, which determines how you'll be charged for reads and writes:.
     * <p>
     * <ul>
     * <li><em>On-demand mode</em> (default) - You pay based on the actual reads and writes your application performs.</li>
     * <li><em>Provisioned mode</em> - Lets you specify the number of reads and writes per second that you need for your application.</li>
     * </ul>
     * <p>
     * If you don't specify a value for this property, then the table will use on-demand mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBillingMode() {
        return software.amazon.jsii.Kernel.get(this, "billingMode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The billing mode for the table, which determines how you'll be charged for reads and writes:.
     * <p>
     * <ul>
     * <li><em>On-demand mode</em> (default) - You pay based on the actual reads and writes your application performs.</li>
     * <li><em>Provisioned mode</em> - Lets you specify the number of reads and writes per second that you need for your application.</li>
     * </ul>
     * <p>
     * If you don't specify a value for this property, then the table will use on-demand mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBillingMode(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cassandra.CfnTable.BillingModeProperty value) {
        software.amazon.jsii.Kernel.set(this, "billingMode", value);
    }

    /**
     * The billing mode for the table, which determines how you'll be charged for reads and writes:.
     * <p>
     * <ul>
     * <li><em>On-demand mode</em> (default) - You pay based on the actual reads and writes your application performs.</li>
     * <li><em>Provisioned mode</em> - Lets you specify the number of reads and writes per second that you need for your application.</li>
     * </ul>
     * <p>
     * If you don't specify a value for this property, then the table will use on-demand mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBillingMode(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "billingMode", value);
    }

    /**
     * One or more columns that determine how the table data is sorted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getClusteringKeyColumns() {
        return software.amazon.jsii.Kernel.get(this, "clusteringKeyColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * One or more columns that determine how the table data is sorted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusteringKeyColumns(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "clusteringKeyColumns", value);
    }

    /**
     * One or more columns that determine how the table data is sorted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusteringKeyColumns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.cassandra.CfnTable.ClusteringKeyColumnProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.cassandra.CfnTable.ClusteringKeyColumnProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "clusteringKeyColumns", value);
    }

    /**
     * The default Time To Live (TTL) value for all rows in a table in seconds.
     * <p>
     * The maximum configurable value is 630,720,000 seconds, which is the equivalent of 20 years. By default, the TTL value for a table is 0, which means data does not expire.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <em>Amazon Keyspaces Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getDefaultTimeToLive() {
        return software.amazon.jsii.Kernel.get(this, "defaultTimeToLive", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The default Time To Live (TTL) value for all rows in a table in seconds.
     * <p>
     * The maximum configurable value is 630,720,000 seconds, which is the equivalent of 20 years. By default, the TTL value for a table is 0, which means data does not expire.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <em>Amazon Keyspaces Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultTimeToLive(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "defaultTimeToLive", value);
    }

    /**
     * The encryption at rest options for the table.
     * <p>
     * <ul>
     * <li><em>AWS owned key</em> (default) - The key is owned by Amazon Keyspaces.</li>
     * <li><em>Customer managed key</em> - The key is stored in your account and is created, owned, and managed by you.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you choose encryption with a customer managed key, you must specify a valid customer managed KMS key with permissions granted to Amazon Keyspaces.
     * <p>
     * </blockquote>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest in Amazon Keyspaces</a> in the <em>Amazon Keyspaces Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionSpecification() {
        return software.amazon.jsii.Kernel.get(this, "encryptionSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The encryption at rest options for the table.
     * <p>
     * <ul>
     * <li><em>AWS owned key</em> (default) - The key is owned by Amazon Keyspaces.</li>
     * <li><em>Customer managed key</em> - The key is stored in your account and is created, owned, and managed by you.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you choose encryption with a customer managed key, you must specify a valid customer managed KMS key with permissions granted to Amazon Keyspaces.
     * <p>
     * </blockquote>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest in Amazon Keyspaces</a> in the <em>Amazon Keyspaces Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cassandra.CfnTable.EncryptionSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "encryptionSpecification", value);
    }

    /**
     * The encryption at rest options for the table.
     * <p>
     * <ul>
     * <li><em>AWS owned key</em> (default) - The key is owned by Amazon Keyspaces.</li>
     * <li><em>Customer managed key</em> - The key is stored in your account and is created, owned, and managed by you.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you choose encryption with a customer managed key, you must specify a valid customer managed KMS key with permissions granted to Amazon Keyspaces.
     * <p>
     * </blockquote>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest in Amazon Keyspaces</a> in the <em>Amazon Keyspaces Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionSpecification(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "encryptionSpecification", value);
    }

    /**
     * Specifies if point-in-time recovery is enabled or disabled for the table.
     * <p>
     * The options are <code>PointInTimeRecoveryEnabled=true</code> and <code>PointInTimeRecoveryEnabled=false</code> . If not specified, the default is <code>PointInTimeRecoveryEnabled=false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPointInTimeRecoveryEnabled() {
        return software.amazon.jsii.Kernel.get(this, "pointInTimeRecoveryEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies if point-in-time recovery is enabled or disabled for the table.
     * <p>
     * The options are <code>PointInTimeRecoveryEnabled=true</code> and <code>PointInTimeRecoveryEnabled=false</code> . If not specified, the default is <code>PointInTimeRecoveryEnabled=false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPointInTimeRecoveryEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "pointInTimeRecoveryEnabled", value);
    }

    /**
     * Specifies if point-in-time recovery is enabled or disabled for the table.
     * <p>
     * The options are <code>PointInTimeRecoveryEnabled=true</code> and <code>PointInTimeRecoveryEnabled=false</code> . If not specified, the default is <code>PointInTimeRecoveryEnabled=false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPointInTimeRecoveryEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "pointInTimeRecoveryEnabled", value);
    }

    /**
     * One or more columns that are not part of the primary key - that is, columns that are *not* defined as partition key columns or clustering key columns.
     * <p>
     * You can add regular columns to existing tables by adding them to the template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRegularColumns() {
        return software.amazon.jsii.Kernel.get(this, "regularColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * One or more columns that are not part of the primary key - that is, columns that are *not* defined as partition key columns or clustering key columns.
     * <p>
     * You can add regular columns to existing tables by adding them to the template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRegularColumns(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "regularColumns", value);
    }

    /**
     * One or more columns that are not part of the primary key - that is, columns that are *not* defined as partition key columns or clustering key columns.
     * <p>
     * You can add regular columns to existing tables by adding them to the template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRegularColumns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.cassandra.CfnTable.ColumnProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.cassandra.CfnTable.ColumnProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "regularColumns", value);
    }

    /**
     * The name of the table to be created.
     * <p>
     * The table name is case sensitive. If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the table name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     * <p>
     * <em>Length constraints:</em> Minimum length of 3. Maximum length of 255.
     * <p>
     * <em>Pattern:</em> <code>^[a-zA-Z0-9][a-zA-Z0-9_]{1,47}$</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
        return software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the table to be created.
     * <p>
     * The table name is case sensitive. If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the table name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     * <p>
     * <em>Length constraints:</em> Minimum length of 3. Maximum length of 255.
     * <p>
     * <em>Pattern:</em> <code>^[a-zA-Z0-9][a-zA-Z0-9_]{1,47}$</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTableName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tableName", value);
    }
    /**
     * Determines the billing mode for the table - On-demand or provisioned.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cassandra.*;
     * BillingModeProperty billingModeProperty = BillingModeProperty.builder()
     *         .mode("mode")
     *         // the properties below are optional
     *         .provisionedThroughput(ProvisionedThroughputProperty.builder()
     *                 .readCapacityUnits(123)
     *                 .writeCapacityUnits(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnTable.BillingModeProperty")
    @software.amazon.jsii.Jsii.Proxy(BillingModeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BillingModeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The billing mode for the table:.
         * <p>
         * <ul>
         * <li>On-demand mode - <code>ON_DEMAND</code></li>
         * <li>Provisioned mode - <code>PROVISIONED</code></li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you choose <code>PROVISIONED</code> mode, then you also need to specify provisioned throughput (read and write capacity) for the table.
         * <p>
         * </blockquote>
         * <p>
         * Valid values: <code>ON_DEMAND</code> | <code>PROVISIONED</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMode();

        /**
         * The provisioned read capacity and write capacity for the table.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html#ReadWriteCapacityMode.Provisioned">Provisioned throughput capacity mode</a> in the <em>Amazon Keyspaces Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProvisionedThroughput() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BillingModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BillingModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BillingModeProperty> {
            java.lang.String mode;
            java.lang.Object provisionedThroughput;

            /**
             * Sets the value of {@link BillingModeProperty#getMode}
             * @param mode The billing mode for the table:. This parameter is required.
             *             <ul>
             *             <li>On-demand mode - <code>ON_DEMAND</code></li>
             *             <li>Provisioned mode - <code>PROVISIONED</code></li>
             *             </ul>
             *             <p>
             *             <blockquote>
             *             <p>
             *             If you choose <code>PROVISIONED</code> mode, then you also need to specify provisioned throughput (read and write capacity) for the table.
             *             <p>
             *             </blockquote>
             *             <p>
             *             Valid values: <code>ON_DEMAND</code> | <code>PROVISIONED</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Sets the value of {@link BillingModeProperty#getProvisionedThroughput}
             * @param provisionedThroughput The provisioned read capacity and write capacity for the table.
             *                              For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html#ReadWriteCapacityMode.Provisioned">Provisioned throughput capacity mode</a> in the <em>Amazon Keyspaces Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisionedThroughput(software.amazon.awscdk.services.cassandra.CfnTable.ProvisionedThroughputProperty provisionedThroughput) {
                this.provisionedThroughput = provisionedThroughput;
                return this;
            }

            /**
             * Sets the value of {@link BillingModeProperty#getProvisionedThroughput}
             * @param provisionedThroughput The provisioned read capacity and write capacity for the table.
             *                              For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html#ReadWriteCapacityMode.Provisioned">Provisioned throughput capacity mode</a> in the <em>Amazon Keyspaces Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisionedThroughput(software.amazon.awscdk.IResolvable provisionedThroughput) {
                this.provisionedThroughput = provisionedThroughput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BillingModeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BillingModeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BillingModeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BillingModeProperty {
            private final java.lang.String mode;
            private final java.lang.Object provisionedThroughput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.provisionedThroughput = software.amazon.jsii.Kernel.get(this, "provisionedThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mode = java.util.Objects.requireNonNull(builder.mode, "mode is required");
                this.provisionedThroughput = builder.provisionedThroughput;
            }

            @Override
            public final java.lang.String getMode() {
                return this.mode;
            }

            @Override
            public final java.lang.Object getProvisionedThroughput() {
                return this.provisionedThroughput;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mode", om.valueToTree(this.getMode()));
                if (this.getProvisionedThroughput() != null) {
                    data.set("provisionedThroughput", om.valueToTree(this.getProvisionedThroughput()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cassandra.CfnTable.BillingModeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BillingModeProperty.Jsii$Proxy that = (BillingModeProperty.Jsii$Proxy) o;

                if (!mode.equals(that.mode)) return false;
                return this.provisionedThroughput != null ? this.provisionedThroughput.equals(that.provisionedThroughput) : that.provisionedThroughput == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mode.hashCode();
                result = 31 * result + (this.provisionedThroughput != null ? this.provisionedThroughput.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines an individual column within the clustering key.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cassandra.*;
     * ClusteringKeyColumnProperty clusteringKeyColumnProperty = ClusteringKeyColumnProperty.builder()
     *         .column(ColumnProperty.builder()
     *                 .columnName("columnName")
     *                 .columnType("columnType")
     *                 .build())
     *         // the properties below are optional
     *         .orderBy("orderBy")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnTable.ClusteringKeyColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusteringKeyColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusteringKeyColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name and data type of this clustering key column.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getColumn();

        /**
         * The order in which this column's data is stored:.
         * <p>
         * <ul>
         * <li><code>ASC</code> (default) - The column's data is stored in ascending order.</li>
         * <li><code>DESC</code> - The column's data is stored in descending order.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOrderBy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusteringKeyColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusteringKeyColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusteringKeyColumnProperty> {
            java.lang.Object column;
            java.lang.String orderBy;

            /**
             * Sets the value of {@link ClusteringKeyColumnProperty#getColumn}
             * @param column The name and data type of this clustering key column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder column(software.amazon.awscdk.services.cassandra.CfnTable.ColumnProperty column) {
                this.column = column;
                return this;
            }

            /**
             * Sets the value of {@link ClusteringKeyColumnProperty#getColumn}
             * @param column The name and data type of this clustering key column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder column(software.amazon.awscdk.IResolvable column) {
                this.column = column;
                return this;
            }

            /**
             * Sets the value of {@link ClusteringKeyColumnProperty#getOrderBy}
             * @param orderBy The order in which this column's data is stored:.
             *                <ul>
             *                <li><code>ASC</code> (default) - The column's data is stored in ascending order.</li>
             *                <li><code>DESC</code> - The column's data is stored in descending order.</li>
             *                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orderBy(java.lang.String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusteringKeyColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusteringKeyColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusteringKeyColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusteringKeyColumnProperty {
            private final java.lang.Object column;
            private final java.lang.String orderBy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.column = software.amazon.jsii.Kernel.get(this, "column", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.orderBy = software.amazon.jsii.Kernel.get(this, "orderBy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.column = java.util.Objects.requireNonNull(builder.column, "column is required");
                this.orderBy = builder.orderBy;
            }

            @Override
            public final java.lang.Object getColumn() {
                return this.column;
            }

            @Override
            public final java.lang.String getOrderBy() {
                return this.orderBy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("column", om.valueToTree(this.getColumn()));
                if (this.getOrderBy() != null) {
                    data.set("orderBy", om.valueToTree(this.getOrderBy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cassandra.CfnTable.ClusteringKeyColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusteringKeyColumnProperty.Jsii$Proxy that = (ClusteringKeyColumnProperty.Jsii$Proxy) o;

                if (!column.equals(that.column)) return false;
                return this.orderBy != null ? this.orderBy.equals(that.orderBy) : that.orderBy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.column.hashCode();
                result = 31 * result + (this.orderBy != null ? this.orderBy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The name and data type of an individual column in a table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cassandra.*;
     * ColumnProperty columnProperty = ColumnProperty.builder()
     *         .columnName("columnName")
     *         .columnType("columnType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnTable.ColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the column.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.elements.identifier">Identifiers</a> in the <em>Amazon Keyspaces Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnName();

        /**
         * The data type of the column.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <em>Amazon Keyspaces Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumnType();

        /**
         * @return a {@link Builder} of {@link ColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnProperty> {
            java.lang.String columnName;
            java.lang.String columnType;

            /**
             * Sets the value of {@link ColumnProperty#getColumnName}
             * @param columnName The name of the column. This parameter is required.
             *                   For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.elements.identifier">Identifiers</a> in the <em>Amazon Keyspaces Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnName(java.lang.String columnName) {
                this.columnName = columnName;
                return this;
            }

            /**
             * Sets the value of {@link ColumnProperty#getColumnType}
             * @param columnType The data type of the column. This parameter is required.
             *                   For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types">Data types</a> in the <em>Amazon Keyspaces Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnType(java.lang.String columnType) {
                this.columnType = columnType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnProperty {
            private final java.lang.String columnName;
            private final java.lang.String columnType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columnName = software.amazon.jsii.Kernel.get(this, "columnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.columnType = software.amazon.jsii.Kernel.get(this, "columnType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columnName = java.util.Objects.requireNonNull(builder.columnName, "columnName is required");
                this.columnType = java.util.Objects.requireNonNull(builder.columnType, "columnType is required");
            }

            @Override
            public final java.lang.String getColumnName() {
                return this.columnName;
            }

            @Override
            public final java.lang.String getColumnType() {
                return this.columnType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("columnName", om.valueToTree(this.getColumnName()));
                data.set("columnType", om.valueToTree(this.getColumnType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cassandra.CfnTable.ColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnProperty.Jsii$Proxy that = (ColumnProperty.Jsii$Proxy) o;

                if (!columnName.equals(that.columnName)) return false;
                return this.columnType.equals(that.columnType);
            }

            @Override
            public final int hashCode() {
                int result = this.columnName.hashCode();
                result = 31 * result + (this.columnType.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the encryption at rest option selected for the table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cassandra.*;
     * EncryptionSpecificationProperty encryptionSpecificationProperty = EncryptionSpecificationProperty.builder()
     *         .encryptionType("encryptionType")
     *         // the properties below are optional
     *         .kmsKeyIdentifier("kmsKeyIdentifier")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnTable.EncryptionSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The encryption at rest options for the table.
         * <p>
         * <ul>
         * <li><em>AWS owned key</em> (default) - <code>AWS_OWNED_KMS_KEY</code></li>
         * <li><em>Customer managed key</em> - <code>CUSTOMER_MANAGED_KMS_KEY</code></li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you choose <code>CUSTOMER_MANAGED_KMS_KEY</code> , a <code>kms_key_identifier</code> in the format of a key ARN is required.
         * <p>
         * </blockquote>
         * <p>
         * Valid values: <code>CUSTOMER_MANAGED_KMS_KEY</code> | <code>AWS_OWNED_KMS_KEY</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEncryptionType();

        /**
         * Requires a `kms_key_identifier` in the format of a key ARN.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyIdentifier() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionSpecificationProperty> {
            java.lang.String encryptionType;
            java.lang.String kmsKeyIdentifier;

            /**
             * Sets the value of {@link EncryptionSpecificationProperty#getEncryptionType}
             * @param encryptionType The encryption at rest options for the table. This parameter is required.
             *                       <ul>
             *                       <li><em>AWS owned key</em> (default) - <code>AWS_OWNED_KMS_KEY</code></li>
             *                       <li><em>Customer managed key</em> - <code>CUSTOMER_MANAGED_KMS_KEY</code></li>
             *                       </ul>
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       If you choose <code>CUSTOMER_MANAGED_KMS_KEY</code> , a <code>kms_key_identifier</code> in the format of a key ARN is required.
             *                       <p>
             *                       </blockquote>
             *                       <p>
             *                       Valid values: <code>CUSTOMER_MANAGED_KMS_KEY</code> | <code>AWS_OWNED_KMS_KEY</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionType(java.lang.String encryptionType) {
                this.encryptionType = encryptionType;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionSpecificationProperty#getKmsKeyIdentifier}
             * @param kmsKeyIdentifier Requires a `kms_key_identifier` in the format of a key ARN.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyIdentifier(java.lang.String kmsKeyIdentifier) {
                this.kmsKeyIdentifier = kmsKeyIdentifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionSpecificationProperty {
            private final java.lang.String encryptionType;
            private final java.lang.String kmsKeyIdentifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionType = software.amazon.jsii.Kernel.get(this, "encryptionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyIdentifier = software.amazon.jsii.Kernel.get(this, "kmsKeyIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionType = java.util.Objects.requireNonNull(builder.encryptionType, "encryptionType is required");
                this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
            }

            @Override
            public final java.lang.String getEncryptionType() {
                return this.encryptionType;
            }

            @Override
            public final java.lang.String getKmsKeyIdentifier() {
                return this.kmsKeyIdentifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("encryptionType", om.valueToTree(this.getEncryptionType()));
                if (this.getKmsKeyIdentifier() != null) {
                    data.set("kmsKeyIdentifier", om.valueToTree(this.getKmsKeyIdentifier()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cassandra.CfnTable.EncryptionSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionSpecificationProperty.Jsii$Proxy that = (EncryptionSpecificationProperty.Jsii$Proxy) o;

                if (!encryptionType.equals(that.encryptionType)) return false;
                return this.kmsKeyIdentifier != null ? this.kmsKeyIdentifier.equals(that.kmsKeyIdentifier) : that.kmsKeyIdentifier == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionType.hashCode();
                result = 31 * result + (this.kmsKeyIdentifier != null ? this.kmsKeyIdentifier.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The provisioned throughput for the table, which consists of `ReadCapacityUnits` and `WriteCapacityUnits` .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cassandra.*;
     * ProvisionedThroughputProperty provisionedThroughputProperty = ProvisionedThroughputProperty.builder()
     *         .readCapacityUnits(123)
     *         .writeCapacityUnits(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnTable.ProvisionedThroughputProperty")
    @software.amazon.jsii.Jsii.Proxy(ProvisionedThroughputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProvisionedThroughputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The amount of read capacity that's provisioned for the table.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity mode</a> in the <em>Amazon Keyspaces Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getReadCapacityUnits();

        /**
         * The amount of write capacity that's provisioned for the table.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity mode</a> in the <em>Amazon Keyspaces Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getWriteCapacityUnits();

        /**
         * @return a {@link Builder} of {@link ProvisionedThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProvisionedThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProvisionedThroughputProperty> {
            java.lang.Number readCapacityUnits;
            java.lang.Number writeCapacityUnits;

            /**
             * Sets the value of {@link ProvisionedThroughputProperty#getReadCapacityUnits}
             * @param readCapacityUnits The amount of read capacity that's provisioned for the table. This parameter is required.
             *                          For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity mode</a> in the <em>Amazon Keyspaces Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readCapacityUnits(java.lang.Number readCapacityUnits) {
                this.readCapacityUnits = readCapacityUnits;
                return this;
            }

            /**
             * Sets the value of {@link ProvisionedThroughputProperty#getWriteCapacityUnits}
             * @param writeCapacityUnits The amount of write capacity that's provisioned for the table. This parameter is required.
             *                           For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html">Read/write capacity mode</a> in the <em>Amazon Keyspaces Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeCapacityUnits(java.lang.Number writeCapacityUnits) {
                this.writeCapacityUnits = writeCapacityUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProvisionedThroughputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProvisionedThroughputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProvisionedThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProvisionedThroughputProperty {
            private final java.lang.Number readCapacityUnits;
            private final java.lang.Number writeCapacityUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.readCapacityUnits = software.amazon.jsii.Kernel.get(this, "readCapacityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.writeCapacityUnits = software.amazon.jsii.Kernel.get(this, "writeCapacityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.readCapacityUnits = java.util.Objects.requireNonNull(builder.readCapacityUnits, "readCapacityUnits is required");
                this.writeCapacityUnits = java.util.Objects.requireNonNull(builder.writeCapacityUnits, "writeCapacityUnits is required");
            }

            @Override
            public final java.lang.Number getReadCapacityUnits() {
                return this.readCapacityUnits;
            }

            @Override
            public final java.lang.Number getWriteCapacityUnits() {
                return this.writeCapacityUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("readCapacityUnits", om.valueToTree(this.getReadCapacityUnits()));
                data.set("writeCapacityUnits", om.valueToTree(this.getWriteCapacityUnits()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cassandra.CfnTable.ProvisionedThroughputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProvisionedThroughputProperty.Jsii$Proxy that = (ProvisionedThroughputProperty.Jsii$Proxy) o;

                if (!readCapacityUnits.equals(that.readCapacityUnits)) return false;
                return this.writeCapacityUnits.equals(that.writeCapacityUnits);
            }

            @Override
            public final int hashCode() {
                int result = this.readCapacityUnits.hashCode();
                result = 31 * result + (this.writeCapacityUnits.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cassandra.CfnTable}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cassandra.CfnTable> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cassandra.CfnTableProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cassandra.CfnTableProps.Builder();
        }

        /**
         * The name of the keyspace in which to create the table.
         * <p>
         * The keyspace must already exist.
         * <p>
         * @return {@code this}
         * @param keyspaceName The name of the keyspace in which to create the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyspaceName(final java.lang.String keyspaceName) {
            this.props.keyspaceName(keyspaceName);
            return this;
        }

        /**
         * One or more columns that uniquely identify every row in the table.
         * <p>
         * Every table must have a partition key.
         * <p>
         * @return {@code this}
         * @param partitionKeyColumns One or more columns that uniquely identify every row in the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionKeyColumns(final software.amazon.awscdk.IResolvable partitionKeyColumns) {
            this.props.partitionKeyColumns(partitionKeyColumns);
            return this;
        }
        /**
         * One or more columns that uniquely identify every row in the table.
         * <p>
         * Every table must have a partition key.
         * <p>
         * @return {@code this}
         * @param partitionKeyColumns One or more columns that uniquely identify every row in the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionKeyColumns(final java.util.List<? extends java.lang.Object> partitionKeyColumns) {
            this.props.partitionKeyColumns(partitionKeyColumns);
            return this;
        }

        /**
         * The billing mode for the table, which determines how you'll be charged for reads and writes:.
         * <p>
         * <ul>
         * <li><em>On-demand mode</em> (default) - You pay based on the actual reads and writes your application performs.</li>
         * <li><em>Provisioned mode</em> - Lets you specify the number of reads and writes per second that you need for your application.</li>
         * </ul>
         * <p>
         * If you don't specify a value for this property, then the table will use on-demand mode.
         * <p>
         * @return {@code this}
         * @param billingMode The billing mode for the table, which determines how you'll be charged for reads and writes:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingMode(final software.amazon.awscdk.services.cassandra.CfnTable.BillingModeProperty billingMode) {
            this.props.billingMode(billingMode);
            return this;
        }
        /**
         * The billing mode for the table, which determines how you'll be charged for reads and writes:.
         * <p>
         * <ul>
         * <li><em>On-demand mode</em> (default) - You pay based on the actual reads and writes your application performs.</li>
         * <li><em>Provisioned mode</em> - Lets you specify the number of reads and writes per second that you need for your application.</li>
         * </ul>
         * <p>
         * If you don't specify a value for this property, then the table will use on-demand mode.
         * <p>
         * @return {@code this}
         * @param billingMode The billing mode for the table, which determines how you'll be charged for reads and writes:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingMode(final software.amazon.awscdk.IResolvable billingMode) {
            this.props.billingMode(billingMode);
            return this;
        }

        /**
         * One or more columns that determine how the table data is sorted.
         * <p>
         * @return {@code this}
         * @param clusteringKeyColumns One or more columns that determine how the table data is sorted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusteringKeyColumns(final software.amazon.awscdk.IResolvable clusteringKeyColumns) {
            this.props.clusteringKeyColumns(clusteringKeyColumns);
            return this;
        }
        /**
         * One or more columns that determine how the table data is sorted.
         * <p>
         * @return {@code this}
         * @param clusteringKeyColumns One or more columns that determine how the table data is sorted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusteringKeyColumns(final java.util.List<? extends java.lang.Object> clusteringKeyColumns) {
            this.props.clusteringKeyColumns(clusteringKeyColumns);
            return this;
        }

        /**
         * The default Time To Live (TTL) value for all rows in a table in seconds.
         * <p>
         * The maximum configurable value is 630,720,000 seconds, which is the equivalent of 20 years. By default, the TTL value for a table is 0, which means data does not expire.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <em>Amazon Keyspaces Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param defaultTimeToLive The default Time To Live (TTL) value for all rows in a table in seconds. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultTimeToLive(final java.lang.Number defaultTimeToLive) {
            this.props.defaultTimeToLive(defaultTimeToLive);
            return this;
        }

        /**
         * The encryption at rest options for the table.
         * <p>
         * <ul>
         * <li><em>AWS owned key</em> (default) - The key is owned by Amazon Keyspaces.</li>
         * <li><em>Customer managed key</em> - The key is stored in your account and is created, owned, and managed by you.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you choose encryption with a customer managed key, you must specify a valid customer managed KMS key with permissions granted to Amazon Keyspaces.
         * <p>
         * </blockquote>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest in Amazon Keyspaces</a> in the <em>Amazon Keyspaces Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param encryptionSpecification The encryption at rest options for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionSpecification(final software.amazon.awscdk.services.cassandra.CfnTable.EncryptionSpecificationProperty encryptionSpecification) {
            this.props.encryptionSpecification(encryptionSpecification);
            return this;
        }
        /**
         * The encryption at rest options for the table.
         * <p>
         * <ul>
         * <li><em>AWS owned key</em> (default) - The key is owned by Amazon Keyspaces.</li>
         * <li><em>Customer managed key</em> - The key is stored in your account and is created, owned, and managed by you.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you choose encryption with a customer managed key, you must specify a valid customer managed KMS key with permissions granted to Amazon Keyspaces.
         * <p>
         * </blockquote>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest in Amazon Keyspaces</a> in the <em>Amazon Keyspaces Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @param encryptionSpecification The encryption at rest options for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionSpecification(final software.amazon.awscdk.IResolvable encryptionSpecification) {
            this.props.encryptionSpecification(encryptionSpecification);
            return this;
        }

        /**
         * Specifies if point-in-time recovery is enabled or disabled for the table.
         * <p>
         * The options are <code>PointInTimeRecoveryEnabled=true</code> and <code>PointInTimeRecoveryEnabled=false</code> . If not specified, the default is <code>PointInTimeRecoveryEnabled=false</code> .
         * <p>
         * @return {@code this}
         * @param pointInTimeRecoveryEnabled Specifies if point-in-time recovery is enabled or disabled for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecoveryEnabled(final java.lang.Boolean pointInTimeRecoveryEnabled) {
            this.props.pointInTimeRecoveryEnabled(pointInTimeRecoveryEnabled);
            return this;
        }
        /**
         * Specifies if point-in-time recovery is enabled or disabled for the table.
         * <p>
         * The options are <code>PointInTimeRecoveryEnabled=true</code> and <code>PointInTimeRecoveryEnabled=false</code> . If not specified, the default is <code>PointInTimeRecoveryEnabled=false</code> .
         * <p>
         * @return {@code this}
         * @param pointInTimeRecoveryEnabled Specifies if point-in-time recovery is enabled or disabled for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecoveryEnabled(final software.amazon.awscdk.IResolvable pointInTimeRecoveryEnabled) {
            this.props.pointInTimeRecoveryEnabled(pointInTimeRecoveryEnabled);
            return this;
        }

        /**
         * One or more columns that are not part of the primary key - that is, columns that are *not* defined as partition key columns or clustering key columns.
         * <p>
         * You can add regular columns to existing tables by adding them to the template.
         * <p>
         * @return {@code this}
         * @param regularColumns One or more columns that are not part of the primary key - that is, columns that are *not* defined as partition key columns or clustering key columns. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regularColumns(final software.amazon.awscdk.IResolvable regularColumns) {
            this.props.regularColumns(regularColumns);
            return this;
        }
        /**
         * One or more columns that are not part of the primary key - that is, columns that are *not* defined as partition key columns or clustering key columns.
         * <p>
         * You can add regular columns to existing tables by adding them to the template.
         * <p>
         * @return {@code this}
         * @param regularColumns One or more columns that are not part of the primary key - that is, columns that are *not* defined as partition key columns or clustering key columns. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regularColumns(final java.util.List<? extends java.lang.Object> regularColumns) {
            this.props.regularColumns(regularColumns);
            return this;
        }

        /**
         * The name of the table to be created.
         * <p>
         * The table name is case sensitive. If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the table name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> .
         * <p>
         * <blockquote>
         * <p>
         * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         * <p>
         * </blockquote>
         * <p>
         * <em>Length constraints:</em> Minimum length of 3. Maximum length of 255.
         * <p>
         * <em>Pattern:</em> <code>^[a-zA-Z0-9][a-zA-Z0-9_]{1,47}$</code>
         * <p>
         * @return {@code this}
         * @param tableName The name of the table to be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(final java.lang.String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        /**
         * A list of key-value pair tags to be attached to the resource.
         * <p>
         * @return {@code this}
         * @param tags A list of key-value pair tags to be attached to the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cassandra.CfnTable}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cassandra.CfnTable build() {
            return new software.amazon.awscdk.services.cassandra.CfnTable(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
