package software.amazon.awscdk.services.autoscaling;

/**
 * Properties for a scaling policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.autoscaling.*;
 * AutoScalingGroup autoScalingGroup;
 * StepScalingActionProps stepScalingActionProps = StepScalingActionProps.builder()
 *         .autoScalingGroup(autoScalingGroup)
 *         // the properties below are optional
 *         .adjustmentType(AdjustmentType.CHANGE_IN_CAPACITY)
 *         .cooldown(Duration.minutes(30))
 *         .estimatedInstanceWarmup(Duration.minutes(30))
 *         .metricAggregationType(MetricAggregationType.AVERAGE)
 *         .minAdjustmentMagnitude(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:49.173Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.StepScalingActionProps")
@software.amazon.jsii.Jsii.Proxy(StepScalingActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StepScalingActionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The auto scaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.IAutoScalingGroup getAutoScalingGroup();

    /**
     * How the adjustment numbers are interpreted.
     * <p>
     * Default: ChangeInCapacity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.AdjustmentType getAdjustmentType() {
        return null;
    }

    /**
     * Period after a scaling completes before another scaling activity can start.
     * <p>
     * Default: The default cooldown configured on the AutoScalingGroup
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getCooldown() {
        return null;
    }

    /**
     * Estimated time until a newly launched instance can send metrics to CloudWatch.
     * <p>
     * Default: Same as the cooldown
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getEstimatedInstanceWarmup() {
        return null;
    }

    /**
     * The aggregation type for the CloudWatch metrics.
     * <p>
     * Default: Average
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.MetricAggregationType getMetricAggregationType() {
        return null;
    }

    /**
     * Minimum absolute number to adjust capacity with as result of percentage scaling.
     * <p>
     * Only when using AdjustmentType = PercentChangeInCapacity, this number controls
     * the minimum absolute effect size.
     * <p>
     * Default: No minimum scaling effect
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinAdjustmentMagnitude() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StepScalingActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StepScalingActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StepScalingActionProps> {
        software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup;
        software.amazon.awscdk.services.autoscaling.AdjustmentType adjustmentType;
        software.amazon.awscdk.Duration cooldown;
        software.amazon.awscdk.Duration estimatedInstanceWarmup;
        software.amazon.awscdk.services.autoscaling.MetricAggregationType metricAggregationType;
        java.lang.Number minAdjustmentMagnitude;

        /**
         * Sets the value of {@link StepScalingActionProps#getAutoScalingGroup}
         * @param autoScalingGroup The auto scaling group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroup(software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup) {
            this.autoScalingGroup = autoScalingGroup;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingActionProps#getAdjustmentType}
         * @param adjustmentType How the adjustment numbers are interpreted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adjustmentType(software.amazon.awscdk.services.autoscaling.AdjustmentType adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingActionProps#getCooldown}
         * @param cooldown Period after a scaling completes before another scaling activity can start.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cooldown(software.amazon.awscdk.Duration cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingActionProps#getEstimatedInstanceWarmup}
         * @param estimatedInstanceWarmup Estimated time until a newly launched instance can send metrics to CloudWatch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder estimatedInstanceWarmup(software.amazon.awscdk.Duration estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingActionProps#getMetricAggregationType}
         * @param metricAggregationType The aggregation type for the CloudWatch metrics.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricAggregationType(software.amazon.awscdk.services.autoscaling.MetricAggregationType metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingActionProps#getMinAdjustmentMagnitude}
         * @param minAdjustmentMagnitude Minimum absolute number to adjust capacity with as result of percentage scaling.
         *                               Only when using AdjustmentType = PercentChangeInCapacity, this number controls
         *                               the minimum absolute effect size.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minAdjustmentMagnitude(java.lang.Number minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StepScalingActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StepScalingActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StepScalingActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StepScalingActionProps {
        private final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup;
        private final software.amazon.awscdk.services.autoscaling.AdjustmentType adjustmentType;
        private final software.amazon.awscdk.Duration cooldown;
        private final software.amazon.awscdk.Duration estimatedInstanceWarmup;
        private final software.amazon.awscdk.services.autoscaling.MetricAggregationType metricAggregationType;
        private final java.lang.Number minAdjustmentMagnitude;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoScalingGroup = software.amazon.jsii.Kernel.get(this, "autoScalingGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.IAutoScalingGroup.class));
            this.adjustmentType = software.amazon.jsii.Kernel.get(this, "adjustmentType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.AdjustmentType.class));
            this.cooldown = software.amazon.jsii.Kernel.get(this, "cooldown", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.estimatedInstanceWarmup = software.amazon.jsii.Kernel.get(this, "estimatedInstanceWarmup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.metricAggregationType = software.amazon.jsii.Kernel.get(this, "metricAggregationType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.MetricAggregationType.class));
            this.minAdjustmentMagnitude = software.amazon.jsii.Kernel.get(this, "minAdjustmentMagnitude", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoScalingGroup = java.util.Objects.requireNonNull(builder.autoScalingGroup, "autoScalingGroup is required");
            this.adjustmentType = builder.adjustmentType;
            this.cooldown = builder.cooldown;
            this.estimatedInstanceWarmup = builder.estimatedInstanceWarmup;
            this.metricAggregationType = builder.metricAggregationType;
            this.minAdjustmentMagnitude = builder.minAdjustmentMagnitude;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup getAutoScalingGroup() {
            return this.autoScalingGroup;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.AdjustmentType getAdjustmentType() {
            return this.adjustmentType;
        }

        @Override
        public final software.amazon.awscdk.Duration getCooldown() {
            return this.cooldown;
        }

        @Override
        public final software.amazon.awscdk.Duration getEstimatedInstanceWarmup() {
            return this.estimatedInstanceWarmup;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.MetricAggregationType getMetricAggregationType() {
            return this.metricAggregationType;
        }

        @Override
        public final java.lang.Number getMinAdjustmentMagnitude() {
            return this.minAdjustmentMagnitude;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("autoScalingGroup", om.valueToTree(this.getAutoScalingGroup()));
            if (this.getAdjustmentType() != null) {
                data.set("adjustmentType", om.valueToTree(this.getAdjustmentType()));
            }
            if (this.getCooldown() != null) {
                data.set("cooldown", om.valueToTree(this.getCooldown()));
            }
            if (this.getEstimatedInstanceWarmup() != null) {
                data.set("estimatedInstanceWarmup", om.valueToTree(this.getEstimatedInstanceWarmup()));
            }
            if (this.getMetricAggregationType() != null) {
                data.set("metricAggregationType", om.valueToTree(this.getMetricAggregationType()));
            }
            if (this.getMinAdjustmentMagnitude() != null) {
                data.set("minAdjustmentMagnitude", om.valueToTree(this.getMinAdjustmentMagnitude()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.StepScalingActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StepScalingActionProps.Jsii$Proxy that = (StepScalingActionProps.Jsii$Proxy) o;

            if (!autoScalingGroup.equals(that.autoScalingGroup)) return false;
            if (this.adjustmentType != null ? !this.adjustmentType.equals(that.adjustmentType) : that.adjustmentType != null) return false;
            if (this.cooldown != null ? !this.cooldown.equals(that.cooldown) : that.cooldown != null) return false;
            if (this.estimatedInstanceWarmup != null ? !this.estimatedInstanceWarmup.equals(that.estimatedInstanceWarmup) : that.estimatedInstanceWarmup != null) return false;
            if (this.metricAggregationType != null ? !this.metricAggregationType.equals(that.metricAggregationType) : that.metricAggregationType != null) return false;
            return this.minAdjustmentMagnitude != null ? this.minAdjustmentMagnitude.equals(that.minAdjustmentMagnitude) : that.minAdjustmentMagnitude == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoScalingGroup.hashCode();
            result = 31 * result + (this.adjustmentType != null ? this.adjustmentType.hashCode() : 0);
            result = 31 * result + (this.cooldown != null ? this.cooldown.hashCode() : 0);
            result = 31 * result + (this.estimatedInstanceWarmup != null ? this.estimatedInstanceWarmup.hashCode() : 0);
            result = 31 * result + (this.metricAggregationType != null ? this.metricAggregationType.hashCode() : 0);
            result = 31 * result + (this.minAdjustmentMagnitude != null ? this.minAdjustmentMagnitude.hashCode() : 0);
            return result;
        }
    }
}
