package software.amazon.awscdk.services.appsync;

/**
 * Properties for defining a `CfnGraphQLApi`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * CfnGraphQLApiProps cfnGraphQLApiProps = CfnGraphQLApiProps.builder()
 *         .authenticationType("authenticationType")
 *         .name("name")
 *         // the properties below are optional
 *         .additionalAuthenticationProviders(List.of(AdditionalAuthenticationProviderProperty.builder()
 *                 .authenticationType("authenticationType")
 *                 // the properties below are optional
 *                 .lambdaAuthorizerConfig(LambdaAuthorizerConfigProperty.builder()
 *                         .authorizerResultTtlInSeconds(123)
 *                         .authorizerUri("authorizerUri")
 *                         .identityValidationExpression("identityValidationExpression")
 *                         .build())
 *                 .openIdConnectConfig(OpenIDConnectConfigProperty.builder()
 *                         .authTtl(123)
 *                         .clientId("clientId")
 *                         .iatTtl(123)
 *                         .issuer("issuer")
 *                         .build())
 *                 .userPoolConfig(CognitoUserPoolConfigProperty.builder()
 *                         .appIdClientRegex("appIdClientRegex")
 *                         .awsRegion("awsRegion")
 *                         .userPoolId("userPoolId")
 *                         .build())
 *                 .build()))
 *         .lambdaAuthorizerConfig(LambdaAuthorizerConfigProperty.builder()
 *                 .authorizerResultTtlInSeconds(123)
 *                 .authorizerUri("authorizerUri")
 *                 .identityValidationExpression("identityValidationExpression")
 *                 .build())
 *         .logConfig(LogConfigProperty.builder()
 *                 .cloudWatchLogsRoleArn("cloudWatchLogsRoleArn")
 *                 .excludeVerboseContent(false)
 *                 .fieldLogLevel("fieldLogLevel")
 *                 .build())
 *         .openIdConnectConfig(OpenIDConnectConfigProperty.builder()
 *                 .authTtl(123)
 *                 .clientId("clientId")
 *                 .iatTtl(123)
 *                 .issuer("issuer")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .userPoolConfig(UserPoolConfigProperty.builder()
 *                 .appIdClientRegex("appIdClientRegex")
 *                 .awsRegion("awsRegion")
 *                 .defaultAction("defaultAction")
 *                 .userPoolId("userPoolId")
 *                 .build())
 *         .xrayEnabled(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:49.034Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnGraphQLApiProps")
@software.amazon.jsii.Jsii.Proxy(CfnGraphQLApiProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGraphQLApiProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Security configuration for your GraphQL API.
     * <p>
     * For allowed values (such as <code>API_KEY</code> , <code>AWS_IAM</code> , <code>AMAZON_COGNITO_USER_POOLS</code> , <code>OPENID_CONNECT</code> , or <code>AWS_LAMBDA</code> ), see <a href="https://docs.aws.amazon.com/appsync/latest/devguide/security.html">Security</a> in the <em>AWS AppSync Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthenticationType();

    /**
     * The API name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * A list of additional authentication providers for the `GraphqlApi` API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalAuthenticationProviders() {
        return null;
    }

    /**
     * A `LambdaAuthorizerConfig` holds configuration on how to authorize AWS AppSync API access when using the `AWS_LAMBDA` authorizer mode.
     * <p>
     * Be aware that an AWS AppSync API may have only one Lambda authorizer configured at a time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaAuthorizerConfig() {
        return null;
    }

    /**
     * The Amazon CloudWatch Logs configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLogConfig() {
        return null;
    }

    /**
     * The OpenID Connect configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOpenIdConnectConfig() {
        return null;
    }

    /**
     * An arbitrary set of tags (key-value pairs) for this GraphQL API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUserPoolConfig() {
        return null;
    }

    /**
     * A flag indicating whether to use AWS X-Ray tracing for this `GraphqlApi` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getXrayEnabled() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnGraphQLApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGraphQLApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGraphQLApiProps> {
        java.lang.String authenticationType;
        java.lang.String name;
        java.lang.Object additionalAuthenticationProviders;
        java.lang.Object lambdaAuthorizerConfig;
        java.lang.Object logConfig;
        java.lang.Object openIdConnectConfig;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object userPoolConfig;
        java.lang.Object xrayEnabled;

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getAuthenticationType}
         * @param authenticationType Security configuration for your GraphQL API. This parameter is required.
         *                           For allowed values (such as <code>API_KEY</code> , <code>AWS_IAM</code> , <code>AMAZON_COGNITO_USER_POOLS</code> , <code>OPENID_CONNECT</code> , or <code>AWS_LAMBDA</code> ), see <a href="https://docs.aws.amazon.com/appsync/latest/devguide/security.html">Security</a> in the <em>AWS AppSync Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationType(java.lang.String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getName}
         * @param name The API name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getAdditionalAuthenticationProviders}
         * @param additionalAuthenticationProviders A list of additional authentication providers for the `GraphqlApi` API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalAuthenticationProviders(software.amazon.awscdk.IResolvable additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders = additionalAuthenticationProviders;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getAdditionalAuthenticationProviders}
         * @param additionalAuthenticationProviders A list of additional authentication providers for the `GraphqlApi` API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalAuthenticationProviders(java.util.List<? extends java.lang.Object> additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders = additionalAuthenticationProviders;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getLambdaAuthorizerConfig}
         * @param lambdaAuthorizerConfig A `LambdaAuthorizerConfig` holds configuration on how to authorize AWS AppSync API access when using the `AWS_LAMBDA` authorizer mode.
         *                               Be aware that an AWS AppSync API may have only one Lambda authorizer configured at a time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaAuthorizerConfig(software.amazon.awscdk.services.appsync.CfnGraphQLApi.LambdaAuthorizerConfigProperty lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getLambdaAuthorizerConfig}
         * @param lambdaAuthorizerConfig A `LambdaAuthorizerConfig` holds configuration on how to authorize AWS AppSync API access when using the `AWS_LAMBDA` authorizer mode.
         *                               Be aware that an AWS AppSync API may have only one Lambda authorizer configured at a time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaAuthorizerConfig(software.amazon.awscdk.IResolvable lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getLogConfig}
         * @param logConfig The Amazon CloudWatch Logs configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfig(software.amazon.awscdk.services.appsync.CfnGraphQLApi.LogConfigProperty logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getLogConfig}
         * @param logConfig The Amazon CloudWatch Logs configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfig(software.amazon.awscdk.IResolvable logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getOpenIdConnectConfig}
         * @param openIdConnectConfig The OpenID Connect configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openIdConnectConfig(software.amazon.awscdk.services.appsync.CfnGraphQLApi.OpenIDConnectConfigProperty openIdConnectConfig) {
            this.openIdConnectConfig = openIdConnectConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getOpenIdConnectConfig}
         * @param openIdConnectConfig The OpenID Connect configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openIdConnectConfig(software.amazon.awscdk.IResolvable openIdConnectConfig) {
            this.openIdConnectConfig = openIdConnectConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getTags}
         * @param tags An arbitrary set of tags (key-value pairs) for this GraphQL API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getUserPoolConfig}
         * @param userPoolConfig Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolConfig(software.amazon.awscdk.services.appsync.CfnGraphQLApi.UserPoolConfigProperty userPoolConfig) {
            this.userPoolConfig = userPoolConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getUserPoolConfig}
         * @param userPoolConfig Optional authorization configuration for using Amazon Cognito user pools with your GraphQL endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolConfig(software.amazon.awscdk.IResolvable userPoolConfig) {
            this.userPoolConfig = userPoolConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getXrayEnabled}
         * @param xrayEnabled A flag indicating whether to use AWS X-Ray tracing for this `GraphqlApi` .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder xrayEnabled(java.lang.Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnGraphQLApiProps#getXrayEnabled}
         * @param xrayEnabled A flag indicating whether to use AWS X-Ray tracing for this `GraphqlApi` .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder xrayEnabled(software.amazon.awscdk.IResolvable xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGraphQLApiProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGraphQLApiProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGraphQLApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGraphQLApiProps {
        private final java.lang.String authenticationType;
        private final java.lang.String name;
        private final java.lang.Object additionalAuthenticationProviders;
        private final java.lang.Object lambdaAuthorizerConfig;
        private final java.lang.Object logConfig;
        private final java.lang.Object openIdConnectConfig;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object userPoolConfig;
        private final java.lang.Object xrayEnabled;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authenticationType = software.amazon.jsii.Kernel.get(this, "authenticationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.additionalAuthenticationProviders = software.amazon.jsii.Kernel.get(this, "additionalAuthenticationProviders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.lambdaAuthorizerConfig = software.amazon.jsii.Kernel.get(this, "lambdaAuthorizerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.logConfig = software.amazon.jsii.Kernel.get(this, "logConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.openIdConnectConfig = software.amazon.jsii.Kernel.get(this, "openIdConnectConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.userPoolConfig = software.amazon.jsii.Kernel.get(this, "userPoolConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.xrayEnabled = software.amazon.jsii.Kernel.get(this, "xrayEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authenticationType = java.util.Objects.requireNonNull(builder.authenticationType, "authenticationType is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.additionalAuthenticationProviders = builder.additionalAuthenticationProviders;
            this.lambdaAuthorizerConfig = builder.lambdaAuthorizerConfig;
            this.logConfig = builder.logConfig;
            this.openIdConnectConfig = builder.openIdConnectConfig;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.userPoolConfig = builder.userPoolConfig;
            this.xrayEnabled = builder.xrayEnabled;
        }

        @Override
        public final java.lang.String getAuthenticationType() {
            return this.authenticationType;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getAdditionalAuthenticationProviders() {
            return this.additionalAuthenticationProviders;
        }

        @Override
        public final java.lang.Object getLambdaAuthorizerConfig() {
            return this.lambdaAuthorizerConfig;
        }

        @Override
        public final java.lang.Object getLogConfig() {
            return this.logConfig;
        }

        @Override
        public final java.lang.Object getOpenIdConnectConfig() {
            return this.openIdConnectConfig;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getUserPoolConfig() {
            return this.userPoolConfig;
        }

        @Override
        public final java.lang.Object getXrayEnabled() {
            return this.xrayEnabled;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authenticationType", om.valueToTree(this.getAuthenticationType()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getAdditionalAuthenticationProviders() != null) {
                data.set("additionalAuthenticationProviders", om.valueToTree(this.getAdditionalAuthenticationProviders()));
            }
            if (this.getLambdaAuthorizerConfig() != null) {
                data.set("lambdaAuthorizerConfig", om.valueToTree(this.getLambdaAuthorizerConfig()));
            }
            if (this.getLogConfig() != null) {
                data.set("logConfig", om.valueToTree(this.getLogConfig()));
            }
            if (this.getOpenIdConnectConfig() != null) {
                data.set("openIdConnectConfig", om.valueToTree(this.getOpenIdConnectConfig()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUserPoolConfig() != null) {
                data.set("userPoolConfig", om.valueToTree(this.getUserPoolConfig()));
            }
            if (this.getXrayEnabled() != null) {
                data.set("xrayEnabled", om.valueToTree(this.getXrayEnabled()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnGraphQLApiProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGraphQLApiProps.Jsii$Proxy that = (CfnGraphQLApiProps.Jsii$Proxy) o;

            if (!authenticationType.equals(that.authenticationType)) return false;
            if (!name.equals(that.name)) return false;
            if (this.additionalAuthenticationProviders != null ? !this.additionalAuthenticationProviders.equals(that.additionalAuthenticationProviders) : that.additionalAuthenticationProviders != null) return false;
            if (this.lambdaAuthorizerConfig != null ? !this.lambdaAuthorizerConfig.equals(that.lambdaAuthorizerConfig) : that.lambdaAuthorizerConfig != null) return false;
            if (this.logConfig != null ? !this.logConfig.equals(that.logConfig) : that.logConfig != null) return false;
            if (this.openIdConnectConfig != null ? !this.openIdConnectConfig.equals(that.openIdConnectConfig) : that.openIdConnectConfig != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.userPoolConfig != null ? !this.userPoolConfig.equals(that.userPoolConfig) : that.userPoolConfig != null) return false;
            return this.xrayEnabled != null ? this.xrayEnabled.equals(that.xrayEnabled) : that.xrayEnabled == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authenticationType.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.additionalAuthenticationProviders != null ? this.additionalAuthenticationProviders.hashCode() : 0);
            result = 31 * result + (this.lambdaAuthorizerConfig != null ? this.lambdaAuthorizerConfig.hashCode() : 0);
            result = 31 * result + (this.logConfig != null ? this.logConfig.hashCode() : 0);
            result = 31 * result + (this.openIdConnectConfig != null ? this.openIdConnectConfig.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.userPoolConfig != null ? this.userPoolConfig.hashCode() : 0);
            result = 31 * result + (this.xrayEnabled != null ? this.xrayEnabled.hashCode() : 0);
            return result;
        }
    }
}
