package software.amazon.awscdk.pipelines;

/**
 * Configuration options for CodeStar source.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodePipeline pipeline = CodePipeline.Builder.create(this, "Pipeline")
 *         .synth(ShellStep.Builder.create("Synth")
 *                 .input(CodePipelineSource.connection("my-org/my-app", "main", ConnectionSourceOptions.builder()
 *                         .connectionArn("arn:aws:codestar-connections:us-east-1:222222222222:connection/7d2469ff-514a-4e4f-9003-5ca4a43cdc41")
 *                         .build()))
 *                 .commands(List.of("npm ci", "npm run build", "npx cdk synth"))
 *                 .build())
 *         // Turn this on because the pipeline uses Docker image assets
 *         .dockerEnabledForSelfMutation(true)
 *         .build();
 * pipeline.addWave("MyWave", WaveOptions.builder()
 *         .post(List.of(
 *             CodeBuildStep.Builder.create("RunApproval")
 *                     .commands(List.of("command-from-image"))
 *                     .buildEnvironment(BuildEnvironment.builder()
 *                             // The user of a Docker image asset in the pipeline requires turning on
 *                             // 'dockerEnabledForSelfMutation'.
 *                             .buildImage(LinuxBuildImage.fromAsset(this, "Image", DockerImageAssetProps.builder()
 *                                     .directory("./docker-image")
 *                                     .build()))
 *                             .build())
 *                     .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-28T18:17:55.186Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.ConnectionSourceOptions")
@software.amazon.jsii.Jsii.Proxy(ConnectionSourceOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ConnectionSourceOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the CodeStar Connection created in the AWS console that has permissions to access this GitHub or BitBucket repository.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "arn:aws:codestar-connections:us-east-1:123456789012:connection/12345678-abcd-12ab-34cdef5678gh";
     * </pre></blockquote>
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/connections-create.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/connections-create.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectionArn();

    /**
     * If this is set, the next CodeBuild job clones the repository (instead of CodePipeline downloading the files).
     * <p>
     * This provides access to repository history, and retains symlinks (symlinks would otherwise be
     * removed by CodePipeline).
     * <p>
     * <strong>Note</strong>: if this option is true, only CodeBuild jobs can use the output artifact.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html#action-reference-CodestarConnectionSource-config">https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html#action-reference-CodestarConnectionSource-config</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCodeBuildCloneOutput() {
        return null;
    }

    /**
     * Controls automatically starting your pipeline when a new commit is made on the configured repository and branch.
     * <p>
     * If unspecified,
     * the default value is true, and the field does not display by default.
     * <p>
     * Default: true
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodestarConnectionSource.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getTriggerOnPush() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ConnectionSourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ConnectionSourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ConnectionSourceOptions> {
        java.lang.String connectionArn;
        java.lang.Boolean codeBuildCloneOutput;
        java.lang.Boolean triggerOnPush;

        /**
         * Sets the value of {@link ConnectionSourceOptions#getConnectionArn}
         * @param connectionArn The ARN of the CodeStar Connection created in the AWS console that has permissions to access this GitHub or BitBucket repository. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionArn(java.lang.String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        /**
         * Sets the value of {@link ConnectionSourceOptions#getCodeBuildCloneOutput}
         * @param codeBuildCloneOutput If this is set, the next CodeBuild job clones the repository (instead of CodePipeline downloading the files).
         *                             This provides access to repository history, and retains symlinks (symlinks would otherwise be
         *                             removed by CodePipeline).
         *                             <p>
         *                             <strong>Note</strong>: if this option is true, only CodeBuild jobs can use the output artifact.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeBuildCloneOutput(java.lang.Boolean codeBuildCloneOutput) {
            this.codeBuildCloneOutput = codeBuildCloneOutput;
            return this;
        }

        /**
         * Sets the value of {@link ConnectionSourceOptions#getTriggerOnPush}
         * @param triggerOnPush Controls automatically starting your pipeline when a new commit is made on the configured repository and branch.
         *                      If unspecified,
         *                      the default value is true, and the field does not display by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggerOnPush(java.lang.Boolean triggerOnPush) {
            this.triggerOnPush = triggerOnPush;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConnectionSourceOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ConnectionSourceOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ConnectionSourceOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionSourceOptions {
        private final java.lang.String connectionArn;
        private final java.lang.Boolean codeBuildCloneOutput;
        private final java.lang.Boolean triggerOnPush;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.connectionArn = software.amazon.jsii.Kernel.get(this, "connectionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.codeBuildCloneOutput = software.amazon.jsii.Kernel.get(this, "codeBuildCloneOutput", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.triggerOnPush = software.amazon.jsii.Kernel.get(this, "triggerOnPush", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.connectionArn = java.util.Objects.requireNonNull(builder.connectionArn, "connectionArn is required");
            this.codeBuildCloneOutput = builder.codeBuildCloneOutput;
            this.triggerOnPush = builder.triggerOnPush;
        }

        @Override
        public final java.lang.String getConnectionArn() {
            return this.connectionArn;
        }

        @Override
        public final java.lang.Boolean getCodeBuildCloneOutput() {
            return this.codeBuildCloneOutput;
        }

        @Override
        public final java.lang.Boolean getTriggerOnPush() {
            return this.triggerOnPush;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("connectionArn", om.valueToTree(this.getConnectionArn()));
            if (this.getCodeBuildCloneOutput() != null) {
                data.set("codeBuildCloneOutput", om.valueToTree(this.getCodeBuildCloneOutput()));
            }
            if (this.getTriggerOnPush() != null) {
                data.set("triggerOnPush", om.valueToTree(this.getTriggerOnPush()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.ConnectionSourceOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ConnectionSourceOptions.Jsii$Proxy that = (ConnectionSourceOptions.Jsii$Proxy) o;

            if (!connectionArn.equals(that.connectionArn)) return false;
            if (this.codeBuildCloneOutput != null ? !this.codeBuildCloneOutput.equals(that.codeBuildCloneOutput) : that.codeBuildCloneOutput != null) return false;
            return this.triggerOnPush != null ? this.triggerOnPush.equals(that.triggerOnPush) : that.triggerOnPush == null;
        }

        @Override
        public final int hashCode() {
            int result = this.connectionArn.hashCode();
            result = 31 * result + (this.codeBuildCloneOutput != null ? this.codeBuildCloneOutput.hashCode() : 0);
            result = 31 * result + (this.triggerOnPush != null ? this.triggerOnPush.hashCode() : 0);
            return result;
        }
    }
}
