package software.amazon.awscdk.services.timestream;

/**
 * A CloudFormation `AWS::Timestream::Table`.
 * <p>
 * The CreateTable operation adds a new table to an existing database in your account. In an AWS account, table names must be at least unique within each Region if they are in the same database. You may have identical table names in the same Region if the tables are in separate databases. While creating the table, you must specify the table name, database name, and the retention properties. <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a> . See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-table.html">code sample</a> for details.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.timestream.*;
 * Object magneticStoreWriteProperties;
 * Object retentionProperties;
 * CfnTable cfnTable = CfnTable.Builder.create(this, "MyCfnTable")
 *         .databaseName("databaseName")
 *         // the properties below are optional
 *         .magneticStoreWriteProperties(magneticStoreWriteProperties)
 *         .retentionProperties(retentionProperties)
 *         .tableName("tableName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:11.074Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnTable")
public class CfnTable extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnTable(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTable(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.timestream.CfnTable.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Timestream::Table`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTable(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.timestream.CfnTableProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The `arn` of the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags to add to the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the Timestream database that contains this table.
     * <p>
     * <em>Length Constraints</em> : Minimum length of 3 bytes. Maximum length of 256 bytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName() {
        return software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Timestream database that contains this table.
     * <p>
     * <em>Length Constraints</em> : Minimum length of 3 bytes. Maximum length of 256 bytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "databaseName", java.util.Objects.requireNonNull(value, "databaseName is required"));
    }

    /**
     * Contains properties to set on the table when enabling magnetic store writes.
     * <p>
     * This object has the following attributes:
     * <p>
     * <ul>
     * <li><em>EnableMagneticStoreWrites</em> : A <code>boolean</code> flag to enable magnetic store writes.</li>
     * <li><em>MagneticStoreRejectedDataLocation</em> : The location to write error reports for records rejected, asynchronously, during magnetic store writes. Only <code>S3Configuration</code> objects are allowed. The <code>S3Configuration</code> object has the following attributes:</li>
     * <li><em>BucketName</em> : The name of the S3 bucket.</li>
     * <li><em>EncryptionOption</em> : The encryption option for the S3 location. Valid values are S3 server-side encryption with an S3 managed key ( <code>SSE_S3</code> ) or AWS managed key ( <code>SSE_KMS</code> ).</li>
     * <li><em>KmsKeyId</em> : The AWS KMS key ID to use when encrypting with an AWS managed key.</li>
     * <li><em>ObjectKeyPrefix</em> : The prefix to use option for the objects stored in S3.</li>
     * </ul>
     * <p>
     * Both <code>BucketName</code> and <code>EncryptionOption</code> are <em>required</em> when <code>S3Configuration</code> is specified. If you specify <code>SSE_KMS</code> as your <code>EncryptionOption</code> then <code>KmsKeyId</code> is <em>required</em> .
     * <p>
     * <code>EnableMagneticStoreWrites</code> attribute is <em>required</em> when <code>MagneticStoreWriteProperties</code> is specified. <code>MagneticStoreRejectedDataLocation</code> attribute is <em>required</em> when <code>EnableMagneticStoreWrites</code> is set to <code>true</code> .
     * <p>
     * See the following examples:
     * <p>
     * <em>JSON</em>
     * <p>
     * <blockquote><pre>
     * { "Type" : AWS::Timestream::Table", "Properties":{ "DatabaseName":"TestDatabase", "TableName":"TestTable", "MagneticStoreWriteProperties":{ "EnableMagneticStoreWrites":true, "MagneticStoreRejectedDataLocation":{ "S3Configuration":{ "BucketName":"testbucket", "EncryptionOption":"SSE_KMS", "KmsKeyId":"1234abcd-12ab-34cd-56ef-1234567890ab", "ObjectKeyPrefix":"prefix" } } } }
     * }
     * </pre></blockquote>
     * <p>
     * <em>YAML</em>
     * <p>
     * <blockquote><pre>
     * Type: AWS::Timestream::Table
     * DependsOn: TestDatabase
     * Properties: TableName: "TestTable" DatabaseName: "TestDatabase" MagneticStoreWriteProperties: EnableMagneticStoreWrites: true MagneticStoreRejectedDataLocation: S3Configuration: BucketName: "testbucket" EncryptionOption: "SSE_KMS" BucketName: "1234abcd-12ab-34cd-56ef-1234567890ab" EncryptionOption: "prefix"
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getMagneticStoreWriteProperties() {
        return software.amazon.jsii.Kernel.get(this, "magneticStoreWriteProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains properties to set on the table when enabling magnetic store writes.
     * <p>
     * This object has the following attributes:
     * <p>
     * <ul>
     * <li><em>EnableMagneticStoreWrites</em> : A <code>boolean</code> flag to enable magnetic store writes.</li>
     * <li><em>MagneticStoreRejectedDataLocation</em> : The location to write error reports for records rejected, asynchronously, during magnetic store writes. Only <code>S3Configuration</code> objects are allowed. The <code>S3Configuration</code> object has the following attributes:</li>
     * <li><em>BucketName</em> : The name of the S3 bucket.</li>
     * <li><em>EncryptionOption</em> : The encryption option for the S3 location. Valid values are S3 server-side encryption with an S3 managed key ( <code>SSE_S3</code> ) or AWS managed key ( <code>SSE_KMS</code> ).</li>
     * <li><em>KmsKeyId</em> : The AWS KMS key ID to use when encrypting with an AWS managed key.</li>
     * <li><em>ObjectKeyPrefix</em> : The prefix to use option for the objects stored in S3.</li>
     * </ul>
     * <p>
     * Both <code>BucketName</code> and <code>EncryptionOption</code> are <em>required</em> when <code>S3Configuration</code> is specified. If you specify <code>SSE_KMS</code> as your <code>EncryptionOption</code> then <code>KmsKeyId</code> is <em>required</em> .
     * <p>
     * <code>EnableMagneticStoreWrites</code> attribute is <em>required</em> when <code>MagneticStoreWriteProperties</code> is specified. <code>MagneticStoreRejectedDataLocation</code> attribute is <em>required</em> when <code>EnableMagneticStoreWrites</code> is set to <code>true</code> .
     * <p>
     * See the following examples:
     * <p>
     * <em>JSON</em>
     * <p>
     * <blockquote><pre>
     * { "Type" : AWS::Timestream::Table", "Properties":{ "DatabaseName":"TestDatabase", "TableName":"TestTable", "MagneticStoreWriteProperties":{ "EnableMagneticStoreWrites":true, "MagneticStoreRejectedDataLocation":{ "S3Configuration":{ "BucketName":"testbucket", "EncryptionOption":"SSE_KMS", "KmsKeyId":"1234abcd-12ab-34cd-56ef-1234567890ab", "ObjectKeyPrefix":"prefix" } } } }
     * }
     * </pre></blockquote>
     * <p>
     * <em>YAML</em>
     * <p>
     * <blockquote><pre>
     * Type: AWS::Timestream::Table
     * DependsOn: TestDatabase
     * Properties: TableName: "TestTable" DatabaseName: "TestDatabase" MagneticStoreWriteProperties: EnableMagneticStoreWrites: true MagneticStoreRejectedDataLocation: S3Configuration: BucketName: "testbucket" EncryptionOption: "SSE_KMS" BucketName: "1234abcd-12ab-34cd-56ef-1234567890ab" EncryptionOption: "prefix"
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMagneticStoreWriteProperties(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "magneticStoreWriteProperties", java.util.Objects.requireNonNull(value, "magneticStoreWriteProperties is required"));
    }

    /**
     * The retention duration for the memory store and magnetic store. This object has the following attributes:.
     * <p>
     * <ul>
     * <li><em>MemoryStoreRetentionPeriodInHours</em> : Retention duration for memory store, in hours.</li>
     * <li><em>MagneticStoreRetentionPeriodInDays</em> : Retention duration for magnetic store, in days.</li>
     * </ul>
     * <p>
     * Both attributes are of type <code>string</code> . Both attributes are <em>required</em> when <code>RetentionProperties</code> is specified.
     * <p>
     * See the following examples:
     * <p>
     * <em>JSON</em>
     * <p>
     * <code>{ "Type" : AWS::Timestream::Table", "Properties" : { "DatabaseName" : "TestDatabase", "TableName" : "TestTable", "RetentionProperties" : { "MemoryStoreRetentionPeriodInHours": "24", "MagneticStoreRetentionPeriodInDays": "7" } } }</code>
     * <p>
     * <em>YAML</em>
     * <p>
     * <blockquote><pre>
     * Type: AWS::Timestream::Table
     * DependsOn: TestDatabase
     * Properties: TableName: "TestTable" DatabaseName: "TestDatabase" RetentionProperties: MemoryStoreRetentionPeriodInHours: "24" MagneticStoreRetentionPeriodInDays: "7"
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRetentionProperties() {
        return software.amazon.jsii.Kernel.get(this, "retentionProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The retention duration for the memory store and magnetic store. This object has the following attributes:.
     * <p>
     * <ul>
     * <li><em>MemoryStoreRetentionPeriodInHours</em> : Retention duration for memory store, in hours.</li>
     * <li><em>MagneticStoreRetentionPeriodInDays</em> : Retention duration for magnetic store, in days.</li>
     * </ul>
     * <p>
     * Both attributes are of type <code>string</code> . Both attributes are <em>required</em> when <code>RetentionProperties</code> is specified.
     * <p>
     * See the following examples:
     * <p>
     * <em>JSON</em>
     * <p>
     * <code>{ "Type" : AWS::Timestream::Table", "Properties" : { "DatabaseName" : "TestDatabase", "TableName" : "TestTable", "RetentionProperties" : { "MemoryStoreRetentionPeriodInHours": "24", "MagneticStoreRetentionPeriodInDays": "7" } } }</code>
     * <p>
     * <em>YAML</em>
     * <p>
     * <blockquote><pre>
     * Type: AWS::Timestream::Table
     * DependsOn: TestDatabase
     * Properties: TableName: "TestTable" DatabaseName: "TestDatabase" RetentionProperties: MemoryStoreRetentionPeriodInHours: "24" MagneticStoreRetentionPeriodInDays: "7"
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetentionProperties(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "retentionProperties", java.util.Objects.requireNonNull(value, "retentionProperties is required"));
    }

    /**
     * The name of the Timestream table.
     * <p>
     * <em>Length Constraints</em> : Minimum length of 3 bytes. Maximum length of 256 bytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
        return software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Timestream table.
     * <p>
     * <em>Length Constraints</em> : Minimum length of 3 bytes. Maximum length of 256 bytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTableName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tableName", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.timestream.CfnTable}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.timestream.CfnTable> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.timestream.CfnTableProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.timestream.CfnTableProps.Builder();
        }

        /**
         * The name of the Timestream database that contains this table.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 3 bytes. Maximum length of 256 bytes.
         * <p>
         * @return {@code this}
         * @param databaseName The name of the Timestream database that contains this table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(final java.lang.String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        /**
         * Contains properties to set on the table when enabling magnetic store writes.
         * <p>
         * This object has the following attributes:
         * <p>
         * <ul>
         * <li><em>EnableMagneticStoreWrites</em> : A <code>boolean</code> flag to enable magnetic store writes.</li>
         * <li><em>MagneticStoreRejectedDataLocation</em> : The location to write error reports for records rejected, asynchronously, during magnetic store writes. Only <code>S3Configuration</code> objects are allowed. The <code>S3Configuration</code> object has the following attributes:</li>
         * <li><em>BucketName</em> : The name of the S3 bucket.</li>
         * <li><em>EncryptionOption</em> : The encryption option for the S3 location. Valid values are S3 server-side encryption with an S3 managed key ( <code>SSE_S3</code> ) or AWS managed key ( <code>SSE_KMS</code> ).</li>
         * <li><em>KmsKeyId</em> : The AWS KMS key ID to use when encrypting with an AWS managed key.</li>
         * <li><em>ObjectKeyPrefix</em> : The prefix to use option for the objects stored in S3.</li>
         * </ul>
         * <p>
         * Both <code>BucketName</code> and <code>EncryptionOption</code> are <em>required</em> when <code>S3Configuration</code> is specified. If you specify <code>SSE_KMS</code> as your <code>EncryptionOption</code> then <code>KmsKeyId</code> is <em>required</em> .
         * <p>
         * <code>EnableMagneticStoreWrites</code> attribute is <em>required</em> when <code>MagneticStoreWriteProperties</code> is specified. <code>MagneticStoreRejectedDataLocation</code> attribute is <em>required</em> when <code>EnableMagneticStoreWrites</code> is set to <code>true</code> .
         * <p>
         * See the following examples:
         * <p>
         * <em>JSON</em>
         * <p>
         * <blockquote><pre>
         * { "Type" : AWS::Timestream::Table", "Properties":{ "DatabaseName":"TestDatabase", "TableName":"TestTable", "MagneticStoreWriteProperties":{ "EnableMagneticStoreWrites":true, "MagneticStoreRejectedDataLocation":{ "S3Configuration":{ "BucketName":"testbucket", "EncryptionOption":"SSE_KMS", "KmsKeyId":"1234abcd-12ab-34cd-56ef-1234567890ab", "ObjectKeyPrefix":"prefix" } } } }
         * }
         * </pre></blockquote>
         * <p>
         * <em>YAML</em>
         * <p>
         * <blockquote><pre>
         * Type: AWS::Timestream::Table
         * DependsOn: TestDatabase
         * Properties: TableName: "TestTable" DatabaseName: "TestDatabase" MagneticStoreWriteProperties: EnableMagneticStoreWrites: true MagneticStoreRejectedDataLocation: S3Configuration: BucketName: "testbucket" EncryptionOption: "SSE_KMS" BucketName: "1234abcd-12ab-34cd-56ef-1234567890ab" EncryptionOption: "prefix"
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param magneticStoreWriteProperties Contains properties to set on the table when enabling magnetic store writes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder magneticStoreWriteProperties(final java.lang.Object magneticStoreWriteProperties) {
            this.props.magneticStoreWriteProperties(magneticStoreWriteProperties);
            return this;
        }

        /**
         * The retention duration for the memory store and magnetic store. This object has the following attributes:.
         * <p>
         * <ul>
         * <li><em>MemoryStoreRetentionPeriodInHours</em> : Retention duration for memory store, in hours.</li>
         * <li><em>MagneticStoreRetentionPeriodInDays</em> : Retention duration for magnetic store, in days.</li>
         * </ul>
         * <p>
         * Both attributes are of type <code>string</code> . Both attributes are <em>required</em> when <code>RetentionProperties</code> is specified.
         * <p>
         * See the following examples:
         * <p>
         * <em>JSON</em>
         * <p>
         * <code>{ "Type" : AWS::Timestream::Table", "Properties" : { "DatabaseName" : "TestDatabase", "TableName" : "TestTable", "RetentionProperties" : { "MemoryStoreRetentionPeriodInHours": "24", "MagneticStoreRetentionPeriodInDays": "7" } } }</code>
         * <p>
         * <em>YAML</em>
         * <p>
         * <blockquote><pre>
         * Type: AWS::Timestream::Table
         * DependsOn: TestDatabase
         * Properties: TableName: "TestTable" DatabaseName: "TestDatabase" RetentionProperties: MemoryStoreRetentionPeriodInHours: "24" MagneticStoreRetentionPeriodInDays: "7"
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param retentionProperties The retention duration for the memory store and magnetic store. This object has the following attributes:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionProperties(final java.lang.Object retentionProperties) {
            this.props.retentionProperties(retentionProperties);
            return this;
        }

        /**
         * The name of the Timestream table.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 3 bytes. Maximum length of 256 bytes.
         * <p>
         * @return {@code this}
         * @param tableName The name of the Timestream table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(final java.lang.String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        /**
         * The tags to add to the table.
         * <p>
         * @return {@code this}
         * @param tags The tags to add to the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.timestream.CfnTable}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.timestream.CfnTable build() {
            return new software.amazon.awscdk.services.timestream.CfnTable(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
