package software.amazon.awscdk.services.ses;

/**
 * AddHeaderAction configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * AddHeaderActionConfig addHeaderActionConfig = AddHeaderActionConfig.builder()
 *         .headerName("headerName")
 *         .headerValue("headerValue")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:10.666Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.AddHeaderActionConfig")
@software.amazon.jsii.Jsii.Proxy(AddHeaderActionConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddHeaderActionConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the header that you want to add to the incoming message.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHeaderName();

    /**
     * The content that you want to include in the header.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHeaderValue();

    /**
     * @return a {@link Builder} of {@link AddHeaderActionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddHeaderActionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AddHeaderActionConfig> {
        java.lang.String headerName;
        java.lang.String headerValue;

        /**
         * Sets the value of {@link AddHeaderActionConfig#getHeaderName}
         * @param headerName The name of the header that you want to add to the incoming message. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder headerName(java.lang.String headerName) {
            this.headerName = headerName;
            return this;
        }

        /**
         * Sets the value of {@link AddHeaderActionConfig#getHeaderValue}
         * @param headerValue The content that you want to include in the header. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder headerValue(java.lang.String headerValue) {
            this.headerValue = headerValue;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddHeaderActionConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AddHeaderActionConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AddHeaderActionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddHeaderActionConfig {
        private final java.lang.String headerName;
        private final java.lang.String headerValue;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.headerName = software.amazon.jsii.Kernel.get(this, "headerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.headerValue = software.amazon.jsii.Kernel.get(this, "headerValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.headerName = java.util.Objects.requireNonNull(builder.headerName, "headerName is required");
            this.headerValue = java.util.Objects.requireNonNull(builder.headerValue, "headerValue is required");
        }

        @Override
        public final java.lang.String getHeaderName() {
            return this.headerName;
        }

        @Override
        public final java.lang.String getHeaderValue() {
            return this.headerValue;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("headerName", om.valueToTree(this.getHeaderName()));
            data.set("headerValue", om.valueToTree(this.getHeaderValue()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.AddHeaderActionConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddHeaderActionConfig.Jsii$Proxy that = (AddHeaderActionConfig.Jsii$Proxy) o;

            if (!headerName.equals(that.headerName)) return false;
            return this.headerValue.equals(that.headerValue);
        }

        @Override
        public final int hashCode() {
            int result = this.headerName.hashCode();
            result = 31 * result + (this.headerValue.hashCode());
            return result;
        }
    }
}
