package software.amazon.awscdk.services.rds;

/**
 * Credentials to update the password for a ``DatabaseInstanceFromSnapshot``.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * IInstanceEngine engine = DatabaseInstanceEngine.postgres(PostgresInstanceEngineProps.builder().version(PostgresEngineVersion.VER_12_3).build());
 * Key myKey = new Key(this, "MyKey");
 * DatabaseInstanceFromSnapshot.Builder.create(this, "InstanceFromSnapshotWithCustomizedSecret")
 *         .engine(engine)
 *         .vpc(vpc)
 *         .snapshotIdentifier("mySnapshot")
 *         .credentials(SnapshotCredentials.fromGeneratedSecret("username", SnapshotCredentialsFromGeneratedPasswordOptions.builder()
 *                 .encryptionKey(myKey)
 *                 .excludeCharacters("!&amp;*^#&#64;()")
 *                 .replicaRegions(List.of(ReplicaRegion.builder().region("eu-west-1").build(), ReplicaRegion.builder().region("eu-west-2").build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:10.021Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.SnapshotCredentials")
public abstract class SnapshotCredentials extends software.amazon.jsii.JsiiObject {

    protected SnapshotCredentials(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SnapshotCredentials(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected SnapshotCredentials() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Generate a new password for the snapshot, using the existing username and an optional encryption key.
     * <p>
     * Note - The username must match the existing master username of the snapshot.
     * <p>
     * NOTE: use <code>fromGeneratedSecret()</code> for new Clusters and Instances. Switching from
     * <code>fromGeneratedPassword()</code> to <code>fromGeneratedSecret()</code> for already deployed Clusters
     * or Instances will update their master password.
     * <p>
     * @param username This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.SnapshotCredentials fromGeneratedPassword(final @org.jetbrains.annotations.NotNull java.lang.String username, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.SnapshotCredentialsFromGeneratedPasswordOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.SnapshotCredentials.class, "fromGeneratedPassword", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SnapshotCredentials.class), new Object[] { java.util.Objects.requireNonNull(username, "username is required"), options });
    }

    /**
     * Generate a new password for the snapshot, using the existing username and an optional encryption key.
     * <p>
     * Note - The username must match the existing master username of the snapshot.
     * <p>
     * NOTE: use <code>fromGeneratedSecret()</code> for new Clusters and Instances. Switching from
     * <code>fromGeneratedPassword()</code> to <code>fromGeneratedSecret()</code> for already deployed Clusters
     * or Instances will update their master password.
     * <p>
     * @param username This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.SnapshotCredentials fromGeneratedPassword(final @org.jetbrains.annotations.NotNull java.lang.String username) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.SnapshotCredentials.class, "fromGeneratedPassword", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SnapshotCredentials.class), new Object[] { java.util.Objects.requireNonNull(username, "username is required") });
    }

    /**
     * Generate a new password for the snapshot, using the existing username and an optional encryption key.
     * <p>
     * The new credentials are stored in Secrets Manager.
     * <p>
     * Note - The username must match the existing master username of the snapshot.
     * <p>
     * @param username This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.SnapshotCredentials fromGeneratedSecret(final @org.jetbrains.annotations.NotNull java.lang.String username, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.rds.SnapshotCredentialsFromGeneratedPasswordOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.SnapshotCredentials.class, "fromGeneratedSecret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SnapshotCredentials.class), new Object[] { java.util.Objects.requireNonNull(username, "username is required"), options });
    }

    /**
     * Generate a new password for the snapshot, using the existing username and an optional encryption key.
     * <p>
     * The new credentials are stored in Secrets Manager.
     * <p>
     * Note - The username must match the existing master username of the snapshot.
     * <p>
     * @param username This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.SnapshotCredentials fromGeneratedSecret(final @org.jetbrains.annotations.NotNull java.lang.String username) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.SnapshotCredentials.class, "fromGeneratedSecret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SnapshotCredentials.class), new Object[] { java.util.Objects.requireNonNull(username, "username is required") });
    }

    /**
     * Update the snapshot login with an existing password.
     * <p>
     * @param password This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.SnapshotCredentials fromPassword(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue password) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.SnapshotCredentials.class, "fromPassword", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SnapshotCredentials.class), new Object[] { java.util.Objects.requireNonNull(password, "password is required") });
    }

    /**
     * Update the snapshot login with an existing password from a Secret.
     * <p>
     * The Secret must be a JSON string with a <code>password</code> field:
     * <p>
     * <blockquote><pre>
     * {
     *    ...
     *    "password": &lt;required: password&gt;,
     * }
     * </pre></blockquote>
     * <p>
     * @param secret This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.SnapshotCredentials fromSecret(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secret) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.SnapshotCredentials.class, "fromSecret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.SnapshotCredentials.class), new Object[] { java.util.Objects.requireNonNull(secret, "secret is required") });
    }

    /**
     * Whether a new password should be generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.Boolean getGeneratePassword();

    /**
     * KMS encryption key to encrypt the generated secret.
     * <p>
     * Default: - default master key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey();

    /**
     * The characters to exclude from the generated password.
     * <p>
     * Only used if {&#64;link generatePassword} if true.
     * <p>
     * Default: - the DatabaseSecret default exclude character set (" %+~`#$&*()|[]{}:;<>?!'/
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable java.lang.String getExcludeCharacters();

    /**
     * The master user password.
     * <p>
     * Do not put passwords in your CDK code directly.
     * <p>
     * Default: - the existing password from the snapshot
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable software.amazon.awscdk.SecretValue getPassword();

    /**
     * Whether to replace the generated secret when the criteria for the password change.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable java.lang.Boolean getReplaceOnPasswordCriteriaChanges();

    /**
     * A list of regions where to replicate the generated secret.
     * <p>
     * Default: - Secret is not replicated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion> getReplicaRegions();

    /**
     * Secret used to instantiate this Login.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecret();

    /**
     * The master user name.
     * <p>
     * Must be the <strong>current</strong> master user name of the snapshot.
     * It is not possible to change the master user name of a RDS instance.
     * <p>
     * Default: - the existing username from the snapshot
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable java.lang.String getUsername();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.rds.SnapshotCredentials {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Whether a new password should be generated.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.Boolean getGeneratePassword() {
            return software.amazon.jsii.Kernel.get(this, "generatePassword", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * KMS encryption key to encrypt the generated secret.
         * <p>
         * Default: - default master key
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
        }

        /**
         * The characters to exclude from the generated password.
         * <p>
         * Only used if {&#64;link generatePassword} if true.
         * <p>
         * Default: - the DatabaseSecret default exclude character set (" %+~`#$&*()|[]{}:;<>?!'/
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.String getExcludeCharacters() {
            return software.amazon.jsii.Kernel.get(this, "excludeCharacters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The master user password.
         * <p>
         * Do not put passwords in your CDK code directly.
         * <p>
         * Default: - the existing password from the snapshot
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.SecretValue getPassword() {
            return software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class));
        }

        /**
         * Whether to replace the generated secret when the criteria for the password change.
         * <p>
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Boolean getReplaceOnPasswordCriteriaChanges() {
            return software.amazon.jsii.Kernel.get(this, "replaceOnPasswordCriteriaChanges", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * A list of regions where to replicate the generated secret.
         * <p>
         * Default: - Secret is not replicated
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion> getReplicaRegions() {
            return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.secretsmanager.ReplicaRegion>)(software.amazon.jsii.Kernel.get(this, "replicaRegions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ReplicaRegion.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
        }

        /**
         * Secret used to instantiate this Login.
         * <p>
         * Default: - none
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
            return software.amazon.jsii.Kernel.get(this, "secret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
        }

        /**
         * The master user name.
         * <p>
         * Must be the <strong>current</strong> master user name of the snapshot.
         * It is not possible to change the master user name of a RDS instance.
         * <p>
         * Default: - the existing username from the snapshot
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.String getUsername() {
            return software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
