package software.amazon.awscdk.services.rds;

/**
 * The processor features.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * ProcessorFeatures processorFeatures = ProcessorFeatures.builder()
 *         .coreCount(123)
 *         .threadsPerCore(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:10.015Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.ProcessorFeatures")
@software.amazon.jsii.Jsii.Proxy(ProcessorFeatures.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ProcessorFeatures extends software.amazon.jsii.JsiiSerializable {

    /**
     * The number of CPU core.
     * <p>
     * Default: - the default number of CPU cores for the chosen instance class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCoreCount() {
        return null;
    }

    /**
     * The number of threads per core.
     * <p>
     * Default: - the default number of threads per core for the chosen instance class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getThreadsPerCore() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ProcessorFeatures}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ProcessorFeatures}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ProcessorFeatures> {
        java.lang.Number coreCount;
        java.lang.Number threadsPerCore;

        /**
         * Sets the value of {@link ProcessorFeatures#getCoreCount}
         * @param coreCount The number of CPU core.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreCount(java.lang.Number coreCount) {
            this.coreCount = coreCount;
            return this;
        }

        /**
         * Sets the value of {@link ProcessorFeatures#getThreadsPerCore}
         * @param threadsPerCore The number of threads per core.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder threadsPerCore(java.lang.Number threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ProcessorFeatures}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ProcessorFeatures build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ProcessorFeatures}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProcessorFeatures {
        private final java.lang.Number coreCount;
        private final java.lang.Number threadsPerCore;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.coreCount = software.amazon.jsii.Kernel.get(this, "coreCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.threadsPerCore = software.amazon.jsii.Kernel.get(this, "threadsPerCore", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.coreCount = builder.coreCount;
            this.threadsPerCore = builder.threadsPerCore;
        }

        @Override
        public final java.lang.Number getCoreCount() {
            return this.coreCount;
        }

        @Override
        public final java.lang.Number getThreadsPerCore() {
            return this.threadsPerCore;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCoreCount() != null) {
                data.set("coreCount", om.valueToTree(this.getCoreCount()));
            }
            if (this.getThreadsPerCore() != null) {
                data.set("threadsPerCore", om.valueToTree(this.getThreadsPerCore()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.ProcessorFeatures"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ProcessorFeatures.Jsii$Proxy that = (ProcessorFeatures.Jsii$Proxy) o;

            if (this.coreCount != null ? !this.coreCount.equals(that.coreCount) : that.coreCount != null) return false;
            return this.threadsPerCore != null ? this.threadsPerCore.equals(that.threadsPerCore) : that.threadsPerCore == null;
        }

        @Override
        public final int hashCode() {
            int result = this.coreCount != null ? this.coreCount.hashCode() : 0;
            result = 31 * result + (this.threadsPerCore != null ? this.threadsPerCore.hashCode() : 0);
            return result;
        }
    }
}
