package software.amazon.awscdk.services.mediatailor;

/**
 * Properties for defining a `CfnPlaybackConfiguration`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediatailor.*;
 * Object configurationAliases;
 * CfnPlaybackConfigurationProps cfnPlaybackConfigurationProps = CfnPlaybackConfigurationProps.builder()
 *         .adDecisionServerUrl("adDecisionServerUrl")
 *         .name("name")
 *         .videoContentSourceUrl("videoContentSourceUrl")
 *         // the properties below are optional
 *         .availSuppression(AvailSuppressionProperty.builder()
 *                 .mode("mode")
 *                 .value("value")
 *                 .build())
 *         .bumper(BumperProperty.builder()
 *                 .endUrl("endUrl")
 *                 .startUrl("startUrl")
 *                 .build())
 *         .cdnConfiguration(CdnConfigurationProperty.builder()
 *                 .adSegmentUrlPrefix("adSegmentUrlPrefix")
 *                 .contentSegmentUrlPrefix("contentSegmentUrlPrefix")
 *                 .build())
 *         .configurationAliases(Map.of(
 *                 "configurationAliasesKey", configurationAliases))
 *         .dashConfiguration(DashConfigurationProperty.builder()
 *                 .manifestEndpointPrefix("manifestEndpointPrefix")
 *                 .mpdLocation("mpdLocation")
 *                 .originManifestType("originManifestType")
 *                 .build())
 *         .livePreRollConfiguration(LivePreRollConfigurationProperty.builder()
 *                 .adDecisionServerUrl("adDecisionServerUrl")
 *                 .maxDurationSeconds(123)
 *                 .build())
 *         .manifestProcessingRules(ManifestProcessingRulesProperty.builder()
 *                 .adMarkerPassthrough(AdMarkerPassthroughProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .build())
 *         .personalizationThresholdSeconds(123)
 *         .slateAdUrl("slateAdUrl")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .transcodeProfileName("transcodeProfileName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:09.474Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediatailor.CfnPlaybackConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnPlaybackConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPlaybackConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The URL for the ad decision server (ADS).
     * <p>
     * This includes the specification of static parameters and placeholders for dynamic parameters. MediaTailor substitutes player-specific and session-specific parameters as needed when calling the ADS. Alternately, for testing you can provide a static VAST URL. The maximum length is 25,000 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAdDecisionServerUrl();

    /**
     * The identifier for the playback configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The URL prefix for the parent manifest for the stream, minus the asset ID.
     * <p>
     * The maximum length is 512 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVideoContentSourceUrl();

    /**
     * The configuration for avail suppression, also known as ad suppression.
     * <p>
     * For more information about ad suppression, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Suppression</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAvailSuppression() {
        return null;
    }

    /**
     * The configuration for bumpers.
     * <p>
     * Bumpers are short audio or video clips that play at the start or before the end of an ad break. To learn more about bumpers, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html">Bumpers</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBumper() {
        return null;
    }

    /**
     * The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCdnConfiguration() {
        return null;
    }

    /**
     * The player parameters and aliases used as dynamic variables during session initialization.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domain.html">Domain Variables</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConfigurationAliases() {
        return null;
    }

    /**
     * The configuration for DASH content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDashConfiguration() {
        return null;
    }

    /**
     * The configuration for pre-roll ad insertion.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLivePreRollConfiguration() {
        return null;
    }

    /**
     * The configuration for manifest processing rules.
     * <p>
     * Manifest processing rules enable customization of the personalized manifests created by MediaTailor.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getManifestProcessingRules() {
        return null;
    }

    /**
     * Defines the maximum duration of underfilled ad time (in seconds) allowed in an ad break.
     * <p>
     * If the duration of underfilled ad time exceeds the personalization threshold, then the personalization of the ad break is abandoned and the underlying content is shown. This feature applies to <em>ad replacement</em> in live and VOD streams, rather than ad insertion, because it relies on an underlying content stream. For more information about ad break behavior, including ad replacement and insertion, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Behavior in MediaTailor</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPersonalizationThresholdSeconds() {
        return null;
    }

    /**
     * The URL for a high-quality video asset to transcode and use to fill in time that's not used by ads.
     * <p>
     * MediaTailor shows the slate to fill in gaps in media content. Configuring the slate is optional for non-VPAID configurations. For VPAID, the slate is required because MediaTailor provides it in the slots that are designated for dynamic ad content. The slate must be a high-quality asset that contains both audio and video.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSlateAdUrl() {
        return null;
    }

    /**
     * The tags to assign to the playback configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The name that is used to associate this playback configuration with a custom transcode profile.
     * <p>
     * This overrides the dynamic transcoding defaults of MediaTailor. Use this only if you have already set up custom profiles with the help of AWS Support.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTranscodeProfileName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPlaybackConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPlaybackConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPlaybackConfigurationProps> {
        java.lang.String adDecisionServerUrl;
        java.lang.String name;
        java.lang.String videoContentSourceUrl;
        java.lang.Object availSuppression;
        java.lang.Object bumper;
        java.lang.Object cdnConfiguration;
        java.lang.Object configurationAliases;
        java.lang.Object dashConfiguration;
        java.lang.Object livePreRollConfiguration;
        java.lang.Object manifestProcessingRules;
        java.lang.Number personalizationThresholdSeconds;
        java.lang.String slateAdUrl;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String transcodeProfileName;

        /**
         * Sets the value of {@link CfnPlaybackConfigurationProps#getAdDecisionServerUrl}
         * @param adDecisionServerUrl The URL for the ad decision server (ADS). This parameter is required.
         *                            This includes the specification of static parameters and placeholders for dynamic parameters. MediaTailor substitutes player-specific and session-specific parameters as needed when calling the ADS. Alternately, for testing you can provide a static VAST URL. The maximum length is 25,000 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adDecisionServerUrl(java.lang.String adDecisionServerUrl) {
            this.adDecisionServerUrl = adDecisionServerUrl;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaybackConfigurationProps#getName}
         * @param name The identifier for the playback configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaybackConfigurationProps#getVideoContentSourceUrl}
         * @param videoContentSourceUrl The URL prefix for the parent manifest for the stream, minus the asset ID. This parameter is required.
         *                              The maximum length is 512 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder videoContentSourceUrl(java.lang.String videoContentSourceUrl) {
            this.videoContentSourceUrl = videoContentSourceUrl;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaybackConfigurationProps#getAvailSuppression}
         * @param availSuppression The configuration for avail suppression, also known as ad suppression.
         *                         For more information about ad suppression, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Suppression</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availSuppression(software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.AvailSuppressionProperty availSuppression) {
            this.availSuppression = availSuppression;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaybackConfigurationProps#getAvailSuppression}
         * @param availSuppression The configuration for avail suppression, also known as ad suppression.
         *                         For more information about ad suppression, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Suppression</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availSuppression(software.amazon.awscdk.IResolvable availSuppression) {
            this.availSuppression = availSuppression;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaybackConfigurationProps#getBumper}
         * @param bumper The configuration for bumpers.
         *               Bumpers are short audio or video clips that play at the start or before the end of an ad break. To learn more about bumpers, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html">Bumpers</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bumper(software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.BumperProperty bumper) {
            this.bumper = bumper;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaybackConfigurationProps#getBumper}
         * @param bumper The configuration for bumpers.
         *               Bumpers are short audio or video clips that play at the start or before the end of an ad break. To learn more about bumpers, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html">Bumpers</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bumper(software.amazon.awscdk.IResolvable bumper) {
            this.bumper = bumper;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaybackConfigurationProps#getCdnConfiguration}
         * @param cdnConfiguration The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cdnConfiguration(software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.CdnConfigurationProperty cdnConfiguration) {
            this.cdnConfiguration = cdnConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaybackConfigurationProps#getCdnConfiguration}
         * @param cdnConfiguration The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment management.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cdnConfiguration(software.amazon.awscdk.IResolvable cdnConfiguration) {
            this.cdnConfiguration = cdnConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaybackConfigurationProps#getConfigurationAliases}
         * @param configurationAliases The player parameters and aliases used as dynamic variables during session initialization.
         *                             For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domain.html">Domain Variables</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationAliases(software.amazon.awscdk.IResolvable configurationAliases) {
            this.configurationAliases = configurationAliases;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaybackConfigurationProps#getConfigurationAliases}
         * @param configurationAliases The player parameters and aliases used as dynamic variables during session initialization.
         *                             For more information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domain.html">Domain Variables</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationAliases(java.util.Map<java.lang.String, ? extends java.lang.Object> configurationAliases) {
            this.configurationAliases = configurationAliases;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaybackConfigurationProps#getDashConfiguration}
         * @param dashConfiguration The configuration for DASH content.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashConfiguration(software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.DashConfigurationProperty dashConfiguration) {
            this.dashConfiguration = dashConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaybackConfigurationProps#getDashConfiguration}
         * @param dashConfiguration The configuration for DASH content.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashConfiguration(software.amazon.awscdk.IResolvable dashConfiguration) {
            this.dashConfiguration = dashConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaybackConfigurationProps#getLivePreRollConfiguration}
         * @param livePreRollConfiguration The configuration for pre-roll ad insertion.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder livePreRollConfiguration(software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.LivePreRollConfigurationProperty livePreRollConfiguration) {
            this.livePreRollConfiguration = livePreRollConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaybackConfigurationProps#getLivePreRollConfiguration}
         * @param livePreRollConfiguration The configuration for pre-roll ad insertion.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder livePreRollConfiguration(software.amazon.awscdk.IResolvable livePreRollConfiguration) {
            this.livePreRollConfiguration = livePreRollConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaybackConfigurationProps#getManifestProcessingRules}
         * @param manifestProcessingRules The configuration for manifest processing rules.
         *                                Manifest processing rules enable customization of the personalized manifests created by MediaTailor.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manifestProcessingRules(software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration.ManifestProcessingRulesProperty manifestProcessingRules) {
            this.manifestProcessingRules = manifestProcessingRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaybackConfigurationProps#getManifestProcessingRules}
         * @param manifestProcessingRules The configuration for manifest processing rules.
         *                                Manifest processing rules enable customization of the personalized manifests created by MediaTailor.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manifestProcessingRules(software.amazon.awscdk.IResolvable manifestProcessingRules) {
            this.manifestProcessingRules = manifestProcessingRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaybackConfigurationProps#getPersonalizationThresholdSeconds}
         * @param personalizationThresholdSeconds Defines the maximum duration of underfilled ad time (in seconds) allowed in an ad break.
         *                                        If the duration of underfilled ad time exceeds the personalization threshold, then the personalization of the ad break is abandoned and the underlying content is shown. This feature applies to <em>ad replacement</em> in live and VOD streams, rather than ad insertion, because it relies on an underlying content stream. For more information about ad break behavior, including ad replacement and insertion, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Behavior in MediaTailor</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder personalizationThresholdSeconds(java.lang.Number personalizationThresholdSeconds) {
            this.personalizationThresholdSeconds = personalizationThresholdSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaybackConfigurationProps#getSlateAdUrl}
         * @param slateAdUrl The URL for a high-quality video asset to transcode and use to fill in time that's not used by ads.
         *                   MediaTailor shows the slate to fill in gaps in media content. Configuring the slate is optional for non-VPAID configurations. For VPAID, the slate is required because MediaTailor provides it in the slots that are designated for dynamic ad content. The slate must be a high-quality asset that contains both audio and video.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder slateAdUrl(java.lang.String slateAdUrl) {
            this.slateAdUrl = slateAdUrl;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaybackConfigurationProps#getTags}
         * @param tags The tags to assign to the playback configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaybackConfigurationProps#getTranscodeProfileName}
         * @param transcodeProfileName The name that is used to associate this playback configuration with a custom transcode profile.
         *                             This overrides the dynamic transcoding defaults of MediaTailor. Use this only if you have already set up custom profiles with the help of AWS Support.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transcodeProfileName(java.lang.String transcodeProfileName) {
            this.transcodeProfileName = transcodeProfileName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPlaybackConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPlaybackConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPlaybackConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPlaybackConfigurationProps {
        private final java.lang.String adDecisionServerUrl;
        private final java.lang.String name;
        private final java.lang.String videoContentSourceUrl;
        private final java.lang.Object availSuppression;
        private final java.lang.Object bumper;
        private final java.lang.Object cdnConfiguration;
        private final java.lang.Object configurationAliases;
        private final java.lang.Object dashConfiguration;
        private final java.lang.Object livePreRollConfiguration;
        private final java.lang.Object manifestProcessingRules;
        private final java.lang.Number personalizationThresholdSeconds;
        private final java.lang.String slateAdUrl;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String transcodeProfileName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.adDecisionServerUrl = software.amazon.jsii.Kernel.get(this, "adDecisionServerUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.videoContentSourceUrl = software.amazon.jsii.Kernel.get(this, "videoContentSourceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.availSuppression = software.amazon.jsii.Kernel.get(this, "availSuppression", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.bumper = software.amazon.jsii.Kernel.get(this, "bumper", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cdnConfiguration = software.amazon.jsii.Kernel.get(this, "cdnConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.configurationAliases = software.amazon.jsii.Kernel.get(this, "configurationAliases", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dashConfiguration = software.amazon.jsii.Kernel.get(this, "dashConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.livePreRollConfiguration = software.amazon.jsii.Kernel.get(this, "livePreRollConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.manifestProcessingRules = software.amazon.jsii.Kernel.get(this, "manifestProcessingRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.personalizationThresholdSeconds = software.amazon.jsii.Kernel.get(this, "personalizationThresholdSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.slateAdUrl = software.amazon.jsii.Kernel.get(this, "slateAdUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.transcodeProfileName = software.amazon.jsii.Kernel.get(this, "transcodeProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.adDecisionServerUrl = java.util.Objects.requireNonNull(builder.adDecisionServerUrl, "adDecisionServerUrl is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.videoContentSourceUrl = java.util.Objects.requireNonNull(builder.videoContentSourceUrl, "videoContentSourceUrl is required");
            this.availSuppression = builder.availSuppression;
            this.bumper = builder.bumper;
            this.cdnConfiguration = builder.cdnConfiguration;
            this.configurationAliases = builder.configurationAliases;
            this.dashConfiguration = builder.dashConfiguration;
            this.livePreRollConfiguration = builder.livePreRollConfiguration;
            this.manifestProcessingRules = builder.manifestProcessingRules;
            this.personalizationThresholdSeconds = builder.personalizationThresholdSeconds;
            this.slateAdUrl = builder.slateAdUrl;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.transcodeProfileName = builder.transcodeProfileName;
        }

        @Override
        public final java.lang.String getAdDecisionServerUrl() {
            return this.adDecisionServerUrl;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getVideoContentSourceUrl() {
            return this.videoContentSourceUrl;
        }

        @Override
        public final java.lang.Object getAvailSuppression() {
            return this.availSuppression;
        }

        @Override
        public final java.lang.Object getBumper() {
            return this.bumper;
        }

        @Override
        public final java.lang.Object getCdnConfiguration() {
            return this.cdnConfiguration;
        }

        @Override
        public final java.lang.Object getConfigurationAliases() {
            return this.configurationAliases;
        }

        @Override
        public final java.lang.Object getDashConfiguration() {
            return this.dashConfiguration;
        }

        @Override
        public final java.lang.Object getLivePreRollConfiguration() {
            return this.livePreRollConfiguration;
        }

        @Override
        public final java.lang.Object getManifestProcessingRules() {
            return this.manifestProcessingRules;
        }

        @Override
        public final java.lang.Number getPersonalizationThresholdSeconds() {
            return this.personalizationThresholdSeconds;
        }

        @Override
        public final java.lang.String getSlateAdUrl() {
            return this.slateAdUrl;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTranscodeProfileName() {
            return this.transcodeProfileName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("adDecisionServerUrl", om.valueToTree(this.getAdDecisionServerUrl()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("videoContentSourceUrl", om.valueToTree(this.getVideoContentSourceUrl()));
            if (this.getAvailSuppression() != null) {
                data.set("availSuppression", om.valueToTree(this.getAvailSuppression()));
            }
            if (this.getBumper() != null) {
                data.set("bumper", om.valueToTree(this.getBumper()));
            }
            if (this.getCdnConfiguration() != null) {
                data.set("cdnConfiguration", om.valueToTree(this.getCdnConfiguration()));
            }
            if (this.getConfigurationAliases() != null) {
                data.set("configurationAliases", om.valueToTree(this.getConfigurationAliases()));
            }
            if (this.getDashConfiguration() != null) {
                data.set("dashConfiguration", om.valueToTree(this.getDashConfiguration()));
            }
            if (this.getLivePreRollConfiguration() != null) {
                data.set("livePreRollConfiguration", om.valueToTree(this.getLivePreRollConfiguration()));
            }
            if (this.getManifestProcessingRules() != null) {
                data.set("manifestProcessingRules", om.valueToTree(this.getManifestProcessingRules()));
            }
            if (this.getPersonalizationThresholdSeconds() != null) {
                data.set("personalizationThresholdSeconds", om.valueToTree(this.getPersonalizationThresholdSeconds()));
            }
            if (this.getSlateAdUrl() != null) {
                data.set("slateAdUrl", om.valueToTree(this.getSlateAdUrl()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTranscodeProfileName() != null) {
                data.set("transcodeProfileName", om.valueToTree(this.getTranscodeProfileName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediatailor.CfnPlaybackConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPlaybackConfigurationProps.Jsii$Proxy that = (CfnPlaybackConfigurationProps.Jsii$Proxy) o;

            if (!adDecisionServerUrl.equals(that.adDecisionServerUrl)) return false;
            if (!name.equals(that.name)) return false;
            if (!videoContentSourceUrl.equals(that.videoContentSourceUrl)) return false;
            if (this.availSuppression != null ? !this.availSuppression.equals(that.availSuppression) : that.availSuppression != null) return false;
            if (this.bumper != null ? !this.bumper.equals(that.bumper) : that.bumper != null) return false;
            if (this.cdnConfiguration != null ? !this.cdnConfiguration.equals(that.cdnConfiguration) : that.cdnConfiguration != null) return false;
            if (this.configurationAliases != null ? !this.configurationAliases.equals(that.configurationAliases) : that.configurationAliases != null) return false;
            if (this.dashConfiguration != null ? !this.dashConfiguration.equals(that.dashConfiguration) : that.dashConfiguration != null) return false;
            if (this.livePreRollConfiguration != null ? !this.livePreRollConfiguration.equals(that.livePreRollConfiguration) : that.livePreRollConfiguration != null) return false;
            if (this.manifestProcessingRules != null ? !this.manifestProcessingRules.equals(that.manifestProcessingRules) : that.manifestProcessingRules != null) return false;
            if (this.personalizationThresholdSeconds != null ? !this.personalizationThresholdSeconds.equals(that.personalizationThresholdSeconds) : that.personalizationThresholdSeconds != null) return false;
            if (this.slateAdUrl != null ? !this.slateAdUrl.equals(that.slateAdUrl) : that.slateAdUrl != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.transcodeProfileName != null ? this.transcodeProfileName.equals(that.transcodeProfileName) : that.transcodeProfileName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.adDecisionServerUrl.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.videoContentSourceUrl.hashCode());
            result = 31 * result + (this.availSuppression != null ? this.availSuppression.hashCode() : 0);
            result = 31 * result + (this.bumper != null ? this.bumper.hashCode() : 0);
            result = 31 * result + (this.cdnConfiguration != null ? this.cdnConfiguration.hashCode() : 0);
            result = 31 * result + (this.configurationAliases != null ? this.configurationAliases.hashCode() : 0);
            result = 31 * result + (this.dashConfiguration != null ? this.dashConfiguration.hashCode() : 0);
            result = 31 * result + (this.livePreRollConfiguration != null ? this.livePreRollConfiguration.hashCode() : 0);
            result = 31 * result + (this.manifestProcessingRules != null ? this.manifestProcessingRules.hashCode() : 0);
            result = 31 * result + (this.personalizationThresholdSeconds != null ? this.personalizationThresholdSeconds.hashCode() : 0);
            result = 31 * result + (this.slateAdUrl != null ? this.slateAdUrl.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.transcodeProfileName != null ? this.transcodeProfileName.hashCode() : 0);
            return result;
        }
    }
}
