package software.amazon.awscdk.services.lex;

/**
 * Properties for defining a `CfnBot`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lex.*;
 * Object dataPrivacy;
 * Object sentimentAnalysisSettings;
 * CfnBotProps cfnBotProps = CfnBotProps.builder()
 *         .dataPrivacy(dataPrivacy)
 *         .idleSessionTtlInSeconds(123)
 *         .name("name")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .autoBuildBotLocales(false)
 *         .botFileS3Location(S3LocationProperty.builder()
 *                 .s3Bucket("s3Bucket")
 *                 .s3ObjectKey("s3ObjectKey")
 *                 // the properties below are optional
 *                 .s3ObjectVersion("s3ObjectVersion")
 *                 .build())
 *         .botLocales(List.of(BotLocaleProperty.builder()
 *                 .localeId("localeId")
 *                 .nluConfidenceThreshold(123)
 *                 // the properties below are optional
 *                 .customVocabulary(CustomVocabularyProperty.builder()
 *                         .customVocabularyItems(List.of(CustomVocabularyItemProperty.builder()
 *                                 .phrase("phrase")
 *                                 // the properties below are optional
 *                                 .weight(123)
 *                                 .build()))
 *                         .build())
 *                 .description("description")
 *                 .intents(List.of(IntentProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .description("description")
 *                         .dialogCodeHook(DialogCodeHookSettingProperty.builder()
 *                                 .enabled(false)
 *                                 .build())
 *                         .fulfillmentCodeHook(FulfillmentCodeHookSettingProperty.builder()
 *                                 .enabled(false)
 *                                 // the properties below are optional
 *                                 .fulfillmentUpdatesSpecification(FulfillmentUpdatesSpecificationProperty.builder()
 *                                         .active(false)
 *                                         // the properties below are optional
 *                                         .startResponse(FulfillmentStartResponseSpecificationProperty.builder()
 *                                                 .delayInSeconds(123)
 *                                                 .messageGroups(List.of(MessageGroupProperty.builder()
 *                                                         .message(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         // the properties below are optional
 *                                                         .variations(List.of(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build()))
 *                                                         .build()))
 *                                                 // the properties below are optional
 *                                                 .allowInterrupt(false)
 *                                                 .build())
 *                                         .timeoutInSeconds(123)
 *                                         .updateResponse(FulfillmentUpdateResponseSpecificationProperty.builder()
 *                                                 .frequencyInSeconds(123)
 *                                                 .messageGroups(List.of(MessageGroupProperty.builder()
 *                                                         .message(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         // the properties below are optional
 *                                                         .variations(List.of(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build()))
 *                                                         .build()))
 *                                                 // the properties below are optional
 *                                                 .allowInterrupt(false)
 *                                                 .build())
 *                                         .build())
 *                                 .postFulfillmentStatusSpecification(PostFulfillmentStatusSpecificationProperty.builder()
 *                                         .failureResponse(ResponseSpecificationProperty.builder()
 *                                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
 *                                                         .message(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         // the properties below are optional
 *                                                         .variations(List.of(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build()))
 *                                                         .build()))
 *                                                 // the properties below are optional
 *                                                 .allowInterrupt(false)
 *                                                 .build())
 *                                         .successResponse(ResponseSpecificationProperty.builder()
 *                                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
 *                                                         .message(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         // the properties below are optional
 *                                                         .variations(List.of(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build()))
 *                                                         .build()))
 *                                                 // the properties below are optional
 *                                                 .allowInterrupt(false)
 *                                                 .build())
 *                                         .timeoutResponse(ResponseSpecificationProperty.builder()
 *                                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
 *                                                         .message(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         // the properties below are optional
 *                                                         .variations(List.of(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build()))
 *                                                         .build()))
 *                                                 // the properties below are optional
 *                                                 .allowInterrupt(false)
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .inputContexts(List.of(InputContextProperty.builder()
 *                                 .name("name")
 *                                 .build()))
 *                         .intentClosingSetting(IntentClosingSettingProperty.builder()
 *                                 .closingResponse(ResponseSpecificationProperty.builder()
 *                                         .messageGroupsList(List.of(MessageGroupProperty.builder()
 *                                                 .message(MessageProperty.builder()
 *                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                 .title("title")
 *                                                                 // the properties below are optional
 *                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                         .text("text")
 *                                                                         .value("value")
 *                                                                         .build()))
 *                                                                 .imageUrl("imageUrl")
 *                                                                 .subtitle("subtitle")
 *                                                                 .build())
 *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .variations(List.of(MessageProperty.builder()
 *                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                 .title("title")
 *                                                                 // the properties below are optional
 *                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                         .text("text")
 *                                                                         .value("value")
 *                                                                         .build()))
 *                                                                 .imageUrl("imageUrl")
 *                                                                 .subtitle("subtitle")
 *                                                                 .build())
 *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .build()))
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .allowInterrupt(false)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .isActive(false)
 *                                 .build())
 *                         .intentConfirmationSetting(IntentConfirmationSettingProperty.builder()
 *                                 .declinationResponse(ResponseSpecificationProperty.builder()
 *                                         .messageGroupsList(List.of(MessageGroupProperty.builder()
 *                                                 .message(MessageProperty.builder()
 *                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                 .title("title")
 *                                                                 // the properties below are optional
 *                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                         .text("text")
 *                                                                         .value("value")
 *                                                                         .build()))
 *                                                                 .imageUrl("imageUrl")
 *                                                                 .subtitle("subtitle")
 *                                                                 .build())
 *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .variations(List.of(MessageProperty.builder()
 *                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                 .title("title")
 *                                                                 // the properties below are optional
 *                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                         .text("text")
 *                                                                         .value("value")
 *                                                                         .build()))
 *                                                                 .imageUrl("imageUrl")
 *                                                                 .subtitle("subtitle")
 *                                                                 .build())
 *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .build()))
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .allowInterrupt(false)
 *                                         .build())
 *                                 .promptSpecification(PromptSpecificationProperty.builder()
 *                                         .maxRetries(123)
 *                                         .messageGroupsList(List.of(MessageGroupProperty.builder()
 *                                                 .message(MessageProperty.builder()
 *                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                 .title("title")
 *                                                                 // the properties below are optional
 *                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                         .text("text")
 *                                                                         .value("value")
 *                                                                         .build()))
 *                                                                 .imageUrl("imageUrl")
 *                                                                 .subtitle("subtitle")
 *                                                                 .build())
 *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .variations(List.of(MessageProperty.builder()
 *                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                 .title("title")
 *                                                                 // the properties below are optional
 *                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                         .text("text")
 *                                                                         .value("value")
 *                                                                         .build()))
 *                                                                 .imageUrl("imageUrl")
 *                                                                 .subtitle("subtitle")
 *                                                                 .build())
 *                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .build()))
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .allowInterrupt(false)
 *                                         .messageSelectionStrategy("messageSelectionStrategy")
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .isActive(false)
 *                                 .build())
 *                         .kendraConfiguration(KendraConfigurationProperty.builder()
 *                                 .kendraIndex("kendraIndex")
 *                                 // the properties below are optional
 *                                 .queryFilterString("queryFilterString")
 *                                 .queryFilterStringEnabled(false)
 *                                 .build())
 *                         .outputContexts(List.of(OutputContextProperty.builder()
 *                                 .name("name")
 *                                 .timeToLiveInSeconds(123)
 *                                 .turnsToLive(123)
 *                                 .build()))
 *                         .parentIntentSignature("parentIntentSignature")
 *                         .sampleUtterances(List.of(SampleUtteranceProperty.builder()
 *                                 .utterance("utterance")
 *                                 .build()))
 *                         .slotPriorities(List.of(SlotPriorityProperty.builder()
 *                                 .priority(123)
 *                                 .slotName("slotName")
 *                                 .build()))
 *                         .slots(List.of(SlotProperty.builder()
 *                                 .name("name")
 *                                 .slotTypeName("slotTypeName")
 *                                 .valueElicitationSetting(SlotValueElicitationSettingProperty.builder()
 *                                         .slotConstraint("slotConstraint")
 *                                         // the properties below are optional
 *                                         .defaultValueSpecification(SlotDefaultValueSpecificationProperty.builder()
 *                                                 .defaultValueList(List.of(SlotDefaultValueProperty.builder()
 *                                                         .defaultValue("defaultValue")
 *                                                         .build()))
 *                                                 .build())
 *                                         .promptSpecification(PromptSpecificationProperty.builder()
 *                                                 .maxRetries(123)
 *                                                 .messageGroupsList(List.of(MessageGroupProperty.builder()
 *                                                         .message(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         // the properties below are optional
 *                                                         .variations(List.of(MessageProperty.builder()
 *                                                                 .customPayload(CustomPayloadProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                         .title("title")
 *                                                                         // the properties below are optional
 *                                                                         .buttons(List.of(ButtonProperty.builder()
 *                                                                                 .text("text")
 *                                                                                 .value("value")
 *                                                                                 .build()))
 *                                                                         .imageUrl("imageUrl")
 *                                                                         .subtitle("subtitle")
 *                                                                         .build())
 *                                                                 .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build()))
 *                                                         .build()))
 *                                                 // the properties below are optional
 *                                                 .allowInterrupt(false)
 *                                                 .messageSelectionStrategy("messageSelectionStrategy")
 *                                                 .build())
 *                                         .sampleUtterances(List.of(SampleUtteranceProperty.builder()
 *                                                 .utterance("utterance")
 *                                                 .build()))
 *                                         .waitAndContinueSpecification(WaitAndContinueSpecificationProperty.builder()
 *                                                 .continueResponse(ResponseSpecificationProperty.builder()
 *                                                         .messageGroupsList(List.of(MessageGroupProperty.builder()
 *                                                                 .message(MessageProperty.builder()
 *                                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                                 .title("title")
 *                                                                                 // the properties below are optional
 *                                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                                         .text("text")
 *                                                                                         .value("value")
 *                                                                                         .build()))
 *                                                                                 .imageUrl("imageUrl")
 *                                                                                 .subtitle("subtitle")
 *                                                                                 .build())
 *                                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .build())
 *                                                                 // the properties below are optional
 *                                                                 .variations(List.of(MessageProperty.builder()
 *                                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                                 .title("title")
 *                                                                                 // the properties below are optional
 *                                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                                         .text("text")
 *                                                                                         .value("value")
 *                                                                                         .build()))
 *                                                                                 .imageUrl("imageUrl")
 *                                                                                 .subtitle("subtitle")
 *                                                                                 .build())
 *                                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .build()))
 *                                                                 .build()))
 *                                                         // the properties below are optional
 *                                                         .allowInterrupt(false)
 *                                                         .build())
 *                                                 .waitingResponse(ResponseSpecificationProperty.builder()
 *                                                         .messageGroupsList(List.of(MessageGroupProperty.builder()
 *                                                                 .message(MessageProperty.builder()
 *                                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                                 .title("title")
 *                                                                                 // the properties below are optional
 *                                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                                         .text("text")
 *                                                                                         .value("value")
 *                                                                                         .build()))
 *                                                                                 .imageUrl("imageUrl")
 *                                                                                 .subtitle("subtitle")
 *                                                                                 .build())
 *                                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .build())
 *                                                                 // the properties below are optional
 *                                                                 .variations(List.of(MessageProperty.builder()
 *                                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                                 .title("title")
 *                                                                                 // the properties below are optional
 *                                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                                         .text("text")
 *                                                                                         .value("value")
 *                                                                                         .build()))
 *                                                                                 .imageUrl("imageUrl")
 *                                                                                 .subtitle("subtitle")
 *                                                                                 .build())
 *                                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .build()))
 *                                                                 .build()))
 *                                                         // the properties below are optional
 *                                                         .allowInterrupt(false)
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .isActive(false)
 *                                                 .stillWaitingResponse(StillWaitingResponseSpecificationProperty.builder()
 *                                                         .frequencyInSeconds(123)
 *                                                         .messageGroupsList(List.of(MessageGroupProperty.builder()
 *                                                                 .message(MessageProperty.builder()
 *                                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                                 .title("title")
 *                                                                                 // the properties below are optional
 *                                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                                         .text("text")
 *                                                                                         .value("value")
 *                                                                                         .build()))
 *                                                                                 .imageUrl("imageUrl")
 *                                                                                 .subtitle("subtitle")
 *                                                                                 .build())
 *                                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .build())
 *                                                                 // the properties below are optional
 *                                                                 .variations(List.of(MessageProperty.builder()
 *                                                                         .customPayload(CustomPayloadProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .imageResponseCard(ImageResponseCardProperty.builder()
 *                                                                                 .title("title")
 *                                                                                 // the properties below are optional
 *                                                                                 .buttons(List.of(ButtonProperty.builder()
 *                                                                                         .text("text")
 *                                                                                         .value("value")
 *                                                                                         .build()))
 *                                                                                 .imageUrl("imageUrl")
 *                                                                                 .subtitle("subtitle")
 *                                                                                 .build())
 *                                                                         .plainTextMessage(PlainTextMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .ssmlMessage(SSMLMessageProperty.builder()
 *                                                                                 .value("value")
 *                                                                                 .build())
 *                                                                         .build()))
 *                                                                 .build()))
 *                                                         .timeoutInSeconds(123)
 *                                                         // the properties below are optional
 *                                                         .allowInterrupt(false)
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .description("description")
 *                                 .multipleValuesSetting(MultipleValuesSettingProperty.builder()
 *                                         .allowMultipleValues(false)
 *                                         .build())
 *                                 .obfuscationSetting(ObfuscationSettingProperty.builder()
 *                                         .obfuscationSettingType("obfuscationSettingType")
 *                                         .build())
 *                                 .build()))
 *                         .build()))
 *                 .slotTypes(List.of(SlotTypeProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .description("description")
 *                         .externalSourceSetting(ExternalSourceSettingProperty.builder()
 *                                 .grammarSlotTypeSetting(GrammarSlotTypeSettingProperty.builder()
 *                                         .source(GrammarSlotTypeSourceProperty.builder()
 *                                                 .s3BucketName("s3BucketName")
 *                                                 .s3ObjectKey("s3ObjectKey")
 *                                                 // the properties below are optional
 *                                                 .kmsKeyArn("kmsKeyArn")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .parentSlotTypeSignature("parentSlotTypeSignature")
 *                         .slotTypeValues(List.of(SlotTypeValueProperty.builder()
 *                                 .sampleValue(SampleValueProperty.builder()
 *                                         .value("value")
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .synonyms(List.of(SampleValueProperty.builder()
 *                                         .value("value")
 *                                         .build()))
 *                                 .build()))
 *                         .valueSelectionSetting(SlotValueSelectionSettingProperty.builder()
 *                                 .resolutionStrategy("resolutionStrategy")
 *                                 // the properties below are optional
 *                                 .advancedRecognitionSetting(AdvancedRecognitionSettingProperty.builder()
 *                                         .audioRecognitionStrategy("audioRecognitionStrategy")
 *                                         .build())
 *                                 .regexFilter(SlotValueRegexFilterProperty.builder()
 *                                         .pattern("pattern")
 *                                         .build())
 *                                 .build())
 *                         .build()))
 *                 .voiceSettings(VoiceSettingsProperty.builder()
 *                         .voiceId("voiceId")
 *                         // the properties below are optional
 *                         .engine("engine")
 *                         .build())
 *                 .build()))
 *         .botTags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .description("description")
 *         .testBotAliasSettings(TestBotAliasSettingsProperty.builder()
 *                 .botAliasLocaleSettings(List.of(BotAliasLocaleSettingsItemProperty.builder()
 *                         .botAliasLocaleSetting(BotAliasLocaleSettingsProperty.builder()
 *                                 .enabled(false)
 *                                 // the properties below are optional
 *                                 .codeHookSpecification(CodeHookSpecificationProperty.builder()
 *                                         .lambdaCodeHook(LambdaCodeHookProperty.builder()
 *                                                 .codeHookInterfaceVersion("codeHookInterfaceVersion")
 *                                                 .lambdaArn("lambdaArn")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .localeId("localeId")
 *                         .build()))
 *                 .conversationLogSettings(ConversationLogSettingsProperty.builder()
 *                         .audioLogSettings(List.of(AudioLogSettingProperty.builder()
 *                                 .destination(AudioLogDestinationProperty.builder()
 *                                         .s3Bucket(S3BucketLogDestinationProperty.builder()
 *                                                 .logPrefix("logPrefix")
 *                                                 .s3BucketArn("s3BucketArn")
 *                                                 // the properties below are optional
 *                                                 .kmsKeyArn("kmsKeyArn")
 *                                                 .build())
 *                                         .build())
 *                                 .enabled(false)
 *                                 .build()))
 *                         .textLogSettings(List.of(TextLogSettingProperty.builder()
 *                                 .destination(TextLogDestinationProperty.builder()
 *                                         .cloudWatch(CloudWatchLogGroupLogDestinationProperty.builder()
 *                                                 .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
 *                                                 .logPrefix("logPrefix")
 *                                                 .build())
 *                                         .build())
 *                                 .enabled(false)
 *                                 .build()))
 *                         .build())
 *                 .description("description")
 *                 .sentimentAnalysisSettings(sentimentAnalysisSettings)
 *                 .build())
 *         .testBotAliasTags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:09.128Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lex.CfnBotProps")
@software.amazon.jsii.Jsii.Proxy(CfnBotProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnBotProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Provides information on additional privacy protections Amazon Lex should use with the bot's data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDataPrivacy();

    /**
     * The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot.
     * <p>
     * A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.
     * <p>
     * You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getIdleSessionTtlInSeconds();

    /**
     * The name of the field to filter the list of bots.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The Amazon Resource Name (ARN) of the IAM role used to build and run the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * Indicates whether Amazon Lex V2 should automatically build the locales for the bot after a change.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoBuildBotLocales() {
        return null;
    }

    /**
     * The Amazon S3 location of files used to import a bot.
     * <p>
     * The files must be in the import format specified in <a href="https://docs.aws.amazon.com/lexv2/latest/dg/import-export-format.html">JSON format for importing and exporting</a> in the <em>Amazon Lex developer guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBotFileS3Location() {
        return null;
    }

    /**
     * A list of locales for the bot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBotLocales() {
        return null;
    }

    /**
     * A list of tags to add to the bot.
     * <p>
     * You can only add tags when you import a bot. You can't use the <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBotTags() {
        return null;
    }

    /**
     * The description of the version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Specifies configuration settings for the alias used to test the bot.
     * <p>
     * If the <code>TestBotAliasSettings</code> property is not specified, the settings are configured with default values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTestBotAliasSettings() {
        return null;
    }

    /**
     * A list of tags to add to the test alias for a bot.
     * <p>
     * You can only add tags when you import a bot. You can't use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the <code>TagResource</code> operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTestBotAliasTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnBotProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnBotProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnBotProps> {
        java.lang.Object dataPrivacy;
        java.lang.Number idleSessionTtlInSeconds;
        java.lang.String name;
        java.lang.String roleArn;
        java.lang.Object autoBuildBotLocales;
        java.lang.Object botFileS3Location;
        java.lang.Object botLocales;
        java.lang.Object botTags;
        java.lang.String description;
        java.lang.Object testBotAliasSettings;
        java.lang.Object testBotAliasTags;

        /**
         * Sets the value of {@link CfnBotProps#getDataPrivacy}
         * @param dataPrivacy Provides information on additional privacy protections Amazon Lex should use with the bot's data. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataPrivacy(java.lang.Object dataPrivacy) {
            this.dataPrivacy = dataPrivacy;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotProps#getIdleSessionTtlInSeconds}
         * @param idleSessionTtlInSeconds The time, in seconds, that Amazon Lex should keep information about a user's conversation with the bot. This parameter is required.
         *                                A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Lex deletes any data provided before the timeout.
         *                                <p>
         *                                You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idleSessionTtlInSeconds(java.lang.Number idleSessionTtlInSeconds) {
            this.idleSessionTtlInSeconds = idleSessionTtlInSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotProps#getName}
         * @param name The name of the field to filter the list of bots. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role used to build and run the bot. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotProps#getAutoBuildBotLocales}
         * @param autoBuildBotLocales Indicates whether Amazon Lex V2 should automatically build the locales for the bot after a change.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoBuildBotLocales(java.lang.Boolean autoBuildBotLocales) {
            this.autoBuildBotLocales = autoBuildBotLocales;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotProps#getAutoBuildBotLocales}
         * @param autoBuildBotLocales Indicates whether Amazon Lex V2 should automatically build the locales for the bot after a change.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoBuildBotLocales(software.amazon.awscdk.IResolvable autoBuildBotLocales) {
            this.autoBuildBotLocales = autoBuildBotLocales;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotProps#getBotFileS3Location}
         * @param botFileS3Location The Amazon S3 location of files used to import a bot.
         *                          The files must be in the import format specified in <a href="https://docs.aws.amazon.com/lexv2/latest/dg/import-export-format.html">JSON format for importing and exporting</a> in the <em>Amazon Lex developer guide.</em>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botFileS3Location(software.amazon.awscdk.services.lex.CfnBot.S3LocationProperty botFileS3Location) {
            this.botFileS3Location = botFileS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotProps#getBotFileS3Location}
         * @param botFileS3Location The Amazon S3 location of files used to import a bot.
         *                          The files must be in the import format specified in <a href="https://docs.aws.amazon.com/lexv2/latest/dg/import-export-format.html">JSON format for importing and exporting</a> in the <em>Amazon Lex developer guide.</em>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botFileS3Location(software.amazon.awscdk.IResolvable botFileS3Location) {
            this.botFileS3Location = botFileS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotProps#getBotLocales}
         * @param botLocales A list of locales for the bot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botLocales(software.amazon.awscdk.IResolvable botLocales) {
            this.botLocales = botLocales;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotProps#getBotLocales}
         * @param botLocales A list of locales for the bot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botLocales(java.util.List<? extends java.lang.Object> botLocales) {
            this.botLocales = botLocales;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotProps#getBotTags}
         * @param botTags A list of tags to add to the bot.
         *                You can only add tags when you import a bot. You can't use the <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botTags(software.amazon.awscdk.IResolvable botTags) {
            this.botTags = botTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotProps#getBotTags}
         * @param botTags A list of tags to add to the bot.
         *                You can only add tags when you import a bot. You can't use the <code>UpdateBot</code> operation to update tags. To update tags, use the <code>TagResource</code> operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder botTags(java.util.List<? extends java.lang.Object> botTags) {
            this.botTags = botTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotProps#getDescription}
         * @param description The description of the version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotProps#getTestBotAliasSettings}
         * @param testBotAliasSettings Specifies configuration settings for the alias used to test the bot.
         *                             If the <code>TestBotAliasSettings</code> property is not specified, the settings are configured with default values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testBotAliasSettings(software.amazon.awscdk.services.lex.CfnBot.TestBotAliasSettingsProperty testBotAliasSettings) {
            this.testBotAliasSettings = testBotAliasSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotProps#getTestBotAliasSettings}
         * @param testBotAliasSettings Specifies configuration settings for the alias used to test the bot.
         *                             If the <code>TestBotAliasSettings</code> property is not specified, the settings are configured with default values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testBotAliasSettings(software.amazon.awscdk.IResolvable testBotAliasSettings) {
            this.testBotAliasSettings = testBotAliasSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotProps#getTestBotAliasTags}
         * @param testBotAliasTags A list of tags to add to the test alias for a bot.
         *                         You can only add tags when you import a bot. You can't use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the <code>TagResource</code> operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testBotAliasTags(software.amazon.awscdk.IResolvable testBotAliasTags) {
            this.testBotAliasTags = testBotAliasTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnBotProps#getTestBotAliasTags}
         * @param testBotAliasTags A list of tags to add to the test alias for a bot.
         *                         You can only add tags when you import a bot. You can't use the <code>UpdateAlias</code> operation to update tags. To update tags on the test alias, use the <code>TagResource</code> operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testBotAliasTags(java.util.List<? extends java.lang.Object> testBotAliasTags) {
            this.testBotAliasTags = testBotAliasTags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnBotProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnBotProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnBotProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnBotProps {
        private final java.lang.Object dataPrivacy;
        private final java.lang.Number idleSessionTtlInSeconds;
        private final java.lang.String name;
        private final java.lang.String roleArn;
        private final java.lang.Object autoBuildBotLocales;
        private final java.lang.Object botFileS3Location;
        private final java.lang.Object botLocales;
        private final java.lang.Object botTags;
        private final java.lang.String description;
        private final java.lang.Object testBotAliasSettings;
        private final java.lang.Object testBotAliasTags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataPrivacy = software.amazon.jsii.Kernel.get(this, "dataPrivacy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.idleSessionTtlInSeconds = software.amazon.jsii.Kernel.get(this, "idleSessionTtlInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoBuildBotLocales = software.amazon.jsii.Kernel.get(this, "autoBuildBotLocales", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.botFileS3Location = software.amazon.jsii.Kernel.get(this, "botFileS3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.botLocales = software.amazon.jsii.Kernel.get(this, "botLocales", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.botTags = software.amazon.jsii.Kernel.get(this, "botTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.testBotAliasSettings = software.amazon.jsii.Kernel.get(this, "testBotAliasSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.testBotAliasTags = software.amazon.jsii.Kernel.get(this, "testBotAliasTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataPrivacy = java.util.Objects.requireNonNull(builder.dataPrivacy, "dataPrivacy is required");
            this.idleSessionTtlInSeconds = java.util.Objects.requireNonNull(builder.idleSessionTtlInSeconds, "idleSessionTtlInSeconds is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.autoBuildBotLocales = builder.autoBuildBotLocales;
            this.botFileS3Location = builder.botFileS3Location;
            this.botLocales = builder.botLocales;
            this.botTags = builder.botTags;
            this.description = builder.description;
            this.testBotAliasSettings = builder.testBotAliasSettings;
            this.testBotAliasTags = builder.testBotAliasTags;
        }

        @Override
        public final java.lang.Object getDataPrivacy() {
            return this.dataPrivacy;
        }

        @Override
        public final java.lang.Number getIdleSessionTtlInSeconds() {
            return this.idleSessionTtlInSeconds;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getAutoBuildBotLocales() {
            return this.autoBuildBotLocales;
        }

        @Override
        public final java.lang.Object getBotFileS3Location() {
            return this.botFileS3Location;
        }

        @Override
        public final java.lang.Object getBotLocales() {
            return this.botLocales;
        }

        @Override
        public final java.lang.Object getBotTags() {
            return this.botTags;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getTestBotAliasSettings() {
            return this.testBotAliasSettings;
        }

        @Override
        public final java.lang.Object getTestBotAliasTags() {
            return this.testBotAliasTags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataPrivacy", om.valueToTree(this.getDataPrivacy()));
            data.set("idleSessionTtlInSeconds", om.valueToTree(this.getIdleSessionTtlInSeconds()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getAutoBuildBotLocales() != null) {
                data.set("autoBuildBotLocales", om.valueToTree(this.getAutoBuildBotLocales()));
            }
            if (this.getBotFileS3Location() != null) {
                data.set("botFileS3Location", om.valueToTree(this.getBotFileS3Location()));
            }
            if (this.getBotLocales() != null) {
                data.set("botLocales", om.valueToTree(this.getBotLocales()));
            }
            if (this.getBotTags() != null) {
                data.set("botTags", om.valueToTree(this.getBotTags()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getTestBotAliasSettings() != null) {
                data.set("testBotAliasSettings", om.valueToTree(this.getTestBotAliasSettings()));
            }
            if (this.getTestBotAliasTags() != null) {
                data.set("testBotAliasTags", om.valueToTree(this.getTestBotAliasTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lex.CfnBotProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnBotProps.Jsii$Proxy that = (CfnBotProps.Jsii$Proxy) o;

            if (!dataPrivacy.equals(that.dataPrivacy)) return false;
            if (!idleSessionTtlInSeconds.equals(that.idleSessionTtlInSeconds)) return false;
            if (!name.equals(that.name)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.autoBuildBotLocales != null ? !this.autoBuildBotLocales.equals(that.autoBuildBotLocales) : that.autoBuildBotLocales != null) return false;
            if (this.botFileS3Location != null ? !this.botFileS3Location.equals(that.botFileS3Location) : that.botFileS3Location != null) return false;
            if (this.botLocales != null ? !this.botLocales.equals(that.botLocales) : that.botLocales != null) return false;
            if (this.botTags != null ? !this.botTags.equals(that.botTags) : that.botTags != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.testBotAliasSettings != null ? !this.testBotAliasSettings.equals(that.testBotAliasSettings) : that.testBotAliasSettings != null) return false;
            return this.testBotAliasTags != null ? this.testBotAliasTags.equals(that.testBotAliasTags) : that.testBotAliasTags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataPrivacy.hashCode();
            result = 31 * result + (this.idleSessionTtlInSeconds.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.autoBuildBotLocales != null ? this.autoBuildBotLocales.hashCode() : 0);
            result = 31 * result + (this.botFileS3Location != null ? this.botFileS3Location.hashCode() : 0);
            result = 31 * result + (this.botLocales != null ? this.botLocales.hashCode() : 0);
            result = 31 * result + (this.botTags != null ? this.botTags.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.testBotAliasSettings != null ? this.testBotAliasSettings.hashCode() : 0);
            result = 31 * result + (this.testBotAliasTags != null ? this.testBotAliasTags.hashCode() : 0);
            return result;
        }
    }
}
