package software.amazon.awscdk.services.lambda;

/**
 * Properties for defining a `CfnLayerVersionPermission`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * CfnLayerVersionPermissionProps cfnLayerVersionPermissionProps = CfnLayerVersionPermissionProps.builder()
 *         .action("action")
 *         .layerVersionArn("layerVersionArn")
 *         .principal("principal")
 *         // the properties below are optional
 *         .organizationId("organizationId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:08.924Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CfnLayerVersionPermissionProps")
@software.amazon.jsii.Jsii.Proxy(CfnLayerVersionPermissionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLayerVersionPermissionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The API action that grants access to the layer.
     * <p>
     * For example, <code>lambda:GetLayerVersion</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAction();

    /**
     * The name or Amazon Resource Name (ARN) of the layer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLayerVersionArn();

    /**
     * An account ID, or `*` to grant layer usage permission to all accounts in an organization, or all AWS accounts (if `organizationId` is not specified).
     * <p>
     * For the last case, make sure that you really do want all AWS accounts to have usage permission to this layer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrincipal();

    /**
     * With the principal set to `*` , grant permission to all accounts in the specified organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOrganizationId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLayerVersionPermissionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLayerVersionPermissionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLayerVersionPermissionProps> {
        java.lang.String action;
        java.lang.String layerVersionArn;
        java.lang.String principal;
        java.lang.String organizationId;

        /**
         * Sets the value of {@link CfnLayerVersionPermissionProps#getAction}
         * @param action The API action that grants access to the layer. This parameter is required.
         *               For example, <code>lambda:GetLayerVersion</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(java.lang.String action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerVersionPermissionProps#getLayerVersionArn}
         * @param layerVersionArn The name or Amazon Resource Name (ARN) of the layer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder layerVersionArn(java.lang.String layerVersionArn) {
            this.layerVersionArn = layerVersionArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerVersionPermissionProps#getPrincipal}
         * @param principal An account ID, or `*` to grant layer usage permission to all accounts in an organization, or all AWS accounts (if `organizationId` is not specified). This parameter is required.
         *                  For the last case, make sure that you really do want all AWS accounts to have usage permission to this layer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principal(java.lang.String principal) {
            this.principal = principal;
            return this;
        }

        /**
         * Sets the value of {@link CfnLayerVersionPermissionProps#getOrganizationId}
         * @param organizationId With the principal set to `*` , grant permission to all accounts in the specified organization.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationId(java.lang.String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLayerVersionPermissionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLayerVersionPermissionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLayerVersionPermissionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLayerVersionPermissionProps {
        private final java.lang.String action;
        private final java.lang.String layerVersionArn;
        private final java.lang.String principal;
        private final java.lang.String organizationId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.layerVersionArn = software.amazon.jsii.Kernel.get(this, "layerVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.organizationId = software.amazon.jsii.Kernel.get(this, "organizationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
            this.layerVersionArn = java.util.Objects.requireNonNull(builder.layerVersionArn, "layerVersionArn is required");
            this.principal = java.util.Objects.requireNonNull(builder.principal, "principal is required");
            this.organizationId = builder.organizationId;
        }

        @Override
        public final java.lang.String getAction() {
            return this.action;
        }

        @Override
        public final java.lang.String getLayerVersionArn() {
            return this.layerVersionArn;
        }

        @Override
        public final java.lang.String getPrincipal() {
            return this.principal;
        }

        @Override
        public final java.lang.String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("action", om.valueToTree(this.getAction()));
            data.set("layerVersionArn", om.valueToTree(this.getLayerVersionArn()));
            data.set("principal", om.valueToTree(this.getPrincipal()));
            if (this.getOrganizationId() != null) {
                data.set("organizationId", om.valueToTree(this.getOrganizationId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.CfnLayerVersionPermissionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLayerVersionPermissionProps.Jsii$Proxy that = (CfnLayerVersionPermissionProps.Jsii$Proxy) o;

            if (!action.equals(that.action)) return false;
            if (!layerVersionArn.equals(that.layerVersionArn)) return false;
            if (!principal.equals(that.principal)) return false;
            return this.organizationId != null ? this.organizationId.equals(that.organizationId) : that.organizationId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.action.hashCode();
            result = 31 * result + (this.layerVersionArn.hashCode());
            result = 31 * result + (this.principal.hashCode());
            result = 31 * result + (this.organizationId != null ? this.organizationId.hashCode() : 0);
            return result;
        }
    }
}
