package software.amazon.awscdk.services.kinesisanalyticsv2;

/**
 * Properties for defining a `CfnApplicationCloudWatchLoggingOption`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
 * CfnApplicationCloudWatchLoggingOptionProps cfnApplicationCloudWatchLoggingOptionProps = CfnApplicationCloudWatchLoggingOptionProps.builder()
 *         .applicationName("applicationName")
 *         .cloudWatchLoggingOption(CloudWatchLoggingOptionProperty.builder()
 *                 .logStreamArn("logStreamArn")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:08.781Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplicationCloudWatchLoggingOptionProps")
@software.amazon.jsii.Jsii.Proxy(CfnApplicationCloudWatchLoggingOptionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApplicationCloudWatchLoggingOptionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationName();

    /**
     * Provides a description of Amazon CloudWatch logging options, including the log stream Amazon Resource Name (ARN).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getCloudWatchLoggingOption();

    /**
     * @return a {@link Builder} of {@link CfnApplicationCloudWatchLoggingOptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApplicationCloudWatchLoggingOptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApplicationCloudWatchLoggingOptionProps> {
        java.lang.String applicationName;
        java.lang.Object cloudWatchLoggingOption;

        /**
         * Sets the value of {@link CfnApplicationCloudWatchLoggingOptionProps#getApplicationName}
         * @param applicationName The name of the application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationName(java.lang.String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationCloudWatchLoggingOptionProps#getCloudWatchLoggingOption}
         * @param cloudWatchLoggingOption Provides a description of Amazon CloudWatch logging options, including the log stream Amazon Resource Name (ARN). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLoggingOption(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplicationCloudWatchLoggingOption.CloudWatchLoggingOptionProperty cloudWatchLoggingOption) {
            this.cloudWatchLoggingOption = cloudWatchLoggingOption;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationCloudWatchLoggingOptionProps#getCloudWatchLoggingOption}
         * @param cloudWatchLoggingOption Provides a description of Amazon CloudWatch logging options, including the log stream Amazon Resource Name (ARN). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLoggingOption(software.amazon.awscdk.IResolvable cloudWatchLoggingOption) {
            this.cloudWatchLoggingOption = cloudWatchLoggingOption;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApplicationCloudWatchLoggingOptionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApplicationCloudWatchLoggingOptionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApplicationCloudWatchLoggingOptionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApplicationCloudWatchLoggingOptionProps {
        private final java.lang.String applicationName;
        private final java.lang.Object cloudWatchLoggingOption;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationName = software.amazon.jsii.Kernel.get(this, "applicationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cloudWatchLoggingOption = software.amazon.jsii.Kernel.get(this, "cloudWatchLoggingOption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationName = java.util.Objects.requireNonNull(builder.applicationName, "applicationName is required");
            this.cloudWatchLoggingOption = java.util.Objects.requireNonNull(builder.cloudWatchLoggingOption, "cloudWatchLoggingOption is required");
        }

        @Override
        public final java.lang.String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final java.lang.Object getCloudWatchLoggingOption() {
            return this.cloudWatchLoggingOption;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationName", om.valueToTree(this.getApplicationName()));
            data.set("cloudWatchLoggingOption", om.valueToTree(this.getCloudWatchLoggingOption()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplicationCloudWatchLoggingOptionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApplicationCloudWatchLoggingOptionProps.Jsii$Proxy that = (CfnApplicationCloudWatchLoggingOptionProps.Jsii$Proxy) o;

            if (!applicationName.equals(that.applicationName)) return false;
            return this.cloudWatchLoggingOption.equals(that.cloudWatchLoggingOption);
        }

        @Override
        public final int hashCode() {
            int result = this.applicationName.hashCode();
            result = 31 * result + (this.cloudWatchLoggingOption.hashCode());
            return result;
        }
    }
}
