package software.amazon.awscdk.services.iotevents;

/**
 * Properties for defining a `CfnInput`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotevents.*;
 * CfnInputProps cfnInputProps = CfnInputProps.builder()
 *         .inputDefinition(InputDefinitionProperty.builder()
 *                 .attributes(List.of(AttributeProperty.builder()
 *                         .jsonPath("jsonPath")
 *                         .build()))
 *                 .build())
 *         // the properties below are optional
 *         .inputDescription("inputDescription")
 *         .inputName("inputName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:08.543Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotevents.CfnInputProps")
@software.amazon.jsii.Jsii.Proxy(CfnInputProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInputProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The definition of the input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getInputDefinition();

    /**
     * A brief description of the input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInputDescription() {
        return null;
    }

    /**
     * The name of the input.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInputName() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInputProps> {
        java.lang.Object inputDefinition;
        java.lang.String inputDescription;
        java.lang.String inputName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnInputProps#getInputDefinition}
         * @param inputDefinition The definition of the input. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputDefinition(software.amazon.awscdk.services.iotevents.CfnInput.InputDefinitionProperty inputDefinition) {
            this.inputDefinition = inputDefinition;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getInputDefinition}
         * @param inputDefinition The definition of the input. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputDefinition(software.amazon.awscdk.IResolvable inputDefinition) {
            this.inputDefinition = inputDefinition;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getInputDescription}
         * @param inputDescription A brief description of the input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputDescription(java.lang.String inputDescription) {
            this.inputDescription = inputDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getInputName}
         * @param inputName The name of the input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputName(java.lang.String inputName) {
            this.inputName = inputName;
            return this;
        }

        /**
         * Sets the value of {@link CfnInputProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInputProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInputProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInputProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInputProps {
        private final java.lang.Object inputDefinition;
        private final java.lang.String inputDescription;
        private final java.lang.String inputName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.inputDefinition = software.amazon.jsii.Kernel.get(this, "inputDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.inputDescription = software.amazon.jsii.Kernel.get(this, "inputDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.inputName = software.amazon.jsii.Kernel.get(this, "inputName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.inputDefinition = java.util.Objects.requireNonNull(builder.inputDefinition, "inputDefinition is required");
            this.inputDescription = builder.inputDescription;
            this.inputName = builder.inputName;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getInputDefinition() {
            return this.inputDefinition;
        }

        @Override
        public final java.lang.String getInputDescription() {
            return this.inputDescription;
        }

        @Override
        public final java.lang.String getInputName() {
            return this.inputName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("inputDefinition", om.valueToTree(this.getInputDefinition()));
            if (this.getInputDescription() != null) {
                data.set("inputDescription", om.valueToTree(this.getInputDescription()));
            }
            if (this.getInputName() != null) {
                data.set("inputName", om.valueToTree(this.getInputName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotevents.CfnInputProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInputProps.Jsii$Proxy that = (CfnInputProps.Jsii$Proxy) o;

            if (!inputDefinition.equals(that.inputDefinition)) return false;
            if (this.inputDescription != null ? !this.inputDescription.equals(that.inputDescription) : that.inputDescription != null) return false;
            if (this.inputName != null ? !this.inputName.equals(that.inputName) : that.inputName != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.inputDefinition.hashCode();
            result = 31 * result + (this.inputDescription != null ? this.inputDescription.hashCode() : 0);
            result = 31 * result + (this.inputName != null ? this.inputName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
