package software.amazon.awscdk.services.iot;

/**
 * Properties for defining a `CfnAccountAuditConfiguration`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnAccountAuditConfigurationProps cfnAccountAuditConfigurationProps = CfnAccountAuditConfigurationProps.builder()
 *         .accountId("accountId")
 *         .auditCheckConfigurations(AuditCheckConfigurationsProperty.builder()
 *                 .authenticatedCognitoRoleOverlyPermissiveCheck(AuditCheckConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .caCertificateExpiringCheck(AuditCheckConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .caCertificateKeyQualityCheck(AuditCheckConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .conflictingClientIdsCheck(AuditCheckConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .deviceCertificateExpiringCheck(AuditCheckConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .deviceCertificateKeyQualityCheck(AuditCheckConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .deviceCertificateSharedCheck(AuditCheckConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .iotPolicyOverlyPermissiveCheck(AuditCheckConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .iotRoleAliasAllowsAccessToUnusedServicesCheck(AuditCheckConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .iotRoleAliasOverlyPermissiveCheck(AuditCheckConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .loggingDisabledCheck(AuditCheckConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .revokedCaCertificateStillActiveCheck(AuditCheckConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .revokedDeviceCertificateStillActiveCheck(AuditCheckConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .unauthenticatedCognitoRoleOverlyPermissiveCheck(AuditCheckConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .build())
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .auditNotificationTargetConfigurations(AuditNotificationTargetConfigurationsProperty.builder()
 *                 .sns(AuditNotificationTargetProperty.builder()
 *                         .enabled(false)
 *                         .roleArn("roleArn")
 *                         .targetArn("targetArn")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:08.356Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnAccountAuditConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnAccountAuditConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAccountAuditConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the account.
     * <p>
     * You can use the expression <code>!Sub "${AWS::AccountId}"</code> to use your account ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccountId();

    /**
     * Specifies which audit checks are enabled and disabled for this account.
     * <p>
     * Some data collection might start immediately when certain checks are enabled. When a check is disabled, any data collected so far in relation to the check is deleted. To disable a check, set the value of the <code>Enabled:</code> key to <code>false</code> .
     * <p>
     * If an enabled check is removed from the template, it will also be disabled.
     * <p>
     * You can't disable a check if it's used by any scheduled audit. You must delete the check from the scheduled audit or delete the scheduled audit itself to disable the check.
     * <p>
     * For more information on avialbe auidt checks see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html">AWS::IoT::AccountAuditConfiguration AuditCheckConfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAuditCheckConfigurations();

    /**
     * The Amazon Resource Name (ARN) of the role that grants permission to AWS IoT to access information about your devices, policies, certificates, and other items as required when performing an audit.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * Information about the targets to which audit notifications are sent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAuditNotificationTargetConfigurations() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAccountAuditConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAccountAuditConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAccountAuditConfigurationProps> {
        java.lang.String accountId;
        java.lang.Object auditCheckConfigurations;
        java.lang.String roleArn;
        java.lang.Object auditNotificationTargetConfigurations;

        /**
         * Sets the value of {@link CfnAccountAuditConfigurationProps#getAccountId}
         * @param accountId The ID of the account. This parameter is required.
         *                  You can use the expression <code>!Sub "${AWS::AccountId}"</code> to use your account ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountId(java.lang.String accountId) {
            this.accountId = accountId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccountAuditConfigurationProps#getAuditCheckConfigurations}
         * @param auditCheckConfigurations Specifies which audit checks are enabled and disabled for this account. This parameter is required.
         *                                 Some data collection might start immediately when certain checks are enabled. When a check is disabled, any data collected so far in relation to the check is deleted. To disable a check, set the value of the <code>Enabled:</code> key to <code>false</code> .
         *                                 <p>
         *                                 If an enabled check is removed from the template, it will also be disabled.
         *                                 <p>
         *                                 You can't disable a check if it's used by any scheduled audit. You must delete the check from the scheduled audit or delete the scheduled audit itself to disable the check.
         *                                 <p>
         *                                 For more information on avialbe auidt checks see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html">AWS::IoT::AccountAuditConfiguration AuditCheckConfigurations</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder auditCheckConfigurations(software.amazon.awscdk.services.iot.CfnAccountAuditConfiguration.AuditCheckConfigurationsProperty auditCheckConfigurations) {
            this.auditCheckConfigurations = auditCheckConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccountAuditConfigurationProps#getAuditCheckConfigurations}
         * @param auditCheckConfigurations Specifies which audit checks are enabled and disabled for this account. This parameter is required.
         *                                 Some data collection might start immediately when certain checks are enabled. When a check is disabled, any data collected so far in relation to the check is deleted. To disable a check, set the value of the <code>Enabled:</code> key to <code>false</code> .
         *                                 <p>
         *                                 If an enabled check is removed from the template, it will also be disabled.
         *                                 <p>
         *                                 You can't disable a check if it's used by any scheduled audit. You must delete the check from the scheduled audit or delete the scheduled audit itself to disable the check.
         *                                 <p>
         *                                 For more information on avialbe auidt checks see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html">AWS::IoT::AccountAuditConfiguration AuditCheckConfigurations</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder auditCheckConfigurations(software.amazon.awscdk.IResolvable auditCheckConfigurations) {
            this.auditCheckConfigurations = auditCheckConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccountAuditConfigurationProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the role that grants permission to AWS IoT to access information about your devices, policies, certificates, and other items as required when performing an audit. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccountAuditConfigurationProps#getAuditNotificationTargetConfigurations}
         * @param auditNotificationTargetConfigurations Information about the targets to which audit notifications are sent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder auditNotificationTargetConfigurations(software.amazon.awscdk.services.iot.CfnAccountAuditConfiguration.AuditNotificationTargetConfigurationsProperty auditNotificationTargetConfigurations) {
            this.auditNotificationTargetConfigurations = auditNotificationTargetConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccountAuditConfigurationProps#getAuditNotificationTargetConfigurations}
         * @param auditNotificationTargetConfigurations Information about the targets to which audit notifications are sent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder auditNotificationTargetConfigurations(software.amazon.awscdk.IResolvable auditNotificationTargetConfigurations) {
            this.auditNotificationTargetConfigurations = auditNotificationTargetConfigurations;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAccountAuditConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAccountAuditConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAccountAuditConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAccountAuditConfigurationProps {
        private final java.lang.String accountId;
        private final java.lang.Object auditCheckConfigurations;
        private final java.lang.String roleArn;
        private final java.lang.Object auditNotificationTargetConfigurations;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accountId = software.amazon.jsii.Kernel.get(this, "accountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.auditCheckConfigurations = software.amazon.jsii.Kernel.get(this, "auditCheckConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.auditNotificationTargetConfigurations = software.amazon.jsii.Kernel.get(this, "auditNotificationTargetConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accountId = java.util.Objects.requireNonNull(builder.accountId, "accountId is required");
            this.auditCheckConfigurations = java.util.Objects.requireNonNull(builder.auditCheckConfigurations, "auditCheckConfigurations is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.auditNotificationTargetConfigurations = builder.auditNotificationTargetConfigurations;
        }

        @Override
        public final java.lang.String getAccountId() {
            return this.accountId;
        }

        @Override
        public final java.lang.Object getAuditCheckConfigurations() {
            return this.auditCheckConfigurations;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getAuditNotificationTargetConfigurations() {
            return this.auditNotificationTargetConfigurations;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accountId", om.valueToTree(this.getAccountId()));
            data.set("auditCheckConfigurations", om.valueToTree(this.getAuditCheckConfigurations()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getAuditNotificationTargetConfigurations() != null) {
                data.set("auditNotificationTargetConfigurations", om.valueToTree(this.getAuditNotificationTargetConfigurations()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnAccountAuditConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAccountAuditConfigurationProps.Jsii$Proxy that = (CfnAccountAuditConfigurationProps.Jsii$Proxy) o;

            if (!accountId.equals(that.accountId)) return false;
            if (!auditCheckConfigurations.equals(that.auditCheckConfigurations)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            return this.auditNotificationTargetConfigurations != null ? this.auditNotificationTargetConfigurations.equals(that.auditNotificationTargetConfigurations) : that.auditNotificationTargetConfigurations == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accountId.hashCode();
            result = 31 * result + (this.auditCheckConfigurations.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.auditNotificationTargetConfigurations != null ? this.auditNotificationTargetConfigurations.hashCode() : 0);
            return result;
        }
    }
}
