package software.amazon.awscdk.services.globalaccelerator;

/**
 * Override specific listener ports used to route traffic to endpoints that are part of an endpoint group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.globalaccelerator.*;
 * PortOverride portOverride = PortOverride.builder()
 *         .endpointPort(123)
 *         .listenerPort(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:08.031Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_globalaccelerator.PortOverride")
@software.amazon.jsii.Jsii.Proxy(PortOverride.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PortOverride extends software.amazon.jsii.JsiiSerializable {

    /**
     * The endpoint port that you want a listener port to be mapped to.
     * <p>
     * This is the port on the endpoint, such as the Application Load Balancer or Amazon EC2 instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getEndpointPort();

    /**
     * The listener port that you want to map to a specific endpoint port.
     * <p>
     * This is the port that user traffic arrives to the Global Accelerator on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getListenerPort();

    /**
     * @return a {@link Builder} of {@link PortOverride}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PortOverride}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PortOverride> {
        java.lang.Number endpointPort;
        java.lang.Number listenerPort;

        /**
         * Sets the value of {@link PortOverride#getEndpointPort}
         * @param endpointPort The endpoint port that you want a listener port to be mapped to. This parameter is required.
         *                     This is the port on the endpoint, such as the Application Load Balancer or Amazon EC2 instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointPort(java.lang.Number endpointPort) {
            this.endpointPort = endpointPort;
            return this;
        }

        /**
         * Sets the value of {@link PortOverride#getListenerPort}
         * @param listenerPort The listener port that you want to map to a specific endpoint port. This parameter is required.
         *                     This is the port that user traffic arrives to the Global Accelerator on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listenerPort(java.lang.Number listenerPort) {
            this.listenerPort = listenerPort;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PortOverride}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PortOverride build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PortOverride}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PortOverride {
        private final java.lang.Number endpointPort;
        private final java.lang.Number listenerPort;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.endpointPort = software.amazon.jsii.Kernel.get(this, "endpointPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.listenerPort = software.amazon.jsii.Kernel.get(this, "listenerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.endpointPort = java.util.Objects.requireNonNull(builder.endpointPort, "endpointPort is required");
            this.listenerPort = java.util.Objects.requireNonNull(builder.listenerPort, "listenerPort is required");
        }

        @Override
        public final java.lang.Number getEndpointPort() {
            return this.endpointPort;
        }

        @Override
        public final java.lang.Number getListenerPort() {
            return this.listenerPort;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("endpointPort", om.valueToTree(this.getEndpointPort()));
            data.set("listenerPort", om.valueToTree(this.getListenerPort()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_globalaccelerator.PortOverride"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PortOverride.Jsii$Proxy that = (PortOverride.Jsii$Proxy) o;

            if (!endpointPort.equals(that.endpointPort)) return false;
            return this.listenerPort.equals(that.listenerPort);
        }

        @Override
        public final int hashCode() {
            int result = this.endpointPort.hashCode();
            result = 31 * result + (this.listenerPort.hashCode());
            return result;
        }
    }
}
