package software.amazon.awscdk.services.fsx;

/**
 * A CloudFormation `AWS::FSx::StorageVirtualMachine`.
 * <p>
 * Creates a storage virtual machine (SVM) for an Amazon FSx for ONTAP file system.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.fsx.*;
 * CfnStorageVirtualMachine cfnStorageVirtualMachine = CfnStorageVirtualMachine.Builder.create(this, "MyCfnStorageVirtualMachine")
 *         .fileSystemId("fileSystemId")
 *         .name("name")
 *         // the properties below are optional
 *         .activeDirectoryConfiguration(ActiveDirectoryConfigurationProperty.builder()
 *                 .netBiosName("netBiosName")
 *                 .selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfigurationProperty.builder()
 *                         .dnsIps(List.of("dnsIps"))
 *                         .domainName("domainName")
 *                         .fileSystemAdministratorsGroup("fileSystemAdministratorsGroup")
 *                         .organizationalUnitDistinguishedName("organizationalUnitDistinguishedName")
 *                         .password("password")
 *                         .userName("userName")
 *                         .build())
 *                 .build())
 *         .rootVolumeSecurityStyle("rootVolumeSecurityStyle")
 *         .svmAdminPassword("svmAdminPassword")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:07.961Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnStorageVirtualMachine")
public class CfnStorageVirtualMachine extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnStorageVirtualMachine(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStorageVirtualMachine(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.fsx.CfnStorageVirtualMachine.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::FSx::StorageVirtualMachine`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStorageVirtualMachine(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.fsx.CfnStorageVirtualMachineProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the storage virtual machine's Amazon Resource Name (ARN).
     * <p>
     * Example: <code>arn:aws:fsx:us-east-2:111111111111:storage-virtual-machine/fs-0123456789abcdef1/svm-01234567890123456</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the storgage virtual machine's system generated ID.
     * <p>
     * Example: <code>svm-0123456789abcedf1</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStorageVirtualMachineId() {
        return software.amazon.jsii.Kernel.get(this, "attrStorageVirtualMachineId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the storage virtual machine's system generated unique identifier (UUID).
     * <p>
     * Example: <code>abcd0123-cd45-ef67-11aa-1111aaaa23bc</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUuid() {
        return software.amazon.jsii.Kernel.get(this, "attrUuid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Specifies the FSx for ONTAP file system on which to create the SVM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId() {
        return software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the FSx for ONTAP file system on which to create the SVM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFileSystemId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "fileSystemId", java.util.Objects.requireNonNull(value, "fileSystemId is required"));
    }

    /**
     * The name of the SVM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the SVM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Describes the Microsoft Active Directory configuration to which the SVM is joined, if applicable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getActiveDirectoryConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "activeDirectoryConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes the Microsoft Active Directory configuration to which the SVM is joined, if applicable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActiveDirectoryConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fsx.CfnStorageVirtualMachine.ActiveDirectoryConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "activeDirectoryConfiguration", value);
    }

    /**
     * Describes the Microsoft Active Directory configuration to which the SVM is joined, if applicable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActiveDirectoryConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "activeDirectoryConfiguration", value);
    }

    /**
     * The security style of the root volume of the SVM. Specify one of the following values:.
     * <p>
     * <ul>
     * <li><code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS clients, and an application accessing the data uses a UNIX user as the service account.</li>
     * <li><code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB clients, and an application accessing the data uses a Windows user as the service account.</li>
     * <li><code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users consist of both NFS and SMB clients.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRootVolumeSecurityStyle() {
        return software.amazon.jsii.Kernel.get(this, "rootVolumeSecurityStyle", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The security style of the root volume of the SVM. Specify one of the following values:.
     * <p>
     * <ul>
     * <li><code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS clients, and an application accessing the data uses a UNIX user as the service account.</li>
     * <li><code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB clients, and an application accessing the data uses a Windows user as the service account.</li>
     * <li><code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users consist of both NFS and SMB clients.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRootVolumeSecurityStyle(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "rootVolumeSecurityStyle", value);
    }

    /**
     * Specifies the password to use when logging on to the SVM using a secure shell (SSH) connection to the SVM's management endpoint.
     * <p>
     * Doing so enables you to manage the SVM using the NetApp ONTAP CLI or REST API. If you do not specify a password, you can still use the file system's <code>fsxadmin</code> user to manage the SVM. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-resources-ontap-apps.html#vsadmin-ontap-cli">Managing SVMs using the NetApp ONTAP CLI</a> in the <em>FSx for ONTAP User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSvmAdminPassword() {
        return software.amazon.jsii.Kernel.get(this, "svmAdminPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the password to use when logging on to the SVM using a secure shell (SSH) connection to the SVM's management endpoint.
     * <p>
     * Doing so enables you to manage the SVM using the NetApp ONTAP CLI or REST API. If you do not specify a password, you can still use the file system's <code>fsxadmin</code> user to manage the SVM. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-resources-ontap-apps.html#vsadmin-ontap-cli">Managing SVMs using the NetApp ONTAP CLI</a> in the <em>FSx for ONTAP User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSvmAdminPassword(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "svmAdminPassword", value);
    }
    /**
     * Describes the self-managed Microsoft Active Directory to which you want to join the SVM.
     * <p>
     * Joining an Active Directory provides user authentication and access control for SMB clients, including Microsoft Windows and macOS client accessing the file system.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * ActiveDirectoryConfigurationProperty activeDirectoryConfigurationProperty = ActiveDirectoryConfigurationProperty.builder()
     *         .netBiosName("netBiosName")
     *         .selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfigurationProperty.builder()
     *                 .dnsIps(List.of("dnsIps"))
     *                 .domainName("domainName")
     *                 .fileSystemAdministratorsGroup("fileSystemAdministratorsGroup")
     *                 .organizationalUnitDistinguishedName("organizationalUnitDistinguishedName")
     *                 .password("password")
     *                 .userName("userName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnStorageVirtualMachine.ActiveDirectoryConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ActiveDirectoryConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActiveDirectoryConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The NetBIOS name of the Active Directory computer object that will be created for your SVM.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNetBiosName() {
            return null;
        }

        /**
         * The configuration that Amazon FSx uses to join the ONTAP storage virtual machine (SVM) to your self-managed (including on-premises) Microsoft Active Directory (AD) directory.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSelfManagedActiveDirectoryConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActiveDirectoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActiveDirectoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActiveDirectoryConfigurationProperty> {
            java.lang.String netBiosName;
            java.lang.Object selfManagedActiveDirectoryConfiguration;

            /**
             * Sets the value of {@link ActiveDirectoryConfigurationProperty#getNetBiosName}
             * @param netBiosName The NetBIOS name of the Active Directory computer object that will be created for your SVM.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder netBiosName(java.lang.String netBiosName) {
                this.netBiosName = netBiosName;
                return this;
            }

            /**
             * Sets the value of {@link ActiveDirectoryConfigurationProperty#getSelfManagedActiveDirectoryConfiguration}
             * @param selfManagedActiveDirectoryConfiguration The configuration that Amazon FSx uses to join the ONTAP storage virtual machine (SVM) to your self-managed (including on-premises) Microsoft Active Directory (AD) directory.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selfManagedActiveDirectoryConfiguration(software.amazon.awscdk.services.fsx.CfnStorageVirtualMachine.SelfManagedActiveDirectoryConfigurationProperty selfManagedActiveDirectoryConfiguration) {
                this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ActiveDirectoryConfigurationProperty#getSelfManagedActiveDirectoryConfiguration}
             * @param selfManagedActiveDirectoryConfiguration The configuration that Amazon FSx uses to join the ONTAP storage virtual machine (SVM) to your self-managed (including on-premises) Microsoft Active Directory (AD) directory.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selfManagedActiveDirectoryConfiguration(software.amazon.awscdk.IResolvable selfManagedActiveDirectoryConfiguration) {
                this.selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActiveDirectoryConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActiveDirectoryConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActiveDirectoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActiveDirectoryConfigurationProperty {
            private final java.lang.String netBiosName;
            private final java.lang.Object selfManagedActiveDirectoryConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.netBiosName = software.amazon.jsii.Kernel.get(this, "netBiosName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.selfManagedActiveDirectoryConfiguration = software.amazon.jsii.Kernel.get(this, "selfManagedActiveDirectoryConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.netBiosName = builder.netBiosName;
                this.selfManagedActiveDirectoryConfiguration = builder.selfManagedActiveDirectoryConfiguration;
            }

            @Override
            public final java.lang.String getNetBiosName() {
                return this.netBiosName;
            }

            @Override
            public final java.lang.Object getSelfManagedActiveDirectoryConfiguration() {
                return this.selfManagedActiveDirectoryConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNetBiosName() != null) {
                    data.set("netBiosName", om.valueToTree(this.getNetBiosName()));
                }
                if (this.getSelfManagedActiveDirectoryConfiguration() != null) {
                    data.set("selfManagedActiveDirectoryConfiguration", om.valueToTree(this.getSelfManagedActiveDirectoryConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnStorageVirtualMachine.ActiveDirectoryConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActiveDirectoryConfigurationProperty.Jsii$Proxy that = (ActiveDirectoryConfigurationProperty.Jsii$Proxy) o;

                if (this.netBiosName != null ? !this.netBiosName.equals(that.netBiosName) : that.netBiosName != null) return false;
                return this.selfManagedActiveDirectoryConfiguration != null ? this.selfManagedActiveDirectoryConfiguration.equals(that.selfManagedActiveDirectoryConfiguration) : that.selfManagedActiveDirectoryConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.netBiosName != null ? this.netBiosName.hashCode() : 0;
                result = 31 * result + (this.selfManagedActiveDirectoryConfiguration != null ? this.selfManagedActiveDirectoryConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration that Amazon FSx uses to join a FSx for Windows File Server file system or an ONTAP storage virtual machine (SVM) to a self-managed (including on-premises) Microsoft Active Directory (AD) directory.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html">Using Amazon FSx with your self-managed Microsoft Active Directory</a> or <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing SVMs</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fsx.*;
     * SelfManagedActiveDirectoryConfigurationProperty selfManagedActiveDirectoryConfigurationProperty = SelfManagedActiveDirectoryConfigurationProperty.builder()
     *         .dnsIps(List.of("dnsIps"))
     *         .domainName("domainName")
     *         .fileSystemAdministratorsGroup("fileSystemAdministratorsGroup")
     *         .organizationalUnitDistinguishedName("organizationalUnitDistinguishedName")
     *         .password("password")
     *         .userName("userName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnStorageVirtualMachine.SelfManagedActiveDirectoryConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SelfManagedActiveDirectoryConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SelfManagedActiveDirectoryConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDnsIps() {
            return null;
        }

        /**
         * The fully qualified domain name of the self-managed AD directory, such as `corp.example.com` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
            return null;
        }

        /**
         * (Optional) The name of the domain group whose members are granted administrative privileges for the file system.
         * <p>
         * Administrative privileges include taking ownership of files and folders, setting audit controls (audit ACLs) on files and folders, and administering the file system remotely by using the FSx Remote PowerShell. The group that you specify must already exist in your domain. If you don't provide one, your AD domain's Domain Admins group is used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFileSystemAdministratorsGroup() {
            return null;
        }

        /**
         * (Optional) The fully qualified distinguished name of the organizational unit within your self-managed AD directory.
         * <p>
         * Amazon FSx only accepts OU as the direct parent of the file system. An example is <code>OU=FSx,DC=yourdomain,DC=corp,DC=com</code> . To learn more, see <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc2253">RFC 2253</a> . If none is provided, the FSx file system is created in the default location of your self-managed AD directory.
         * <p>
         * <blockquote>
         * <p>
         * Only Organizational Unit (OU) objects can be the direct parent of the file system that you're creating.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOrganizationalUnitDistinguishedName() {
            return null;
        }

        /**
         * The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
            return null;
        }

        /**
         * The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
         * <p>
         * This account must have the permission to join computers to the domain in the organizational unit provided in <code>OrganizationalUnitDistinguishedName</code> , or in the default location of your AD domain.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SelfManagedActiveDirectoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SelfManagedActiveDirectoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SelfManagedActiveDirectoryConfigurationProperty> {
            java.util.List<java.lang.String> dnsIps;
            java.lang.String domainName;
            java.lang.String fileSystemAdministratorsGroup;
            java.lang.String organizationalUnitDistinguishedName;
            java.lang.String password;
            java.lang.String userName;

            /**
             * Sets the value of {@link SelfManagedActiveDirectoryConfigurationProperty#getDnsIps}
             * @param dnsIps A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsIps(java.util.List<java.lang.String> dnsIps) {
                this.dnsIps = dnsIps;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedActiveDirectoryConfigurationProperty#getDomainName}
             * @param domainName The fully qualified domain name of the self-managed AD directory, such as `corp.example.com` .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainName(java.lang.String domainName) {
                this.domainName = domainName;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedActiveDirectoryConfigurationProperty#getFileSystemAdministratorsGroup}
             * @param fileSystemAdministratorsGroup (Optional) The name of the domain group whose members are granted administrative privileges for the file system.
             *                                      Administrative privileges include taking ownership of files and folders, setting audit controls (audit ACLs) on files and folders, and administering the file system remotely by using the FSx Remote PowerShell. The group that you specify must already exist in your domain. If you don't provide one, your AD domain's Domain Admins group is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileSystemAdministratorsGroup(java.lang.String fileSystemAdministratorsGroup) {
                this.fileSystemAdministratorsGroup = fileSystemAdministratorsGroup;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedActiveDirectoryConfigurationProperty#getOrganizationalUnitDistinguishedName}
             * @param organizationalUnitDistinguishedName (Optional) The fully qualified distinguished name of the organizational unit within your self-managed AD directory.
             *                                            Amazon FSx only accepts OU as the direct parent of the file system. An example is <code>OU=FSx,DC=yourdomain,DC=corp,DC=com</code> . To learn more, see <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc2253">RFC 2253</a> . If none is provided, the FSx file system is created in the default location of your self-managed AD directory.
             *                                            <p>
             *                                            <blockquote>
             *                                            <p>
             *                                            Only Organizational Unit (OU) objects can be the direct parent of the file system that you're creating.
             *                                            <p>
             *                                            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder organizationalUnitDistinguishedName(java.lang.String organizationalUnitDistinguishedName) {
                this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedActiveDirectoryConfigurationProperty#getPassword}
             * @param password The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link SelfManagedActiveDirectoryConfigurationProperty#getUserName}
             * @param userName The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
             *                 This account must have the permission to join computers to the domain in the organizational unit provided in <code>OrganizationalUnitDistinguishedName</code> , or in the default location of your AD domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userName(java.lang.String userName) {
                this.userName = userName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SelfManagedActiveDirectoryConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SelfManagedActiveDirectoryConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SelfManagedActiveDirectoryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SelfManagedActiveDirectoryConfigurationProperty {
            private final java.util.List<java.lang.String> dnsIps;
            private final java.lang.String domainName;
            private final java.lang.String fileSystemAdministratorsGroup;
            private final java.lang.String organizationalUnitDistinguishedName;
            private final java.lang.String password;
            private final java.lang.String userName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dnsIps = software.amazon.jsii.Kernel.get(this, "dnsIps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fileSystemAdministratorsGroup = software.amazon.jsii.Kernel.get(this, "fileSystemAdministratorsGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.organizationalUnitDistinguishedName = software.amazon.jsii.Kernel.get(this, "organizationalUnitDistinguishedName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userName = software.amazon.jsii.Kernel.get(this, "userName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dnsIps = builder.dnsIps;
                this.domainName = builder.domainName;
                this.fileSystemAdministratorsGroup = builder.fileSystemAdministratorsGroup;
                this.organizationalUnitDistinguishedName = builder.organizationalUnitDistinguishedName;
                this.password = builder.password;
                this.userName = builder.userName;
            }

            @Override
            public final java.util.List<java.lang.String> getDnsIps() {
                return this.dnsIps;
            }

            @Override
            public final java.lang.String getDomainName() {
                return this.domainName;
            }

            @Override
            public final java.lang.String getFileSystemAdministratorsGroup() {
                return this.fileSystemAdministratorsGroup;
            }

            @Override
            public final java.lang.String getOrganizationalUnitDistinguishedName() {
                return this.organizationalUnitDistinguishedName;
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getUserName() {
                return this.userName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDnsIps() != null) {
                    data.set("dnsIps", om.valueToTree(this.getDnsIps()));
                }
                if (this.getDomainName() != null) {
                    data.set("domainName", om.valueToTree(this.getDomainName()));
                }
                if (this.getFileSystemAdministratorsGroup() != null) {
                    data.set("fileSystemAdministratorsGroup", om.valueToTree(this.getFileSystemAdministratorsGroup()));
                }
                if (this.getOrganizationalUnitDistinguishedName() != null) {
                    data.set("organizationalUnitDistinguishedName", om.valueToTree(this.getOrganizationalUnitDistinguishedName()));
                }
                if (this.getPassword() != null) {
                    data.set("password", om.valueToTree(this.getPassword()));
                }
                if (this.getUserName() != null) {
                    data.set("userName", om.valueToTree(this.getUserName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnStorageVirtualMachine.SelfManagedActiveDirectoryConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SelfManagedActiveDirectoryConfigurationProperty.Jsii$Proxy that = (SelfManagedActiveDirectoryConfigurationProperty.Jsii$Proxy) o;

                if (this.dnsIps != null ? !this.dnsIps.equals(that.dnsIps) : that.dnsIps != null) return false;
                if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
                if (this.fileSystemAdministratorsGroup != null ? !this.fileSystemAdministratorsGroup.equals(that.fileSystemAdministratorsGroup) : that.fileSystemAdministratorsGroup != null) return false;
                if (this.organizationalUnitDistinguishedName != null ? !this.organizationalUnitDistinguishedName.equals(that.organizationalUnitDistinguishedName) : that.organizationalUnitDistinguishedName != null) return false;
                if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
                return this.userName != null ? this.userName.equals(that.userName) : that.userName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dnsIps != null ? this.dnsIps.hashCode() : 0;
                result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
                result = 31 * result + (this.fileSystemAdministratorsGroup != null ? this.fileSystemAdministratorsGroup.hashCode() : 0);
                result = 31 * result + (this.organizationalUnitDistinguishedName != null ? this.organizationalUnitDistinguishedName.hashCode() : 0);
                result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
                result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.fsx.CfnStorageVirtualMachine}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.fsx.CfnStorageVirtualMachine> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.fsx.CfnStorageVirtualMachineProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.fsx.CfnStorageVirtualMachineProps.Builder();
        }

        /**
         * Specifies the FSx for ONTAP file system on which to create the SVM.
         * <p>
         * @return {@code this}
         * @param fileSystemId Specifies the FSx for ONTAP file system on which to create the SVM. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemId(final java.lang.String fileSystemId) {
            this.props.fileSystemId(fileSystemId);
            return this;
        }

        /**
         * The name of the SVM.
         * <p>
         * @return {@code this}
         * @param name The name of the SVM. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Describes the Microsoft Active Directory configuration to which the SVM is joined, if applicable.
         * <p>
         * @return {@code this}
         * @param activeDirectoryConfiguration Describes the Microsoft Active Directory configuration to which the SVM is joined, if applicable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder activeDirectoryConfiguration(final software.amazon.awscdk.services.fsx.CfnStorageVirtualMachine.ActiveDirectoryConfigurationProperty activeDirectoryConfiguration) {
            this.props.activeDirectoryConfiguration(activeDirectoryConfiguration);
            return this;
        }
        /**
         * Describes the Microsoft Active Directory configuration to which the SVM is joined, if applicable.
         * <p>
         * @return {@code this}
         * @param activeDirectoryConfiguration Describes the Microsoft Active Directory configuration to which the SVM is joined, if applicable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder activeDirectoryConfiguration(final software.amazon.awscdk.IResolvable activeDirectoryConfiguration) {
            this.props.activeDirectoryConfiguration(activeDirectoryConfiguration);
            return this;
        }

        /**
         * The security style of the root volume of the SVM. Specify one of the following values:.
         * <p>
         * <ul>
         * <li><code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS clients, and an application accessing the data uses a UNIX user as the service account.</li>
         * <li><code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB clients, and an application accessing the data uses a Windows user as the service account.</li>
         * <li><code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users consist of both NFS and SMB clients.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param rootVolumeSecurityStyle The security style of the root volume of the SVM. Specify one of the following values:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rootVolumeSecurityStyle(final java.lang.String rootVolumeSecurityStyle) {
            this.props.rootVolumeSecurityStyle(rootVolumeSecurityStyle);
            return this;
        }

        /**
         * Specifies the password to use when logging on to the SVM using a secure shell (SSH) connection to the SVM's management endpoint.
         * <p>
         * Doing so enables you to manage the SVM using the NetApp ONTAP CLI or REST API. If you do not specify a password, you can still use the file system's <code>fsxadmin</code> user to manage the SVM. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-resources-ontap-apps.html#vsadmin-ontap-cli">Managing SVMs using the NetApp ONTAP CLI</a> in the <em>FSx for ONTAP User Guide</em> .
         * <p>
         * @return {@code this}
         * @param svmAdminPassword Specifies the password to use when logging on to the SVM using a secure shell (SSH) connection to the SVM's management endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder svmAdminPassword(final java.lang.String svmAdminPassword) {
            this.props.svmAdminPassword(svmAdminPassword);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.fsx.CfnStorageVirtualMachine}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.fsx.CfnStorageVirtualMachine build() {
            return new software.amazon.awscdk.services.fsx.CfnStorageVirtualMachine(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
