package software.amazon.awscdk.services.fms;

/**
 * A CloudFormation `AWS::FMS::Policy`.
 * <p>
 * An AWS Firewall Manager policy.
 * <p>
 * Firewall Manager provides the following types of policies:
 * <p>
 * <ul>
 * <li>An AWS Shield Advanced policy, which applies Shield Advanced protection to specified accounts and resources.</li>
 * <li>An AWS WAF policy (type WAFV2), which defines rule groups to run first in the corresponding AWS WAF web ACL and rule groups to run last in the web ACL.</li>
 * <li>An AWS WAF Classic policy, which defines a rule group. AWS WAF Classic doesn't support rule groups in Amazon CloudFront , so, to create AWS WAF Classic policies through CloudFront , you first need to create your rule groups outside of CloudFront .</li>
 * <li>A security group policy, which manages VPC security groups across your AWS organization.</li>
 * <li>An AWS Network Firewall policy, which provides firewall rules to filter network traffic in specified Amazon VPCs.</li>
 * <li>A DNS Firewall policy, which provides Amazon Route 53 Resolver DNS Firewall rules to filter DNS queries for specified Amazon VPCs.</li>
 * </ul>
 * <p>
 * Each policy is specific to one of the types. If you want to enforce more than one policy type across accounts, create multiple policies. You can create multiple policies for each type.
 * <p>
 * These policies require some setup to use. For more information, see the sections on prerequisites and getting started under <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-prereq.html">AWS Firewall Manager</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.fms.*;
 * CfnPolicy cfnPolicy = CfnPolicy.Builder.create(this, "MyCfnPolicy")
 *         .excludeResourceTags(false)
 *         .policyName("policyName")
 *         .remediationEnabled(false)
 *         .resourceType("resourceType")
 *         .securityServicePolicyData(SecurityServicePolicyDataProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .managedServiceData("managedServiceData")
 *                 .policyOption(PolicyOptionProperty.builder()
 *                         .networkFirewallPolicy(NetworkFirewallPolicyProperty.builder()
 *                                 .firewallDeploymentModel("firewallDeploymentModel")
 *                                 .build())
 *                         .thirdPartyFirewallPolicy(ThirdPartyFirewallPolicyProperty.builder()
 *                                 .firewallDeploymentModel("firewallDeploymentModel")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .deleteAllPolicyResources(false)
 *         .excludeMap(Map.of(
 *                 "account", List.of("account"),
 *                 "orgunit", List.of("orgunit")))
 *         .includeMap(Map.of(
 *                 "account", List.of("account"),
 *                 "orgunit", List.of("orgunit")))
 *         .resourcesCleanUp(false)
 *         .resourceTags(List.of(ResourceTagProperty.builder()
 *                 .key("key")
 *                 // the properties below are optional
 *                 .value("value")
 *                 .build()))
 *         .resourceTypeList(List.of("resourceTypeList"))
 *         .tags(List.of(PolicyTagProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:07.897Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fms.CfnPolicy")
public class CfnPolicy extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.fms.CfnPolicy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::FMS::Policy`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.fms.CfnPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Used only when tags are specified in the `ResourceTags` property.
     * <p>
     * If this property is <code>True</code> , resources with the specified tags are not in scope of the policy. If it's <code>False</code> , only resources with the specified tags are in scope of the policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getExcludeResourceTags() {
        return software.amazon.jsii.Kernel.get(this, "excludeResourceTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Used only when tags are specified in the `ResourceTags` property.
     * <p>
     * If this property is <code>True</code> , resources with the specified tags are not in scope of the policy. If it's <code>False</code> , only resources with the specified tags are in scope of the policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExcludeResourceTags(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "excludeResourceTags", java.util.Objects.requireNonNull(value, "excludeResourceTags is required"));
    }

    /**
     * Used only when tags are specified in the `ResourceTags` property.
     * <p>
     * If this property is <code>True</code> , resources with the specified tags are not in scope of the policy. If it's <code>False</code> , only resources with the specified tags are in scope of the policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExcludeResourceTags(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "excludeResourceTags", java.util.Objects.requireNonNull(value, "excludeResourceTags is required"));
    }

    /**
     * The name of the AWS Firewall Manager policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPolicyName() {
        return software.amazon.jsii.Kernel.get(this, "policyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the AWS Firewall Manager policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicyName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "policyName", java.util.Objects.requireNonNull(value, "policyName is required"));
    }

    /**
     * Indicates if the policy should be automatically applied to new resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRemediationEnabled() {
        return software.amazon.jsii.Kernel.get(this, "remediationEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates if the policy should be automatically applied to new resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRemediationEnabled(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "remediationEnabled", java.util.Objects.requireNonNull(value, "remediationEnabled is required"));
    }

    /**
     * Indicates if the policy should be automatically applied to new resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRemediationEnabled(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "remediationEnabled", java.util.Objects.requireNonNull(value, "remediationEnabled is required"));
    }

    /**
     * The type of resource protected by or in scope of the policy.
     * <p>
     * This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">AWS Resource Types Reference</a> . To apply this policy to multiple resource types, specify a resource type of <code>ResourceTypeList</code> and then specify the resource types in a <code>ResourceTypeList</code> .
     * <p>
     * For AWS WAF and Shield Advanced, example resource types include <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code> and <code>AWS::CloudFront::Distribution</code> . For a security group common policy, valid values are <code>AWS::EC2::NetworkInterface</code> and <code>AWS::EC2::Instance</code> . For a security group content audit policy, valid values are <code>AWS::EC2::SecurityGroup</code> , <code>AWS::EC2::NetworkInterface</code> , and <code>AWS::EC2::Instance</code> . For a security group usage audit policy, the value is <code>AWS::EC2::SecurityGroup</code> . For an AWS Network Firewall policy or DNS Firewall policy, the value is <code>AWS::EC2::VPC</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceType() {
        return software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of resource protected by or in scope of the policy.
     * <p>
     * This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">AWS Resource Types Reference</a> . To apply this policy to multiple resource types, specify a resource type of <code>ResourceTypeList</code> and then specify the resource types in a <code>ResourceTypeList</code> .
     * <p>
     * For AWS WAF and Shield Advanced, example resource types include <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code> and <code>AWS::CloudFront::Distribution</code> . For a security group common policy, valid values are <code>AWS::EC2::NetworkInterface</code> and <code>AWS::EC2::Instance</code> . For a security group content audit policy, valid values are <code>AWS::EC2::SecurityGroup</code> , <code>AWS::EC2::NetworkInterface</code> , and <code>AWS::EC2::Instance</code> . For a security group usage audit policy, the value is <code>AWS::EC2::SecurityGroup</code> . For an AWS Network Firewall policy or DNS Firewall policy, the value is <code>AWS::EC2::VPC</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resourceType", java.util.Objects.requireNonNull(value, "resourceType is required"));
    }

    /**
     * Details about the security service that is being used to protect the resources.
     * <p>
     * This contains the following settings:
     * <p>
     * <ul>
     * <li>Type - Indicates the service type that the policy uses to protect the resource. For security group policies, Firewall Manager supports one security group for each common policy and for each content audit policy. This is an adjustable limit that you can increase by contacting AWS Support .</li>
     * </ul>
     * <p>
     * Valid values: <code>DNS_FIREWALL</code> | <code>NETWORK_FIREWALL</code> | <code>SECURITY_GROUPS_COMMON</code> | <code>SECURITY_GROUPS_CONTENT_AUDIT</code> | <code>SECURITY_GROUPS_USAGE_AUDIT</code> | <code>SHIELD_ADVANCED</code> | <code>WAFV2</code> | <code>WAF</code>
     * <p>
     * <ul>
     * <li>ManagedServiceData - Details about the service that are specific to the service type, in JSON format.</li>
     * <li>Example: <code>DNS_FIREWALL</code></li>
     * </ul>
     * <p>
     * <code>"ManagedServiceData": "{ \"type\": \"DNS_FIREWALL\", \"preProcessRuleGroups\": [{\"ruleGroupId\": \"rslvr-frg-123456\", \"priority\": 11}], \"postProcessRuleGroups\": [{\"ruleGroupId\": \"rslvr-frg-123456\", \"priority\": 9902}]}"</code>
     * <p>
     * <ul>
     * <li>Example: <code>NETWORK_FIREWALL</code></li>
     * </ul>
     * <p>
     * <code>"ManagedServiceData":"{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:000000000000:stateless-rulegroup\/example\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:drop\",\"example\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:drop\",\"example\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"example\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"example\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:000000000000:stateful-rulegroup\/example\"}],\"networkFirewallOrchestrationConfig\":{\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":[]}}"</code>
     * <p>
     * <ul>
     * <li>Example: <code>SECURITY_GROUPS_COMMON</code></li>
     * </ul>
     * <p>
     * <code>"SecurityServicePolicyData":{"Type":"SECURITY_GROUPS_COMMON","ManagedServiceData":"{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false,\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd\"}]}"},"RemediationEnabled":false,"ResourceType":"AWS::EC2::NetworkInterface"}</code>
     * <p>
     * <ul>
     * <li>Example: <code>SECURITY_GROUPS_CONTENT_AUDIT</code></li>
     * </ul>
     * <p>
     * <code>"SecurityServicePolicyData":{"Type":"SECURITY_GROUPS_CONTENT_AUDIT","ManagedServiceData":"{\"type\":\"SECURITY_GROUPS_CONTENT_AUDIT\",\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd \"}],\"securityGroupAction\":{\"type\":\"ALLOW\"}}"},"RemediationEnabled":false,"ResourceType":"AWS::EC2::NetworkInterface"}</code>
     * <p>
     * The security group action for content audit can be <code>ALLOW</code> or <code>DENY</code> . For <code>ALLOW</code> , all in-scope security group rules must be within the allowed range of the policy's security group rules. For <code>DENY</code> , all in-scope security group rules must not contain a value or a range that matches a rule value or range in the policy security group.
     * <p>
     * <ul>
     * <li>Example: <code>SECURITY_GROUPS_USAGE_AUDIT</code></li>
     * </ul>
     * <p>
     * <code>"SecurityServicePolicyData":{"Type":"SECURITY_GROUPS_USAGE_AUDIT","ManagedServiceData":"{\"type\":\"SECURITY_GROUPS_USAGE_AUDIT\",\"deleteUnusedSecurityGroups\":true,\"coalesceRedundantSecurityGroups\":true}"},"RemediationEnabled":false,"Resou rceType":"AWS::EC2::SecurityGroup"}</code>
     * <p>
     * <ul>
     * <li>Specification for <code>SHIELD_ADVANCED</code> for Amazon CloudFront distributions</li>
     * </ul>
     * <p>
     * <code>"ManagedServiceData": "{\"type\": \"SHIELD_ADVANCED\", \"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED|IGNORED|DISABLED\", \"automaticResponseAction\":\"BLOCK|COUNT\"}, \"overrideCustomerWebaclClassic\":true|false}"</code>
     * <p>
     * For example: <code>"ManagedServiceData": "{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED\", \"automaticResponseAction\":\"COUNT\"}}"</code>
     * <p>
     * The default value for <code>automaticResponseStatus</code> is <code>IGNORED</code> . The value for <code>automaticResponseAction</code> is only required when <code>automaticResponseStatus</code> is set to <code>ENABLED</code> . The default value for <code>overrideCustomerWebaclClassic</code> is <code>false</code> .
     * <p>
     * For other resource types that you can protect with a Shield Advanced policy, this <code>ManagedServiceData</code> configuration is an empty string.
     * <p>
     * <ul>
     * <li>Example: <code>WAFV2</code></li>
     * </ul>
     * <p>
     * <code>"ManagedServiceData": "{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"version\":null,\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesAmazonIpReputationList\"},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[]}],\"postProcessRuleGroups\":[],\"defaultAction\":{\"type\":\"ALLOW\"},\"overrideCustomerWebACLAssociation\":false,\"loggingConfiguration\":{\"logDestinationConfigs\":[\"arn:aws:firehose:us-west-2:12345678912:deliverystream/aws-waf-logs-fms-admin-destination\"],\"redactedFields\":[{\"redactedFieldType\":\"SingleHeader\",\"redactedFieldValue\":\"Cookies\"},{\"redactedFieldType\":\"Method\"}]}}"</code>
     * <p>
     * In the <code>loggingConfiguration</code> , you can specify one <code>logDestinationConfigs</code> , you can optionally provide up to 20 <code>redactedFields</code> , and the <code>RedactedFieldType</code> must be one of <code>URI</code> , <code>QUERY_STRING</code> , <code>HEADER</code> , or <code>METHOD</code> .
     * <p>
     * <ul>
     * <li>Example: <code>WAF Classic</code></li>
     * </ul>
     * <p>
     * <code>"ManagedServiceData": "{\"type\": \"WAF\", \"ruleGroups\": [{\"id\":\"12345678-1bcd-9012-efga-0987654321ab\", \"overrideAction\" : {\"type\": \"COUNT\"}}],\"defaultAction\": {\"type\": \"BLOCK\"}}</code>
     * <p>
     * AWS WAF Classic doesn't support rule groups in CloudFront . To create a WAF Classic policy through CloudFormation, create your rule groups outside of CloudFront , then provide the rule group IDs in the WAF managed service data specification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSecurityServicePolicyData() {
        return software.amazon.jsii.Kernel.get(this, "securityServicePolicyData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Details about the security service that is being used to protect the resources.
     * <p>
     * This contains the following settings:
     * <p>
     * <ul>
     * <li>Type - Indicates the service type that the policy uses to protect the resource. For security group policies, Firewall Manager supports one security group for each common policy and for each content audit policy. This is an adjustable limit that you can increase by contacting AWS Support .</li>
     * </ul>
     * <p>
     * Valid values: <code>DNS_FIREWALL</code> | <code>NETWORK_FIREWALL</code> | <code>SECURITY_GROUPS_COMMON</code> | <code>SECURITY_GROUPS_CONTENT_AUDIT</code> | <code>SECURITY_GROUPS_USAGE_AUDIT</code> | <code>SHIELD_ADVANCED</code> | <code>WAFV2</code> | <code>WAF</code>
     * <p>
     * <ul>
     * <li>ManagedServiceData - Details about the service that are specific to the service type, in JSON format.</li>
     * <li>Example: <code>DNS_FIREWALL</code></li>
     * </ul>
     * <p>
     * <code>"ManagedServiceData": "{ \"type\": \"DNS_FIREWALL\", \"preProcessRuleGroups\": [{\"ruleGroupId\": \"rslvr-frg-123456\", \"priority\": 11}], \"postProcessRuleGroups\": [{\"ruleGroupId\": \"rslvr-frg-123456\", \"priority\": 9902}]}"</code>
     * <p>
     * <ul>
     * <li>Example: <code>NETWORK_FIREWALL</code></li>
     * </ul>
     * <p>
     * <code>"ManagedServiceData":"{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:000000000000:stateless-rulegroup\/example\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:drop\",\"example\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:drop\",\"example\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"example\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"example\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:000000000000:stateful-rulegroup\/example\"}],\"networkFirewallOrchestrationConfig\":{\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":[]}}"</code>
     * <p>
     * <ul>
     * <li>Example: <code>SECURITY_GROUPS_COMMON</code></li>
     * </ul>
     * <p>
     * <code>"SecurityServicePolicyData":{"Type":"SECURITY_GROUPS_COMMON","ManagedServiceData":"{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false,\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd\"}]}"},"RemediationEnabled":false,"ResourceType":"AWS::EC2::NetworkInterface"}</code>
     * <p>
     * <ul>
     * <li>Example: <code>SECURITY_GROUPS_CONTENT_AUDIT</code></li>
     * </ul>
     * <p>
     * <code>"SecurityServicePolicyData":{"Type":"SECURITY_GROUPS_CONTENT_AUDIT","ManagedServiceData":"{\"type\":\"SECURITY_GROUPS_CONTENT_AUDIT\",\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd \"}],\"securityGroupAction\":{\"type\":\"ALLOW\"}}"},"RemediationEnabled":false,"ResourceType":"AWS::EC2::NetworkInterface"}</code>
     * <p>
     * The security group action for content audit can be <code>ALLOW</code> or <code>DENY</code> . For <code>ALLOW</code> , all in-scope security group rules must be within the allowed range of the policy's security group rules. For <code>DENY</code> , all in-scope security group rules must not contain a value or a range that matches a rule value or range in the policy security group.
     * <p>
     * <ul>
     * <li>Example: <code>SECURITY_GROUPS_USAGE_AUDIT</code></li>
     * </ul>
     * <p>
     * <code>"SecurityServicePolicyData":{"Type":"SECURITY_GROUPS_USAGE_AUDIT","ManagedServiceData":"{\"type\":\"SECURITY_GROUPS_USAGE_AUDIT\",\"deleteUnusedSecurityGroups\":true,\"coalesceRedundantSecurityGroups\":true}"},"RemediationEnabled":false,"Resou rceType":"AWS::EC2::SecurityGroup"}</code>
     * <p>
     * <ul>
     * <li>Specification for <code>SHIELD_ADVANCED</code> for Amazon CloudFront distributions</li>
     * </ul>
     * <p>
     * <code>"ManagedServiceData": "{\"type\": \"SHIELD_ADVANCED\", \"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED|IGNORED|DISABLED\", \"automaticResponseAction\":\"BLOCK|COUNT\"}, \"overrideCustomerWebaclClassic\":true|false}"</code>
     * <p>
     * For example: <code>"ManagedServiceData": "{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED\", \"automaticResponseAction\":\"COUNT\"}}"</code>
     * <p>
     * The default value for <code>automaticResponseStatus</code> is <code>IGNORED</code> . The value for <code>automaticResponseAction</code> is only required when <code>automaticResponseStatus</code> is set to <code>ENABLED</code> . The default value for <code>overrideCustomerWebaclClassic</code> is <code>false</code> .
     * <p>
     * For other resource types that you can protect with a Shield Advanced policy, this <code>ManagedServiceData</code> configuration is an empty string.
     * <p>
     * <ul>
     * <li>Example: <code>WAFV2</code></li>
     * </ul>
     * <p>
     * <code>"ManagedServiceData": "{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"version\":null,\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesAmazonIpReputationList\"},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[]}],\"postProcessRuleGroups\":[],\"defaultAction\":{\"type\":\"ALLOW\"},\"overrideCustomerWebACLAssociation\":false,\"loggingConfiguration\":{\"logDestinationConfigs\":[\"arn:aws:firehose:us-west-2:12345678912:deliverystream/aws-waf-logs-fms-admin-destination\"],\"redactedFields\":[{\"redactedFieldType\":\"SingleHeader\",\"redactedFieldValue\":\"Cookies\"},{\"redactedFieldType\":\"Method\"}]}}"</code>
     * <p>
     * In the <code>loggingConfiguration</code> , you can specify one <code>logDestinationConfigs</code> , you can optionally provide up to 20 <code>redactedFields</code> , and the <code>RedactedFieldType</code> must be one of <code>URI</code> , <code>QUERY_STRING</code> , <code>HEADER</code> , or <code>METHOD</code> .
     * <p>
     * <ul>
     * <li>Example: <code>WAF Classic</code></li>
     * </ul>
     * <p>
     * <code>"ManagedServiceData": "{\"type\": \"WAF\", \"ruleGroups\": [{\"id\":\"12345678-1bcd-9012-efga-0987654321ab\", \"overrideAction\" : {\"type\": \"COUNT\"}}],\"defaultAction\": {\"type\": \"BLOCK\"}}</code>
     * <p>
     * AWS WAF Classic doesn't support rule groups in CloudFront . To create a WAF Classic policy through CloudFormation, create your rule groups outside of CloudFront , then provide the rule group IDs in the WAF managed service data specification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityServicePolicyData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.fms.CfnPolicy.SecurityServicePolicyDataProperty value) {
        software.amazon.jsii.Kernel.set(this, "securityServicePolicyData", java.util.Objects.requireNonNull(value, "securityServicePolicyData is required"));
    }

    /**
     * Details about the security service that is being used to protect the resources.
     * <p>
     * This contains the following settings:
     * <p>
     * <ul>
     * <li>Type - Indicates the service type that the policy uses to protect the resource. For security group policies, Firewall Manager supports one security group for each common policy and for each content audit policy. This is an adjustable limit that you can increase by contacting AWS Support .</li>
     * </ul>
     * <p>
     * Valid values: <code>DNS_FIREWALL</code> | <code>NETWORK_FIREWALL</code> | <code>SECURITY_GROUPS_COMMON</code> | <code>SECURITY_GROUPS_CONTENT_AUDIT</code> | <code>SECURITY_GROUPS_USAGE_AUDIT</code> | <code>SHIELD_ADVANCED</code> | <code>WAFV2</code> | <code>WAF</code>
     * <p>
     * <ul>
     * <li>ManagedServiceData - Details about the service that are specific to the service type, in JSON format.</li>
     * <li>Example: <code>DNS_FIREWALL</code></li>
     * </ul>
     * <p>
     * <code>"ManagedServiceData": "{ \"type\": \"DNS_FIREWALL\", \"preProcessRuleGroups\": [{\"ruleGroupId\": \"rslvr-frg-123456\", \"priority\": 11}], \"postProcessRuleGroups\": [{\"ruleGroupId\": \"rslvr-frg-123456\", \"priority\": 9902}]}"</code>
     * <p>
     * <ul>
     * <li>Example: <code>NETWORK_FIREWALL</code></li>
     * </ul>
     * <p>
     * <code>"ManagedServiceData":"{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:000000000000:stateless-rulegroup\/example\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:drop\",\"example\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:drop\",\"example\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"example\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"example\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:000000000000:stateful-rulegroup\/example\"}],\"networkFirewallOrchestrationConfig\":{\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":[]}}"</code>
     * <p>
     * <ul>
     * <li>Example: <code>SECURITY_GROUPS_COMMON</code></li>
     * </ul>
     * <p>
     * <code>"SecurityServicePolicyData":{"Type":"SECURITY_GROUPS_COMMON","ManagedServiceData":"{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false,\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd\"}]}"},"RemediationEnabled":false,"ResourceType":"AWS::EC2::NetworkInterface"}</code>
     * <p>
     * <ul>
     * <li>Example: <code>SECURITY_GROUPS_CONTENT_AUDIT</code></li>
     * </ul>
     * <p>
     * <code>"SecurityServicePolicyData":{"Type":"SECURITY_GROUPS_CONTENT_AUDIT","ManagedServiceData":"{\"type\":\"SECURITY_GROUPS_CONTENT_AUDIT\",\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd \"}],\"securityGroupAction\":{\"type\":\"ALLOW\"}}"},"RemediationEnabled":false,"ResourceType":"AWS::EC2::NetworkInterface"}</code>
     * <p>
     * The security group action for content audit can be <code>ALLOW</code> or <code>DENY</code> . For <code>ALLOW</code> , all in-scope security group rules must be within the allowed range of the policy's security group rules. For <code>DENY</code> , all in-scope security group rules must not contain a value or a range that matches a rule value or range in the policy security group.
     * <p>
     * <ul>
     * <li>Example: <code>SECURITY_GROUPS_USAGE_AUDIT</code></li>
     * </ul>
     * <p>
     * <code>"SecurityServicePolicyData":{"Type":"SECURITY_GROUPS_USAGE_AUDIT","ManagedServiceData":"{\"type\":\"SECURITY_GROUPS_USAGE_AUDIT\",\"deleteUnusedSecurityGroups\":true,\"coalesceRedundantSecurityGroups\":true}"},"RemediationEnabled":false,"Resou rceType":"AWS::EC2::SecurityGroup"}</code>
     * <p>
     * <ul>
     * <li>Specification for <code>SHIELD_ADVANCED</code> for Amazon CloudFront distributions</li>
     * </ul>
     * <p>
     * <code>"ManagedServiceData": "{\"type\": \"SHIELD_ADVANCED\", \"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED|IGNORED|DISABLED\", \"automaticResponseAction\":\"BLOCK|COUNT\"}, \"overrideCustomerWebaclClassic\":true|false}"</code>
     * <p>
     * For example: <code>"ManagedServiceData": "{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED\", \"automaticResponseAction\":\"COUNT\"}}"</code>
     * <p>
     * The default value for <code>automaticResponseStatus</code> is <code>IGNORED</code> . The value for <code>automaticResponseAction</code> is only required when <code>automaticResponseStatus</code> is set to <code>ENABLED</code> . The default value for <code>overrideCustomerWebaclClassic</code> is <code>false</code> .
     * <p>
     * For other resource types that you can protect with a Shield Advanced policy, this <code>ManagedServiceData</code> configuration is an empty string.
     * <p>
     * <ul>
     * <li>Example: <code>WAFV2</code></li>
     * </ul>
     * <p>
     * <code>"ManagedServiceData": "{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"version\":null,\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesAmazonIpReputationList\"},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[]}],\"postProcessRuleGroups\":[],\"defaultAction\":{\"type\":\"ALLOW\"},\"overrideCustomerWebACLAssociation\":false,\"loggingConfiguration\":{\"logDestinationConfigs\":[\"arn:aws:firehose:us-west-2:12345678912:deliverystream/aws-waf-logs-fms-admin-destination\"],\"redactedFields\":[{\"redactedFieldType\":\"SingleHeader\",\"redactedFieldValue\":\"Cookies\"},{\"redactedFieldType\":\"Method\"}]}}"</code>
     * <p>
     * In the <code>loggingConfiguration</code> , you can specify one <code>logDestinationConfigs</code> , you can optionally provide up to 20 <code>redactedFields</code> , and the <code>RedactedFieldType</code> must be one of <code>URI</code> , <code>QUERY_STRING</code> , <code>HEADER</code> , or <code>METHOD</code> .
     * <p>
     * <ul>
     * <li>Example: <code>WAF Classic</code></li>
     * </ul>
     * <p>
     * <code>"ManagedServiceData": "{\"type\": \"WAF\", \"ruleGroups\": [{\"id\":\"12345678-1bcd-9012-efga-0987654321ab\", \"overrideAction\" : {\"type\": \"COUNT\"}}],\"defaultAction\": {\"type\": \"BLOCK\"}}</code>
     * <p>
     * AWS WAF Classic doesn't support rule groups in CloudFront . To create a WAF Classic policy through CloudFormation, create your rule groups outside of CloudFront , then provide the rule group IDs in the WAF managed service data specification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityServicePolicyData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "securityServicePolicyData", java.util.Objects.requireNonNull(value, "securityServicePolicyData is required"));
    }

    /**
     * Used when deleting a policy. If `true` , Firewall Manager performs cleanup according to the policy type.
     * <p>
     * For AWS WAF and Shield Advanced policies, Firewall Manager does the following:
     * <p>
     * <ul>
     * <li>Deletes rule groups created by Firewall Manager</li>
     * <li>Removes web ACLs from in-scope resources</li>
     * <li>Deletes web ACLs that contain no rules or rule groups</li>
     * </ul>
     * <p>
     * For security group policies, Firewall Manager does the following for each security group in the policy:
     * <p>
     * <ul>
     * <li>Disassociates the security group from in-scope resources</li>
     * <li>Deletes the security group if it was created through Firewall Manager and if it's no longer associated with any resources through another policy</li>
     * </ul>
     * <p>
     * After the cleanup, in-scope resources are no longer protected by web ACLs in this policy. Protection of out-of-scope resources remains unchanged. Scope is determined by tags that you create and accounts that you associate with the policy. When creating the policy, if you specify that only resources in specific accounts or with specific tags are in scope of the policy, those accounts and resources are handled by the policy. All others are out of scope. If you don't specify tags or accounts, all resources are in scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeleteAllPolicyResources() {
        return software.amazon.jsii.Kernel.get(this, "deleteAllPolicyResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Used when deleting a policy. If `true` , Firewall Manager performs cleanup according to the policy type.
     * <p>
     * For AWS WAF and Shield Advanced policies, Firewall Manager does the following:
     * <p>
     * <ul>
     * <li>Deletes rule groups created by Firewall Manager</li>
     * <li>Removes web ACLs from in-scope resources</li>
     * <li>Deletes web ACLs that contain no rules or rule groups</li>
     * </ul>
     * <p>
     * For security group policies, Firewall Manager does the following for each security group in the policy:
     * <p>
     * <ul>
     * <li>Disassociates the security group from in-scope resources</li>
     * <li>Deletes the security group if it was created through Firewall Manager and if it's no longer associated with any resources through another policy</li>
     * </ul>
     * <p>
     * After the cleanup, in-scope resources are no longer protected by web ACLs in this policy. Protection of out-of-scope resources remains unchanged. Scope is determined by tags that you create and accounts that you associate with the policy. When creating the policy, if you specify that only resources in specific accounts or with specific tags are in scope of the policy, those accounts and resources are handled by the policy. All others are out of scope. If you don't specify tags or accounts, all resources are in scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeleteAllPolicyResources(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "deleteAllPolicyResources", value);
    }

    /**
     * Used when deleting a policy. If `true` , Firewall Manager performs cleanup according to the policy type.
     * <p>
     * For AWS WAF and Shield Advanced policies, Firewall Manager does the following:
     * <p>
     * <ul>
     * <li>Deletes rule groups created by Firewall Manager</li>
     * <li>Removes web ACLs from in-scope resources</li>
     * <li>Deletes web ACLs that contain no rules or rule groups</li>
     * </ul>
     * <p>
     * For security group policies, Firewall Manager does the following for each security group in the policy:
     * <p>
     * <ul>
     * <li>Disassociates the security group from in-scope resources</li>
     * <li>Deletes the security group if it was created through Firewall Manager and if it's no longer associated with any resources through another policy</li>
     * </ul>
     * <p>
     * After the cleanup, in-scope resources are no longer protected by web ACLs in this policy. Protection of out-of-scope resources remains unchanged. Scope is determined by tags that you create and accounts that you associate with the policy. When creating the policy, if you specify that only resources in specific accounts or with specific tags are in scope of the policy, those accounts and resources are handled by the policy. All others are out of scope. If you don't specify tags or accounts, all resources are in scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeleteAllPolicyResources(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deleteAllPolicyResources", value);
    }

    /**
     * Specifies the AWS account IDs and AWS Organizations organizational units (OUs) to exclude from the policy.
     * <p>
     * Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
     * <p>
     * You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code> , AWS Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code> , and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code> , then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code> .
     * <p>
     * You can specify account IDs, OUs, or a combination:
     * <p>
     * <ul>
     * <li>Specify account IDs by setting the key to <code>ACCOUNT</code> . For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code> .</li>
     * <li>Specify OUs by setting the key to <code>ORGUNIT</code> . For example, the following is a valid map: <code>{“ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
     * <li>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getExcludeMap() {
        return software.amazon.jsii.Kernel.get(this, "excludeMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the AWS account IDs and AWS Organizations organizational units (OUs) to exclude from the policy.
     * <p>
     * Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
     * <p>
     * You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code> , AWS Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code> , and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code> , then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code> .
     * <p>
     * You can specify account IDs, OUs, or a combination:
     * <p>
     * <ul>
     * <li>Specify account IDs by setting the key to <code>ACCOUNT</code> . For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code> .</li>
     * <li>Specify OUs by setting the key to <code>ORGUNIT</code> . For example, the following is a valid map: <code>{“ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
     * <li>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExcludeMap(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fms.CfnPolicy.IEMapProperty value) {
        software.amazon.jsii.Kernel.set(this, "excludeMap", value);
    }

    /**
     * Specifies the AWS account IDs and AWS Organizations organizational units (OUs) to exclude from the policy.
     * <p>
     * Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
     * <p>
     * You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code> , AWS Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code> , and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code> , then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code> .
     * <p>
     * You can specify account IDs, OUs, or a combination:
     * <p>
     * <ul>
     * <li>Specify account IDs by setting the key to <code>ACCOUNT</code> . For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code> .</li>
     * <li>Specify OUs by setting the key to <code>ORGUNIT</code> . For example, the following is a valid map: <code>{“ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
     * <li>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExcludeMap(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "excludeMap", value);
    }

    /**
     * Specifies the AWS account IDs and AWS Organizations organizational units (OUs) to include in the policy.
     * <p>
     * Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
     * <p>
     * You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code> , AWS Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code> , and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code> , then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code> .
     * <p>
     * You can specify account IDs, OUs, or a combination:
     * <p>
     * <ul>
     * <li>Specify account IDs by setting the key to <code>ACCOUNT</code> . For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code> .</li>
     * <li>Specify OUs by setting the key to <code>ORGUNIT</code> . For example, the following is a valid map: <code>{“ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
     * <li>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIncludeMap() {
        return software.amazon.jsii.Kernel.get(this, "includeMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the AWS account IDs and AWS Organizations organizational units (OUs) to include in the policy.
     * <p>
     * Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
     * <p>
     * You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code> , AWS Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code> , and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code> , then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code> .
     * <p>
     * You can specify account IDs, OUs, or a combination:
     * <p>
     * <ul>
     * <li>Specify account IDs by setting the key to <code>ACCOUNT</code> . For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code> .</li>
     * <li>Specify OUs by setting the key to <code>ORGUNIT</code> . For example, the following is a valid map: <code>{“ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
     * <li>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIncludeMap(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.fms.CfnPolicy.IEMapProperty value) {
        software.amazon.jsii.Kernel.set(this, "includeMap", value);
    }

    /**
     * Specifies the AWS account IDs and AWS Organizations organizational units (OUs) to include in the policy.
     * <p>
     * Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
     * <p>
     * You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code> , AWS Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code> , and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code> , then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code> .
     * <p>
     * You can specify account IDs, OUs, or a combination:
     * <p>
     * <ul>
     * <li>Specify account IDs by setting the key to <code>ACCOUNT</code> . For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code> .</li>
     * <li>Specify OUs by setting the key to <code>ORGUNIT</code> . For example, the following is a valid map: <code>{“ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
     * <li>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIncludeMap(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "includeMap", value);
    }

    /**
     * Indicates whether AWS Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope.
     * <p>
     * For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope.
     * <p>
     * By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources.
     * <p>
     * This option is not available for Shield Advanced or AWS WAF Classic policies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getResourcesCleanUp() {
        return software.amazon.jsii.Kernel.get(this, "resourcesCleanUp", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether AWS Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope.
     * <p>
     * For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope.
     * <p>
     * By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources.
     * <p>
     * This option is not available for Shield Advanced or AWS WAF Classic policies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourcesCleanUp(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "resourcesCleanUp", value);
    }

    /**
     * Indicates whether AWS Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope.
     * <p>
     * For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope.
     * <p>
     * By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources.
     * <p>
     * This option is not available for Shield Advanced or AWS WAF Classic policies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourcesCleanUp(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resourcesCleanUp", value);
    }

    /**
     * An array of `ResourceTag` objects, used to explicitly include resources in the policy scope or explicitly exclude them.
     * <p>
     * If this isn't set, then tags aren't used to modify policy scope. See also <code>ExcludeResourceTags</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getResourceTags() {
        return software.amazon.jsii.Kernel.get(this, "resourceTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of `ResourceTag` objects, used to explicitly include resources in the policy scope or explicitly exclude them.
     * <p>
     * If this isn't set, then tags aren't used to modify policy scope. See also <code>ExcludeResourceTags</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceTags(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resourceTags", value);
    }

    /**
     * An array of `ResourceTag` objects, used to explicitly include resources in the policy scope or explicitly exclude them.
     * <p>
     * If this isn't set, then tags aren't used to modify policy scope. See also <code>ExcludeResourceTags</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceTags(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.services.fms.CfnPolicy.ResourceTagProperty)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.services.fms.CfnPolicy.ResourceTagProperty, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "resourceTags", value);
    }

    /**
     * An array of `ResourceType` objects.
     * <p>
     * Use this only to specify multiple resource types. To specify a single resource type, use <code>ResourceType</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceTypeList() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "resourceTypeList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of `ResourceType` objects.
     * <p>
     * Use this only to specify multiple resource types. To specify a single resource type, use <code>ResourceType</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceTypeList(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "resourceTypeList", value);
    }

    /**
     * A collection of key:value pairs associated with an AWS resource.
     * <p>
     * The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.fms.CfnPolicy.PolicyTagProperty> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.fms.CfnPolicy.PolicyTagProperty>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.fms.CfnPolicy.PolicyTagProperty.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A collection of key:value pairs associated with an AWS resource.
     * <p>
     * The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.fms.CfnPolicy.PolicyTagProperty> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Specifies the AWS account IDs and AWS Organizations organizational units (OUs) to include in or exclude from the policy.
     * <p>
     * Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
     * <p>
     * This is used for the policy's <code>IncludeMap</code> and <code>ExcludeMap</code> .
     * <p>
     * You can specify account IDs, OUs, or a combination:
     * <p>
     * <ul>
     * <li>Specify account IDs by setting the key to <code>ACCOUNT</code> . For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code> .</li>
     * <li>Specify OUs by setting the key to <code>ORGUNIT</code> . For example, the following is a valid map: <code>{“ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
     * <li>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fms.*;
     * IEMapProperty iEMapProperty = Map.of(
     *         "account", List.of("account"),
     *         "orgunit", List.of("orgunit"));
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fms.CfnPolicy.IEMapProperty")
    @software.amazon.jsii.Jsii.Proxy(IEMapProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IEMapProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The account list for the map.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAccount() {
            return null;
        }

        /**
         * The organizational unit list for the map.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOrgunit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IEMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IEMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IEMapProperty> {
            java.util.List<java.lang.String> account;
            java.util.List<java.lang.String> orgunit;

            /**
             * Sets the value of {@link IEMapProperty#getAccount}
             * @param account The account list for the map.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder account(java.util.List<java.lang.String> account) {
                this.account = account;
                return this;
            }

            /**
             * Sets the value of {@link IEMapProperty#getOrgunit}
             * @param orgunit The organizational unit list for the map.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orgunit(java.util.List<java.lang.String> orgunit) {
                this.orgunit = orgunit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IEMapProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IEMapProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IEMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IEMapProperty {
            private final java.util.List<java.lang.String> account;
            private final java.util.List<java.lang.String> orgunit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.account = software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.orgunit = software.amazon.jsii.Kernel.get(this, "orgunit", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.account = builder.account;
                this.orgunit = builder.orgunit;
            }

            @Override
            public final java.util.List<java.lang.String> getAccount() {
                return this.account;
            }

            @Override
            public final java.util.List<java.lang.String> getOrgunit() {
                return this.orgunit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccount() != null) {
                    data.set("account", om.valueToTree(this.getAccount()));
                }
                if (this.getOrgunit() != null) {
                    data.set("orgunit", om.valueToTree(this.getOrgunit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fms.CfnPolicy.IEMapProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IEMapProperty.Jsii$Proxy that = (IEMapProperty.Jsii$Proxy) o;

                if (this.account != null ? !this.account.equals(that.account) : that.account != null) return false;
                return this.orgunit != null ? this.orgunit.equals(that.orgunit) : that.orgunit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.account != null ? this.account.hashCode() : 0;
                result = 31 * result + (this.orgunit != null ? this.orgunit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fms.*;
     * NetworkFirewallPolicyProperty networkFirewallPolicyProperty = NetworkFirewallPolicyProperty.builder()
     *         .firewallDeploymentModel("firewallDeploymentModel")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fms.CfnPolicy.NetworkFirewallPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkFirewallPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkFirewallPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnPolicy.NetworkFirewallPolicyProperty.FirewallDeploymentModel`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFirewallDeploymentModel();

        /**
         * @return a {@link Builder} of {@link NetworkFirewallPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkFirewallPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkFirewallPolicyProperty> {
            java.lang.String firewallDeploymentModel;

            /**
             * Sets the value of {@link NetworkFirewallPolicyProperty#getFirewallDeploymentModel}
             * @param firewallDeploymentModel `CfnPolicy.NetworkFirewallPolicyProperty.FirewallDeploymentModel`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firewallDeploymentModel(java.lang.String firewallDeploymentModel) {
                this.firewallDeploymentModel = firewallDeploymentModel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkFirewallPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkFirewallPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkFirewallPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkFirewallPolicyProperty {
            private final java.lang.String firewallDeploymentModel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.firewallDeploymentModel = software.amazon.jsii.Kernel.get(this, "firewallDeploymentModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.firewallDeploymentModel = java.util.Objects.requireNonNull(builder.firewallDeploymentModel, "firewallDeploymentModel is required");
            }

            @Override
            public final java.lang.String getFirewallDeploymentModel() {
                return this.firewallDeploymentModel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("firewallDeploymentModel", om.valueToTree(this.getFirewallDeploymentModel()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fms.CfnPolicy.NetworkFirewallPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkFirewallPolicyProperty.Jsii$Proxy that = (NetworkFirewallPolicyProperty.Jsii$Proxy) o;

                return this.firewallDeploymentModel.equals(that.firewallDeploymentModel);
            }

            @Override
            public final int hashCode() {
                int result = this.firewallDeploymentModel.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fms.*;
     * PolicyOptionProperty policyOptionProperty = PolicyOptionProperty.builder()
     *         .networkFirewallPolicy(NetworkFirewallPolicyProperty.builder()
     *                 .firewallDeploymentModel("firewallDeploymentModel")
     *                 .build())
     *         .thirdPartyFirewallPolicy(ThirdPartyFirewallPolicyProperty.builder()
     *                 .firewallDeploymentModel("firewallDeploymentModel")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fms.CfnPolicy.PolicyOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(PolicyOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PolicyOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnPolicy.PolicyOptionProperty.NetworkFirewallPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkFirewallPolicy() {
            return null;
        }

        /**
         * `CfnPolicy.PolicyOptionProperty.ThirdPartyFirewallPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getThirdPartyFirewallPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PolicyOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PolicyOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PolicyOptionProperty> {
            java.lang.Object networkFirewallPolicy;
            java.lang.Object thirdPartyFirewallPolicy;

            /**
             * Sets the value of {@link PolicyOptionProperty#getNetworkFirewallPolicy}
             * @param networkFirewallPolicy `CfnPolicy.PolicyOptionProperty.NetworkFirewallPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkFirewallPolicy(software.amazon.awscdk.services.fms.CfnPolicy.NetworkFirewallPolicyProperty networkFirewallPolicy) {
                this.networkFirewallPolicy = networkFirewallPolicy;
                return this;
            }

            /**
             * Sets the value of {@link PolicyOptionProperty#getNetworkFirewallPolicy}
             * @param networkFirewallPolicy `CfnPolicy.PolicyOptionProperty.NetworkFirewallPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkFirewallPolicy(software.amazon.awscdk.IResolvable networkFirewallPolicy) {
                this.networkFirewallPolicy = networkFirewallPolicy;
                return this;
            }

            /**
             * Sets the value of {@link PolicyOptionProperty#getThirdPartyFirewallPolicy}
             * @param thirdPartyFirewallPolicy `CfnPolicy.PolicyOptionProperty.ThirdPartyFirewallPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thirdPartyFirewallPolicy(software.amazon.awscdk.services.fms.CfnPolicy.ThirdPartyFirewallPolicyProperty thirdPartyFirewallPolicy) {
                this.thirdPartyFirewallPolicy = thirdPartyFirewallPolicy;
                return this;
            }

            /**
             * Sets the value of {@link PolicyOptionProperty#getThirdPartyFirewallPolicy}
             * @param thirdPartyFirewallPolicy `CfnPolicy.PolicyOptionProperty.ThirdPartyFirewallPolicy`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thirdPartyFirewallPolicy(software.amazon.awscdk.IResolvable thirdPartyFirewallPolicy) {
                this.thirdPartyFirewallPolicy = thirdPartyFirewallPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PolicyOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PolicyOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PolicyOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyOptionProperty {
            private final java.lang.Object networkFirewallPolicy;
            private final java.lang.Object thirdPartyFirewallPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.networkFirewallPolicy = software.amazon.jsii.Kernel.get(this, "networkFirewallPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.thirdPartyFirewallPolicy = software.amazon.jsii.Kernel.get(this, "thirdPartyFirewallPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.networkFirewallPolicy = builder.networkFirewallPolicy;
                this.thirdPartyFirewallPolicy = builder.thirdPartyFirewallPolicy;
            }

            @Override
            public final java.lang.Object getNetworkFirewallPolicy() {
                return this.networkFirewallPolicy;
            }

            @Override
            public final java.lang.Object getThirdPartyFirewallPolicy() {
                return this.thirdPartyFirewallPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNetworkFirewallPolicy() != null) {
                    data.set("networkFirewallPolicy", om.valueToTree(this.getNetworkFirewallPolicy()));
                }
                if (this.getThirdPartyFirewallPolicy() != null) {
                    data.set("thirdPartyFirewallPolicy", om.valueToTree(this.getThirdPartyFirewallPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fms.CfnPolicy.PolicyOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PolicyOptionProperty.Jsii$Proxy that = (PolicyOptionProperty.Jsii$Proxy) o;

                if (this.networkFirewallPolicy != null ? !this.networkFirewallPolicy.equals(that.networkFirewallPolicy) : that.networkFirewallPolicy != null) return false;
                return this.thirdPartyFirewallPolicy != null ? this.thirdPartyFirewallPolicy.equals(that.thirdPartyFirewallPolicy) : that.thirdPartyFirewallPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.networkFirewallPolicy != null ? this.networkFirewallPolicy.hashCode() : 0;
                result = 31 * result + (this.thirdPartyFirewallPolicy != null ? this.thirdPartyFirewallPolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A collection of key:value pairs associated with an AWS resource.
     * <p>
     * The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fms.*;
     * PolicyTagProperty policyTagProperty = PolicyTagProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fms.CfnPolicy.PolicyTagProperty")
    @software.amazon.jsii.Jsii.Proxy(PolicyTagProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PolicyTagProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Part of the key:value pair that defines a tag.
         * <p>
         * You can use a tag key to describe a category of information, such as "customer." Tag keys are case-sensitive.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * Part of the key:value pair that defines a tag.
         * <p>
         * You can use a tag value to describe a specific value within a category, such as "companyA" or "companyB." Tag values are case-sensitive.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link PolicyTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PolicyTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PolicyTagProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link PolicyTagProperty#getKey}
             * @param key Part of the key:value pair that defines a tag. This parameter is required.
             *            You can use a tag key to describe a category of information, such as "customer." Tag keys are case-sensitive.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link PolicyTagProperty#getValue}
             * @param value Part of the key:value pair that defines a tag. This parameter is required.
             *              You can use a tag value to describe a specific value within a category, such as "companyA" or "companyB." Tag values are case-sensitive.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PolicyTagProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PolicyTagProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PolicyTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyTagProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fms.CfnPolicy.PolicyTagProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PolicyTagProperty.Jsii$Proxy that = (PolicyTagProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The resource tags that AWS Firewall Manager uses to determine if a particular resource should be included or excluded from the AWS Firewall Manager policy.
     * <p>
     * Tags enable you to categorize your AWS resources in different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an optional value. Firewall Manager combines the tags with "AND" so that, if you add more than one tag to a policy scope, a resource must have all the specified tags to be included or excluded. For more information, see <a href="https://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/tag-editor.html">Working with Tag Editor</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fms.*;
     * ResourceTagProperty resourceTagProperty = ResourceTagProperty.builder()
     *         .key("key")
     *         // the properties below are optional
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fms.CfnPolicy.ResourceTagProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceTagProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceTagProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The resource tag key.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The resource tag value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceTagProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link ResourceTagProperty#getKey}
             * @param key The resource tag key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link ResourceTagProperty#getValue}
             * @param value The resource tag value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceTagProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceTagProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceTagProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceTagProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fms.CfnPolicy.ResourceTagProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceTagProperty.Jsii$Proxy that = (ResourceTagProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fms.*;
     * SecurityServicePolicyDataProperty securityServicePolicyDataProperty = SecurityServicePolicyDataProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .managedServiceData("managedServiceData")
     *         .policyOption(PolicyOptionProperty.builder()
     *                 .networkFirewallPolicy(NetworkFirewallPolicyProperty.builder()
     *                         .firewallDeploymentModel("firewallDeploymentModel")
     *                         .build())
     *                 .thirdPartyFirewallPolicy(ThirdPartyFirewallPolicyProperty.builder()
     *                         .firewallDeploymentModel("firewallDeploymentModel")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fms.CfnPolicy.SecurityServicePolicyDataProperty")
    @software.amazon.jsii.Jsii.Proxy(SecurityServicePolicyDataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SecurityServicePolicyDataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnPolicy.SecurityServicePolicyDataProperty.Type`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * `CfnPolicy.SecurityServicePolicyDataProperty.ManagedServiceData`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getManagedServiceData() {
            return null;
        }

        /**
         * `CfnPolicy.SecurityServicePolicyDataProperty.PolicyOption`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPolicyOption() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SecurityServicePolicyDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SecurityServicePolicyDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SecurityServicePolicyDataProperty> {
            java.lang.String type;
            java.lang.String managedServiceData;
            java.lang.Object policyOption;

            /**
             * Sets the value of {@link SecurityServicePolicyDataProperty#getType}
             * @param type `CfnPolicy.SecurityServicePolicyDataProperty.Type`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link SecurityServicePolicyDataProperty#getManagedServiceData}
             * @param managedServiceData `CfnPolicy.SecurityServicePolicyDataProperty.ManagedServiceData`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedServiceData(java.lang.String managedServiceData) {
                this.managedServiceData = managedServiceData;
                return this;
            }

            /**
             * Sets the value of {@link SecurityServicePolicyDataProperty#getPolicyOption}
             * @param policyOption `CfnPolicy.SecurityServicePolicyDataProperty.PolicyOption`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyOption(software.amazon.awscdk.services.fms.CfnPolicy.PolicyOptionProperty policyOption) {
                this.policyOption = policyOption;
                return this;
            }

            /**
             * Sets the value of {@link SecurityServicePolicyDataProperty#getPolicyOption}
             * @param policyOption `CfnPolicy.SecurityServicePolicyDataProperty.PolicyOption`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyOption(software.amazon.awscdk.IResolvable policyOption) {
                this.policyOption = policyOption;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SecurityServicePolicyDataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SecurityServicePolicyDataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SecurityServicePolicyDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecurityServicePolicyDataProperty {
            private final java.lang.String type;
            private final java.lang.String managedServiceData;
            private final java.lang.Object policyOption;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.managedServiceData = software.amazon.jsii.Kernel.get(this, "managedServiceData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.policyOption = software.amazon.jsii.Kernel.get(this, "policyOption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.managedServiceData = builder.managedServiceData;
                this.policyOption = builder.policyOption;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getManagedServiceData() {
                return this.managedServiceData;
            }

            @Override
            public final java.lang.Object getPolicyOption() {
                return this.policyOption;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getManagedServiceData() != null) {
                    data.set("managedServiceData", om.valueToTree(this.getManagedServiceData()));
                }
                if (this.getPolicyOption() != null) {
                    data.set("policyOption", om.valueToTree(this.getPolicyOption()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fms.CfnPolicy.SecurityServicePolicyDataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SecurityServicePolicyDataProperty.Jsii$Proxy that = (SecurityServicePolicyDataProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.managedServiceData != null ? !this.managedServiceData.equals(that.managedServiceData) : that.managedServiceData != null) return false;
                return this.policyOption != null ? this.policyOption.equals(that.policyOption) : that.policyOption == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.managedServiceData != null ? this.managedServiceData.hashCode() : 0);
                result = 31 * result + (this.policyOption != null ? this.policyOption.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.fms.*;
     * ThirdPartyFirewallPolicyProperty thirdPartyFirewallPolicyProperty = ThirdPartyFirewallPolicyProperty.builder()
     *         .firewallDeploymentModel("firewallDeploymentModel")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fms.CfnPolicy.ThirdPartyFirewallPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ThirdPartyFirewallPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ThirdPartyFirewallPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnPolicy.ThirdPartyFirewallPolicyProperty.FirewallDeploymentModel`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFirewallDeploymentModel();

        /**
         * @return a {@link Builder} of {@link ThirdPartyFirewallPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ThirdPartyFirewallPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ThirdPartyFirewallPolicyProperty> {
            java.lang.String firewallDeploymentModel;

            /**
             * Sets the value of {@link ThirdPartyFirewallPolicyProperty#getFirewallDeploymentModel}
             * @param firewallDeploymentModel `CfnPolicy.ThirdPartyFirewallPolicyProperty.FirewallDeploymentModel`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firewallDeploymentModel(java.lang.String firewallDeploymentModel) {
                this.firewallDeploymentModel = firewallDeploymentModel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ThirdPartyFirewallPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ThirdPartyFirewallPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ThirdPartyFirewallPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThirdPartyFirewallPolicyProperty {
            private final java.lang.String firewallDeploymentModel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.firewallDeploymentModel = software.amazon.jsii.Kernel.get(this, "firewallDeploymentModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.firewallDeploymentModel = java.util.Objects.requireNonNull(builder.firewallDeploymentModel, "firewallDeploymentModel is required");
            }

            @Override
            public final java.lang.String getFirewallDeploymentModel() {
                return this.firewallDeploymentModel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("firewallDeploymentModel", om.valueToTree(this.getFirewallDeploymentModel()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fms.CfnPolicy.ThirdPartyFirewallPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ThirdPartyFirewallPolicyProperty.Jsii$Proxy that = (ThirdPartyFirewallPolicyProperty.Jsii$Proxy) o;

                return this.firewallDeploymentModel.equals(that.firewallDeploymentModel);
            }

            @Override
            public final int hashCode() {
                int result = this.firewallDeploymentModel.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.fms.CfnPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.fms.CfnPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.fms.CfnPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.fms.CfnPolicyProps.Builder();
        }

        /**
         * Used only when tags are specified in the `ResourceTags` property.
         * <p>
         * If this property is <code>True</code> , resources with the specified tags are not in scope of the policy. If it's <code>False</code> , only resources with the specified tags are in scope of the policy.
         * <p>
         * @return {@code this}
         * @param excludeResourceTags Used only when tags are specified in the `ResourceTags` property. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeResourceTags(final java.lang.Boolean excludeResourceTags) {
            this.props.excludeResourceTags(excludeResourceTags);
            return this;
        }
        /**
         * Used only when tags are specified in the `ResourceTags` property.
         * <p>
         * If this property is <code>True</code> , resources with the specified tags are not in scope of the policy. If it's <code>False</code> , only resources with the specified tags are in scope of the policy.
         * <p>
         * @return {@code this}
         * @param excludeResourceTags Used only when tags are specified in the `ResourceTags` property. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeResourceTags(final software.amazon.awscdk.IResolvable excludeResourceTags) {
            this.props.excludeResourceTags(excludeResourceTags);
            return this;
        }

        /**
         * The name of the AWS Firewall Manager policy.
         * <p>
         * @return {@code this}
         * @param policyName The name of the AWS Firewall Manager policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyName(final java.lang.String policyName) {
            this.props.policyName(policyName);
            return this;
        }

        /**
         * Indicates if the policy should be automatically applied to new resources.
         * <p>
         * @return {@code this}
         * @param remediationEnabled Indicates if the policy should be automatically applied to new resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder remediationEnabled(final java.lang.Boolean remediationEnabled) {
            this.props.remediationEnabled(remediationEnabled);
            return this;
        }
        /**
         * Indicates if the policy should be automatically applied to new resources.
         * <p>
         * @return {@code this}
         * @param remediationEnabled Indicates if the policy should be automatically applied to new resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder remediationEnabled(final software.amazon.awscdk.IResolvable remediationEnabled) {
            this.props.remediationEnabled(remediationEnabled);
            return this;
        }

        /**
         * The type of resource protected by or in scope of the policy.
         * <p>
         * This is in the format shown in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">AWS Resource Types Reference</a> . To apply this policy to multiple resource types, specify a resource type of <code>ResourceTypeList</code> and then specify the resource types in a <code>ResourceTypeList</code> .
         * <p>
         * For AWS WAF and Shield Advanced, example resource types include <code>AWS::ElasticLoadBalancingV2::LoadBalancer</code> and <code>AWS::CloudFront::Distribution</code> . For a security group common policy, valid values are <code>AWS::EC2::NetworkInterface</code> and <code>AWS::EC2::Instance</code> . For a security group content audit policy, valid values are <code>AWS::EC2::SecurityGroup</code> , <code>AWS::EC2::NetworkInterface</code> , and <code>AWS::EC2::Instance</code> . For a security group usage audit policy, the value is <code>AWS::EC2::SecurityGroup</code> . For an AWS Network Firewall policy or DNS Firewall policy, the value is <code>AWS::EC2::VPC</code> .
         * <p>
         * @return {@code this}
         * @param resourceType The type of resource protected by or in scope of the policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(final java.lang.String resourceType) {
            this.props.resourceType(resourceType);
            return this;
        }

        /**
         * Details about the security service that is being used to protect the resources.
         * <p>
         * This contains the following settings:
         * <p>
         * <ul>
         * <li>Type - Indicates the service type that the policy uses to protect the resource. For security group policies, Firewall Manager supports one security group for each common policy and for each content audit policy. This is an adjustable limit that you can increase by contacting AWS Support .</li>
         * </ul>
         * <p>
         * Valid values: <code>DNS_FIREWALL</code> | <code>NETWORK_FIREWALL</code> | <code>SECURITY_GROUPS_COMMON</code> | <code>SECURITY_GROUPS_CONTENT_AUDIT</code> | <code>SECURITY_GROUPS_USAGE_AUDIT</code> | <code>SHIELD_ADVANCED</code> | <code>WAFV2</code> | <code>WAF</code>
         * <p>
         * <ul>
         * <li>ManagedServiceData - Details about the service that are specific to the service type, in JSON format.</li>
         * <li>Example: <code>DNS_FIREWALL</code></li>
         * </ul>
         * <p>
         * <code>"ManagedServiceData": "{ \"type\": \"DNS_FIREWALL\", \"preProcessRuleGroups\": [{\"ruleGroupId\": \"rslvr-frg-123456\", \"priority\": 11}], \"postProcessRuleGroups\": [{\"ruleGroupId\": \"rslvr-frg-123456\", \"priority\": 9902}]}"</code>
         * <p>
         * <ul>
         * <li>Example: <code>NETWORK_FIREWALL</code></li>
         * </ul>
         * <p>
         * <code>"ManagedServiceData":"{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:000000000000:stateless-rulegroup\/example\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:drop\",\"example\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:drop\",\"example\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"example\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"example\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:000000000000:stateful-rulegroup\/example\"}],\"networkFirewallOrchestrationConfig\":{\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":[]}}"</code>
         * <p>
         * <ul>
         * <li>Example: <code>SECURITY_GROUPS_COMMON</code></li>
         * </ul>
         * <p>
         * <code>"SecurityServicePolicyData":{"Type":"SECURITY_GROUPS_COMMON","ManagedServiceData":"{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false,\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd\"}]}"},"RemediationEnabled":false,"ResourceType":"AWS::EC2::NetworkInterface"}</code>
         * <p>
         * <ul>
         * <li>Example: <code>SECURITY_GROUPS_CONTENT_AUDIT</code></li>
         * </ul>
         * <p>
         * <code>"SecurityServicePolicyData":{"Type":"SECURITY_GROUPS_CONTENT_AUDIT","ManagedServiceData":"{\"type\":\"SECURITY_GROUPS_CONTENT_AUDIT\",\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd \"}],\"securityGroupAction\":{\"type\":\"ALLOW\"}}"},"RemediationEnabled":false,"ResourceType":"AWS::EC2::NetworkInterface"}</code>
         * <p>
         * The security group action for content audit can be <code>ALLOW</code> or <code>DENY</code> . For <code>ALLOW</code> , all in-scope security group rules must be within the allowed range of the policy's security group rules. For <code>DENY</code> , all in-scope security group rules must not contain a value or a range that matches a rule value or range in the policy security group.
         * <p>
         * <ul>
         * <li>Example: <code>SECURITY_GROUPS_USAGE_AUDIT</code></li>
         * </ul>
         * <p>
         * <code>"SecurityServicePolicyData":{"Type":"SECURITY_GROUPS_USAGE_AUDIT","ManagedServiceData":"{\"type\":\"SECURITY_GROUPS_USAGE_AUDIT\",\"deleteUnusedSecurityGroups\":true,\"coalesceRedundantSecurityGroups\":true}"},"RemediationEnabled":false,"Resou rceType":"AWS::EC2::SecurityGroup"}</code>
         * <p>
         * <ul>
         * <li>Specification for <code>SHIELD_ADVANCED</code> for Amazon CloudFront distributions</li>
         * </ul>
         * <p>
         * <code>"ManagedServiceData": "{\"type\": \"SHIELD_ADVANCED\", \"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED|IGNORED|DISABLED\", \"automaticResponseAction\":\"BLOCK|COUNT\"}, \"overrideCustomerWebaclClassic\":true|false}"</code>
         * <p>
         * For example: <code>"ManagedServiceData": "{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED\", \"automaticResponseAction\":\"COUNT\"}}"</code>
         * <p>
         * The default value for <code>automaticResponseStatus</code> is <code>IGNORED</code> . The value for <code>automaticResponseAction</code> is only required when <code>automaticResponseStatus</code> is set to <code>ENABLED</code> . The default value for <code>overrideCustomerWebaclClassic</code> is <code>false</code> .
         * <p>
         * For other resource types that you can protect with a Shield Advanced policy, this <code>ManagedServiceData</code> configuration is an empty string.
         * <p>
         * <ul>
         * <li>Example: <code>WAFV2</code></li>
         * </ul>
         * <p>
         * <code>"ManagedServiceData": "{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"version\":null,\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesAmazonIpReputationList\"},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[]}],\"postProcessRuleGroups\":[],\"defaultAction\":{\"type\":\"ALLOW\"},\"overrideCustomerWebACLAssociation\":false,\"loggingConfiguration\":{\"logDestinationConfigs\":[\"arn:aws:firehose:us-west-2:12345678912:deliverystream/aws-waf-logs-fms-admin-destination\"],\"redactedFields\":[{\"redactedFieldType\":\"SingleHeader\",\"redactedFieldValue\":\"Cookies\"},{\"redactedFieldType\":\"Method\"}]}}"</code>
         * <p>
         * In the <code>loggingConfiguration</code> , you can specify one <code>logDestinationConfigs</code> , you can optionally provide up to 20 <code>redactedFields</code> , and the <code>RedactedFieldType</code> must be one of <code>URI</code> , <code>QUERY_STRING</code> , <code>HEADER</code> , or <code>METHOD</code> .
         * <p>
         * <ul>
         * <li>Example: <code>WAF Classic</code></li>
         * </ul>
         * <p>
         * <code>"ManagedServiceData": "{\"type\": \"WAF\", \"ruleGroups\": [{\"id\":\"12345678-1bcd-9012-efga-0987654321ab\", \"overrideAction\" : {\"type\": \"COUNT\"}}],\"defaultAction\": {\"type\": \"BLOCK\"}}</code>
         * <p>
         * AWS WAF Classic doesn't support rule groups in CloudFront . To create a WAF Classic policy through CloudFormation, create your rule groups outside of CloudFront , then provide the rule group IDs in the WAF managed service data specification.
         * <p>
         * @return {@code this}
         * @param securityServicePolicyData Details about the security service that is being used to protect the resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityServicePolicyData(final software.amazon.awscdk.services.fms.CfnPolicy.SecurityServicePolicyDataProperty securityServicePolicyData) {
            this.props.securityServicePolicyData(securityServicePolicyData);
            return this;
        }
        /**
         * Details about the security service that is being used to protect the resources.
         * <p>
         * This contains the following settings:
         * <p>
         * <ul>
         * <li>Type - Indicates the service type that the policy uses to protect the resource. For security group policies, Firewall Manager supports one security group for each common policy and for each content audit policy. This is an adjustable limit that you can increase by contacting AWS Support .</li>
         * </ul>
         * <p>
         * Valid values: <code>DNS_FIREWALL</code> | <code>NETWORK_FIREWALL</code> | <code>SECURITY_GROUPS_COMMON</code> | <code>SECURITY_GROUPS_CONTENT_AUDIT</code> | <code>SECURITY_GROUPS_USAGE_AUDIT</code> | <code>SHIELD_ADVANCED</code> | <code>WAFV2</code> | <code>WAF</code>
         * <p>
         * <ul>
         * <li>ManagedServiceData - Details about the service that are specific to the service type, in JSON format.</li>
         * <li>Example: <code>DNS_FIREWALL</code></li>
         * </ul>
         * <p>
         * <code>"ManagedServiceData": "{ \"type\": \"DNS_FIREWALL\", \"preProcessRuleGroups\": [{\"ruleGroupId\": \"rslvr-frg-123456\", \"priority\": 11}], \"postProcessRuleGroups\": [{\"ruleGroupId\": \"rslvr-frg-123456\", \"priority\": 9902}]}"</code>
         * <p>
         * <ul>
         * <li>Example: <code>NETWORK_FIREWALL</code></li>
         * </ul>
         * <p>
         * <code>"ManagedServiceData":"{\"type\":\"NETWORK_FIREWALL\",\"networkFirewallStatelessRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:000000000000:stateless-rulegroup\/example\",\"priority\":1}],\"networkFirewallStatelessDefaultActions\":[\"aws:drop\",\"example\"],\"networkFirewallStatelessFragmentDefaultActions\":[\"aws:drop\",\"example\"],\"networkFirewallStatelessCustomActions\":[{\"actionName\":\"example\",\"actionDefinition\":{\"publishMetricAction\":{\"dimensions\":[{\"value\":\"example\"}]}}}],\"networkFirewallStatefulRuleGroupReferences\":[{\"resourceARN\":\"arn:aws:network-firewall:us-east-1:000000000000:stateful-rulegroup\/example\"}],\"networkFirewallOrchestrationConfig\":{\"singleFirewallEndpointPerVPC\":false,\"allowedIPV4CidrList\":[]}}"</code>
         * <p>
         * <ul>
         * <li>Example: <code>SECURITY_GROUPS_COMMON</code></li>
         * </ul>
         * <p>
         * <code>"SecurityServicePolicyData":{"Type":"SECURITY_GROUPS_COMMON","ManagedServiceData":"{\"type\":\"SECURITY_GROUPS_COMMON\",\"revertManualSecurityGroupChanges\":false,\"exclusiveResourceSecurityGroupManagement\":false,\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd\"}]}"},"RemediationEnabled":false,"ResourceType":"AWS::EC2::NetworkInterface"}</code>
         * <p>
         * <ul>
         * <li>Example: <code>SECURITY_GROUPS_CONTENT_AUDIT</code></li>
         * </ul>
         * <p>
         * <code>"SecurityServicePolicyData":{"Type":"SECURITY_GROUPS_CONTENT_AUDIT","ManagedServiceData":"{\"type\":\"SECURITY_GROUPS_CONTENT_AUDIT\",\"securityGroups\":[{\"id\":\" sg-000e55995d61a06bd \"}],\"securityGroupAction\":{\"type\":\"ALLOW\"}}"},"RemediationEnabled":false,"ResourceType":"AWS::EC2::NetworkInterface"}</code>
         * <p>
         * The security group action for content audit can be <code>ALLOW</code> or <code>DENY</code> . For <code>ALLOW</code> , all in-scope security group rules must be within the allowed range of the policy's security group rules. For <code>DENY</code> , all in-scope security group rules must not contain a value or a range that matches a rule value or range in the policy security group.
         * <p>
         * <ul>
         * <li>Example: <code>SECURITY_GROUPS_USAGE_AUDIT</code></li>
         * </ul>
         * <p>
         * <code>"SecurityServicePolicyData":{"Type":"SECURITY_GROUPS_USAGE_AUDIT","ManagedServiceData":"{\"type\":\"SECURITY_GROUPS_USAGE_AUDIT\",\"deleteUnusedSecurityGroups\":true,\"coalesceRedundantSecurityGroups\":true}"},"RemediationEnabled":false,"Resou rceType":"AWS::EC2::SecurityGroup"}</code>
         * <p>
         * <ul>
         * <li>Specification for <code>SHIELD_ADVANCED</code> for Amazon CloudFront distributions</li>
         * </ul>
         * <p>
         * <code>"ManagedServiceData": "{\"type\": \"SHIELD_ADVANCED\", \"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED|IGNORED|DISABLED\", \"automaticResponseAction\":\"BLOCK|COUNT\"}, \"overrideCustomerWebaclClassic\":true|false}"</code>
         * <p>
         * For example: <code>"ManagedServiceData": "{\"type\":\"SHIELD_ADVANCED\",\"automaticResponseConfiguration\": {\"automaticResponseStatus\":\"ENABLED\", \"automaticResponseAction\":\"COUNT\"}}"</code>
         * <p>
         * The default value for <code>automaticResponseStatus</code> is <code>IGNORED</code> . The value for <code>automaticResponseAction</code> is only required when <code>automaticResponseStatus</code> is set to <code>ENABLED</code> . The default value for <code>overrideCustomerWebaclClassic</code> is <code>false</code> .
         * <p>
         * For other resource types that you can protect with a Shield Advanced policy, this <code>ManagedServiceData</code> configuration is an empty string.
         * <p>
         * <ul>
         * <li>Example: <code>WAFV2</code></li>
         * </ul>
         * <p>
         * <code>"ManagedServiceData": "{\"type\":\"WAFV2\",\"preProcessRuleGroups\":[{\"ruleGroupArn\":null,\"overrideAction\":{\"type\":\"NONE\"},\"managedRuleGroupIdentifier\":{\"version\":null,\"vendorName\":\"AWS\",\"managedRuleGroupName\":\"AWSManagedRulesAmazonIpReputationList\"},\"ruleGroupType\":\"ManagedRuleGroup\",\"excludeRules\":[]}],\"postProcessRuleGroups\":[],\"defaultAction\":{\"type\":\"ALLOW\"},\"overrideCustomerWebACLAssociation\":false,\"loggingConfiguration\":{\"logDestinationConfigs\":[\"arn:aws:firehose:us-west-2:12345678912:deliverystream/aws-waf-logs-fms-admin-destination\"],\"redactedFields\":[{\"redactedFieldType\":\"SingleHeader\",\"redactedFieldValue\":\"Cookies\"},{\"redactedFieldType\":\"Method\"}]}}"</code>
         * <p>
         * In the <code>loggingConfiguration</code> , you can specify one <code>logDestinationConfigs</code> , you can optionally provide up to 20 <code>redactedFields</code> , and the <code>RedactedFieldType</code> must be one of <code>URI</code> , <code>QUERY_STRING</code> , <code>HEADER</code> , or <code>METHOD</code> .
         * <p>
         * <ul>
         * <li>Example: <code>WAF Classic</code></li>
         * </ul>
         * <p>
         * <code>"ManagedServiceData": "{\"type\": \"WAF\", \"ruleGroups\": [{\"id\":\"12345678-1bcd-9012-efga-0987654321ab\", \"overrideAction\" : {\"type\": \"COUNT\"}}],\"defaultAction\": {\"type\": \"BLOCK\"}}</code>
         * <p>
         * AWS WAF Classic doesn't support rule groups in CloudFront . To create a WAF Classic policy through CloudFormation, create your rule groups outside of CloudFront , then provide the rule group IDs in the WAF managed service data specification.
         * <p>
         * @return {@code this}
         * @param securityServicePolicyData Details about the security service that is being used to protect the resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityServicePolicyData(final software.amazon.awscdk.IResolvable securityServicePolicyData) {
            this.props.securityServicePolicyData(securityServicePolicyData);
            return this;
        }

        /**
         * Used when deleting a policy. If `true` , Firewall Manager performs cleanup according to the policy type.
         * <p>
         * For AWS WAF and Shield Advanced policies, Firewall Manager does the following:
         * <p>
         * <ul>
         * <li>Deletes rule groups created by Firewall Manager</li>
         * <li>Removes web ACLs from in-scope resources</li>
         * <li>Deletes web ACLs that contain no rules or rule groups</li>
         * </ul>
         * <p>
         * For security group policies, Firewall Manager does the following for each security group in the policy:
         * <p>
         * <ul>
         * <li>Disassociates the security group from in-scope resources</li>
         * <li>Deletes the security group if it was created through Firewall Manager and if it's no longer associated with any resources through another policy</li>
         * </ul>
         * <p>
         * After the cleanup, in-scope resources are no longer protected by web ACLs in this policy. Protection of out-of-scope resources remains unchanged. Scope is determined by tags that you create and accounts that you associate with the policy. When creating the policy, if you specify that only resources in specific accounts or with specific tags are in scope of the policy, those accounts and resources are handled by the policy. All others are out of scope. If you don't specify tags or accounts, all resources are in scope.
         * <p>
         * @return {@code this}
         * @param deleteAllPolicyResources Used when deleting a policy. If `true` , Firewall Manager performs cleanup according to the policy type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAllPolicyResources(final java.lang.Boolean deleteAllPolicyResources) {
            this.props.deleteAllPolicyResources(deleteAllPolicyResources);
            return this;
        }
        /**
         * Used when deleting a policy. If `true` , Firewall Manager performs cleanup according to the policy type.
         * <p>
         * For AWS WAF and Shield Advanced policies, Firewall Manager does the following:
         * <p>
         * <ul>
         * <li>Deletes rule groups created by Firewall Manager</li>
         * <li>Removes web ACLs from in-scope resources</li>
         * <li>Deletes web ACLs that contain no rules or rule groups</li>
         * </ul>
         * <p>
         * For security group policies, Firewall Manager does the following for each security group in the policy:
         * <p>
         * <ul>
         * <li>Disassociates the security group from in-scope resources</li>
         * <li>Deletes the security group if it was created through Firewall Manager and if it's no longer associated with any resources through another policy</li>
         * </ul>
         * <p>
         * After the cleanup, in-scope resources are no longer protected by web ACLs in this policy. Protection of out-of-scope resources remains unchanged. Scope is determined by tags that you create and accounts that you associate with the policy. When creating the policy, if you specify that only resources in specific accounts or with specific tags are in scope of the policy, those accounts and resources are handled by the policy. All others are out of scope. If you don't specify tags or accounts, all resources are in scope.
         * <p>
         * @return {@code this}
         * @param deleteAllPolicyResources Used when deleting a policy. If `true` , Firewall Manager performs cleanup according to the policy type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAllPolicyResources(final software.amazon.awscdk.IResolvable deleteAllPolicyResources) {
            this.props.deleteAllPolicyResources(deleteAllPolicyResources);
            return this;
        }

        /**
         * Specifies the AWS account IDs and AWS Organizations organizational units (OUs) to exclude from the policy.
         * <p>
         * Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
         * <p>
         * You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code> , AWS Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code> , and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code> , then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code> .
         * <p>
         * You can specify account IDs, OUs, or a combination:
         * <p>
         * <ul>
         * <li>Specify account IDs by setting the key to <code>ACCOUNT</code> . For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code> .</li>
         * <li>Specify OUs by setting the key to <code>ORGUNIT</code> . For example, the following is a valid map: <code>{“ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
         * <li>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param excludeMap Specifies the AWS account IDs and AWS Organizations organizational units (OUs) to exclude from the policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeMap(final software.amazon.awscdk.services.fms.CfnPolicy.IEMapProperty excludeMap) {
            this.props.excludeMap(excludeMap);
            return this;
        }
        /**
         * Specifies the AWS account IDs and AWS Organizations organizational units (OUs) to exclude from the policy.
         * <p>
         * Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
         * <p>
         * You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code> , AWS Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code> , and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code> , then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code> .
         * <p>
         * You can specify account IDs, OUs, or a combination:
         * <p>
         * <ul>
         * <li>Specify account IDs by setting the key to <code>ACCOUNT</code> . For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code> .</li>
         * <li>Specify OUs by setting the key to <code>ORGUNIT</code> . For example, the following is a valid map: <code>{“ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
         * <li>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param excludeMap Specifies the AWS account IDs and AWS Organizations organizational units (OUs) to exclude from the policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeMap(final software.amazon.awscdk.IResolvable excludeMap) {
            this.props.excludeMap(excludeMap);
            return this;
        }

        /**
         * Specifies the AWS account IDs and AWS Organizations organizational units (OUs) to include in the policy.
         * <p>
         * Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
         * <p>
         * You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code> , AWS Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code> , and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code> , then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code> .
         * <p>
         * You can specify account IDs, OUs, or a combination:
         * <p>
         * <ul>
         * <li>Specify account IDs by setting the key to <code>ACCOUNT</code> . For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code> .</li>
         * <li>Specify OUs by setting the key to <code>ORGUNIT</code> . For example, the following is a valid map: <code>{“ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
         * <li>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param includeMap Specifies the AWS account IDs and AWS Organizations organizational units (OUs) to include in the policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeMap(final software.amazon.awscdk.services.fms.CfnPolicy.IEMapProperty includeMap) {
            this.props.includeMap(includeMap);
            return this;
        }
        /**
         * Specifies the AWS account IDs and AWS Organizations organizational units (OUs) to include in the policy.
         * <p>
         * Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
         * <p>
         * You can specify inclusions or exclusions, but not both. If you specify an <code>IncludeMap</code> , AWS Firewall Manager applies the policy to all accounts specified by the <code>IncludeMap</code> , and does not evaluate any <code>ExcludeMap</code> specifications. If you do not specify an <code>IncludeMap</code> , then Firewall Manager applies the policy to all accounts except for those specified by the <code>ExcludeMap</code> .
         * <p>
         * You can specify account IDs, OUs, or a combination:
         * <p>
         * <ul>
         * <li>Specify account IDs by setting the key to <code>ACCOUNT</code> . For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”]}</code> .</li>
         * <li>Specify OUs by setting the key to <code>ORGUNIT</code> . For example, the following is a valid map: <code>{“ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
         * <li>Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: <code>{“ACCOUNT” : [“accountID1”, “accountID2”], “ORGUNIT” : [“ouid111”, “ouid112”]}</code> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param includeMap Specifies the AWS account IDs and AWS Organizations organizational units (OUs) to include in the policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeMap(final software.amazon.awscdk.IResolvable includeMap) {
            this.props.includeMap(includeMap);
            return this;
        }

        /**
         * Indicates whether AWS Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope.
         * <p>
         * For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope.
         * <p>
         * By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources.
         * <p>
         * This option is not available for Shield Advanced or AWS WAF Classic policies.
         * <p>
         * @return {@code this}
         * @param resourcesCleanUp Indicates whether AWS Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcesCleanUp(final java.lang.Boolean resourcesCleanUp) {
            this.props.resourcesCleanUp(resourcesCleanUp);
            return this;
        }
        /**
         * Indicates whether AWS Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope.
         * <p>
         * For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope.
         * <p>
         * By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources.
         * <p>
         * This option is not available for Shield Advanced or AWS WAF Classic policies.
         * <p>
         * @return {@code this}
         * @param resourcesCleanUp Indicates whether AWS Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourcesCleanUp(final software.amazon.awscdk.IResolvable resourcesCleanUp) {
            this.props.resourcesCleanUp(resourcesCleanUp);
            return this;
        }

        /**
         * An array of `ResourceTag` objects, used to explicitly include resources in the policy scope or explicitly exclude them.
         * <p>
         * If this isn't set, then tags aren't used to modify policy scope. See also <code>ExcludeResourceTags</code> .
         * <p>
         * @return {@code this}
         * @param resourceTags An array of `ResourceTag` objects, used to explicitly include resources in the policy scope or explicitly exclude them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceTags(final software.amazon.awscdk.IResolvable resourceTags) {
            this.props.resourceTags(resourceTags);
            return this;
        }
        /**
         * An array of `ResourceTag` objects, used to explicitly include resources in the policy scope or explicitly exclude them.
         * <p>
         * If this isn't set, then tags aren't used to modify policy scope. See also <code>ExcludeResourceTags</code> .
         * <p>
         * @return {@code this}
         * @param resourceTags An array of `ResourceTag` objects, used to explicitly include resources in the policy scope or explicitly exclude them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceTags(final java.util.List<? extends java.lang.Object> resourceTags) {
            this.props.resourceTags(resourceTags);
            return this;
        }

        /**
         * An array of `ResourceType` objects.
         * <p>
         * Use this only to specify multiple resource types. To specify a single resource type, use <code>ResourceType</code> .
         * <p>
         * @return {@code this}
         * @param resourceTypeList An array of `ResourceType` objects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceTypeList(final java.util.List<java.lang.String> resourceTypeList) {
            this.props.resourceTypeList(resourceTypeList);
            return this;
        }

        /**
         * A collection of key:value pairs associated with an AWS resource.
         * <p>
         * The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
         * <p>
         * @return {@code this}
         * @param tags A collection of key:value pairs associated with an AWS resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.services.fms.CfnPolicy.PolicyTagProperty> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.fms.CfnPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.fms.CfnPolicy build() {
            return new software.amazon.awscdk.services.fms.CfnPolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
