package software.amazon.awscdk.services.events;

/**
 * The event archive base properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EventBus bus = EventBus.Builder.create(this, "bus")
 *         .eventBusName("MyCustomEventBus")
 *         .build();
 * bus.archive("MyArchive", BaseArchiveProps.builder()
 *         .archiveName("MyCustomEventBusArchive")
 *         .description("MyCustomerEventBus Archive")
 *         .eventPattern(EventPattern.builder()
 *                 .account(List.of(Stack.of(this).getAccount()))
 *                 .build())
 *         .retention(Duration.days(365))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:07.760Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.BaseArchiveProps")
@software.amazon.jsii.Jsii.Proxy(BaseArchiveProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BaseArchiveProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An event pattern to use to filter events sent to the archive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.EventPattern getEventPattern();

    /**
     * The name of the archive.
     * <p>
     * Default: - Automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getArchiveName() {
        return null;
    }

    /**
     * A description for the archive.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The number of days to retain events for.
     * <p>
     * Default value is 0. If set to 0, events are retained indefinitely.
     * <p>
     * Default: - Infinite
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getRetention() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BaseArchiveProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BaseArchiveProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BaseArchiveProps> {
        software.amazon.awscdk.services.events.EventPattern eventPattern;
        java.lang.String archiveName;
        java.lang.String description;
        software.amazon.awscdk.Duration retention;

        /**
         * Sets the value of {@link BaseArchiveProps#getEventPattern}
         * @param eventPattern An event pattern to use to filter events sent to the archive. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventPattern(software.amazon.awscdk.services.events.EventPattern eventPattern) {
            this.eventPattern = eventPattern;
            return this;
        }

        /**
         * Sets the value of {@link BaseArchiveProps#getArchiveName}
         * @param archiveName The name of the archive.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder archiveName(java.lang.String archiveName) {
            this.archiveName = archiveName;
            return this;
        }

        /**
         * Sets the value of {@link BaseArchiveProps#getDescription}
         * @param description A description for the archive.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link BaseArchiveProps#getRetention}
         * @param retention The number of days to retain events for.
         *                  Default value is 0. If set to 0, events are retained indefinitely.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retention(software.amazon.awscdk.Duration retention) {
            this.retention = retention;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseArchiveProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BaseArchiveProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BaseArchiveProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaseArchiveProps {
        private final software.amazon.awscdk.services.events.EventPattern eventPattern;
        private final java.lang.String archiveName;
        private final java.lang.String description;
        private final software.amazon.awscdk.Duration retention;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventPattern = software.amazon.jsii.Kernel.get(this, "eventPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.EventPattern.class));
            this.archiveName = software.amazon.jsii.Kernel.get(this, "archiveName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.retention = software.amazon.jsii.Kernel.get(this, "retention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventPattern = java.util.Objects.requireNonNull(builder.eventPattern, "eventPattern is required");
            this.archiveName = builder.archiveName;
            this.description = builder.description;
            this.retention = builder.retention;
        }

        @Override
        public final software.amazon.awscdk.services.events.EventPattern getEventPattern() {
            return this.eventPattern;
        }

        @Override
        public final java.lang.String getArchiveName() {
            return this.archiveName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.Duration getRetention() {
            return this.retention;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eventPattern", om.valueToTree(this.getEventPattern()));
            if (this.getArchiveName() != null) {
                data.set("archiveName", om.valueToTree(this.getArchiveName()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getRetention() != null) {
                data.set("retention", om.valueToTree(this.getRetention()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events.BaseArchiveProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BaseArchiveProps.Jsii$Proxy that = (BaseArchiveProps.Jsii$Proxy) o;

            if (!eventPattern.equals(that.eventPattern)) return false;
            if (this.archiveName != null ? !this.archiveName.equals(that.archiveName) : that.archiveName != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.retention != null ? this.retention.equals(that.retention) : that.retention == null;
        }

        @Override
        public final int hashCode() {
            int result = this.eventPattern.hashCode();
            result = 31 * result + (this.archiveName != null ? this.archiveName.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.retention != null ? this.retention.hashCode() : 0);
            return result;
        }
    }
}
