package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * How to interpret the load balancing target identifiers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * ApplicationTargetGroup tg = ApplicationTargetGroup.Builder.create(this, "TG")
 *         .targetType(TargetType.IP)
 *         .port(50051)
 *         .protocol(ApplicationProtocol.HTTP)
 *         .protocolVersion(ApplicationProtocolVersion.GRPC)
 *         .healthCheck(HealthCheck.builder()
 *                 .enabled(true)
 *                 .healthyGrpcCodes("0-99")
 *                 .build())
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:07.647Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.TargetType")
public enum TargetType {
    /**
     * Targets identified by instance ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INSTANCE,
    /**
     * Targets identified by IP address.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IP,
    /**
     * Target is a single Lambda Function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LAMBDA,
    /**
     * Target is a single Application Load Balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALB,
}
