package software.amazon.awscdk.services.ecs;

/**
 * Specifies the syslog log driver configuration options.
 * <p>
 * <a href="https://docs.docker.com/config/containers/logging/syslog/">Source</a>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * SyslogLogDriverProps syslogLogDriverProps = SyslogLogDriverProps.builder()
 *         .address("address")
 *         .env(List.of("env"))
 *         .envRegex("envRegex")
 *         .facility("facility")
 *         .format("format")
 *         .labels(List.of("labels"))
 *         .tag("tag")
 *         .tlsCaCert("tlsCaCert")
 *         .tlsCert("tlsCert")
 *         .tlsKey("tlsKey")
 *         .tlsSkipVerify(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:07.262Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.SyslogLogDriverProps")
@software.amazon.jsii.Jsii.Proxy(SyslogLogDriverProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SyslogLogDriverProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.BaseLogDriverProps {

    /**
     * The address of an external syslog server.
     * <p>
     * The URI specifier may be
     * [tcp|udp|tcp+tls]://host:port, unix://path, or unixgram://path.
     * <p>
     * Default: - If the transport is tcp, udp, or tcp+tls, the default port is 514.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAddress() {
        return null;
    }

    /**
     * The syslog facility to use.
     * <p>
     * Can be the number or name for any valid
     * syslog facility. See the syslog documentation:
     * https://tools.ietf.org/html/rfc5424#section-6.2.1.
     * <p>
     * Default: - facility not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFacility() {
        return null;
    }

    /**
     * The syslog message format to use.
     * <p>
     * If not specified the local UNIX syslog
     * format is used, without a specified hostname. Specify rfc3164 for the RFC-3164
     * compatible format, rfc5424 for RFC-5424 compatible format, or rfc5424micro
     * for RFC-5424 compatible format with microsecond timestamp resolution.
     * <p>
     * Default: - format not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFormat() {
        return null;
    }

    /**
     * The absolute path to the trust certificates signed by the CA.
     * <p>
     * Ignored
     * if the address protocol is not tcp+tls.
     * <p>
     * Default: - tlsCaCert not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTlsCaCert() {
        return null;
    }

    /**
     * The absolute path to the TLS certificate file.
     * <p>
     * Ignored if the address
     * protocol is not tcp+tls.
     * <p>
     * Default: - tlsCert not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTlsCert() {
        return null;
    }

    /**
     * The absolute path to the TLS key file.
     * <p>
     * Ignored if the address protocol
     * is not tcp+tls.
     * <p>
     * Default: - tlsKey not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTlsKey() {
        return null;
    }

    /**
     * If set to true, TLS verification is skipped when connecting to the syslog daemon.
     * <p>
     * Ignored if the address protocol is not tcp+tls.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getTlsSkipVerify() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SyslogLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SyslogLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SyslogLogDriverProps> {
        java.lang.String address;
        java.lang.String facility;
        java.lang.String format;
        java.lang.String tlsCaCert;
        java.lang.String tlsCert;
        java.lang.String tlsKey;
        java.lang.Boolean tlsSkipVerify;
        java.util.List<java.lang.String> env;
        java.lang.String envRegex;
        java.util.List<java.lang.String> labels;
        java.lang.String tag;

        /**
         * Sets the value of {@link SyslogLogDriverProps#getAddress}
         * @param address The address of an external syslog server.
         *                The URI specifier may be
         *                [tcp|udp|tcp+tls]://host:port, unix://path, or unixgram://path.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder address(java.lang.String address) {
            this.address = address;
            return this;
        }

        /**
         * Sets the value of {@link SyslogLogDriverProps#getFacility}
         * @param facility The syslog facility to use.
         *                 Can be the number or name for any valid
         *                 syslog facility. See the syslog documentation:
         *                 https://tools.ietf.org/html/rfc5424#section-6.2.1.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder facility(java.lang.String facility) {
            this.facility = facility;
            return this;
        }

        /**
         * Sets the value of {@link SyslogLogDriverProps#getFormat}
         * @param format The syslog message format to use.
         *               If not specified the local UNIX syslog
         *               format is used, without a specified hostname. Specify rfc3164 for the RFC-3164
         *               compatible format, rfc5424 for RFC-5424 compatible format, or rfc5424micro
         *               for RFC-5424 compatible format with microsecond timestamp resolution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder format(java.lang.String format) {
            this.format = format;
            return this;
        }

        /**
         * Sets the value of {@link SyslogLogDriverProps#getTlsCaCert}
         * @param tlsCaCert The absolute path to the trust certificates signed by the CA.
         *                  Ignored
         *                  if the address protocol is not tcp+tls.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsCaCert(java.lang.String tlsCaCert) {
            this.tlsCaCert = tlsCaCert;
            return this;
        }

        /**
         * Sets the value of {@link SyslogLogDriverProps#getTlsCert}
         * @param tlsCert The absolute path to the TLS certificate file.
         *                Ignored if the address
         *                protocol is not tcp+tls.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsCert(java.lang.String tlsCert) {
            this.tlsCert = tlsCert;
            return this;
        }

        /**
         * Sets the value of {@link SyslogLogDriverProps#getTlsKey}
         * @param tlsKey The absolute path to the TLS key file.
         *               Ignored if the address protocol
         *               is not tcp+tls.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsKey(java.lang.String tlsKey) {
            this.tlsKey = tlsKey;
            return this;
        }

        /**
         * Sets the value of {@link SyslogLogDriverProps#getTlsSkipVerify}
         * @param tlsSkipVerify If set to true, TLS verification is skipped when connecting to the syslog daemon.
         *                      Ignored if the address protocol is not tcp+tls.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsSkipVerify(java.lang.Boolean tlsSkipVerify) {
            this.tlsSkipVerify = tlsSkipVerify;
            return this;
        }

        /**
         * Sets the value of {@link SyslogLogDriverProps#getEnv}
         * @param env The env option takes an array of keys.
         *            If there is collision between
         *            label and env keys, the value of the env takes precedence. Adds additional fields
         *            to the extra attributes of a logging message.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(java.util.List<java.lang.String> env) {
            this.env = env;
            return this;
        }

        /**
         * Sets the value of {@link SyslogLogDriverProps#getEnvRegex}
         * @param envRegex The env-regex option is similar to and compatible with env.
         *                 Its value is a regular
         *                 expression to match logging-related environment variables. It is used for advanced
         *                 log tag options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder envRegex(java.lang.String envRegex) {
            this.envRegex = envRegex;
            return this;
        }

        /**
         * Sets the value of {@link SyslogLogDriverProps#getLabels}
         * @param labels The labels option takes an array of keys.
         *               If there is collision
         *               between label and env keys, the value of the env takes precedence. Adds additional
         *               fields to the extra attributes of a logging message.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(java.util.List<java.lang.String> labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Sets the value of {@link SyslogLogDriverProps#getTag}
         * @param tag By default, Docker uses the first 12 characters of the container ID to tag log messages.
         *            Refer to the log tag option documentation for customizing the
         *            log tag format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tag(java.lang.String tag) {
            this.tag = tag;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SyslogLogDriverProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SyslogLogDriverProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SyslogLogDriverProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SyslogLogDriverProps {
        private final java.lang.String address;
        private final java.lang.String facility;
        private final java.lang.String format;
        private final java.lang.String tlsCaCert;
        private final java.lang.String tlsCert;
        private final java.lang.String tlsKey;
        private final java.lang.Boolean tlsSkipVerify;
        private final java.util.List<java.lang.String> env;
        private final java.lang.String envRegex;
        private final java.util.List<java.lang.String> labels;
        private final java.lang.String tag;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.address = software.amazon.jsii.Kernel.get(this, "address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.facility = software.amazon.jsii.Kernel.get(this, "facility", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tlsCaCert = software.amazon.jsii.Kernel.get(this, "tlsCaCert", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tlsCert = software.amazon.jsii.Kernel.get(this, "tlsCert", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tlsKey = software.amazon.jsii.Kernel.get(this, "tlsKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tlsSkipVerify = software.amazon.jsii.Kernel.get(this, "tlsSkipVerify", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.env = software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.envRegex = software.amazon.jsii.Kernel.get(this, "envRegex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.labels = software.amazon.jsii.Kernel.get(this, "labels", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tag = software.amazon.jsii.Kernel.get(this, "tag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.address = builder.address;
            this.facility = builder.facility;
            this.format = builder.format;
            this.tlsCaCert = builder.tlsCaCert;
            this.tlsCert = builder.tlsCert;
            this.tlsKey = builder.tlsKey;
            this.tlsSkipVerify = builder.tlsSkipVerify;
            this.env = builder.env;
            this.envRegex = builder.envRegex;
            this.labels = builder.labels;
            this.tag = builder.tag;
        }

        @Override
        public final java.lang.String getAddress() {
            return this.address;
        }

        @Override
        public final java.lang.String getFacility() {
            return this.facility;
        }

        @Override
        public final java.lang.String getFormat() {
            return this.format;
        }

        @Override
        public final java.lang.String getTlsCaCert() {
            return this.tlsCaCert;
        }

        @Override
        public final java.lang.String getTlsCert() {
            return this.tlsCert;
        }

        @Override
        public final java.lang.String getTlsKey() {
            return this.tlsKey;
        }

        @Override
        public final java.lang.Boolean getTlsSkipVerify() {
            return this.tlsSkipVerify;
        }

        @Override
        public final java.util.List<java.lang.String> getEnv() {
            return this.env;
        }

        @Override
        public final java.lang.String getEnvRegex() {
            return this.envRegex;
        }

        @Override
        public final java.util.List<java.lang.String> getLabels() {
            return this.labels;
        }

        @Override
        public final java.lang.String getTag() {
            return this.tag;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAddress() != null) {
                data.set("address", om.valueToTree(this.getAddress()));
            }
            if (this.getFacility() != null) {
                data.set("facility", om.valueToTree(this.getFacility()));
            }
            if (this.getFormat() != null) {
                data.set("format", om.valueToTree(this.getFormat()));
            }
            if (this.getTlsCaCert() != null) {
                data.set("tlsCaCert", om.valueToTree(this.getTlsCaCert()));
            }
            if (this.getTlsCert() != null) {
                data.set("tlsCert", om.valueToTree(this.getTlsCert()));
            }
            if (this.getTlsKey() != null) {
                data.set("tlsKey", om.valueToTree(this.getTlsKey()));
            }
            if (this.getTlsSkipVerify() != null) {
                data.set("tlsSkipVerify", om.valueToTree(this.getTlsSkipVerify()));
            }
            if (this.getEnv() != null) {
                data.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getEnvRegex() != null) {
                data.set("envRegex", om.valueToTree(this.getEnvRegex()));
            }
            if (this.getLabels() != null) {
                data.set("labels", om.valueToTree(this.getLabels()));
            }
            if (this.getTag() != null) {
                data.set("tag", om.valueToTree(this.getTag()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.SyslogLogDriverProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SyslogLogDriverProps.Jsii$Proxy that = (SyslogLogDriverProps.Jsii$Proxy) o;

            if (this.address != null ? !this.address.equals(that.address) : that.address != null) return false;
            if (this.facility != null ? !this.facility.equals(that.facility) : that.facility != null) return false;
            if (this.format != null ? !this.format.equals(that.format) : that.format != null) return false;
            if (this.tlsCaCert != null ? !this.tlsCaCert.equals(that.tlsCaCert) : that.tlsCaCert != null) return false;
            if (this.tlsCert != null ? !this.tlsCert.equals(that.tlsCert) : that.tlsCert != null) return false;
            if (this.tlsKey != null ? !this.tlsKey.equals(that.tlsKey) : that.tlsKey != null) return false;
            if (this.tlsSkipVerify != null ? !this.tlsSkipVerify.equals(that.tlsSkipVerify) : that.tlsSkipVerify != null) return false;
            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            if (this.envRegex != null ? !this.envRegex.equals(that.envRegex) : that.envRegex != null) return false;
            if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) return false;
            return this.tag != null ? this.tag.equals(that.tag) : that.tag == null;
        }

        @Override
        public final int hashCode() {
            int result = this.address != null ? this.address.hashCode() : 0;
            result = 31 * result + (this.facility != null ? this.facility.hashCode() : 0);
            result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
            result = 31 * result + (this.tlsCaCert != null ? this.tlsCaCert.hashCode() : 0);
            result = 31 * result + (this.tlsCert != null ? this.tlsCert.hashCode() : 0);
            result = 31 * result + (this.tlsKey != null ? this.tlsKey.hashCode() : 0);
            result = 31 * result + (this.tlsSkipVerify != null ? this.tlsSkipVerify.hashCode() : 0);
            result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
            result = 31 * result + (this.envRegex != null ? this.envRegex.hashCode() : 0);
            result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
            result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
            return result;
        }
    }
}
