package software.amazon.awscdk.services.ecs;

/**
 * The machine image type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * LaunchTemplate launchTemplate = LaunchTemplate.Builder.create(this, "ASG-LaunchTemplate")
 *         .instanceType(new InstanceType("t3.medium"))
 *         .machineImage(EcsOptimizedImage.amazonLinux2())
 *         .userData(UserData.forLinux())
 *         .build();
 * AutoScalingGroup autoScalingGroup = AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .mixedInstancesPolicy(MixedInstancesPolicy.builder()
 *                 .instancesDistribution(InstancesDistribution.builder()
 *                         .onDemandPercentageAboveBaseCapacity(50)
 *                         .build())
 *                 .launchTemplate(launchTemplate)
 *                 .build())
 *         .build();
 * Cluster cluster = Cluster.Builder.create(this, "Cluster").vpc(vpc).build();
 * AsgCapacityProvider capacityProvider = AsgCapacityProvider.Builder.create(this, "AsgCapacityProvider")
 *         .autoScalingGroup(autoScalingGroup)
 *         .machineImageType(MachineImageType.AMAZON_LINUX_2)
 *         .build();
 * cluster.addAsgCapacityProvider(capacityProvider);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:07.254Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.MachineImageType")
public enum MachineImageType {
    /**
     * Amazon ECS-optimized Amazon Linux 2 AMI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AMAZON_LINUX_2,
    /**
     * Bottlerocket AMI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BOTTLEROCKET,
}
