package software.amazon.awscdk.services.ecs;

/**
 * Properties for defining a `CfnTaskDefinition`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * CfnTaskDefinitionProps cfnTaskDefinitionProps = CfnTaskDefinitionProps.builder()
 *         .containerDefinitions(List.of(ContainerDefinitionProperty.builder()
 *                 .command(List.of("command"))
 *                 .cpu(123)
 *                 .dependsOn(List.of(ContainerDependencyProperty.builder()
 *                         .condition("condition")
 *                         .containerName("containerName")
 *                         .build()))
 *                 .disableNetworking(false)
 *                 .dnsSearchDomains(List.of("dnsSearchDomains"))
 *                 .dnsServers(List.of("dnsServers"))
 *                 .dockerLabels(Map.of(
 *                         "dockerLabelsKey", "dockerLabels"))
 *                 .dockerSecurityOptions(List.of("dockerSecurityOptions"))
 *                 .entryPoint(List.of("entryPoint"))
 *                 .environment(List.of(KeyValuePairProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .environmentFiles(List.of(EnvironmentFileProperty.builder()
 *                         .type("type")
 *                         .value("value")
 *                         .build()))
 *                 .essential(false)
 *                 .extraHosts(List.of(HostEntryProperty.builder()
 *                         .hostname("hostname")
 *                         .ipAddress("ipAddress")
 *                         .build()))
 *                 .firelensConfiguration(FirelensConfigurationProperty.builder()
 *                         .options(Map.of(
 *                                 "optionsKey", "options"))
 *                         .type("type")
 *                         .build())
 *                 .healthCheck(HealthCheckProperty.builder()
 *                         .command(List.of("command"))
 *                         .interval(123)
 *                         .retries(123)
 *                         .startPeriod(123)
 *                         .timeout(123)
 *                         .build())
 *                 .hostname("hostname")
 *                 .image("image")
 *                 .interactive(false)
 *                 .links(List.of("links"))
 *                 .linuxParameters(LinuxParametersProperty.builder()
 *                         .capabilities(KernelCapabilitiesProperty.builder()
 *                                 .add(List.of("add"))
 *                                 .drop(List.of("drop"))
 *                                 .build())
 *                         .devices(List.of(DeviceProperty.builder()
 *                                 .containerPath("containerPath")
 *                                 .hostPath("hostPath")
 *                                 .permissions(List.of("permissions"))
 *                                 .build()))
 *                         .initProcessEnabled(false)
 *                         .maxSwap(123)
 *                         .sharedMemorySize(123)
 *                         .swappiness(123)
 *                         .tmpfs(List.of(TmpfsProperty.builder()
 *                                 .size(123)
 *                                 // the properties below are optional
 *                                 .containerPath("containerPath")
 *                                 .mountOptions(List.of("mountOptions"))
 *                                 .build()))
 *                         .build())
 *                 .logConfiguration(LogConfigurationProperty.builder()
 *                         .logDriver("logDriver")
 *                         // the properties below are optional
 *                         .options(Map.of(
 *                                 "optionsKey", "options"))
 *                         .secretOptions(List.of(SecretProperty.builder()
 *                                 .name("name")
 *                                 .valueFrom("valueFrom")
 *                                 .build()))
 *                         .build())
 *                 .memory(123)
 *                 .memoryReservation(123)
 *                 .mountPoints(List.of(MountPointProperty.builder()
 *                         .containerPath("containerPath")
 *                         .readOnly(false)
 *                         .sourceVolume("sourceVolume")
 *                         .build()))
 *                 .name("name")
 *                 .portMappings(List.of(PortMappingProperty.builder()
 *                         .containerPort(123)
 *                         .hostPort(123)
 *                         .protocol("protocol")
 *                         .build()))
 *                 .privileged(false)
 *                 .pseudoTerminal(false)
 *                 .readonlyRootFilesystem(false)
 *                 .repositoryCredentials(RepositoryCredentialsProperty.builder()
 *                         .credentialsParameter("credentialsParameter")
 *                         .build())
 *                 .resourceRequirements(List.of(ResourceRequirementProperty.builder()
 *                         .type("type")
 *                         .value("value")
 *                         .build()))
 *                 .secrets(List.of(SecretProperty.builder()
 *                         .name("name")
 *                         .valueFrom("valueFrom")
 *                         .build()))
 *                 .startTimeout(123)
 *                 .stopTimeout(123)
 *                 .systemControls(List.of(SystemControlProperty.builder()
 *                         .namespace("namespace")
 *                         .value("value")
 *                         .build()))
 *                 .ulimits(List.of(UlimitProperty.builder()
 *                         .hardLimit(123)
 *                         .name("name")
 *                         .softLimit(123)
 *                         .build()))
 *                 .user("user")
 *                 .volumesFrom(List.of(VolumeFromProperty.builder()
 *                         .readOnly(false)
 *                         .sourceContainer("sourceContainer")
 *                         .build()))
 *                 .workingDirectory("workingDirectory")
 *                 .build()))
 *         .cpu("cpu")
 *         .ephemeralStorage(EphemeralStorageProperty.builder()
 *                 .sizeInGiB(123)
 *                 .build())
 *         .executionRoleArn("executionRoleArn")
 *         .family("family")
 *         .inferenceAccelerators(List.of(InferenceAcceleratorProperty.builder()
 *                 .deviceName("deviceName")
 *                 .deviceType("deviceType")
 *                 .build()))
 *         .ipcMode("ipcMode")
 *         .memory("memory")
 *         .networkMode("networkMode")
 *         .pidMode("pidMode")
 *         .placementConstraints(List.of(TaskDefinitionPlacementConstraintProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .expression("expression")
 *                 .build()))
 *         .proxyConfiguration(ProxyConfigurationProperty.builder()
 *                 .containerName("containerName")
 *                 // the properties below are optional
 *                 .proxyConfigurationProperties(List.of(KeyValuePairProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .type("type")
 *                 .build())
 *         .requiresCompatibilities(List.of("requiresCompatibilities"))
 *         .runtimePlatform(RuntimePlatformProperty.builder()
 *                 .cpuArchitecture("cpuArchitecture")
 *                 .operatingSystemFamily("operatingSystemFamily")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .taskRoleArn("taskRoleArn")
 *         .volumes(List.of(VolumeProperty.builder()
 *                 .dockerVolumeConfiguration(DockerVolumeConfigurationProperty.builder()
 *                         .autoprovision(false)
 *                         .driver("driver")
 *                         .driverOpts(Map.of(
 *                                 "driverOptsKey", "driverOpts"))
 *                         .labels(Map.of(
 *                                 "labelsKey", "labels"))
 *                         .scope("scope")
 *                         .build())
 *                 .efsVolumeConfiguration(EFSVolumeConfigurationProperty.builder()
 *                         .filesystemId("filesystemId")
 *                         // the properties below are optional
 *                         .authorizationConfig(AuthorizationConfigProperty.builder()
 *                                 .accessPointId("accessPointId")
 *                                 .iam("iam")
 *                                 .build())
 *                         .rootDirectory("rootDirectory")
 *                         .transitEncryption("transitEncryption")
 *                         .transitEncryptionPort(123)
 *                         .build())
 *                 .host(HostVolumePropertiesProperty.builder()
 *                         .sourcePath("sourcePath")
 *                         .build())
 *                 .name("name")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:07.180Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(CfnTaskDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTaskDefinitionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of container definitions in JSON format that describe the different containers that make up your task.
     * <p>
     * For more information about container definition parameters and defaults, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Amazon ECS Task Definitions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getContainerDefinitions() {
        return null;
    }

    /**
     * The number of `cpu` units used by the task.
     * <p>
     * If you use the EC2 launch type, this field is optional. Any value can be used. If you use the Fargate launch type, this field is required. You must use one of the following values. The value that you choose determines your range of valid values for the <code>memory</code> parameter.
     * <p>
     * The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.
     * <p>
     * <ul>
     * <li>256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)</li>
     * <li>512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)</li>
     * <li>1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)</li>
     * <li>2048 (2 vCPU) - Available <code>memory</code> values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)</li>
     * <li>4096 (4 vCPU) - Available <code>memory</code> values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCpu() {
        return null;
    }

    /**
     * The ephemeral storage settings to use for tasks run with the task definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEphemeralStorage() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent permission to make AWS API calls on your behalf.
     * <p>
     * The task execution IAM role is required depending on the requirements of your task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon ECS task execution IAM role</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleArn() {
        return null;
    }

    /**
     * The name of a family that this task definition is registered to.
     * <p>
     * Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
     * <p>
     * A family groups multiple versions of a task definition. Amazon ECS gives the first task definition that you registered to a family a revision number of 1. Amazon ECS gives sequential revision numbers to each task definition that you add.
     * <p>
     * <blockquote>
     * <p>
     * To use revision numbers when you update a task definition, specify this property. If you don't specify a value, AWS CloudFormation generates a new task definition each time that you update it.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFamily() {
        return null;
    }

    /**
     * The Elastic Inference accelerators to use for the containers in the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInferenceAccelerators() {
        return null;
    }

    /**
     * The IPC resource namespace to use for the containers in the task.
     * <p>
     * The valid values are <code>host</code> , <code>task</code> , or <code>none</code> . If <code>host</code> is specified, then all containers within the tasks that specified the <code>host</code> IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance. If <code>task</code> is specified, all containers within the specified task share the same IPC resources. If <code>none</code> is specified, then IPC resources within the containers of a task are private and not shared with other containers in a task or on the container instance. If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC settings</a> in the <em>Docker run reference</em> .
     * <p>
     * If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of undesired IPC namespace expose. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/security/security/">Docker security</a> .
     * <p>
     * If you are setting namespaced kernel parameters using <code>systemControls</code> for the containers in the task, the following will apply to your IPC resource namespace. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System Controls</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * <ul>
     * <li>For tasks that use the <code>host</code> IPC mode, IPC namespace related <code>systemControls</code> are not supported.</li>
     * <li>For tasks that use the <code>task</code> IPC mode, IPC namespace related <code>systemControls</code> will apply to all containers within a task.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * This parameter is not supported for Windows containers or tasks run on AWS Fargate .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpcMode() {
        return null;
    }

    /**
     * The amount (in MiB) of memory used by the task.
     * <p>
     * If your tasks runs on Amazon EC2 instances, you must specify either a task-level memory value or a container-level memory value. This field is optional and any value can be used. If a task-level memory value is specified, the container-level memory value is optional. For more information regarding container-level memory and memory reservation, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html">ContainerDefinition</a> .
     * <p>
     * If your tasks runs on AWS Fargate , this field is required. You must use one of the following values. The value you choose determines your range of valid values for the <code>cpu</code> parameter.
     * <p>
     * <ul>
     * <li>512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)</li>
     * <li>1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)</li>
     * <li>2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available <code>cpu</code> values: 1024 (1 vCPU)</li>
     * <li>Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2 vCPU)</li>
     * <li>Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4 vCPU)</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMemory() {
        return null;
    }

    /**
     * The Docker networking mode to use for the containers in the task.
     * <p>
     * The valid values are <code>none</code> , <code>bridge</code> , <code>awsvpc</code> , and <code>host</code> . The default Docker network mode is <code>bridge</code> . If you are using the Fargate launch type, the <code>awsvpc</code> network mode is required. If you are using the EC2 launch type, any network mode can be used. If the network mode is set to <code>none</code> , you cannot specify port mappings in your container definitions, and the tasks containers do not have external connectivity. The <code>host</code> and <code>awsvpc</code> network modes offer the highest networking performance for containers because they use the EC2 network stack instead of the virtualized network stack provided by the <code>bridge</code> mode.
     * <p>
     * With the <code>host</code> and <code>awsvpc</code> network modes, exposed container ports are mapped directly to the corresponding host port (for the <code>host</code> network mode) or the attached elastic network interface port (for the <code>awsvpc</code> network mode), so you cannot take advantage of dynamic host port mappings.
     * <p>
     * If the network mode is <code>awsvpc</code> , the task is allocated an elastic network interface, and you must specify a <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_NetworkConfiguration.html">NetworkConfiguration</a> value when you create a service or run a task with the task definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * Currently, only Amazon ECS-optimized AMIs, other Amazon Linux variants with the <code>ecs-init</code> package, or AWS Fargate infrastructure support the <code>awsvpc</code> network mode.
     * <p>
     * </blockquote>
     * <p>
     * If the network mode is <code>host</code> , you cannot run multiple instantiations of the same task on a single container instance when port mappings are used.
     * <p>
     * Docker for Windows uses different network modes than Docker for Linux. When you register a task definition with Windows containers, you must not specify a network mode. If you use the console to register a task definition with Windows containers, you must choose the <code>&lt;default&gt;</code> network mode object.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#network-settings">Network settings</a> in the <em>Docker run reference</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNetworkMode() {
        return null;
    }

    /**
     * The process namespace to use for the containers in the task.
     * <p>
     * The valid values are <code>host</code> or <code>task</code> . If <code>host</code> is specified, then all containers within the tasks that specified the <code>host</code> PID mode on the same container instance share the same process namespace with the host Amazon EC2 instance. If <code>task</code> is specified, all containers within the specified task share the same process namespace. If no value is specified, the default is a private namespace. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID settings</a> in the <em>Docker run reference</em> .
     * <p>
     * If the <code>host</code> PID mode is used, be aware that there is a heightened risk of undesired process namespace expose. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/security/security/">Docker security</a> .
     * <p>
     * <blockquote>
     * <p>
     * This parameter is not supported for Windows containers or tasks run on AWS Fargate .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPidMode() {
        return null;
    }

    /**
     * An array of placement constraint objects to use for tasks.
     * <p>
     * <blockquote>
     * <p>
     * This parameter isn't supported for tasks run on AWS Fargate .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPlacementConstraints() {
        return null;
    }

    /**
     * The `ProxyConfiguration` property specifies the configuration details for the App Mesh proxy.
     * <p>
     * Your Amazon ECS container instances require at least version 1.26.0 of the container agent and at least version 1.26.0-1 of the <code>ecs-init</code> package to enable a proxy configuration. If your container instances are launched from the Amazon ECS-optimized AMI version <code>20190301</code> or later, then they contain the required versions of the container agent and <code>ecs-init</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProxyConfiguration() {
        return null;
    }

    /**
     * The task launch types the task definition was validated against.
     * <p>
     * To determine which task launch types the task definition is validated for, see the <code>TaskDefinition$compatibilities</code> parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRequiresCompatibilities() {
        return null;
    }

    /**
     * The operating system that your tasks definitions run on.
     * <p>
     * A platform family is specified only for tasks using the Fargate launch type.
     * <p>
     * When you specify a task definition in a service, this value must match the <code>runtimePlatform</code> value of the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRuntimePlatform() {
        return null;
    }

    /**
     * The metadata that you apply to the task definition to help you categorize and organize them.
     * <p>
     * Each tag consists of a key and an optional value. You define both of them.
     * <p>
     * The following basic restrictions apply to tags:
     * <p>
     * <ul>
     * <li>Maximum number of tags per resource - 50</li>
     * <li>For each resource, each tag key must be unique, and each tag key can have only one value.</li>
     * <li>Maximum key length - 128 Unicode characters in UTF-8</li>
     * <li>Maximum value length - 256 Unicode characters in UTF-8</li>
     * <li>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / &#64;.</li>
     * <li>Tag keys and values are case-sensitive.</li>
     * <li>Do not use <code>aws:</code> , <code>AWS:</code> , or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The short name or full Amazon Resource Name (ARN) of the AWS Identity and Access Management role that grants containers in the task permission to call AWS APIs on your behalf.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">Amazon ECS Task Role</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * IAM roles for tasks on Windows require that the <code>-EnableTaskIAMRole</code> option is set when you launch the Amazon ECS-optimized Windows AMI. Your containers must also run some configuration code to use the feature. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows_task_IAM_roles.html">Windows IAM roles for tasks</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTaskRoleArn() {
        return null;
    }

    /**
     * The list of data volume definitions for the task.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html">Using data volumes in tasks</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * The <code>host</code> and <code>sourcePath</code> parameters aren't supported for tasks run on AWS Fargate .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVolumes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTaskDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTaskDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTaskDefinitionProps> {
        java.lang.Object containerDefinitions;
        java.lang.String cpu;
        java.lang.Object ephemeralStorage;
        java.lang.String executionRoleArn;
        java.lang.String family;
        java.lang.Object inferenceAccelerators;
        java.lang.String ipcMode;
        java.lang.String memory;
        java.lang.String networkMode;
        java.lang.String pidMode;
        java.lang.Object placementConstraints;
        java.lang.Object proxyConfiguration;
        java.util.List<java.lang.String> requiresCompatibilities;
        java.lang.Object runtimePlatform;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String taskRoleArn;
        java.lang.Object volumes;

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getContainerDefinitions}
         * @param containerDefinitions A list of container definitions in JSON format that describe the different containers that make up your task.
         *                             For more information about container definition parameters and defaults, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Amazon ECS Task Definitions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerDefinitions(software.amazon.awscdk.IResolvable containerDefinitions) {
            this.containerDefinitions = containerDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getContainerDefinitions}
         * @param containerDefinitions A list of container definitions in JSON format that describe the different containers that make up your task.
         *                             For more information about container definition parameters and defaults, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Amazon ECS Task Definitions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerDefinitions(java.util.List<? extends java.lang.Object> containerDefinitions) {
            this.containerDefinitions = containerDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getCpu}
         * @param cpu The number of `cpu` units used by the task.
         *            If you use the EC2 launch type, this field is optional. Any value can be used. If you use the Fargate launch type, this field is required. You must use one of the following values. The value that you choose determines your range of valid values for the <code>memory</code> parameter.
         *            <p>
         *            The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.
         *            <p>
         *            <ul>
         *            <li>256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)</li>
         *            <li>512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)</li>
         *            <li>1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)</li>
         *            <li>2048 (2 vCPU) - Available <code>memory</code> values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)</li>
         *            <li>4096 (4 vCPU) - Available <code>memory</code> values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)</li>
         *            </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(java.lang.String cpu) {
            this.cpu = cpu;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getEphemeralStorage}
         * @param ephemeralStorage The ephemeral storage settings to use for tasks run with the task definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorage(software.amazon.awscdk.services.ecs.CfnTaskDefinition.EphemeralStorageProperty ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getEphemeralStorage}
         * @param ephemeralStorage The ephemeral storage settings to use for tasks run with the task definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorage(software.amazon.awscdk.IResolvable ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getExecutionRoleArn}
         * @param executionRoleArn The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent permission to make AWS API calls on your behalf.
         *                         The task execution IAM role is required depending on the requirements of your task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon ECS task execution IAM role</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(java.lang.String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getFamily}
         * @param family The name of a family that this task definition is registered to.
         *               Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
         *               <p>
         *               A family groups multiple versions of a task definition. Amazon ECS gives the first task definition that you registered to a family a revision number of 1. Amazon ECS gives sequential revision numbers to each task definition that you add.
         *               <p>
         *               <blockquote>
         *               <p>
         *               To use revision numbers when you update a task definition, specify this property. If you don't specify a value, AWS CloudFormation generates a new task definition each time that you update it.
         *               <p>
         *               </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder family(java.lang.String family) {
            this.family = family;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getInferenceAccelerators}
         * @param inferenceAccelerators The Elastic Inference accelerators to use for the containers in the task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceAccelerators(software.amazon.awscdk.IResolvable inferenceAccelerators) {
            this.inferenceAccelerators = inferenceAccelerators;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getInferenceAccelerators}
         * @param inferenceAccelerators The Elastic Inference accelerators to use for the containers in the task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceAccelerators(java.util.List<? extends java.lang.Object> inferenceAccelerators) {
            this.inferenceAccelerators = inferenceAccelerators;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getIpcMode}
         * @param ipcMode The IPC resource namespace to use for the containers in the task.
         *                The valid values are <code>host</code> , <code>task</code> , or <code>none</code> . If <code>host</code> is specified, then all containers within the tasks that specified the <code>host</code> IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance. If <code>task</code> is specified, all containers within the specified task share the same IPC resources. If <code>none</code> is specified, then IPC resources within the containers of a task are private and not shared with other containers in a task or on the container instance. If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#ipc-settings---ipc">IPC settings</a> in the <em>Docker run reference</em> .
         *                <p>
         *                If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of undesired IPC namespace expose. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/security/security/">Docker security</a> .
         *                <p>
         *                If you are setting namespaced kernel parameters using <code>systemControls</code> for the containers in the task, the following will apply to your IPC resource namespace. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System Controls</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         *                <p>
         *                <ul>
         *                <li>For tasks that use the <code>host</code> IPC mode, IPC namespace related <code>systemControls</code> are not supported.</li>
         *                <li>For tasks that use the <code>task</code> IPC mode, IPC namespace related <code>systemControls</code> will apply to all containers within a task.</li>
         *                </ul>
         *                <p>
         *                <blockquote>
         *                <p>
         *                This parameter is not supported for Windows containers or tasks run on AWS Fargate .
         *                <p>
         *                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipcMode(java.lang.String ipcMode) {
            this.ipcMode = ipcMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getMemory}
         * @param memory The amount (in MiB) of memory used by the task.
         *               If your tasks runs on Amazon EC2 instances, you must specify either a task-level memory value or a container-level memory value. This field is optional and any value can be used. If a task-level memory value is specified, the container-level memory value is optional. For more information regarding container-level memory and memory reservation, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html">ContainerDefinition</a> .
         *               <p>
         *               If your tasks runs on AWS Fargate , this field is required. You must use one of the following values. The value you choose determines your range of valid values for the <code>cpu</code> parameter.
         *               <p>
         *               <ul>
         *               <li>512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)</li>
         *               <li>1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)</li>
         *               <li>2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available <code>cpu</code> values: 1024 (1 vCPU)</li>
         *               <li>Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2 vCPU)</li>
         *               <li>Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4 vCPU)</li>
         *               </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memory(java.lang.String memory) {
            this.memory = memory;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getNetworkMode}
         * @param networkMode The Docker networking mode to use for the containers in the task.
         *                    The valid values are <code>none</code> , <code>bridge</code> , <code>awsvpc</code> , and <code>host</code> . The default Docker network mode is <code>bridge</code> . If you are using the Fargate launch type, the <code>awsvpc</code> network mode is required. If you are using the EC2 launch type, any network mode can be used. If the network mode is set to <code>none</code> , you cannot specify port mappings in your container definitions, and the tasks containers do not have external connectivity. The <code>host</code> and <code>awsvpc</code> network modes offer the highest networking performance for containers because they use the EC2 network stack instead of the virtualized network stack provided by the <code>bridge</code> mode.
         *                    <p>
         *                    With the <code>host</code> and <code>awsvpc</code> network modes, exposed container ports are mapped directly to the corresponding host port (for the <code>host</code> network mode) or the attached elastic network interface port (for the <code>awsvpc</code> network mode), so you cannot take advantage of dynamic host port mappings.
         *                    <p>
         *                    If the network mode is <code>awsvpc</code> , the task is allocated an elastic network interface, and you must specify a <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_NetworkConfiguration.html">NetworkConfiguration</a> value when you create a service or run a task with the task definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    Currently, only Amazon ECS-optimized AMIs, other Amazon Linux variants with the <code>ecs-init</code> package, or AWS Fargate infrastructure support the <code>awsvpc</code> network mode.
         *                    <p>
         *                    </blockquote>
         *                    <p>
         *                    If the network mode is <code>host</code> , you cannot run multiple instantiations of the same task on a single container instance when port mappings are used.
         *                    <p>
         *                    Docker for Windows uses different network modes than Docker for Linux. When you register a task definition with Windows containers, you must not specify a network mode. If you use the console to register a task definition with Windows containers, you must choose the <code>&lt;default&gt;</code> network mode object.
         *                    <p>
         *                    For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#network-settings">Network settings</a> in the <em>Docker run reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkMode(java.lang.String networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getPidMode}
         * @param pidMode The process namespace to use for the containers in the task.
         *                The valid values are <code>host</code> or <code>task</code> . If <code>host</code> is specified, then all containers within the tasks that specified the <code>host</code> PID mode on the same container instance share the same process namespace with the host Amazon EC2 instance. If <code>task</code> is specified, all containers within the specified task share the same process namespace. If no value is specified, the default is a private namespace. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#pid-settings---pid">PID settings</a> in the <em>Docker run reference</em> .
         *                <p>
         *                If the <code>host</code> PID mode is used, be aware that there is a heightened risk of undesired process namespace expose. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/security/security/">Docker security</a> .
         *                <p>
         *                <blockquote>
         *                <p>
         *                This parameter is not supported for Windows containers or tasks run on AWS Fargate .
         *                <p>
         *                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pidMode(java.lang.String pidMode) {
            this.pidMode = pidMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getPlacementConstraints}
         * @param placementConstraints An array of placement constraint objects to use for tasks.
         *                             <blockquote>
         *                             <p>
         *                             This parameter isn't supported for tasks run on AWS Fargate .
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementConstraints(software.amazon.awscdk.IResolvable placementConstraints) {
            this.placementConstraints = placementConstraints;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getPlacementConstraints}
         * @param placementConstraints An array of placement constraint objects to use for tasks.
         *                             <blockquote>
         *                             <p>
         *                             This parameter isn't supported for tasks run on AWS Fargate .
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementConstraints(java.util.List<? extends java.lang.Object> placementConstraints) {
            this.placementConstraints = placementConstraints;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getProxyConfiguration}
         * @param proxyConfiguration The `ProxyConfiguration` property specifies the configuration details for the App Mesh proxy.
         *                           Your Amazon ECS container instances require at least version 1.26.0 of the container agent and at least version 1.26.0-1 of the <code>ecs-init</code> package to enable a proxy configuration. If your container instances are launched from the Amazon ECS-optimized AMI version <code>20190301</code> or later, then they contain the required versions of the container agent and <code>ecs-init</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyConfiguration(software.amazon.awscdk.services.ecs.CfnTaskDefinition.ProxyConfigurationProperty proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getProxyConfiguration}
         * @param proxyConfiguration The `ProxyConfiguration` property specifies the configuration details for the App Mesh proxy.
         *                           Your Amazon ECS container instances require at least version 1.26.0 of the container agent and at least version 1.26.0-1 of the <code>ecs-init</code> package to enable a proxy configuration. If your container instances are launched from the Amazon ECS-optimized AMI version <code>20190301</code> or later, then they contain the required versions of the container agent and <code>ecs-init</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyConfiguration(software.amazon.awscdk.IResolvable proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getRequiresCompatibilities}
         * @param requiresCompatibilities The task launch types the task definition was validated against.
         *                                To determine which task launch types the task definition is validated for, see the <code>TaskDefinition$compatibilities</code> parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requiresCompatibilities(java.util.List<java.lang.String> requiresCompatibilities) {
            this.requiresCompatibilities = requiresCompatibilities;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getRuntimePlatform}
         * @param runtimePlatform The operating system that your tasks definitions run on.
         *                        A platform family is specified only for tasks using the Fargate launch type.
         *                        <p>
         *                        When you specify a task definition in a service, this value must match the <code>runtimePlatform</code> value of the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimePlatform(software.amazon.awscdk.services.ecs.CfnTaskDefinition.RuntimePlatformProperty runtimePlatform) {
            this.runtimePlatform = runtimePlatform;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getRuntimePlatform}
         * @param runtimePlatform The operating system that your tasks definitions run on.
         *                        A platform family is specified only for tasks using the Fargate launch type.
         *                        <p>
         *                        When you specify a task definition in a service, this value must match the <code>runtimePlatform</code> value of the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimePlatform(software.amazon.awscdk.IResolvable runtimePlatform) {
            this.runtimePlatform = runtimePlatform;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getTags}
         * @param tags The metadata that you apply to the task definition to help you categorize and organize them.
         *             Each tag consists of a key and an optional value. You define both of them.
         *             <p>
         *             The following basic restrictions apply to tags:
         *             <p>
         *             <ul>
         *             <li>Maximum number of tags per resource - 50</li>
         *             <li>For each resource, each tag key must be unique, and each tag key can have only one value.</li>
         *             <li>Maximum key length - 128 Unicode characters in UTF-8</li>
         *             <li>Maximum value length - 256 Unicode characters in UTF-8</li>
         *             <li>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / &#64;.</li>
         *             <li>Tag keys and values are case-sensitive.</li>
         *             <li>Do not use <code>aws:</code> , <code>AWS:</code> , or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getTaskRoleArn}
         * @param taskRoleArn The short name or full Amazon Resource Name (ARN) of the AWS Identity and Access Management role that grants containers in the task permission to call AWS APIs on your behalf.
         *                    For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">Amazon ECS Task Role</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         *                    <p>
         *                    IAM roles for tasks on Windows require that the <code>-EnableTaskIAMRole</code> option is set when you launch the Amazon ECS-optimized Windows AMI. Your containers must also run some configuration code to use the feature. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows_task_IAM_roles.html">Windows IAM roles for tasks</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskRoleArn(java.lang.String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getVolumes}
         * @param volumes The list of data volume definitions for the task.
         *                For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html">Using data volumes in tasks</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         *                <p>
         *                <blockquote>
         *                <p>
         *                The <code>host</code> and <code>sourcePath</code> parameters aren't supported for tasks run on AWS Fargate .
         *                <p>
         *                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(software.amazon.awscdk.IResolvable volumes) {
            this.volumes = volumes;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getVolumes}
         * @param volumes The list of data volume definitions for the task.
         *                For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html">Using data volumes in tasks</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         *                <p>
         *                <blockquote>
         *                <p>
         *                The <code>host</code> and <code>sourcePath</code> parameters aren't supported for tasks run on AWS Fargate .
         *                <p>
         *                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(java.util.List<? extends java.lang.Object> volumes) {
            this.volumes = volumes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTaskDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTaskDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTaskDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTaskDefinitionProps {
        private final java.lang.Object containerDefinitions;
        private final java.lang.String cpu;
        private final java.lang.Object ephemeralStorage;
        private final java.lang.String executionRoleArn;
        private final java.lang.String family;
        private final java.lang.Object inferenceAccelerators;
        private final java.lang.String ipcMode;
        private final java.lang.String memory;
        private final java.lang.String networkMode;
        private final java.lang.String pidMode;
        private final java.lang.Object placementConstraints;
        private final java.lang.Object proxyConfiguration;
        private final java.util.List<java.lang.String> requiresCompatibilities;
        private final java.lang.Object runtimePlatform;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String taskRoleArn;
        private final java.lang.Object volumes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.containerDefinitions = software.amazon.jsii.Kernel.get(this, "containerDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ephemeralStorage = software.amazon.jsii.Kernel.get(this, "ephemeralStorage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.executionRoleArn = software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.family = software.amazon.jsii.Kernel.get(this, "family", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.inferenceAccelerators = software.amazon.jsii.Kernel.get(this, "inferenceAccelerators", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ipcMode = software.amazon.jsii.Kernel.get(this, "ipcMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkMode = software.amazon.jsii.Kernel.get(this, "networkMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pidMode = software.amazon.jsii.Kernel.get(this, "pidMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.placementConstraints = software.amazon.jsii.Kernel.get(this, "placementConstraints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.proxyConfiguration = software.amazon.jsii.Kernel.get(this, "proxyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.requiresCompatibilities = software.amazon.jsii.Kernel.get(this, "requiresCompatibilities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.runtimePlatform = software.amazon.jsii.Kernel.get(this, "runtimePlatform", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.taskRoleArn = software.amazon.jsii.Kernel.get(this, "taskRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.containerDefinitions = builder.containerDefinitions;
            this.cpu = builder.cpu;
            this.ephemeralStorage = builder.ephemeralStorage;
            this.executionRoleArn = builder.executionRoleArn;
            this.family = builder.family;
            this.inferenceAccelerators = builder.inferenceAccelerators;
            this.ipcMode = builder.ipcMode;
            this.memory = builder.memory;
            this.networkMode = builder.networkMode;
            this.pidMode = builder.pidMode;
            this.placementConstraints = builder.placementConstraints;
            this.proxyConfiguration = builder.proxyConfiguration;
            this.requiresCompatibilities = builder.requiresCompatibilities;
            this.runtimePlatform = builder.runtimePlatform;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.taskRoleArn = builder.taskRoleArn;
            this.volumes = builder.volumes;
        }

        @Override
        public final java.lang.Object getContainerDefinitions() {
            return this.containerDefinitions;
        }

        @Override
        public final java.lang.String getCpu() {
            return this.cpu;
        }

        @Override
        public final java.lang.Object getEphemeralStorage() {
            return this.ephemeralStorage;
        }

        @Override
        public final java.lang.String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final java.lang.String getFamily() {
            return this.family;
        }

        @Override
        public final java.lang.Object getInferenceAccelerators() {
            return this.inferenceAccelerators;
        }

        @Override
        public final java.lang.String getIpcMode() {
            return this.ipcMode;
        }

        @Override
        public final java.lang.String getMemory() {
            return this.memory;
        }

        @Override
        public final java.lang.String getNetworkMode() {
            return this.networkMode;
        }

        @Override
        public final java.lang.String getPidMode() {
            return this.pidMode;
        }

        @Override
        public final java.lang.Object getPlacementConstraints() {
            return this.placementConstraints;
        }

        @Override
        public final java.lang.Object getProxyConfiguration() {
            return this.proxyConfiguration;
        }

        @Override
        public final java.util.List<java.lang.String> getRequiresCompatibilities() {
            return this.requiresCompatibilities;
        }

        @Override
        public final java.lang.Object getRuntimePlatform() {
            return this.runtimePlatform;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTaskRoleArn() {
            return this.taskRoleArn;
        }

        @Override
        public final java.lang.Object getVolumes() {
            return this.volumes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getContainerDefinitions() != null) {
                data.set("containerDefinitions", om.valueToTree(this.getContainerDefinitions()));
            }
            if (this.getCpu() != null) {
                data.set("cpu", om.valueToTree(this.getCpu()));
            }
            if (this.getEphemeralStorage() != null) {
                data.set("ephemeralStorage", om.valueToTree(this.getEphemeralStorage()));
            }
            if (this.getExecutionRoleArn() != null) {
                data.set("executionRoleArn", om.valueToTree(this.getExecutionRoleArn()));
            }
            if (this.getFamily() != null) {
                data.set("family", om.valueToTree(this.getFamily()));
            }
            if (this.getInferenceAccelerators() != null) {
                data.set("inferenceAccelerators", om.valueToTree(this.getInferenceAccelerators()));
            }
            if (this.getIpcMode() != null) {
                data.set("ipcMode", om.valueToTree(this.getIpcMode()));
            }
            if (this.getMemory() != null) {
                data.set("memory", om.valueToTree(this.getMemory()));
            }
            if (this.getNetworkMode() != null) {
                data.set("networkMode", om.valueToTree(this.getNetworkMode()));
            }
            if (this.getPidMode() != null) {
                data.set("pidMode", om.valueToTree(this.getPidMode()));
            }
            if (this.getPlacementConstraints() != null) {
                data.set("placementConstraints", om.valueToTree(this.getPlacementConstraints()));
            }
            if (this.getProxyConfiguration() != null) {
                data.set("proxyConfiguration", om.valueToTree(this.getProxyConfiguration()));
            }
            if (this.getRequiresCompatibilities() != null) {
                data.set("requiresCompatibilities", om.valueToTree(this.getRequiresCompatibilities()));
            }
            if (this.getRuntimePlatform() != null) {
                data.set("runtimePlatform", om.valueToTree(this.getRuntimePlatform()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTaskRoleArn() != null) {
                data.set("taskRoleArn", om.valueToTree(this.getTaskRoleArn()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTaskDefinitionProps.Jsii$Proxy that = (CfnTaskDefinitionProps.Jsii$Proxy) o;

            if (this.containerDefinitions != null ? !this.containerDefinitions.equals(that.containerDefinitions) : that.containerDefinitions != null) return false;
            if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
            if (this.ephemeralStorage != null ? !this.ephemeralStorage.equals(that.ephemeralStorage) : that.ephemeralStorage != null) return false;
            if (this.executionRoleArn != null ? !this.executionRoleArn.equals(that.executionRoleArn) : that.executionRoleArn != null) return false;
            if (this.family != null ? !this.family.equals(that.family) : that.family != null) return false;
            if (this.inferenceAccelerators != null ? !this.inferenceAccelerators.equals(that.inferenceAccelerators) : that.inferenceAccelerators != null) return false;
            if (this.ipcMode != null ? !this.ipcMode.equals(that.ipcMode) : that.ipcMode != null) return false;
            if (this.memory != null ? !this.memory.equals(that.memory) : that.memory != null) return false;
            if (this.networkMode != null ? !this.networkMode.equals(that.networkMode) : that.networkMode != null) return false;
            if (this.pidMode != null ? !this.pidMode.equals(that.pidMode) : that.pidMode != null) return false;
            if (this.placementConstraints != null ? !this.placementConstraints.equals(that.placementConstraints) : that.placementConstraints != null) return false;
            if (this.proxyConfiguration != null ? !this.proxyConfiguration.equals(that.proxyConfiguration) : that.proxyConfiguration != null) return false;
            if (this.requiresCompatibilities != null ? !this.requiresCompatibilities.equals(that.requiresCompatibilities) : that.requiresCompatibilities != null) return false;
            if (this.runtimePlatform != null ? !this.runtimePlatform.equals(that.runtimePlatform) : that.runtimePlatform != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.taskRoleArn != null ? !this.taskRoleArn.equals(that.taskRoleArn) : that.taskRoleArn != null) return false;
            return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.containerDefinitions != null ? this.containerDefinitions.hashCode() : 0;
            result = 31 * result + (this.cpu != null ? this.cpu.hashCode() : 0);
            result = 31 * result + (this.ephemeralStorage != null ? this.ephemeralStorage.hashCode() : 0);
            result = 31 * result + (this.executionRoleArn != null ? this.executionRoleArn.hashCode() : 0);
            result = 31 * result + (this.family != null ? this.family.hashCode() : 0);
            result = 31 * result + (this.inferenceAccelerators != null ? this.inferenceAccelerators.hashCode() : 0);
            result = 31 * result + (this.ipcMode != null ? this.ipcMode.hashCode() : 0);
            result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
            result = 31 * result + (this.networkMode != null ? this.networkMode.hashCode() : 0);
            result = 31 * result + (this.pidMode != null ? this.pidMode.hashCode() : 0);
            result = 31 * result + (this.placementConstraints != null ? this.placementConstraints.hashCode() : 0);
            result = 31 * result + (this.proxyConfiguration != null ? this.proxyConfiguration.hashCode() : 0);
            result = 31 * result + (this.requiresCompatibilities != null ? this.requiresCompatibilities.hashCode() : 0);
            result = 31 * result + (this.runtimePlatform != null ? this.runtimePlatform.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.taskRoleArn != null ? this.taskRoleArn.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            return result;
        }
    }
}
