package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnTransitGateway`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnTransitGatewayProps cfnTransitGatewayProps = CfnTransitGatewayProps.builder()
 *         .amazonSideAsn(123)
 *         .associationDefaultRouteTableId("associationDefaultRouteTableId")
 *         .autoAcceptSharedAttachments("autoAcceptSharedAttachments")
 *         .defaultRouteTableAssociation("defaultRouteTableAssociation")
 *         .defaultRouteTablePropagation("defaultRouteTablePropagation")
 *         .description("description")
 *         .dnsSupport("dnsSupport")
 *         .multicastSupport("multicastSupport")
 *         .propagationDefaultRouteTableId("propagationDefaultRouteTableId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .transitGatewayCidrBlocks(List.of("transitGatewayCidrBlocks"))
 *         .vpnEcmpSupport("vpnEcmpSupport")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:06.872Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnTransitGatewayProps")
@software.amazon.jsii.Jsii.Proxy(CfnTransitGatewayProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTransitGatewayProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A private Autonomous System Number (ASN) for the Amazon side of a BGP session.
     * <p>
     * The range is 64512 to 65534 for 16-bit ASNs. The default is 64512.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAmazonSideAsn() {
        return null;
    }

    /**
     * The ID of the default association route table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssociationDefaultRouteTableId() {
        return null;
    }

    /**
     * Enable or disable automatic acceptance of attachment requests.
     * <p>
     * Disabled by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAutoAcceptSharedAttachments() {
        return null;
    }

    /**
     * Enable or disable automatic association with the default association route table.
     * <p>
     * Enabled by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultRouteTableAssociation() {
        return null;
    }

    /**
     * Enable or disable automatic propagation of routes to the default propagation route table.
     * <p>
     * Enabled by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultRouteTablePropagation() {
        return null;
    }

    /**
     * The description of the transit gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Enable or disable DNS support.
     * <p>
     * Enabled by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDnsSupport() {
        return null;
    }

    /**
     * Indicates whether multicast is enabled on the transit gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMulticastSupport() {
        return null;
    }

    /**
     * The ID of the default propagation route table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPropagationDefaultRouteTableId() {
        return null;
    }

    /**
     * The tags for the transit gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The transit gateway CIDR blocks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTransitGatewayCidrBlocks() {
        return null;
    }

    /**
     * Enable or disable Equal Cost Multipath Protocol support.
     * <p>
     * Enabled by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpnEcmpSupport() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTransitGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTransitGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTransitGatewayProps> {
        java.lang.Number amazonSideAsn;
        java.lang.String associationDefaultRouteTableId;
        java.lang.String autoAcceptSharedAttachments;
        java.lang.String defaultRouteTableAssociation;
        java.lang.String defaultRouteTablePropagation;
        java.lang.String description;
        java.lang.String dnsSupport;
        java.lang.String multicastSupport;
        java.lang.String propagationDefaultRouteTableId;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.util.List<java.lang.String> transitGatewayCidrBlocks;
        java.lang.String vpnEcmpSupport;

        /**
         * Sets the value of {@link CfnTransitGatewayProps#getAmazonSideAsn}
         * @param amazonSideAsn A private Autonomous System Number (ASN) for the Amazon side of a BGP session.
         *                      The range is 64512 to 65534 for 16-bit ASNs. The default is 64512.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amazonSideAsn(java.lang.Number amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayProps#getAssociationDefaultRouteTableId}
         * @param associationDefaultRouteTableId The ID of the default association route table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associationDefaultRouteTableId(java.lang.String associationDefaultRouteTableId) {
            this.associationDefaultRouteTableId = associationDefaultRouteTableId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayProps#getAutoAcceptSharedAttachments}
         * @param autoAcceptSharedAttachments Enable or disable automatic acceptance of attachment requests.
         *                                    Disabled by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoAcceptSharedAttachments(java.lang.String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayProps#getDefaultRouteTableAssociation}
         * @param defaultRouteTableAssociation Enable or disable automatic association with the default association route table.
         *                                     Enabled by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRouteTableAssociation(java.lang.String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayProps#getDefaultRouteTablePropagation}
         * @param defaultRouteTablePropagation Enable or disable automatic propagation of routes to the default propagation route table.
         *                                     Enabled by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRouteTablePropagation(java.lang.String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayProps#getDescription}
         * @param description The description of the transit gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayProps#getDnsSupport}
         * @param dnsSupport Enable or disable DNS support.
         *                   Enabled by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsSupport(java.lang.String dnsSupport) {
            this.dnsSupport = dnsSupport;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayProps#getMulticastSupport}
         * @param multicastSupport Indicates whether multicast is enabled on the transit gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multicastSupport(java.lang.String multicastSupport) {
            this.multicastSupport = multicastSupport;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayProps#getPropagationDefaultRouteTableId}
         * @param propagationDefaultRouteTableId The ID of the default propagation route table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagationDefaultRouteTableId(java.lang.String propagationDefaultRouteTableId) {
            this.propagationDefaultRouteTableId = propagationDefaultRouteTableId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayProps#getTags}
         * @param tags The tags for the transit gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayProps#getTransitGatewayCidrBlocks}
         * @param transitGatewayCidrBlocks The transit gateway CIDR blocks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayCidrBlocks(java.util.List<java.lang.String> transitGatewayCidrBlocks) {
            this.transitGatewayCidrBlocks = transitGatewayCidrBlocks;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayProps#getVpnEcmpSupport}
         * @param vpnEcmpSupport Enable or disable Equal Cost Multipath Protocol support.
         *                       Enabled by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnEcmpSupport(java.lang.String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTransitGatewayProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTransitGatewayProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTransitGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTransitGatewayProps {
        private final java.lang.Number amazonSideAsn;
        private final java.lang.String associationDefaultRouteTableId;
        private final java.lang.String autoAcceptSharedAttachments;
        private final java.lang.String defaultRouteTableAssociation;
        private final java.lang.String defaultRouteTablePropagation;
        private final java.lang.String description;
        private final java.lang.String dnsSupport;
        private final java.lang.String multicastSupport;
        private final java.lang.String propagationDefaultRouteTableId;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.util.List<java.lang.String> transitGatewayCidrBlocks;
        private final java.lang.String vpnEcmpSupport;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.amazonSideAsn = software.amazon.jsii.Kernel.get(this, "amazonSideAsn", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.associationDefaultRouteTableId = software.amazon.jsii.Kernel.get(this, "associationDefaultRouteTableId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoAcceptSharedAttachments = software.amazon.jsii.Kernel.get(this, "autoAcceptSharedAttachments", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultRouteTableAssociation = software.amazon.jsii.Kernel.get(this, "defaultRouteTableAssociation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultRouteTablePropagation = software.amazon.jsii.Kernel.get(this, "defaultRouteTablePropagation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dnsSupport = software.amazon.jsii.Kernel.get(this, "dnsSupport", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.multicastSupport = software.amazon.jsii.Kernel.get(this, "multicastSupport", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.propagationDefaultRouteTableId = software.amazon.jsii.Kernel.get(this, "propagationDefaultRouteTableId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.transitGatewayCidrBlocks = software.amazon.jsii.Kernel.get(this, "transitGatewayCidrBlocks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.vpnEcmpSupport = software.amazon.jsii.Kernel.get(this, "vpnEcmpSupport", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.amazonSideAsn = builder.amazonSideAsn;
            this.associationDefaultRouteTableId = builder.associationDefaultRouteTableId;
            this.autoAcceptSharedAttachments = builder.autoAcceptSharedAttachments;
            this.defaultRouteTableAssociation = builder.defaultRouteTableAssociation;
            this.defaultRouteTablePropagation = builder.defaultRouteTablePropagation;
            this.description = builder.description;
            this.dnsSupport = builder.dnsSupport;
            this.multicastSupport = builder.multicastSupport;
            this.propagationDefaultRouteTableId = builder.propagationDefaultRouteTableId;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.transitGatewayCidrBlocks = builder.transitGatewayCidrBlocks;
            this.vpnEcmpSupport = builder.vpnEcmpSupport;
        }

        @Override
        public final java.lang.Number getAmazonSideAsn() {
            return this.amazonSideAsn;
        }

        @Override
        public final java.lang.String getAssociationDefaultRouteTableId() {
            return this.associationDefaultRouteTableId;
        }

        @Override
        public final java.lang.String getAutoAcceptSharedAttachments() {
            return this.autoAcceptSharedAttachments;
        }

        @Override
        public final java.lang.String getDefaultRouteTableAssociation() {
            return this.defaultRouteTableAssociation;
        }

        @Override
        public final java.lang.String getDefaultRouteTablePropagation() {
            return this.defaultRouteTablePropagation;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDnsSupport() {
            return this.dnsSupport;
        }

        @Override
        public final java.lang.String getMulticastSupport() {
            return this.multicastSupport;
        }

        @Override
        public final java.lang.String getPropagationDefaultRouteTableId() {
            return this.propagationDefaultRouteTableId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getTransitGatewayCidrBlocks() {
            return this.transitGatewayCidrBlocks;
        }

        @Override
        public final java.lang.String getVpnEcmpSupport() {
            return this.vpnEcmpSupport;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAmazonSideAsn() != null) {
                data.set("amazonSideAsn", om.valueToTree(this.getAmazonSideAsn()));
            }
            if (this.getAssociationDefaultRouteTableId() != null) {
                data.set("associationDefaultRouteTableId", om.valueToTree(this.getAssociationDefaultRouteTableId()));
            }
            if (this.getAutoAcceptSharedAttachments() != null) {
                data.set("autoAcceptSharedAttachments", om.valueToTree(this.getAutoAcceptSharedAttachments()));
            }
            if (this.getDefaultRouteTableAssociation() != null) {
                data.set("defaultRouteTableAssociation", om.valueToTree(this.getDefaultRouteTableAssociation()));
            }
            if (this.getDefaultRouteTablePropagation() != null) {
                data.set("defaultRouteTablePropagation", om.valueToTree(this.getDefaultRouteTablePropagation()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDnsSupport() != null) {
                data.set("dnsSupport", om.valueToTree(this.getDnsSupport()));
            }
            if (this.getMulticastSupport() != null) {
                data.set("multicastSupport", om.valueToTree(this.getMulticastSupport()));
            }
            if (this.getPropagationDefaultRouteTableId() != null) {
                data.set("propagationDefaultRouteTableId", om.valueToTree(this.getPropagationDefaultRouteTableId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTransitGatewayCidrBlocks() != null) {
                data.set("transitGatewayCidrBlocks", om.valueToTree(this.getTransitGatewayCidrBlocks()));
            }
            if (this.getVpnEcmpSupport() != null) {
                data.set("vpnEcmpSupport", om.valueToTree(this.getVpnEcmpSupport()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnTransitGatewayProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTransitGatewayProps.Jsii$Proxy that = (CfnTransitGatewayProps.Jsii$Proxy) o;

            if (this.amazonSideAsn != null ? !this.amazonSideAsn.equals(that.amazonSideAsn) : that.amazonSideAsn != null) return false;
            if (this.associationDefaultRouteTableId != null ? !this.associationDefaultRouteTableId.equals(that.associationDefaultRouteTableId) : that.associationDefaultRouteTableId != null) return false;
            if (this.autoAcceptSharedAttachments != null ? !this.autoAcceptSharedAttachments.equals(that.autoAcceptSharedAttachments) : that.autoAcceptSharedAttachments != null) return false;
            if (this.defaultRouteTableAssociation != null ? !this.defaultRouteTableAssociation.equals(that.defaultRouteTableAssociation) : that.defaultRouteTableAssociation != null) return false;
            if (this.defaultRouteTablePropagation != null ? !this.defaultRouteTablePropagation.equals(that.defaultRouteTablePropagation) : that.defaultRouteTablePropagation != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.dnsSupport != null ? !this.dnsSupport.equals(that.dnsSupport) : that.dnsSupport != null) return false;
            if (this.multicastSupport != null ? !this.multicastSupport.equals(that.multicastSupport) : that.multicastSupport != null) return false;
            if (this.propagationDefaultRouteTableId != null ? !this.propagationDefaultRouteTableId.equals(that.propagationDefaultRouteTableId) : that.propagationDefaultRouteTableId != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.transitGatewayCidrBlocks != null ? !this.transitGatewayCidrBlocks.equals(that.transitGatewayCidrBlocks) : that.transitGatewayCidrBlocks != null) return false;
            return this.vpnEcmpSupport != null ? this.vpnEcmpSupport.equals(that.vpnEcmpSupport) : that.vpnEcmpSupport == null;
        }

        @Override
        public final int hashCode() {
            int result = this.amazonSideAsn != null ? this.amazonSideAsn.hashCode() : 0;
            result = 31 * result + (this.associationDefaultRouteTableId != null ? this.associationDefaultRouteTableId.hashCode() : 0);
            result = 31 * result + (this.autoAcceptSharedAttachments != null ? this.autoAcceptSharedAttachments.hashCode() : 0);
            result = 31 * result + (this.defaultRouteTableAssociation != null ? this.defaultRouteTableAssociation.hashCode() : 0);
            result = 31 * result + (this.defaultRouteTablePropagation != null ? this.defaultRouteTablePropagation.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.dnsSupport != null ? this.dnsSupport.hashCode() : 0);
            result = 31 * result + (this.multicastSupport != null ? this.multicastSupport.hashCode() : 0);
            result = 31 * result + (this.propagationDefaultRouteTableId != null ? this.propagationDefaultRouteTableId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.transitGatewayCidrBlocks != null ? this.transitGatewayCidrBlocks.hashCode() : 0);
            result = 31 * result + (this.vpnEcmpSupport != null ? this.vpnEcmpSupport.hashCode() : 0);
            return result;
        }
    }
}
