package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnClientVpnEndpoint`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnClientVpnEndpointProps cfnClientVpnEndpointProps = CfnClientVpnEndpointProps.builder()
 *         .authenticationOptions(List.of(ClientAuthenticationRequestProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .activeDirectory(DirectoryServiceAuthenticationRequestProperty.builder()
 *                         .directoryId("directoryId")
 *                         .build())
 *                 .federatedAuthentication(FederatedAuthenticationRequestProperty.builder()
 *                         .samlProviderArn("samlProviderArn")
 *                         // the properties below are optional
 *                         .selfServiceSamlProviderArn("selfServiceSamlProviderArn")
 *                         .build())
 *                 .mutualAuthentication(CertificateAuthenticationRequestProperty.builder()
 *                         .clientRootCertificateChainArn("clientRootCertificateChainArn")
 *                         .build())
 *                 .build()))
 *         .clientCidrBlock("clientCidrBlock")
 *         .connectionLogOptions(ConnectionLogOptionsProperty.builder()
 *                 .enabled(false)
 *                 // the properties below are optional
 *                 .cloudwatchLogGroup("cloudwatchLogGroup")
 *                 .cloudwatchLogStream("cloudwatchLogStream")
 *                 .build())
 *         .serverCertificateArn("serverCertificateArn")
 *         // the properties below are optional
 *         .clientConnectOptions(ClientConnectOptionsProperty.builder()
 *                 .enabled(false)
 *                 // the properties below are optional
 *                 .lambdaFunctionArn("lambdaFunctionArn")
 *                 .build())
 *         .clientLoginBannerOptions(ClientLoginBannerOptionsProperty.builder()
 *                 .enabled(false)
 *                 // the properties below are optional
 *                 .bannerText("bannerText")
 *                 .build())
 *         .description("description")
 *         .dnsServers(List.of("dnsServers"))
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .selfServicePortal("selfServicePortal")
 *         .sessionTimeoutHours(123)
 *         .splitTunnel(false)
 *         .tagSpecifications(List.of(TagSpecificationProperty.builder()
 *                 .resourceType("resourceType")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         .transportProtocol("transportProtocol")
 *         .vpcId("vpcId")
 *         .vpnPort(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:06.648Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnClientVpnEndpointProps")
@software.amazon.jsii.Jsii.Proxy(CfnClientVpnEndpointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnClientVpnEndpointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Information about the authentication method to be used to authenticate clients.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAuthenticationOptions();

    /**
     * The IPv4 address range, in CIDR notation, from which to assign client IP addresses.
     * <p>
     * The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClientCidrBlock();

    /**
     * Information about the client connection logging options.
     * <p>
     * If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream. The following information is logged:
     * <p>
     * <ul>
     * <li>Client connection requests</li>
     * <li>Client connection results (successful and unsuccessful)</li>
     * <li>Reasons for unsuccessful client connection requests</li>
     * <li>Client connection termination time</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConnectionLogOptions();

    /**
     * The ARN of the server certificate.
     * <p>
     * For more information, see the <a href="https://docs.aws.amazon.com/acm/latest/userguide/">AWS Certificate Manager User Guide</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServerCertificateArn();

    /**
     * The options for managing connection authorization for new client connections.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getClientConnectOptions() {
        return null;
    }

    /**
     * Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getClientLoginBannerOptions() {
        return null;
    }

    /**
     * A brief description of the Client VPN endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Information about the DNS servers to be used for DNS resolution.
     * <p>
     * A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address configured on the device is used for the DNS server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDnsServers() {
        return null;
    }

    /**
     * The IDs of one or more security groups to apply to the target network.
     * <p>
     * You must also specify the ID of the VPC that contains the security groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return null;
    }

    /**
     * Specify whether to enable the self-service portal for the Client VPN endpoint.
     * <p>
     * Default Value: <code>enabled</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSelfServicePortal() {
        return null;
    }

    /**
     * The maximum VPN session duration time in hours.
     * <p>
     * Valid values: <code>8 | 10 | 12 | 24</code>
     * <p>
     * Default value: <code>24</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSessionTimeoutHours() {
        return null;
    }

    /**
     * Indicates whether split-tunnel is enabled on the AWS Client VPN endpoint.
     * <p>
     * By default, split-tunnel on a VPN endpoint is disabled.
     * <p>
     * For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel AWS Client VPN endpoint</a> in the <em>AWS Client VPN Administrator Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSplitTunnel() {
        return null;
    }

    /**
     * The tags to apply to the Client VPN endpoint during creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTagSpecifications() {
        return null;
    }

    /**
     * The transport protocol to be used by the VPN session.
     * <p>
     * Default value: <code>udp</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTransportProtocol() {
        return null;
    }

    /**
     * The ID of the VPC to associate with the Client VPN endpoint.
     * <p>
     * If no security group IDs are specified in the request, the default security group for the VPC is applied.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
        return null;
    }

    /**
     * The port number to assign to the Client VPN endpoint for TCP and UDP traffic.
     * <p>
     * Valid Values: <code>443</code> | <code>1194</code>
     * <p>
     * Default Value: <code>443</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getVpnPort() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnClientVpnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnClientVpnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnClientVpnEndpointProps> {
        java.lang.Object authenticationOptions;
        java.lang.String clientCidrBlock;
        java.lang.Object connectionLogOptions;
        java.lang.String serverCertificateArn;
        java.lang.Object clientConnectOptions;
        java.lang.Object clientLoginBannerOptions;
        java.lang.String description;
        java.util.List<java.lang.String> dnsServers;
        java.util.List<java.lang.String> securityGroupIds;
        java.lang.String selfServicePortal;
        java.lang.Number sessionTimeoutHours;
        java.lang.Object splitTunnel;
        java.lang.Object tagSpecifications;
        java.lang.String transportProtocol;
        java.lang.String vpcId;
        java.lang.Number vpnPort;

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getAuthenticationOptions}
         * @param authenticationOptions Information about the authentication method to be used to authenticate clients. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationOptions(software.amazon.awscdk.IResolvable authenticationOptions) {
            this.authenticationOptions = authenticationOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getAuthenticationOptions}
         * @param authenticationOptions Information about the authentication method to be used to authenticate clients. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationOptions(java.util.List<? extends java.lang.Object> authenticationOptions) {
            this.authenticationOptions = authenticationOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getClientCidrBlock}
         * @param clientCidrBlock The IPv4 address range, in CIDR notation, from which to assign client IP addresses. This parameter is required.
         *                        The address range cannot overlap with the local CIDR of the VPC in which the associated subnet is located, or the routes that you add manually. The address range cannot be changed after the Client VPN endpoint has been created. The CIDR block should be /22 or greater.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientCidrBlock(java.lang.String clientCidrBlock) {
            this.clientCidrBlock = clientCidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getConnectionLogOptions}
         * @param connectionLogOptions Information about the client connection logging options. This parameter is required.
         *                             If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream. The following information is logged:
         *                             <p>
         *                             <ul>
         *                             <li>Client connection requests</li>
         *                             <li>Client connection results (successful and unsuccessful)</li>
         *                             <li>Reasons for unsuccessful client connection requests</li>
         *                             <li>Client connection termination time</li>
         *                             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionLogOptions(software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.ConnectionLogOptionsProperty connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getConnectionLogOptions}
         * @param connectionLogOptions Information about the client connection logging options. This parameter is required.
         *                             If you enable client connection logging, data about client connections is sent to a Cloudwatch Logs log stream. The following information is logged:
         *                             <p>
         *                             <ul>
         *                             <li>Client connection requests</li>
         *                             <li>Client connection results (successful and unsuccessful)</li>
         *                             <li>Reasons for unsuccessful client connection requests</li>
         *                             <li>Client connection termination time</li>
         *                             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionLogOptions(software.amazon.awscdk.IResolvable connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getServerCertificateArn}
         * @param serverCertificateArn The ARN of the server certificate. This parameter is required.
         *                             For more information, see the <a href="https://docs.aws.amazon.com/acm/latest/userguide/">AWS Certificate Manager User Guide</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverCertificateArn(java.lang.String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getClientConnectOptions}
         * @param clientConnectOptions The options for managing connection authorization for new client connections.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientConnectOptions(software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.ClientConnectOptionsProperty clientConnectOptions) {
            this.clientConnectOptions = clientConnectOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getClientConnectOptions}
         * @param clientConnectOptions The options for managing connection authorization for new client connections.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientConnectOptions(software.amazon.awscdk.IResolvable clientConnectOptions) {
            this.clientConnectOptions = clientConnectOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getClientLoginBannerOptions}
         * @param clientLoginBannerOptions Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientLoginBannerOptions(software.amazon.awscdk.services.ec2.CfnClientVpnEndpoint.ClientLoginBannerOptionsProperty clientLoginBannerOptions) {
            this.clientLoginBannerOptions = clientLoginBannerOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getClientLoginBannerOptions}
         * @param clientLoginBannerOptions Options for enabling a customizable text banner that will be displayed on AWS provided clients when a VPN session is established.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientLoginBannerOptions(software.amazon.awscdk.IResolvable clientLoginBannerOptions) {
            this.clientLoginBannerOptions = clientLoginBannerOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getDescription}
         * @param description A brief description of the Client VPN endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getDnsServers}
         * @param dnsServers Information about the DNS servers to be used for DNS resolution.
         *                   A Client VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address configured on the device is used for the DNS server.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsServers(java.util.List<java.lang.String> dnsServers) {
            this.dnsServers = dnsServers;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getSecurityGroupIds}
         * @param securityGroupIds The IDs of one or more security groups to apply to the target network.
         *                         You must also specify the ID of the VPC that contains the security groups.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getSelfServicePortal}
         * @param selfServicePortal Specify whether to enable the self-service portal for the Client VPN endpoint.
         *                          Default Value: <code>enabled</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfServicePortal(java.lang.String selfServicePortal) {
            this.selfServicePortal = selfServicePortal;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getSessionTimeoutHours}
         * @param sessionTimeoutHours The maximum VPN session duration time in hours.
         *                            Valid values: <code>8 | 10 | 12 | 24</code>
         *                            <p>
         *                            Default value: <code>24</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionTimeoutHours(java.lang.Number sessionTimeoutHours) {
            this.sessionTimeoutHours = sessionTimeoutHours;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getSplitTunnel}
         * @param splitTunnel Indicates whether split-tunnel is enabled on the AWS Client VPN endpoint.
         *                    By default, split-tunnel on a VPN endpoint is disabled.
         *                    <p>
         *                    For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel AWS Client VPN endpoint</a> in the <em>AWS Client VPN Administrator Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder splitTunnel(java.lang.Boolean splitTunnel) {
            this.splitTunnel = splitTunnel;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getSplitTunnel}
         * @param splitTunnel Indicates whether split-tunnel is enabled on the AWS Client VPN endpoint.
         *                    By default, split-tunnel on a VPN endpoint is disabled.
         *                    <p>
         *                    For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-tunnel AWS Client VPN endpoint</a> in the <em>AWS Client VPN Administrator Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder splitTunnel(software.amazon.awscdk.IResolvable splitTunnel) {
            this.splitTunnel = splitTunnel;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getTagSpecifications}
         * @param tagSpecifications The tags to apply to the Client VPN endpoint during creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(software.amazon.awscdk.IResolvable tagSpecifications) {
            this.tagSpecifications = tagSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getTagSpecifications}
         * @param tagSpecifications The tags to apply to the Client VPN endpoint during creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagSpecifications(java.util.List<? extends java.lang.Object> tagSpecifications) {
            this.tagSpecifications = tagSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getTransportProtocol}
         * @param transportProtocol The transport protocol to be used by the VPN session.
         *                          Default value: <code>udp</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transportProtocol(java.lang.String transportProtocol) {
            this.transportProtocol = transportProtocol;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getVpcId}
         * @param vpcId The ID of the VPC to associate with the Client VPN endpoint.
         *              If no security group IDs are specified in the request, the default security group for the VPC is applied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of {@link CfnClientVpnEndpointProps#getVpnPort}
         * @param vpnPort The port number to assign to the Client VPN endpoint for TCP and UDP traffic.
         *                Valid Values: <code>443</code> | <code>1194</code>
         *                <p>
         *                Default Value: <code>443</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnPort(java.lang.Number vpnPort) {
            this.vpnPort = vpnPort;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnClientVpnEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnClientVpnEndpointProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnClientVpnEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnClientVpnEndpointProps {
        private final java.lang.Object authenticationOptions;
        private final java.lang.String clientCidrBlock;
        private final java.lang.Object connectionLogOptions;
        private final java.lang.String serverCertificateArn;
        private final java.lang.Object clientConnectOptions;
        private final java.lang.Object clientLoginBannerOptions;
        private final java.lang.String description;
        private final java.util.List<java.lang.String> dnsServers;
        private final java.util.List<java.lang.String> securityGroupIds;
        private final java.lang.String selfServicePortal;
        private final java.lang.Number sessionTimeoutHours;
        private final java.lang.Object splitTunnel;
        private final java.lang.Object tagSpecifications;
        private final java.lang.String transportProtocol;
        private final java.lang.String vpcId;
        private final java.lang.Number vpnPort;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authenticationOptions = software.amazon.jsii.Kernel.get(this, "authenticationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.clientCidrBlock = software.amazon.jsii.Kernel.get(this, "clientCidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectionLogOptions = software.amazon.jsii.Kernel.get(this, "connectionLogOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.serverCertificateArn = software.amazon.jsii.Kernel.get(this, "serverCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clientConnectOptions = software.amazon.jsii.Kernel.get(this, "clientConnectOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.clientLoginBannerOptions = software.amazon.jsii.Kernel.get(this, "clientLoginBannerOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dnsServers = software.amazon.jsii.Kernel.get(this, "dnsServers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.selfServicePortal = software.amazon.jsii.Kernel.get(this, "selfServicePortal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sessionTimeoutHours = software.amazon.jsii.Kernel.get(this, "sessionTimeoutHours", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.splitTunnel = software.amazon.jsii.Kernel.get(this, "splitTunnel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tagSpecifications = software.amazon.jsii.Kernel.get(this, "tagSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.transportProtocol = software.amazon.jsii.Kernel.get(this, "transportProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpnPort = software.amazon.jsii.Kernel.get(this, "vpnPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authenticationOptions = java.util.Objects.requireNonNull(builder.authenticationOptions, "authenticationOptions is required");
            this.clientCidrBlock = java.util.Objects.requireNonNull(builder.clientCidrBlock, "clientCidrBlock is required");
            this.connectionLogOptions = java.util.Objects.requireNonNull(builder.connectionLogOptions, "connectionLogOptions is required");
            this.serverCertificateArn = java.util.Objects.requireNonNull(builder.serverCertificateArn, "serverCertificateArn is required");
            this.clientConnectOptions = builder.clientConnectOptions;
            this.clientLoginBannerOptions = builder.clientLoginBannerOptions;
            this.description = builder.description;
            this.dnsServers = builder.dnsServers;
            this.securityGroupIds = builder.securityGroupIds;
            this.selfServicePortal = builder.selfServicePortal;
            this.sessionTimeoutHours = builder.sessionTimeoutHours;
            this.splitTunnel = builder.splitTunnel;
            this.tagSpecifications = builder.tagSpecifications;
            this.transportProtocol = builder.transportProtocol;
            this.vpcId = builder.vpcId;
            this.vpnPort = builder.vpnPort;
        }

        @Override
        public final java.lang.Object getAuthenticationOptions() {
            return this.authenticationOptions;
        }

        @Override
        public final java.lang.String getClientCidrBlock() {
            return this.clientCidrBlock;
        }

        @Override
        public final java.lang.Object getConnectionLogOptions() {
            return this.connectionLogOptions;
        }

        @Override
        public final java.lang.String getServerCertificateArn() {
            return this.serverCertificateArn;
        }

        @Override
        public final java.lang.Object getClientConnectOptions() {
            return this.clientConnectOptions;
        }

        @Override
        public final java.lang.Object getClientLoginBannerOptions() {
            return this.clientLoginBannerOptions;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<java.lang.String> getDnsServers() {
            return this.dnsServers;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final java.lang.String getSelfServicePortal() {
            return this.selfServicePortal;
        }

        @Override
        public final java.lang.Number getSessionTimeoutHours() {
            return this.sessionTimeoutHours;
        }

        @Override
        public final java.lang.Object getSplitTunnel() {
            return this.splitTunnel;
        }

        @Override
        public final java.lang.Object getTagSpecifications() {
            return this.tagSpecifications;
        }

        @Override
        public final java.lang.String getTransportProtocol() {
            return this.transportProtocol;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final java.lang.Number getVpnPort() {
            return this.vpnPort;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authenticationOptions", om.valueToTree(this.getAuthenticationOptions()));
            data.set("clientCidrBlock", om.valueToTree(this.getClientCidrBlock()));
            data.set("connectionLogOptions", om.valueToTree(this.getConnectionLogOptions()));
            data.set("serverCertificateArn", om.valueToTree(this.getServerCertificateArn()));
            if (this.getClientConnectOptions() != null) {
                data.set("clientConnectOptions", om.valueToTree(this.getClientConnectOptions()));
            }
            if (this.getClientLoginBannerOptions() != null) {
                data.set("clientLoginBannerOptions", om.valueToTree(this.getClientLoginBannerOptions()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDnsServers() != null) {
                data.set("dnsServers", om.valueToTree(this.getDnsServers()));
            }
            if (this.getSecurityGroupIds() != null) {
                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
            }
            if (this.getSelfServicePortal() != null) {
                data.set("selfServicePortal", om.valueToTree(this.getSelfServicePortal()));
            }
            if (this.getSessionTimeoutHours() != null) {
                data.set("sessionTimeoutHours", om.valueToTree(this.getSessionTimeoutHours()));
            }
            if (this.getSplitTunnel() != null) {
                data.set("splitTunnel", om.valueToTree(this.getSplitTunnel()));
            }
            if (this.getTagSpecifications() != null) {
                data.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
            }
            if (this.getTransportProtocol() != null) {
                data.set("transportProtocol", om.valueToTree(this.getTransportProtocol()));
            }
            if (this.getVpcId() != null) {
                data.set("vpcId", om.valueToTree(this.getVpcId()));
            }
            if (this.getVpnPort() != null) {
                data.set("vpnPort", om.valueToTree(this.getVpnPort()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnClientVpnEndpointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnClientVpnEndpointProps.Jsii$Proxy that = (CfnClientVpnEndpointProps.Jsii$Proxy) o;

            if (!authenticationOptions.equals(that.authenticationOptions)) return false;
            if (!clientCidrBlock.equals(that.clientCidrBlock)) return false;
            if (!connectionLogOptions.equals(that.connectionLogOptions)) return false;
            if (!serverCertificateArn.equals(that.serverCertificateArn)) return false;
            if (this.clientConnectOptions != null ? !this.clientConnectOptions.equals(that.clientConnectOptions) : that.clientConnectOptions != null) return false;
            if (this.clientLoginBannerOptions != null ? !this.clientLoginBannerOptions.equals(that.clientLoginBannerOptions) : that.clientLoginBannerOptions != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.dnsServers != null ? !this.dnsServers.equals(that.dnsServers) : that.dnsServers != null) return false;
            if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
            if (this.selfServicePortal != null ? !this.selfServicePortal.equals(that.selfServicePortal) : that.selfServicePortal != null) return false;
            if (this.sessionTimeoutHours != null ? !this.sessionTimeoutHours.equals(that.sessionTimeoutHours) : that.sessionTimeoutHours != null) return false;
            if (this.splitTunnel != null ? !this.splitTunnel.equals(that.splitTunnel) : that.splitTunnel != null) return false;
            if (this.tagSpecifications != null ? !this.tagSpecifications.equals(that.tagSpecifications) : that.tagSpecifications != null) return false;
            if (this.transportProtocol != null ? !this.transportProtocol.equals(that.transportProtocol) : that.transportProtocol != null) return false;
            if (this.vpcId != null ? !this.vpcId.equals(that.vpcId) : that.vpcId != null) return false;
            return this.vpnPort != null ? this.vpnPort.equals(that.vpnPort) : that.vpnPort == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authenticationOptions.hashCode();
            result = 31 * result + (this.clientCidrBlock.hashCode());
            result = 31 * result + (this.connectionLogOptions.hashCode());
            result = 31 * result + (this.serverCertificateArn.hashCode());
            result = 31 * result + (this.clientConnectOptions != null ? this.clientConnectOptions.hashCode() : 0);
            result = 31 * result + (this.clientLoginBannerOptions != null ? this.clientLoginBannerOptions.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.dnsServers != null ? this.dnsServers.hashCode() : 0);
            result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
            result = 31 * result + (this.selfServicePortal != null ? this.selfServicePortal.hashCode() : 0);
            result = 31 * result + (this.sessionTimeoutHours != null ? this.sessionTimeoutHours.hashCode() : 0);
            result = 31 * result + (this.splitTunnel != null ? this.splitTunnel.hashCode() : 0);
            result = 31 * result + (this.tagSpecifications != null ? this.tagSpecifications.hashCode() : 0);
            result = 31 * result + (this.transportProtocol != null ? this.transportProtocol.hashCode() : 0);
            result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
            result = 31 * result + (this.vpnPort != null ? this.vpnPort.hashCode() : 0);
            return result;
        }
    }
}
