package software.amazon.awscdk.services.dynamodb;

/**
 * DynamoDB's table class.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Table table = Table.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder().name("id").type(AttributeType.STRING).build())
 *         .tableClass(TableClass.STANDARD_INFREQUENT_ACCESS)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.TableClasses.html">https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.TableClasses.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:06.600Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.TableClass")
public enum TableClass {
    /**
     * Default table class for DynamoDB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
    /**
     * Table class for DynamoDB that reduces storage costs compared to existing DynamoDB Standard tables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD_INFREQUENT_ACCESS,
}
