package software.amazon.awscdk.services.datasync;

/**
 * A CloudFormation `AWS::DataSync::Agent`.
 * <p>
 * The <code>AWS::DataSync::Agent</code> resource specifies an AWS DataSync agent to be deployed and activated on your host. The activation process associates your agent with your account. In the activation process, you specify information such as the AWS Region that you want to activate the agent in. You activate the agent in the AWS Region where your target locations (in Amazon S3, Amazon EFS, or Amazon FSx for Windows File Server) reside. Your tasks are created in this AWS Region .
 * <p>
 * You can activate the agent in a virtual private cloud (VPC) or provide the agent access to a VPC endpoint so that you can run tasks without sending them over the public internet.
 * <p>
 * You can specify an agent to be used for more than one location. If a task uses multiple agents, all of them must have a status of AVAILABLE for the task to run. If you use multiple agents for a source location, the status of all the agents must be AVAILABLE for the task to run.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/activating-agent.html">Activating an Agent</a> in the <em>AWS DataSync User Guide</em> .
 * <p>
 * Agents are automatically updated by AWS on a regular basis, using a mechanism that ensures minimal interruption to your tasks.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datasync.*;
 * CfnAgent cfnAgent = CfnAgent.Builder.create(this, "MyCfnAgent")
 *         .activationKey("activationKey")
 *         // the properties below are optional
 *         .agentName("agentName")
 *         .securityGroupArns(List.of("securityGroupArns"))
 *         .subnetArns(List.of("subnetArns"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcEndpointId("vpcEndpointId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:06.379Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnAgent")
public class CfnAgent extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnAgent(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAgent(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.datasync.CfnAgent.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::DataSync::Agent`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAgent(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.datasync.CfnAgentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the agent.
     * <p>
     * Use the <code>ListAgents</code> operation to return a list of agents for your account and AWS Region .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAgentArn() {
        return software.amazon.jsii.Kernel.get(this, "attrAgentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of endpoint that your agent is connected to.
     * <p>
     * If the endpoint is a VPC endpoint, the agent is not accessible over the public internet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpointType() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpointType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The key-value pair that represents the tag that you want to associate with the agent.
     * <p>
     * The value can be an empty string. This value helps you manage, filter, and search for your agents.
     * <p>
     * <blockquote>
     * <p>
     * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / &#64;.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Your agent activation key.
     * <p>
     * You can get the activation key either by sending an HTTP GET request with redirects that enable you to get the agent IP address (port 80). Alternatively, you can get it from the DataSync console.
     * <p>
     * The redirect URL returned in the response provides you the activation key for your agent in the query string parameter <code>activationKey</code> . It might also include other activation-related parameters; however, these are merely defaults. The arguments you pass to this API call determine the actual configuration of your agent.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/activating-agent.html">Creating and activating an agent</a> in the <em>AWS DataSync User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getActivationKey() {
        return software.amazon.jsii.Kernel.get(this, "activationKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Your agent activation key.
     * <p>
     * You can get the activation key either by sending an HTTP GET request with redirects that enable you to get the agent IP address (port 80). Alternatively, you can get it from the DataSync console.
     * <p>
     * The redirect URL returned in the response provides you the activation key for your agent in the query string parameter <code>activationKey</code> . It might also include other activation-related parameters; however, these are merely defaults. The arguments you pass to this API call determine the actual configuration of your agent.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/activating-agent.html">Creating and activating an agent</a> in the <em>AWS DataSync User Guide.</em>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActivationKey(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "activationKey", java.util.Objects.requireNonNull(value, "activationKey is required"));
    }

    /**
     * The name you configured for your agent.
     * <p>
     * This value is a text reference that is used to identify the agent in the console.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAgentName() {
        return software.amazon.jsii.Kernel.get(this, "agentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name you configured for your agent.
     * <p>
     * This value is a text reference that is used to identify the agent in the console.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAgentName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "agentName", value);
    }

    /**
     * The Amazon Resource Names (ARNs) of the security groups used to protect your data transfer task subnets.
     * <p>
     * See <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Ec2Config.html#DataSync-Type-Ec2Config-SecurityGroupArns">SecurityGroupArns</a> .
     * <p>
     * <em>Pattern</em> : <code>^arn:(aws|aws-cn|aws-us-gov|aws-iso|aws-iso-b):ec2:[a-z\-0-9]*:[0-9]{12}:security-group/.*$</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "securityGroupArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The Amazon Resource Names (ARNs) of the security groups used to protect your data transfer task subnets.
     * <p>
     * See <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Ec2Config.html#DataSync-Type-Ec2Config-SecurityGroupArns">SecurityGroupArns</a> .
     * <p>
     * <em>Pattern</em> : <code>^arn:(aws|aws-cn|aws-us-gov|aws-iso|aws-iso-b):ec2:[a-z\-0-9]*:[0-9]{12}:security-group/.*$</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroupArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "securityGroupArns", value);
    }

    /**
     * The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network interfaces for each data transfer task.
     * <p>
     * The agent that runs a task must be private. When you start a task that is associated with an agent created in a VPC, or one that has access to an IP address in a VPC, then the task is also private. In this case, DataSync creates four network interfaces for each task in your subnet. For a data transfer to work, the agent must be able to route to all these four network interfaces.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "subnetArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network interfaces for each data transfer task.
     * <p>
     * The agent that runs a task must be private. When you start a task that is associated with an agent created in a VPC, or one that has access to an IP address in a VPC, then the task is also private. In this case, DataSync creates four network interfaces for each task in your subnet. For a data transfer to work, the agent must be able to route to all these four network interfaces.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubnetArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "subnetArns", value);
    }

    /**
     * The ID of the virtual private cloud (VPC) endpoint that the agent has access to.
     * <p>
     * This is the client-side VPC endpoint, powered by AWS PrivateLink . If you don't have an AWS PrivateLink VPC endpoint, see <a href="https://docs.aws.amazon.com//vpc/latest/userguide/endpoint-services-overview.html">AWS PrivateLink and VPC endpoints</a> in the <em>Amazon VPC User Guide</em> .
     * <p>
     * For more information about activating your agent in a private network based on a VPC, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/datasync-in-vpc.html">Using AWS DataSync in a Virtual Private Cloud</a> in the <em>AWS DataSync User Guide.</em>
     * <p>
     * A VPC endpoint ID looks like this: <code>vpce-01234d5aff67890e1</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVpcEndpointId() {
        return software.amazon.jsii.Kernel.get(this, "vpcEndpointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the virtual private cloud (VPC) endpoint that the agent has access to.
     * <p>
     * This is the client-side VPC endpoint, powered by AWS PrivateLink . If you don't have an AWS PrivateLink VPC endpoint, see <a href="https://docs.aws.amazon.com//vpc/latest/userguide/endpoint-services-overview.html">AWS PrivateLink and VPC endpoints</a> in the <em>Amazon VPC User Guide</em> .
     * <p>
     * For more information about activating your agent in a private network based on a VPC, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/datasync-in-vpc.html">Using AWS DataSync in a Virtual Private Cloud</a> in the <em>AWS DataSync User Guide.</em>
     * <p>
     * A VPC endpoint ID looks like this: <code>vpce-01234d5aff67890e1</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcEndpointId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vpcEndpointId", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.datasync.CfnAgent}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.datasync.CfnAgent> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.datasync.CfnAgentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.datasync.CfnAgentProps.Builder();
        }

        /**
         * Your agent activation key.
         * <p>
         * You can get the activation key either by sending an HTTP GET request with redirects that enable you to get the agent IP address (port 80). Alternatively, you can get it from the DataSync console.
         * <p>
         * The redirect URL returned in the response provides you the activation key for your agent in the query string parameter <code>activationKey</code> . It might also include other activation-related parameters; however, these are merely defaults. The arguments you pass to this API call determine the actual configuration of your agent.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/activating-agent.html">Creating and activating an agent</a> in the <em>AWS DataSync User Guide.</em>
         * <p>
         * @return {@code this}
         * @param activationKey Your agent activation key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder activationKey(final java.lang.String activationKey) {
            this.props.activationKey(activationKey);
            return this;
        }

        /**
         * The name you configured for your agent.
         * <p>
         * This value is a text reference that is used to identify the agent in the console.
         * <p>
         * @return {@code this}
         * @param agentName The name you configured for your agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentName(final java.lang.String agentName) {
            this.props.agentName(agentName);
            return this;
        }

        /**
         * The Amazon Resource Names (ARNs) of the security groups used to protect your data transfer task subnets.
         * <p>
         * See <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_Ec2Config.html#DataSync-Type-Ec2Config-SecurityGroupArns">SecurityGroupArns</a> .
         * <p>
         * <em>Pattern</em> : <code>^arn:(aws|aws-cn|aws-us-gov|aws-iso|aws-iso-b):ec2:[a-z\-0-9]*:[0-9]{12}:security-group/.*$</code>
         * <p>
         * @return {@code this}
         * @param securityGroupArns The Amazon Resource Names (ARNs) of the security groups used to protect your data transfer task subnets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupArns(final java.util.List<java.lang.String> securityGroupArns) {
            this.props.securityGroupArns(securityGroupArns);
            return this;
        }

        /**
         * The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network interfaces for each data transfer task.
         * <p>
         * The agent that runs a task must be private. When you start a task that is associated with an agent created in a VPC, or one that has access to an IP address in a VPC, then the task is also private. In this case, DataSync creates four network interfaces for each task in your subnet. For a data transfer to work, the agent must be able to route to all these four network interfaces.
         * <p>
         * @return {@code this}
         * @param subnetArns The Amazon Resource Names (ARNs) of the subnets in which DataSync will create elastic network interfaces for each data transfer task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetArns(final java.util.List<java.lang.String> subnetArns) {
            this.props.subnetArns(subnetArns);
            return this;
        }

        /**
         * The key-value pair that represents the tag that you want to associate with the agent.
         * <p>
         * The value can be an empty string. This value helps you manage, filter, and search for your agents.
         * <p>
         * <blockquote>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the following special characters: + - = . _ : / &#64;.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param tags The key-value pair that represents the tag that you want to associate with the agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The ID of the virtual private cloud (VPC) endpoint that the agent has access to.
         * <p>
         * This is the client-side VPC endpoint, powered by AWS PrivateLink . If you don't have an AWS PrivateLink VPC endpoint, see <a href="https://docs.aws.amazon.com//vpc/latest/userguide/endpoint-services-overview.html">AWS PrivateLink and VPC endpoints</a> in the <em>Amazon VPC User Guide</em> .
         * <p>
         * For more information about activating your agent in a private network based on a VPC, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/datasync-in-vpc.html">Using AWS DataSync in a Virtual Private Cloud</a> in the <em>AWS DataSync User Guide.</em>
         * <p>
         * A VPC endpoint ID looks like this: <code>vpce-01234d5aff67890e1</code> .
         * <p>
         * @return {@code this}
         * @param vpcEndpointId The ID of the virtual private cloud (VPC) endpoint that the agent has access to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcEndpointId(final java.lang.String vpcEndpointId) {
            this.props.vpcEndpointId(vpcEndpointId);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.datasync.CfnAgent}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.datasync.CfnAgent build() {
            return new software.amazon.awscdk.services.datasync.CfnAgent(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
