package software.amazon.awscdk.services.connect;

/**
 * A CloudFormation `AWS::Connect::Instance`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connect.*;
 * CfnInstance cfnInstance = CfnInstance.Builder.create(this, "MyCfnInstance")
 *         .attributes(AttributesProperty.builder()
 *                 .inboundCalls(false)
 *                 .outboundCalls(false)
 *                 // the properties below are optional
 *                 .autoResolveBestVoices(false)
 *                 .contactflowLogs(false)
 *                 .contactLens(false)
 *                 .earlyMedia(false)
 *                 .useCustomTtsVoices(false)
 *                 .build())
 *         .identityManagementType("identityManagementType")
 *         // the properties below are optional
 *         .directoryId("directoryId")
 *         .instanceAlias("instanceAlias")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:06.284Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnInstance")
public class CfnInstance extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnInstance(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInstance(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.connect.CfnInstance.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Connect::Instance`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnInstance(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connect.CfnInstanceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrInstanceStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrInstanceStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServiceRole() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::Connect::Instance.Attributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAttributes() {
        return software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Connect::Instance.Attributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttributes(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connect.CfnInstance.AttributesProperty value) {
        software.amazon.jsii.Kernel.set(this, "attributes", java.util.Objects.requireNonNull(value, "attributes is required"));
    }

    /**
     * `AWS::Connect::Instance.Attributes`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttributes(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "attributes", java.util.Objects.requireNonNull(value, "attributes is required"));
    }

    /**
     * `AWS::Connect::Instance.IdentityManagementType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIdentityManagementType() {
        return software.amazon.jsii.Kernel.get(this, "identityManagementType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Connect::Instance.IdentityManagementType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityManagementType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "identityManagementType", java.util.Objects.requireNonNull(value, "identityManagementType is required"));
    }

    /**
     * `AWS::Connect::Instance.DirectoryId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDirectoryId() {
        return software.amazon.jsii.Kernel.get(this, "directoryId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Connect::Instance.DirectoryId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDirectoryId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "directoryId", value);
    }

    /**
     * `AWS::Connect::Instance.InstanceAlias`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInstanceAlias() {
        return software.amazon.jsii.Kernel.get(this, "instanceAlias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Connect::Instance.InstanceAlias`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceAlias(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceAlias", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * AttributesProperty attributesProperty = AttributesProperty.builder()
     *         .inboundCalls(false)
     *         .outboundCalls(false)
     *         // the properties below are optional
     *         .autoResolveBestVoices(false)
     *         .contactflowLogs(false)
     *         .contactLens(false)
     *         .earlyMedia(false)
     *         .useCustomTtsVoices(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnInstance.AttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(AttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnInstance.AttributesProperty.InboundCalls`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getInboundCalls();

        /**
         * `CfnInstance.AttributesProperty.OutboundCalls`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOutboundCalls();

        /**
         * `CfnInstance.AttributesProperty.AutoResolveBestVoices`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoResolveBestVoices() {
            return null;
        }

        /**
         * `CfnInstance.AttributesProperty.ContactflowLogs`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContactflowLogs() {
            return null;
        }

        /**
         * `CfnInstance.AttributesProperty.ContactLens`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContactLens() {
            return null;
        }

        /**
         * `CfnInstance.AttributesProperty.EarlyMedia`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEarlyMedia() {
            return null;
        }

        /**
         * `CfnInstance.AttributesProperty.UseCustomTTSVoices`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseCustomTtsVoices() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AttributesProperty> {
            java.lang.Object inboundCalls;
            java.lang.Object outboundCalls;
            java.lang.Object autoResolveBestVoices;
            java.lang.Object contactflowLogs;
            java.lang.Object contactLens;
            java.lang.Object earlyMedia;
            java.lang.Object useCustomTtsVoices;

            /**
             * Sets the value of {@link AttributesProperty#getInboundCalls}
             * @param inboundCalls `CfnInstance.AttributesProperty.InboundCalls`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inboundCalls(java.lang.Boolean inboundCalls) {
                this.inboundCalls = inboundCalls;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getInboundCalls}
             * @param inboundCalls `CfnInstance.AttributesProperty.InboundCalls`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inboundCalls(software.amazon.awscdk.IResolvable inboundCalls) {
                this.inboundCalls = inboundCalls;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getOutboundCalls}
             * @param outboundCalls `CfnInstance.AttributesProperty.OutboundCalls`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outboundCalls(java.lang.Boolean outboundCalls) {
                this.outboundCalls = outboundCalls;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getOutboundCalls}
             * @param outboundCalls `CfnInstance.AttributesProperty.OutboundCalls`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outboundCalls(software.amazon.awscdk.IResolvable outboundCalls) {
                this.outboundCalls = outboundCalls;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getAutoResolveBestVoices}
             * @param autoResolveBestVoices `CfnInstance.AttributesProperty.AutoResolveBestVoices`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoResolveBestVoices(java.lang.Boolean autoResolveBestVoices) {
                this.autoResolveBestVoices = autoResolveBestVoices;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getAutoResolveBestVoices}
             * @param autoResolveBestVoices `CfnInstance.AttributesProperty.AutoResolveBestVoices`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoResolveBestVoices(software.amazon.awscdk.IResolvable autoResolveBestVoices) {
                this.autoResolveBestVoices = autoResolveBestVoices;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getContactflowLogs}
             * @param contactflowLogs `CfnInstance.AttributesProperty.ContactflowLogs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contactflowLogs(java.lang.Boolean contactflowLogs) {
                this.contactflowLogs = contactflowLogs;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getContactflowLogs}
             * @param contactflowLogs `CfnInstance.AttributesProperty.ContactflowLogs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contactflowLogs(software.amazon.awscdk.IResolvable contactflowLogs) {
                this.contactflowLogs = contactflowLogs;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getContactLens}
             * @param contactLens `CfnInstance.AttributesProperty.ContactLens`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contactLens(java.lang.Boolean contactLens) {
                this.contactLens = contactLens;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getContactLens}
             * @param contactLens `CfnInstance.AttributesProperty.ContactLens`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contactLens(software.amazon.awscdk.IResolvable contactLens) {
                this.contactLens = contactLens;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getEarlyMedia}
             * @param earlyMedia `CfnInstance.AttributesProperty.EarlyMedia`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder earlyMedia(java.lang.Boolean earlyMedia) {
                this.earlyMedia = earlyMedia;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getEarlyMedia}
             * @param earlyMedia `CfnInstance.AttributesProperty.EarlyMedia`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder earlyMedia(software.amazon.awscdk.IResolvable earlyMedia) {
                this.earlyMedia = earlyMedia;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getUseCustomTtsVoices}
             * @param useCustomTtsVoices `CfnInstance.AttributesProperty.UseCustomTTSVoices`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useCustomTtsVoices(java.lang.Boolean useCustomTtsVoices) {
                this.useCustomTtsVoices = useCustomTtsVoices;
                return this;
            }

            /**
             * Sets the value of {@link AttributesProperty#getUseCustomTtsVoices}
             * @param useCustomTtsVoices `CfnInstance.AttributesProperty.UseCustomTTSVoices`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useCustomTtsVoices(software.amazon.awscdk.IResolvable useCustomTtsVoices) {
                this.useCustomTtsVoices = useCustomTtsVoices;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AttributesProperty {
            private final java.lang.Object inboundCalls;
            private final java.lang.Object outboundCalls;
            private final java.lang.Object autoResolveBestVoices;
            private final java.lang.Object contactflowLogs;
            private final java.lang.Object contactLens;
            private final java.lang.Object earlyMedia;
            private final java.lang.Object useCustomTtsVoices;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inboundCalls = software.amazon.jsii.Kernel.get(this, "inboundCalls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outboundCalls = software.amazon.jsii.Kernel.get(this, "outboundCalls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.autoResolveBestVoices = software.amazon.jsii.Kernel.get(this, "autoResolveBestVoices", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.contactflowLogs = software.amazon.jsii.Kernel.get(this, "contactflowLogs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.contactLens = software.amazon.jsii.Kernel.get(this, "contactLens", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.earlyMedia = software.amazon.jsii.Kernel.get(this, "earlyMedia", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.useCustomTtsVoices = software.amazon.jsii.Kernel.get(this, "useCustomTtsVoices", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inboundCalls = java.util.Objects.requireNonNull(builder.inboundCalls, "inboundCalls is required");
                this.outboundCalls = java.util.Objects.requireNonNull(builder.outboundCalls, "outboundCalls is required");
                this.autoResolveBestVoices = builder.autoResolveBestVoices;
                this.contactflowLogs = builder.contactflowLogs;
                this.contactLens = builder.contactLens;
                this.earlyMedia = builder.earlyMedia;
                this.useCustomTtsVoices = builder.useCustomTtsVoices;
            }

            @Override
            public final java.lang.Object getInboundCalls() {
                return this.inboundCalls;
            }

            @Override
            public final java.lang.Object getOutboundCalls() {
                return this.outboundCalls;
            }

            @Override
            public final java.lang.Object getAutoResolveBestVoices() {
                return this.autoResolveBestVoices;
            }

            @Override
            public final java.lang.Object getContactflowLogs() {
                return this.contactflowLogs;
            }

            @Override
            public final java.lang.Object getContactLens() {
                return this.contactLens;
            }

            @Override
            public final java.lang.Object getEarlyMedia() {
                return this.earlyMedia;
            }

            @Override
            public final java.lang.Object getUseCustomTtsVoices() {
                return this.useCustomTtsVoices;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inboundCalls", om.valueToTree(this.getInboundCalls()));
                data.set("outboundCalls", om.valueToTree(this.getOutboundCalls()));
                if (this.getAutoResolveBestVoices() != null) {
                    data.set("autoResolveBestVoices", om.valueToTree(this.getAutoResolveBestVoices()));
                }
                if (this.getContactflowLogs() != null) {
                    data.set("contactflowLogs", om.valueToTree(this.getContactflowLogs()));
                }
                if (this.getContactLens() != null) {
                    data.set("contactLens", om.valueToTree(this.getContactLens()));
                }
                if (this.getEarlyMedia() != null) {
                    data.set("earlyMedia", om.valueToTree(this.getEarlyMedia()));
                }
                if (this.getUseCustomTtsVoices() != null) {
                    data.set("useCustomTtsVoices", om.valueToTree(this.getUseCustomTtsVoices()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnInstance.AttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AttributesProperty.Jsii$Proxy that = (AttributesProperty.Jsii$Proxy) o;

                if (!inboundCalls.equals(that.inboundCalls)) return false;
                if (!outboundCalls.equals(that.outboundCalls)) return false;
                if (this.autoResolveBestVoices != null ? !this.autoResolveBestVoices.equals(that.autoResolveBestVoices) : that.autoResolveBestVoices != null) return false;
                if (this.contactflowLogs != null ? !this.contactflowLogs.equals(that.contactflowLogs) : that.contactflowLogs != null) return false;
                if (this.contactLens != null ? !this.contactLens.equals(that.contactLens) : that.contactLens != null) return false;
                if (this.earlyMedia != null ? !this.earlyMedia.equals(that.earlyMedia) : that.earlyMedia != null) return false;
                return this.useCustomTtsVoices != null ? this.useCustomTtsVoices.equals(that.useCustomTtsVoices) : that.useCustomTtsVoices == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inboundCalls.hashCode();
                result = 31 * result + (this.outboundCalls.hashCode());
                result = 31 * result + (this.autoResolveBestVoices != null ? this.autoResolveBestVoices.hashCode() : 0);
                result = 31 * result + (this.contactflowLogs != null ? this.contactflowLogs.hashCode() : 0);
                result = 31 * result + (this.contactLens != null ? this.contactLens.hashCode() : 0);
                result = 31 * result + (this.earlyMedia != null ? this.earlyMedia.hashCode() : 0);
                result = 31 * result + (this.useCustomTtsVoices != null ? this.useCustomTtsVoices.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.connect.CfnInstance}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.connect.CfnInstance> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.connect.CfnInstanceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.connect.CfnInstanceProps.Builder();
        }

        /**
         * `AWS::Connect::Instance.Attributes`.
         * <p>
         * @return {@code this}
         * @param attributes `AWS::Connect::Instance.Attributes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(final software.amazon.awscdk.services.connect.CfnInstance.AttributesProperty attributes) {
            this.props.attributes(attributes);
            return this;
        }
        /**
         * `AWS::Connect::Instance.Attributes`.
         * <p>
         * @return {@code this}
         * @param attributes `AWS::Connect::Instance.Attributes`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(final software.amazon.awscdk.IResolvable attributes) {
            this.props.attributes(attributes);
            return this;
        }

        /**
         * `AWS::Connect::Instance.IdentityManagementType`.
         * <p>
         * @return {@code this}
         * @param identityManagementType `AWS::Connect::Instance.IdentityManagementType`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityManagementType(final java.lang.String identityManagementType) {
            this.props.identityManagementType(identityManagementType);
            return this;
        }

        /**
         * `AWS::Connect::Instance.DirectoryId`.
         * <p>
         * @return {@code this}
         * @param directoryId `AWS::Connect::Instance.DirectoryId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directoryId(final java.lang.String directoryId) {
            this.props.directoryId(directoryId);
            return this;
        }

        /**
         * `AWS::Connect::Instance.InstanceAlias`.
         * <p>
         * @return {@code this}
         * @param instanceAlias `AWS::Connect::Instance.InstanceAlias`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceAlias(final java.lang.String instanceAlias) {
            this.props.instanceAlias(instanceAlias);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.connect.CfnInstance}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.connect.CfnInstance build() {
            return new software.amazon.awscdk.services.connect.CfnInstance(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
