package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Used for HTTP cache-control header, which influences downstream caches.
 * <p>
 * Use the provided static factory methods to construct instances of this class.
 * Used in the {&#64;link S3DeployActionProps.cacheControl} property.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.actions.*;
 * CacheControl cacheControl = CacheControl.fromString("s");
 * </pre></blockquote>
 * <p>
 * @see <a href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9">https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.68.0 (build b45f2f6)", date = "2022-09-23T11:44:06.018Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.CacheControl")
public class CacheControl extends software.amazon.jsii.JsiiObject {

    protected CacheControl(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CacheControl(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Allows you to create an arbitrary cache control directive, in case our support is missing a method for a particular directive.
     * <p>
     * @param s This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.CacheControl fromString(final @org.jetbrains.annotations.NotNull java.lang.String s) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.actions.CacheControl.class, "fromString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.CacheControl.class), new Object[] { java.util.Objects.requireNonNull(s, "s is required") });
    }

    /**
     * The 'max-age' cache control directive.
     * <p>
     * @param t This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.CacheControl maxAge(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration t) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.actions.CacheControl.class, "maxAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.CacheControl.class), new Object[] { java.util.Objects.requireNonNull(t, "t is required") });
    }

    /**
     * The 'must-revalidate' cache control directive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.CacheControl mustRevalidate() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.actions.CacheControl.class, "mustRevalidate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.CacheControl.class));
    }

    /**
     * The 'no-cache' cache control directive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.CacheControl noCache() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.actions.CacheControl.class, "noCache", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.CacheControl.class));
    }

    /**
     * The 'no-transform' cache control directive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.CacheControl noTransform() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.actions.CacheControl.class, "noTransform", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.CacheControl.class));
    }

    /**
     * The 'proxy-revalidate' cache control directive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.CacheControl proxyRevalidate() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.actions.CacheControl.class, "proxyRevalidate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.CacheControl.class));
    }

    /**
     * The 'private' cache control directive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.CacheControl setPrivate() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.actions.CacheControl.class, "setPrivate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.CacheControl.class));
    }

    /**
     * The 'public' cache control directive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.CacheControl setPublic() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.actions.CacheControl.class, "setPublic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.CacheControl.class));
    }

    /**
     * The 's-max-age' cache control directive.
     * <p>
     * @param t This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.CacheControl sMaxAge(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration t) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.actions.CacheControl.class, "sMaxAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.CacheControl.class), new Object[] { java.util.Objects.requireNonNull(t, "t is required") });
    }

    /**
     * the actual text value of the created directive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * the actual text value of the created directive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setValue(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "value", java.util.Objects.requireNonNull(value, "value is required"));
    }
}
